 /*
 regional emissions (fos, luc, ch4, n2o)
  */

package jcm.mod.soc;

import jcm.core.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.futbasescen;
import jcm.mod.reg.*;
import java.util.*;

public class socreg extends module  {
    
    //*********** SETUP ******************
    public void initsetup() {
	/*
	 socreg has no loop calculations, but interactions necessary to trigger calc if want to view the qtsets,
	 or for  costs and responsibility follow socreg,
	 however as global emissions are NOT affected by socreg, it can follow shares which follows carboncycle (in case of stab / opt feedback)
	 */
	follows(history.class);
	follows(futbasescen.class);
	follows(sresext.class);
	follows(futureLUC.class);
	follows(shares.class);
	setaffectedby(AviaShipEmit.class); //due to removing bunker from SRES
	
	//emitfosbase.addAction(showpan.pan("percap histogram", histoplot.class, new qtset[]{emitfosbase, pop, emitlucbase }));
	emitfosabate=emitfosbase.makederiv(qt.Type.difference, emitfosquota);
	emitfosabate.mycomplexity=expert;
    }
    
    
    //********* QTSETS ******************
    
    public qtset
	    emitfosbase=new qtset("emitfosbase", "mega&ton&carbon"),
	    emitfosquota=new qtset("emitfosquota", "mega&ton&carbon", simplest),
	    emitfosabate,
	    emitlucbase =new qtset("emitlucbase", "mega&ton&carbon"),
	    emitlucquota=new qtset("emitlucquota",  "mega&ton&carbon"),
	    emitch4=new qtset("emitch4", "mega&ton&CH4"),
	    emitn2o=new qtset("emitn2o",  "mega&ton&N"),
	    emitequiv=new qtset("CO2 Equivalent  (GWP) Emissions", "mega&ton&CO2", "expert");
    
    
    
    //************ REGIONS ****************
    public param<region> regions= regman.makeregionparam("socregions");
    
    //note this code is called from history precalc, in order to calc before anything else, but remains here since it accompanies the regions param
    
    public void clearoldregions() { clearoldregions(this); setefareg(); }
    public void clearoldregions(module m) { for (qtset qq : m.qtsets) clearoldregions(qq); }
    public void clearoldregions(Class c) { clearoldregions(get(c)); }
    public void clearoldregions(qtset qq) {
	for (Object o : qq.mapwithouttotal().keySet())  {
	    if (!((region)regions.chosen).reg.contains(o) && !o.equals("bunker")) qq.map.remove(o);
	}
    }
    
    public void setefareg() { //needed for mappings of emitfosabate, maybe not most efficient method
	List<region> reg=((region) regions.chosen).reg;
	for (region r : reg) { emitfosquota.reg(r);emitfosbase.reg(r); emitfosabate.reg(r); }
    }
    
    //************* EQUIV *****
    /*equivalents using GWP
    created for comparison with attribution of temperature, therefore only including CO2, inc all LUC, CH4 and N2O
     may be extended for other applications later
     GWPs from TAR 100 year time horizon (for 10yr: 62 & 275, for 500yr: 7 & 156)
     *44/12 => mass CO2, *44/14 => mass N2O, note ch4emit was already in MtCH4
     */
    static float gwpch4=23, gwpn2o=296;
    
    void calcequiv() { //called from shares  calcstep in order to be at right point of loop
	for (region r :  regions.chosen.reg) {
	    emitequiv.set(r, (emitfosquota.get(r)+emitlucquota.get(r))*44f/12f +emitch4.get(r)*gwpch4+emitn2o.get(r)*gwpn2o*44f/14f);
	}
    }
    
    
} //end socreg class









