/*
 Responsibility of each region for climate change
developed for UNFCCC Brazilian proposal exercise
Developed Louvain-la-neuve July 2002, updated for all regions 2005 + added timeslice etc.
 
Note, this module comes at the end of the calculation step loop,
so it can draw on results from other modules, but it should not affect them.
It won't be called unless an attribution plot is visible.
It can use a lot of memory / take a long time, if many regions are calculated
 
 *********** Responsibilty Todo *********
P3 recheck timeslice and and normarg since convert from array to qt.get and since changed loop calling
 
 P4 problem with unattributed pre 1890 (move start year in stacked plot - total not constant)
 
P3  include attribution of bunker emissions as a separate region
probably best to include it in socreg reg (to simplify code in several modules) but that would need a lot of checking
 (would help checking all text references to bunker were replaced by a region socreg.bunker but make sure don't depend on checking whether it is a region)
 also should convert the nregs  nemit etc. into collections
 
 P3 recheck timeslice and FIX problem with CH4 contribution to timeslice / normarg- even if frac is zero, it upsets the others, but only if the atchem OH feedback is on
 P2 IDEA Generalise calculation of marginal cause-effect tables (MATCH P3 concept)
 P2 new options should also apply to timeslice mettod
 
P2 FIX in attribution - changing atchem TARO3 param => small unatt co2 spike at beginning (persistent)
P2 CHECK should recheck attribution results against old data (before move to qt system May05)
P2 marginal seems reasonable but may need extra normalising -shld check with all unttributed in calc
P2 Could extract as another module -and make any indicator (auto-qtset menu)
P1 IDEA time-Integrated -per capitae for division?
 
 */

package jcm.mod.soc;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.gui.gen.processdialog;
import jcm.mod.luc.futureLUC;

import jcm.core.reg.region;
import jcm.mod.obj.controller;
import jcm.mod.carbon.*;
import jcm.mod.ogas.*;
import jcm.mod.cli.*;
import static jcm.core.report.*;


public class responsibility extends module implements Runnable {
    
    //*****************************
    //standard module bits
    
    public void setinteractions() {
	follows(get(socreg.class)); //which follows shares which follows carboncycle, futureLUC etc.
	follows(get(radfor.class)); //will catch any gas-changed
	follows(get(glotemp.class));
	//note also precalc method
    }
    
    public param method=new param("attmeth", new String[]{	"tracer",  "timeslice","normarg" }, "tracer", experimental);
    //"tracer+differentialRF", removed since not  working since restruc -check
    
    public param
	    startyear=new param("startyear", "", 1900, 1750, 2000),
	    endyear=new param("endyear", "", 2002, 1990, 2100),
	    includeLUC=new param("attributeLUC-CO2", true),
	    includeCH4N2O=new param("attributeCH4N2O", true),
	    removeextrareg=new param("regionsonly", false);
    //simplecarbon=new param("simplecarbon", false, experimental); //ignore back fluxes
    
    
    public qtset
	    atco2=new qtset("atco2", "ppm"),
	    atch4=new qtset("atch4", "ppb"),
	    atn2o=new qtset("atn2o", "ppb"),
	    
	    rfco2=new qtset("rfco2", "w&per&m2"),
	    rfch4=new qtset("rfch4", "w&per&m2"),
	    rfn2o=new qtset("rfn2o", "w&per&m2"),
	    rftot=new qtset("rftot", "w&per&m2"),
	    
	    surftemp=new qtset("surftemp", "degcbase"),
	    surftemprel=new qtset("surftemp&relative", "%"),
	    sealevte=new qtset("sealevte", "metres");
    
    //####################################
    
// this doesn't seem to work
//    public void initsetup() {
//	for (qtset qq : qtsets) { qq.associate(startyear, endyear); }
//    }
    
    //PRECALC
    public void precalc() {
	if (!intimesliceloop) {
	    for (qtset qq : qtsets) get(socreg.class).clearoldregions(qq);
	    for (qtset qq : qtsets) qq.associate(startyear, endyear);
	    //	for (param p : qq.assocparams) System.err.println(qq.name+" <=> "+p.name);
	    
	    makearrays();
	    if (changed && needed) {	loop.calcfutureonly=false; get(carboncycle.class).changed=true; get(glotemp.class).changed=true; }
	    //this forces carboncycle and get glotemp to recalc, so that this module can access their temporary state of boxes/fluxes within the timestep loop
	    //but these modules are not set affectedby responsibility (would be very inefficient)
	    //if (startyear.getval()<1850) startyear.setval(1850);
	    //if (endyear.getval()>2100) endyear.setval(2100);
	    debug="";
	}
    }
    
    //CALCSTEP
    public void calcstep() {
	if (!intimesliceloop && (method.chosen.equals("tracer") || method.chosen.equals("tracer+differentialRF"))) {
	    if (year>2100 && year> endyear.getval()) return; //makes it faster and plots lower
	    carbonstep();
	    atchemstep();
	    rfstep();
	    glotempstep();
	    
	    //make surfremprel for convenient comparison with absolute
	    //note another way would be to make a pointer qt of type frac, which would save on memory, but would have to adjust the method to get the total (since mapwithouttotal is not right)
	    List<region> reg=((region)(get(socreg.class).regions.chosen)).reg;
	    float totattrib=0;  for (region r : reg) totattrib+=surftemp.get(r);
	    for (region r : reg) surftemprel.set(r, 100f*surftemp.get(r)/totattrib);
	    
	} //if
    } //end calcstep
    
    
    
//POSTCALC
    public void postcalc() {
	if (!intimesliceloop && (method.chosen.equals("timeslice") || method.chosen.equals("normarg")))   attributeloop();
	if (method.chosen.equals("tracer")) deb(debug);
	if (!intimesliceloop &&removeextrareg.istrue()) {
	    for (qtset qq : qtsets) { qq.map.remove(bestafen); qq.map.remove(aerosolreg); qq.map.remove(othgasreg); qq.map.remove(solvolreg); }
	}
    }
    
    
//####################################
//attribution emissions start and end year, impact calculation year, number of years (for array)
    
    boolean attrib=false; //flag whether to attribute this year
    
    public int nregs, oldnregs=0, nemit, nrf, oth;
    final static int ncb=berncarbon.ncb,  nhb=udebclimod.nhb;
    
    float[] ls,hs,so,hu;
    float[][]ciq; float[][][] hiq;
    float[][] acccbox;
    
    public boolean intimesliceloop=false;
    String debug="";
    
    region bestafen=new region("Before start/After End", dkgrey );
    region othgasreg=new region("Unattributed gases (inc F-gases, Ozone)", greygreen );
    region aerosolreg=new region("Aerosols", cyan );
    region solvolreg=new region("Solar and Volcano", yellow );
    
    
    region reg(int nr) {
	if (nr<nregs) return ((region) (get(socreg.class).regions.chosen)).reg.get(nr);
	if (nr==nregs) return bestafen;
	if (nr==nregs+1) return othgasreg;
	if (nr==nregs+2) return aerosolreg;
	if (nr==nregs+3) return solvolreg;
	return null;
    }
    
    public void makearrays() {
	nregs=((region) (get(socreg.class).regions.chosen)).reg.size();
	if (nregs!=oldnregs) {
	    
	    oldnregs=nregs;
	    nemit=nregs+1; nrf=nregs+4; oth=nregs;
	    //note +1 for other/unattributed before start, after end, +4 adds also other gas, get(aerosol.class), solvol
	    
	    //for carbon cycle
	    ciq=new float[nrf][ncb];
	    ls=new float[nrf]; hs=new float [nrf]; so=new float[nrf]; hu=new float[nrf];
	    acccbox= new float[nrf][4];
	    //for heat fluxes
	    hiq=new float[nrf][2][nhb];
	}
	
	
    } //makearrays
    
    
//#######################
//EMISSIONS
    
    boolean attrib(int y) { return (y>=startyear.getval() && y <=endyear.getval()); }
    
    float totco2emit(region r, int y) {
	if (y<gsy) return 0; //oldtotemit at start
	if (r==bestafen) return attrib(y) ? 0 : get(carboncycle.class).fossil.get(y) - get(socreg.class).emitfosquota.get("bunker", y)   +( includeLUC.istrue() ?  get(carboncycle.class).lucf.get(y) : 0 );
	if (r==othgasreg)  return (includeLUC.istrue() ? 0 :  get(carboncycle.class).lucf.get(y))+get(socreg.class).emitfosquota.get("bunker", y) ;
	if (r==aerosolreg || r==solvolreg) return 0;//- no emissions, but effect from temperature feedbacks
	else return attrib(y) ? get(socreg.class).emitfosquota.get(r, y) + (includeLUC.istrue() ? get(socreg.class).emitlucquota.get(r, y) : 0 ) : 0;
    }
    float ch4emit(region r, int y) {
	if (r==bestafen) return attrib(y) ? 0 : get(othgasemit.class).ch4emit.get(y);
	else return attrib(y) ?  get(socreg.class).emitch4.get(r, y) : 0;
    }
    float n2oemit(region r, int y) {
	if (r==bestafen) return attrib(y) ? 0 : get(othgasemit.class).n2oemit.get(y);
	else return attrib(y) ?  get(socreg.class).emitn2o.get(r, y) : 0;
    }
    
    
//#######################
//CARBON CYCLE
    
    float sink, atinc, lsinc, hsinc, fracat, fracls, frachs,  totls, toths, totat, npinc, dls, dhs, dnp, dat;
    float soinc, huinc, fracso, frachu, totso, tothu, dso, dhu;
    float  glotempforfb, fraccarbfb, fracoftempfb;
    
    void carbonstep() {
	
	//simple ACCC model
	if (get(carboncycle.class).accccarbon.istrue()) {
	    if (year==gsy) for (int i=0; i<4; i++) {	acccbox[oth][i]=get(carboncycle.class).acccbox[i]; for (int nr=0; nr<nregs; nr++) acccbox[nr][i]=0; }
	    for (int nr=0; nr<nrf; nr++) atco2.set(reg(nr), get(carboncycle.class).acccmod(acccbox[nr],  totco2emit(reg(nr), year)) );
	    return;
	}
	
		/*
		 Adapt BernCarbon
		Since this module follows carboncycle - berncarbon in same step loop,
		we can scale the global nonlinear fluxes in proportion to the attributed fraction from the source box,
		i.e. fraction of the atmosphere for npinc (fertilisation air=>bio),
		and of ls and hs boxes for lsinc and hsinc which are sea=>air fluxes (the extra due to carbonate chemistry).
		This proportionality based on previous timestep to avoid iteration.
		(the iteration and chemistry are the slow parts of carbon calcstep)
		Note that this only works if carbon module always calculated!
		 */
	berncarbon bc=get(berncarbon.class);
	carboncycle cc=get(carboncycle.class);
	glotempforfb =get(glotemp.class).avchange.get(year-1);
	
	for (int nr=0; nr<nrf; nr++) {
	    region r=reg(nr);
	    
	    //set starting state
	    if (year==gsy) for (int n=0; n<ncb; n++) ciq[nr][n]=(nr==oth ? (float)bc.ciq[n] : 0);
	    
			/*
			Apportioning non-linear fluxes:
			Non-linear flux from atmosphere is obviously apportioned to atmospheric CO2
			 
			But feedback on ocean chemistry is response to both CO2 and temperature - complex equilibria!
			In A2 scenario by 2100,  ocean sink is 13.3 with linear model, 7.26 with chemistry but no temp-feedback, 6.44 with temp-feedback too.
			So non-lin flux (when CF on) could be apportioned as 88% to carbon in that box, and 12% to surface temperature
			But this only applies when high CO2 (pCO2rise=appx550, temprise = appx5.0), not in early years when temp matters more.
			try 0.008 * co2rise / temprise
			NOTE May06 changed from former value 0.0016 * co2rise (alone)
			 
			check lsinc- gets more negative with feedback=>  implies greater flux out of ocean
			check npinc - gets more and more negative  - because it's the difference once you subtract the linear part (prop to at?)
			check soinc - gets negative when there is a feedback - its a flux out of soil
			 
			Attribution of temp feedback on soil carbon is apportioned by shares of temperature
			(noting that mostly non-anthropogenic carbon is released)
			Fraction of heat from other gases/aerosols/solv should also be included!
			 
			Note that to get ocean chemistry feedbacks to work, it's important that non-linear fluxes start at zero,
			not starting with offset to put more flux into linear part averaged over run (an efficiency trick used in berncabon - now removed)
			 
			 fc is the same for all regions, whilst ft varies with fraction of temp coming from each region - be careful as cross zero
			 */
	    
	    
	    if (year==gsy || (glotempforfb<0.01 && glotempforfb>-0.01) || !get(carbonatechemistry.class).chemfeedback.istrue()) {
		fraccarbfb=1f; fracoftempfb=0;
	    } else {
		fraccarbfb=    Math.abs( 0.008f * (cc.co2atppm.get(year-1)-(float)cc.atppmprein) / glotempforfb );
		if (fraccarbfb<0) fraccarbfb=0; else if (fraccarbfb>1) fraccarbfb=1;
		fracoftempfb =  surftemp.get(r, year-1)/glotempforfb;
	    }
	    
	    fracat= (year>gsy) ? (atco2.get(r, year-1)/(cc.co2atppm.get(year-1)-(float)cc.atppmprein)) : 0;
	    if (fracat<0) fracat=0; else if (fracat>1) fracat=1;
	    
	    //if (year>1900 && year<1950) System.err.println("year: "+year+" region: "+r.name+" fc="+fraccarbfb+" ft="+fracoftempfb+" fracat="+fracat);
	    
	    fracls=  (year>gsy) ? fraccarbfb* ls[nr]/totls + (1f - fraccarbfb)* fracoftempfb : 0;
	    frachs=  (year>gsy) ? fraccarbfb*hs[nr]/toths + (1f - fraccarbfb)* fracoftempfb : 0;
	    //note totls and toths typically a few thousand
	    fracso= fracoftempfb;
	    frachu= fracoftempfb;
	    
			/*
			if (!attribtempfb.istrue()) {
			//below attribute soil feedback to carbon only (not correct -for experiment)
			//also problems when anthropogenic soil carbon goes negative
			fracso= (ns>0) ? so[nr]/totso : 0;
			frachu= (ns>0) ? hu[nr]/tothu : 0;
			}
			 */
	    
	    atco2.set(r, 0); ls[nr]=0; hs[nr]=0; so[nr]=0; hu[nr]=0;
	    
	    //use the *old* values for the step function
	    lsinc=(float)bc.oldlsinc*fracls;
	    hsinc=(float)bc.oldhsinc*frachs;
	    npinc=(float)bc.oldnpinc*fracat;
	    soinc=(float)bc.oldsoinc*fracso;
	    huinc=(float)bc.oldhuinc*frachu;
	    atinc= totco2emit(r, year-1)- (lsinc+hsinc+npinc+soinc+huinc);
	    //and changes for the ramp function
	    dls=(float)bc.dls*fracls;
	    dhs=(float)bc.dhs*frachs;
	    dnp=(float)bc.dnp*fracat;
	    dso=(float)bc.dso*fracso;
	    dhu=(float)bc.dhu*frachu;
	    
	    dat= (totco2emit(r, year)-totco2emit(r, year-1)) -(dls+dhs+dnp+dso+dhu);
	    
	    for (int n=0; n<ncb; n++) {
		
		//apply the prop & step & ramp functions
		ciq[nr][n]=(float)(
			ciq[nr][n]*bc.cpropf[n]
			+bc.scicAT[n]*atinc
			+bc.scicLS[n]*lsinc
			+bc.scicHS[n]*hsinc
			+bc.scicNP[n]*npinc
			+bc.rcicAT[n]*dat
			+bc.rcicLS[n]*dls
			+bc.rcicHS[n]*dhs
			+bc.rcicNP[n]*dnp
			+bc.scicSO[n]*soinc
			+bc.rcicSO[n]*dso
			+bc.scicHU[n]*huinc
			+bc.rcicHU[n]*dhu
			);
		//and calculate new concentration
		atco2.set(r, atco2.get(r)+(float)bc.crAT[n]*ciq[nr][n]);
		ls[nr]+=(float)bc.crLS[n]*ciq[nr][n];
		hs[nr]+=(float)bc.crHS[n]*ciq[nr][n];
		so[nr]+=(float)bc.crSO[n]*ciq[nr][n];
		hu[nr]+=(float)bc.crHU[n]*ciq[nr][n];
	    } //n
	    atco2.set(r, atco2.get(r)*(float)cc.ppmpmtc);
	    
	} //nr
	
	//new totals
	totls=0; toths=0; totat=0; totso=0; tothu=0;
	for (int nr=0; nr<nrf; nr++) {	totls+=ls[nr]; toths+=hs[nr]; totat+=atco2.get(reg(nr)); totso+=so[nr]; tothu+=hu[nr]; }
	
    } //carbonstep
    
    
    
//####################################
//ATMOSPHERIC CHEMISTRY
    
    float  extrach4, extran2o, fracn2o;
    
    void atchemstep() {
	if (year==gsy) {
	    for (int nr=0; nr<nregs ; nr++) {	atch4.set(reg(nr), 0) ; atn2o.set(reg(nr), 0) ; }
	    atch4.set(bestafen, get(atchem.class).ch4conc.get()-get(atchem.class).ch4prein);
	    atch4.set(othgasreg, 0);
	    atn2o.set(bestafen, get(atchem.class).n2oconc.get()-get(atchem.class).n2oprein);
	    
	} else {
	    
	    for (int nr=0; nr<nemit ; nr++) {
		region r=reg(nr);
		atch4.set(r, atch4.get(r, year-1) *(1f-1f/get(atchem.class).ch4life(year)) +(float)(get(atchem.class).ppbpmtch4 * ch4emit(r, year) ) );
		atn2o.set(r, atn2o.get(r, year-1) *(1f-1f/get(atchem.class).n2olife(year)) +(float)(get(atchem.class).ppbpmtn * n2oemit(r, year) ) );
	    } //nr
	    
	    
			/*account for any effect of changing lifetime on natural emissions,
			or (if we use fixed 2000 lifetimes) discrepancy between preindustrial concn and natural emissions
			 
			This should ensure consistency with concentrations in main JCM calculations.
			But how to attribute this extra change in concentration?
			for ch4, this is due to changing OH which is affected by several gases
			- so until we can attribute OH, assign this to "other gas" category (nemit)
			 */
	    
	    extrach4=(get(atchem.class).ppbpmtch4 * get(atchem.class).ch4emitnat() - get(atchem.class).ch4prein /get(atchem.class).ch4life(year) );
	    atch4.set(othgasreg, atch4.get(othgasreg, year-1) *(1f-1f/get(atchem.class).ch4life(year)) + extrach4 ) ; //other gas category
	    
	    //apply same rule to n2o
	    extran2o=(get(atchem.class).ppbpmtn * get(atchem.class).n2oemitnat() - get(atchem.class).n2oprein /get(atchem.class).n2olife(year) );
	    atn2o.set(othgasreg, atn2o.get(othgasreg, year-1) *(1f-1f/get(atchem.class).n2olife(year)) + extran2o ); //other gas category
	    
			/* old method
			for co2 extra (nonlinear) sea-air flux attributed according to fraction of extra carbon in mixed layer
			for n2o which affects its own lifetime, apply similar principle as CO2, according to concentration
			 
			fracn2o=(get(atchem.class).n2oconc[ns]-get(atchem.class).n2oprein); //avoid dividing by tiny quantities
			if (fracn2o>0.1) for (int nr=0; nr<(nemit); nr++) atn2o[nr][ns]+= extran2o*atn2o[nr][ns]/fracn2o;
			 */
	} //ns>0
    } //get(atchem.class)step
    
    
//####################################
//RADIATIVE FORCING
    
	/* differential RF formula taken from Enting papers,
	not bad for CO2,
	however causes a long "memory" with CH4
	beware total emissions must be consistent with oghga if use oghga concs!
	 */
    float dc;
    
    void rfstep() {
	atchem atchem=get(atchem.class);
	for (int nr=0; nr<nrf ; nr++) {
	    region r=reg(nr);
	    
	    if (method.equals("tracer+differentialRF") && year>(startyear.getval()+1)) {
		//year because first step is too big to apply differential rate
		int yy= (year>gsy ? year-1 : gsy);
		dc=(get(carboncycle.class).co2atppm.get()-get(carboncycle.class).co2atppm.get(yy));
		rfco2.set(r, yy/* check! */ , rfco2.get(r, yy)+ ((Math.abs(dc)>0.0001) ? (get(carboncycle.class).co2rf.get()-get(carboncycle.class).co2rf.get(yy) )*(atco2.get(r) -atco2.get(r, yy) )/dc : 0) );
		
		if (nr<nemit+1){	//n2o and ch4 no effect from aerosol/solvar
		    dc=(atchem.n2oconc.get()-atchem.n2oconc.get(yy));
		    rfn2o.set(r, rfn2o.get(r, yy)+ ((Math.abs(dc)>0.0001) ? (atchem.n2orf.get()-atchem.n2orf.get(yy))*(atn2o.get(r) -atn2o.get(r, yy) )/dc: 0) );
		    dc=(atchem.ch4conc.get()-atchem.ch4conc.get(yy));
		    rfch4.set(r, rfch4.get(r, yy)+ ((Math.abs(dc)>0.0001) ? (atchem.ch4rf.get()-atchem.ch4rf.get(yy))*(atch4.get(r) -atch4.get(r, yy) )/dc : 0) );
		}
	    } 	else {	//normal tracer method
		dc=(get(carboncycle.class).co2atppm.get()-(float)get(carboncycle.class).atppmprein);
		rfco2.set(r, atco2.get(r) * ((Math.abs(dc)>0.0001) ? get(carboncycle.class).co2rf.get()/dc : 0) );
		if (nr<nemit+1){
		    dc=(atchem.n2oconc.get()-atchem.n2oprein);
		    rfn2o.set(r, atn2o.get(r) * ((Math.abs(dc)>0.0001) ? atchem.n2orf.get()/dc : 0) );
		    dc=(atchem.ch4conc.get()-atchem.ch4prein);
		    rfch4.set(r, atch4.get(r) * ((Math.abs(dc)>0.0001) ? atchem.ch4rf.get()/dc : 0) );
		}
	    }
	} //nr
	
	//total
	for (int nr=0; nr<nemit ; nr++)  rftot.set(reg(nr), rfco2.get(reg(nr))+(includeCH4N2O.istrue() ? rfch4.get(reg(nr))+rfn2o.get(reg(nr)) : 0) );
	//other gases
	rftot.set( othgasreg,
		rfco2.get(othgasreg)+rfch4.get(othgasreg)+rfn2o.get(othgasreg)
		+get(fgas.class).cfcrf.get()+get(fgas.class).hfcrf.get()+atchem.strath2orf.get()+atchem.tropo3rf.get()+get(fgas.class).strato3rf.get()
		);
	if (!includeCH4N2O.istrue()) for (int nr=0; nr<nemit ; nr++) rftot.set( othgasreg, rftot.get(othgasreg)+rfch4.get(reg(nr))+rfn2o.get(reg(nr)));
	
	//aerosol and solar - include feedback effect on carbon
	rftot.set( aerosolreg, rfco2.get( aerosolreg) +get(aerosol.class).aerorf.get() );
	rftot.set( solvolreg, rfco2.get( solvolreg) +get(aerosol.class).natvrf.get() );
	
    } //rfstep
    
	/*
	Note: RF from other gases includes any due to accumulated conc before start
	also includes effect of changing CH4 lifetime (see note above)!
	not problem if start-date before 1970 (as no fgases and ozone has short life)
	but if start much later should calc separately to shift to "other" category
	 */
    
//####################################
	/*
	HEAT FLUXES: surface temp and sealevel
	adapted from udebclimod.java but a bit simpler:
	no upwelling feedback (yet)
	only well mixed rf same for all surface boxes
	no north-south flux (as setting the rate to zero makes hardly any difference to global temp)
	(note the two oceans are still different as northern has more land => cools/warms faster).
	 */
    
    float qin, qinold, dqin;
    float[] rff=new float[2], sf=new float[2], mlt=new float[2], boxtemp=new float[4];
    
    void udebclimodsetup() {
	udebclimod udeb=get(udebclimod.class);
	for (int o=0; o<2; o++) {
	    //factor to combine direct input from rf + input via land
	    rff[o]=(float)(1f+ (udeb.frac[o*3]/udeb.frac[o+1])*udeb.klo/(udeb.kls*udeb.frac[o*3]+udeb.klo));
	    sf[o]=(float)(udeb.spaceflux[o]*udeb.qpt*udeb.tstart);
	    for (int n=0; n<nhb; n++) {
		//fill boxes: oth gets all the heat already accumulated, others start with steady-state
		for (int nr=0; nr<(nrf) ; nr++)
		    hiq[nr][o][n]=(float) ( (nr==oth) ?  udeb.hiq[o][n] : udeb.hiqstart[o][n]) ;
	    }
	} //o
    } //hf setup
    
    void glotempstep() {
	
	if (year==gsy) udebclimodsetup();
	
	//below lets it start in 1750 accumulating get(aerosol.class)s etc.
	
	udebclimod udeb=get(udebclimod.class);
	for (int nr=0; nr<nrf ; nr++) {
	    region r=reg(nr);
	    surftemp.set(r, 0);
	    sealevte.set(r, 0);
	    
	    for (int o=0; o<2; o++) {	//for each ocean
		
		mlt[o]=0;
		
		//calc heat input to each ocean mixed layer (watt-year per m2)
		qinold = sf[o] + (year>gsy ? rftot.get(r, year-1)  : 0) *rff[o];
		qin=  sf[o] + rftot.get(r) *rff[o];
		dqin= qin-qinold;
		
		for (int n=0; n<nhb; n++) {	//for each layer
		    
		    //apply prop, step, ramp functions
		    hiq[nr][o][n]= (float)(
			    udeb.hpropf[o][n]*hiq[nr][o][n]
			    + udeb.shicML[o][n]*qinold
			    + udeb.rhicML[o][n]*dqin
			    );
		    
		    //calc new surface temperatures
		    mlt[o]+=(float)udeb.hrML[o][n]*hiq[nr][o][n];
		    //sea-level rise due to thermal expansion (averages both oceans)
		    sealevte.set( r, sealevte.get(r) + (float)udeb.hrsl[o][n]*hiq[nr][o][n] );
		    
		} //nhb
		
		mlt[o]= (float)(mlt[o]/udeb.qpt - udeb.tstart); //convert to temp rise
	    } //o
	    
	    //P2 CHECK sealevteinit seems to be not working!
	    sealevte.set( r, sealevte.get(r) - (float)udeb.sealevteinit ); //convert to change
	    
	    boxtemp[0]=(float)((mlt[0]*udeb.cice*udeb.klo + udeb.frac[0]*rftot.get(r))/(udeb.kls*udeb.frac[0]+udeb.klo));
	    boxtemp[3]=(float)((mlt[1]*udeb.cice*udeb.klo + udeb.frac[3]*rftot.get(r))/(udeb.kls*udeb.frac[3]+udeb.klo));
	    boxtemp[1]=(float)(mlt[0]*udeb.cice);
	    boxtemp[2]=(float)(mlt[1]*udeb.cice);
	    for (int i=0; i<4; i++) surftemp.set(r,  surftemp.get(r) + (float)(boxtemp[i]*udeb.frac[i]) );
	} //nr
	
    } //end get(glotemp.class)step
    
//####################################
//TIMESLICE
    
    
    int ng=3; //number orig emit gas sources
    qt[] emitqt, emitorig=new qt[ng];
    qt indicorig, base;
    float[][][] effect=new float[ng][][];
    Object mitigorig, emitoptorig;
    JLabel pinfo=new JLabel("initialising...");
    JCheckBox pcb=new JCheckBox("Running", true);
    processdialog pd;
    
    void attributeloop() {
	if (pd==null || !pd.running) {
	    pd=new processdialog(this, "Attribution by "+method.chosen, new JLabel("<html><i>Attribution by  "+method.chosen+"  -please wait"), pinfo, pcb );
	}
    }
    
    public void run() {
	if (pd!=null && Thread.currentThread()==pd.mythread) {
	    //	    //note: checking pd.running doesn't work - both pd and original thread can be running at same time!
	    Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
	    intimesliceloop=true;
	    loop.waitUntilLoopDone();
	    setuploop();
	    makeeffectmatrix();
	    attribute();
	    putbackorig();
	    intimesliceloop=false;
	}
    } //run
    
    void setuploop() {
	loop.endyear=2150; //make it faster!
	emitqt= new qt[]{ get(carboncycle.class).totemit,  get(othgasemit.class).ch4emit, get(othgasemit.class).n2oemit, }; //
	// recalc at start shouldn't be necessary if event mainloop finished ok, but helps to be sure
	loopgo();
	indicorig= get(glotemp.class).avchange.cloneIndependent();
	
	for (int g=0; g<ng; g++) {
	    emitorig[g]=emitqt[g].cloneIndependent();
	    effect[g]=new float[1+(int)(endyear.getval()-startyear.getval())][1+loop.endyear-gsy]; //effect of year A on year B, for each gas
	}
	
	mitigorig=get(controller.class).objective.chosen; get(controller.class).objective.chosen="donothing";
	emitoptorig=get(othgasemit.class).emitoption.chosen;  get(othgasemit.class).emitoption.chosen="donothing";
	//uncomment below to stop seeing calc as it goes along - faster
	//loop.itc=new interacob[] {	get(carboncycle.class), get(othgasemit.class) }; loop.itn=new interacob[] {	this};  loop.scin=true;
    }
    
    void loopgo() {
	//note: would be more efficient if we could just run from the beginning of timeslice year, but then have be sure can restore starting state in model boxes
	for (int j=0; j<ng; j++) ((module)emitqt[j].owner).changed=true; 
        loop.gonow(false); //recalc model
    }
    
    
    void makeeffectmatrix() {
	//for timeslice set all emissions after start year to zero
	if (method.chosen.equals("timeslice")) {
	    for (int y=(int)startyear.getval(); y<=loop.endyear; y++) for (int g=0; g<ng; g++) emitqt[g].set(y, 0);
	    loopgo();  //not sure why this necessary but seems to be so
	}
	for (int tsy=(int) startyear.getval(); tsy<= (int)endyear.getval(); tsy++)  if (pcb.isSelected())	{
	    int tss=tsy-(int)startyear.getval();
	    for (int g=0; g<ng;g++) emitqt[g].set(tsy-1, emitorig[g].get(tsy-1)); //restore all gases previous timestep
	    if (method.chosen.equals("timeslice")) {
		loopgo();
		base=get(glotemp.class).avchange.cloneIndependent();
		for (int g=0; g<ng; g++)  {
		    //for timeslice put back the emissions for this gas this year, others zero
		    for (int j=0; j<ng; j++) { if (g==j)  emitqt[j].set(tsy, emitorig[j].get(tsy));  else emitqt[j].set(tsy,0);}
		    //calc model and save in cause-effect matrix
		    loopgo();
		    for (int y=tsy; y<=loop.endyear; y++) effect[g][tss][y-gsy]=get(glotemp.class).avchange.get(y)-base.get(y);
		} //g
	    } //timeslice
	    if (method.chosen.equals("normarg"))   {
		for (int g=0; g<ng; g++) {
		    // for normarg subtract this gas, put back others
		    for (int j=0; j<ng; j++) {  if (g==j)   emitqt[j].set(tsy, 0);  else emitqt[j].set(tsy, emitorig[j].get(tsy));  }
		    //calc model and save in cause-effect matrix
		    loopgo();
		    for (int y=tsy; y<=loop.endyear; y++) effect[g][tss][y-gsy]=indicorig.get(y)-get(glotemp.class).avchange.get(y);
		}//g
	    } //normarg
	    pinfo.setText("done "+tsy);
	} //tsy
	
	//table to check
	for (int g=0; g<ng; g++) {
	    deb("\ngas "+g);
	    for (int tsy=(int) startyear.getval(); tsy<= (int)endyear.getval(); tsy+=20) {
		String s=""+tsy;
		for (int ns=tsy-gsy; ns<2100-gsy; ns+=20) s+="\t"+effect[g][tsy-(int)startyear.getval()][ns];
		deb(s);
	    }
	}
    }
    
    void attribute() {
	deb("attributing ");
	float frac=1;
	for (int y=gsy; y<=loop.endyear; y++)  for (int nr=0; nr<nregs ; nr++) 	surftemp.set(reg(nr), y, 0);
	for (int tsy=(int)startyear.getval(); tsy<(int)endyear.getval() && tsy<year; tsy++) if (pcb.isSelected()) {
	    int tss=tsy-(int)startyear.getval();
	    for (int y=tsy; y<=loop.endyear; y++)  {
		for (int g=0; g<ng; g++) { //gas
		    //assign to regions using change in indicator (above) and frac of emissions of each gas in each year
		    for (int nr=0; nr<nregs ; nr++) {
			region r=((region) (get(socreg.class).regions.chosen)).reg.get(nr);
			if (g==0) frac=(get(socreg.class).emitfosquota.get(r, tsy)+get(socreg.class).emitlucquota.get(r, tsy))/(get(carboncycle.class).fossil.get(tsy)+get(carboncycle.class).lucf.get(tsy));
			if (g==1) frac=get(socreg.class).emitch4.get(r, tsy)/get(othgasemit.class).ch4emit.get(tsy);
			if (g==2)  frac=get(socreg.class).emitn2o.get(r, tsy)/get(othgasemit.class).n2oemit.get(tsy);
			surftemp.set(reg(nr), y, surftemp.get(reg(nr), y) + effect[g][tsy-gsy][y-gsy]*frac );
		    }
		}//gas
	    } //y
	    pinfo.setText("attrib "+(tsy));
	} //tsy
    } //attribute
    
    
    void putbackorig() {
	//restore original emissions after endyear (can't just move pointer, because plot keeps old qt reference)!
	for (int y=(int)startyear.getval(); y<=loop.endyear; y++) for (int i=0; i<ng; i++) emitqt[i].set(y, emitorig[i].get(y));
	get(controller.class).objective.chosen=mitigorig;
	get(othgasemit.class).emitoption.chosen=emitoptorig;
	loop.endyear=gey;
	for (int j=0; j<ng; j++) ((module)emitqt[j].owner).changed=true;  
	changed=true; //note we are still in timesliceloop, so nothing should change in this module, but will replot
	loop.gonow(false);
    }
    
    
} //end responsibility

	    /*normalising factor -this is not right,
	    the top of norfrac fraction should not be orig but real sum of change due to this gas over this period
	     - but then what about nonlin combination other forcings?
	     can only get right absolute including ALL factors
	     
	    if (method.chosen.equals("normarg")) {
		sumchange=0;
		for (int tsy=(int)startyear.getval(); tsy<(int)endyear.getval() && tsy<(ns+gsy); tsy++) sumchange+=indicorig[ns]-indic[tsy-(int)startyear.getval()][ns];
		norfac=indicorig[ns]/sumchange;
	    }
	     */


