/*
 ok P1 CHRIS added UNFCCC data
 p1 CHRIS fix years without UNFCCC data not repeat the -999
 */

package jcm.mod.soc;
import jcm.core.*;
import jcm.core.data.histdata;
import jcm.core.data.interpolator;
import jcm.core.data.matchdata;
import jcm.core.reg.region;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.globco2emit;
import jcm.mod.reg.*;
import jcm.mod.carbon.*;
import static jcm.gui.gen.colfont.*;
import jcm.mod.ogas.othgasemit;

public class history extends module {
    
    public param LULUCF_UNFCCC_on = new param("UNFCCC LULUCF data", false, complexity.experimental);
    
    public void initsetup() {
	follows(get(CalcLucEmit.class));
	setaffectedby(get(socreg.class).regions);
	makegdpen();
    }
    
    
    public void setinteractions() {
	//P2 reconsider inverse carbon  feedback affects history: inefficient because we don't need to recalc *regional* LUC if only exploring the global feedbacks
	setaffectedby(get(carboncycle.class), get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") ||  get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") 	);
    }
    
    //*****************************
    qtset emitfos, emitluc, emitch4, emitn2o, pop, gdp, energy; //references only
    region regset;
    socreg socreg;  AviaShipEmit av; socio socio; globco2emit gc;
	    
    public static qtset fosCO2=new qtset("fosCO2", "mega&ton&carbon", 1750, 2002, complexity.expert);
    public static qtset hydepop=new qtset("pop", "kilo&person", 1700, 2002, complexity.expert);
    public static qtset epaCH4=new qtset("epaCH4", "mega&ton&CH4", 1990, 2020, 5, complexity.expert);
    public static qtset epaN2O=new qtset("epaN2O", "mega&ton&N", 1990, 2020, 5, complexity.expert);
    
    static  {
	//P2 note complicated mix for fosCO2 could be replaced by CDIAC which now extends to 2003 (but note UNFCCC extends to 2004) -see also scenarios.todo
	histdata.loaddata(fosCO2, "cdiacrows.csv", ",", false, 1f, 1750, 2000, 1750); histdata.oldsplit(fosCO2);
	histdata.loaddata(fosCO2, "eia_co2_emission.csv", "\t", false,  1f, 1980, 2002, 2001); //use only 2001-2
	histdata.loaddata(fosCO2, "UNFCCC_CO2emit.csv", ",", false,  12f/44f, 1990, 2002, 1990); //use 1990-2002 for countries with data
	histdata.loaddata(hydepop, "HYDE_pop_kkg.csv", "\t", true,  1f, 1700, 1995, 1700);
	histdata.loaddata(hydepop, "pop2002.csv", "\t", false, 1f, 2002, 2002, 2002); interpolator.linearinterp(hydepop, 1995, 2002);
	//original data was mega ton CO2eq, divide by GWP=23 to get mega ton CH4 
	histdata.loaddata(epaCH4, "EPA_CH4.csv", "\t", false, 1f/23f, 1990, 2020, 5, 1990); 
	//original data was mega ton CO2eq, divide by GWP=296 to get mega tonN2O,  then multiply 14/44 for N2O=> N (for consistent units with rest of JCM, as IPCC)
	histdata.loaddata(epaN2O, "EPA_N2O.csv", "\t", false, (14f/44f)*(1f/296f), 1990, 2020, 5, 1990); 
    }
    
    //****************************
    
    public void precalc() {
	
	//get references
	socreg=get(socreg.class);
	socio=get(socio.class);
	av=get(AviaShipEmit.class);
	gc=get(globco2emit.class);
	
	emitfos=socreg.emitfosbase;   emitch4=socreg.emitch4; emitn2o=socreg.emitn2o;
	emitluc=socreg.emitlucbase;
	pop=socio.pop; gdp=socio.gdp; energy=socio.energy;
	regset=(region)socreg.regions.chosen;
	
	qt fossil=gc.fossil, lucf=gc.lucf, totemit=gc.totemit;
	
	//*********** REGIONS ****************
//important to do this at start of calc chain, before other precalcs
	socreg.clearoldregions();
	socreg.clearoldregions(socio);
//	emitfos.map.clear(); emitluc.map.clear(); emitch4.map.clear(); emitn2o.map.clear(); pop.map.clear(); gdp.map.clear(); energy.map.clear();
	
	//*********** SOCIO *********************
	interpolator.fillregdata(hydepop, pop, regset , 0.001f);
	
	new interpolator(jcm12gdp, "JCM12", 1900, 1, false).fill(gdp, regset, 1900, 2000, hydepop);
	new interpolator(jcm12en, "JCM12", 1900, 1, false).fill(energy, regset, 1900, 2000, hydepop);
	
	//********* FOS ******************
	
	if (get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR")) interpolator.fillregdata(LUCdata.edgarff, emitfos, regset, 0.001f);
	else interpolator.fillregdata(fosCO2, emitfos, regset, 0.001f);
//	interpolator.fillregdata(histdata.lucCO2, emitluc, regset, 0.001f);
	
	//********** LUC ********************
	
	if (get(CalcLucEmit.class).lucsource.chosen.equals("Houghton")) {
	    float scalefactor=(float)get(CalcLucEmit.class).landuseemit1990.getval()/2158.09f;
	    new interpolator(LUCdata.lucCO2Houghton, 1950, 1f, scalefactor).fill(emitluc, regset, 1750, 2000, LUCdata.lucCO2CAIT);
	}
	
	if (get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR"))
	    interpolator.fillregdata(LUCdata.edgarluc, emitluc, regset, 1f);
	
//        if (lucsource.chosen.equals("MATCH"))
//            new interpolator(matchdata.matchco2luc, 1890, 1).fill(emitluc, regset, 1890, 2000, histdata.lucCO2IVIG);
	
	if (get(CalcLucEmit.class).lucsource.chosen.equals("IVIGmodel")) 
            interpolator.fillregdata(get(CalcLucEmit.class).lucemit, emitluc, regset, 0.001f);
            
        if (LULUCF_UNFCCC_on.istrue())
                interpolator.fillregdata(LUCdata.lucCO2UNFCCC, emitluc, regset, 1f);
      
        
//	if (get(CalcLucEmit.class).lucsource.chosen.equals("IVIGdata")) interpolator.fillregdata(get(CalcLucEmit.class).lucCO2IVIG, emitluc, regset, 0.001f);
	//            } else if (year<=2002) { lucf.set(0); for (qt q : histdata.lucCO2.map.values()) lucf.set(lucf.get()+q.get()/1000f); }
	
	//**************** CH4, N2O *******************
	
//	emitch4.map.clear();
	new interpolator(matchdata.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true).fill(emitch4, regset, 1890, 1970, epaCH4);
	new interpolator(matchdata.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true).fill(emitch4, regset, 1971, 2000, epaCH4);
	for (int y=1890; y<2000; y++) 	get(othgasemit.class).ch4emit.set(y, emitch4.calctot(y));
	
//	emitn2o.map.clear();
	new interpolator(matchdata.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true).fill(emitn2o, regset, 1890, 1970, epaN2O);
	new interpolator(matchdata.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true).fill(emitn2o, regset, 1971, 2000, epaN2O);
	for (int y=1890; y<2000; y++) 	get(othgasemit.class).n2oemit.set(y, emitn2o.calctot(y));
	//Note EH CH4 in Tg CH4, N2O in TgN
	
	
    }
    
    // ************** STEP ******
    public void calcstep(){
	
	if (year<fsy) {
	    for (region r : regset.reg) { socreg.emitfosquota.set(r, socreg.emitfosbase.get(r)); socreg.emitlucquota.set(r, emitluc.get(r)); }
	    float bunker=year>1900 ? av.secemit.get(AviaShipEmit.sec.tot_int) : 0;
	    socreg.emitfosbase.set("bunker", bunker);
	    socreg.emitfosquota.set("bunker", bunker);
	    
	    gc.fossil.set(socreg.emitfosbase.calctot());
	    socreg.emitfosquota.calctot();
	    pop.calctot();
	    gdp.calctot();
	    energy.calctot();
	    emitch4.calctot();
	    emitn2o.calctot();
	}
	if ( year>1755 && ((get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year<2005 ))) get(carboncycle.class).inverseluc();
	 //|| (get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") && year<1850) //old option - now houghton scaled back to 1750 (starting at 0 in 1700)
	
	else if (year < fsy) gc.lucf.set(emitluc.calctot());
	if (year<fsy) gc.totemit.set(gc.fossil.get()+gc.lucf.get());
    }
    
    //*********** DATA *****************
    //Historical data - array starts in 1900 but data starts in 1970 (why?)
    //note region 12 is world, 13 is denmark
    //gdp, energy data was saved per-capita, so don't apply any weights in splitting
    
    static public float[][]
	    jcm12pop=new float[14][101], // now only used for restoring gdp&en below
	    jcm12gdp=new float[14][101],
	    jcm12en=new float[14][101];
    ;
    
    void makegdpen() {
	//multiply gdp and en by population (original from image was per-capita)
	//have to do this before interpolation, otherwise doesn't work for other region-sets
	for (int i=0; i<13; i++) {
	    for (int j=70; j<101; j++) jcm12gdp[i][j]*=0.001f*jcm12pop[i][j];
	    for (int j=71; j<101; j++) jcm12en[i][j]*=jcm12pop[i][j];
	}
    }
    
} //end class


