    /*
Abatement (mitigation) and damagecost (Adaptation?) costs
Experimental!  May be developed further with clim-neg project Louvain
Please note, the author of JCM does not trust these simple formulae!
     
Developed January 2002 Louvain-la-neuve
     
     ************* Costs Todo ***************
P3 IDEA Other gas MACs: EPA MACs for CH4/N2O (not including agriculture) + CIRAD ppt for agric (in papers)
Note also MAC from MIT, but these are similar to EPA. Or other EMF sources?
     P3 add dynamic interactions to costs parameters
     
P2 CHECK total costs change with regionsets: to be expected, but needs consideration
P2 restore function parameters to original source regions (Nordhaus, CWS)
P2 CHECK costs: logarithmic formula for equity aversion=1 - it seems right, check algebra
P2 CHECK /FIX ?? min-costs for equal MACs
P2 IDEA Seek MACs for LUCF emissions?
P2 Systematically Explore effect of costs uncertainties
P1 IDEA Discuss coherence with Johan, Vincent
P1 IDEA Explore simpler variants for use in Climneg?
P1 IDEA  plot effective discount rate per region/country
      P1 STRUC apply forking qtset to GDP (reduced-GDP)?
     
     
     
     */

package jcm.mod.soc;
import java.util.*;
import jcm.core.*;
import static jcm.core.complexity.*;
import jcm.mod.obj.futbasescen;
import jcm.mod.obj.sres;
import jcm.core.reg.region;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.core.reg.regman;
import static jcm.core.report.*;


public class costs extends module  {
    
    //*****************************
    //standard module bits
    
    public void initsetup() {
	follows(get(socreg.class));
	follows(get(glotemp.class));
	//		follows(sealevel);
	affectsfutureonly=true; //check?  not for initial impacts costs, but irrelevant to optim etc.
    }
    
    
    public void setinteractions()  {
	setaffects(prtp,  constdisc.istrue());
	setaffects(effdisc2000, !constdisc.istrue());
    }
    
    
    
    public qtset
	    abatecost=new qtset("abatecost",  "giga&dollar&per&year"),
	    damagecost=new qtset("damagecost",  "giga&dollar&per&year"),
	    totalcost=new qtset("totalcost",  "giga&dollar&per&year"),
	    abatewelch=new qtset("abatewelch"),
	    damagewelch=new qtset("damagewelch"),
	    totalwelch=new qtset("totalwelch"),
	    reducedgdp=new qtset("reducedgdp",  "giga&dollar&per&year"),
	    origwelf=new qtset("welfare no-cli", expert);
    
    public param
	    prtp=new param("pure rate time pref", "%", 1.5, 0, 6), //set to 1.72 makes effective discount rate =3 at 2000 with ineqav=1
	    ineqav=new param("inequality-aversion","", 1.0, 0, 2),
	    effdisc2000=new param("effdisc2000", "%", 2.78, 0, 6),
	    constdisc=new param("fix-effdisc2000", false),
	    scaleabate=new param("scaledown abatement", "", 0.33, 0, 1, expert),
	    useprtp=new param("useprtp", true, expert),
	    ch4n2o=new param("ch4n2o", false, expert),
	    dyngdp=new param("dyngdp", true, expert),
	    usebackstop=new param("backstop", false),
	    macgem=new param("macgem", true), //use mac-gem abatement cost functions
	    abatepow=new param("abatepow", "", 2.887, 0, 6),
	    abatelin=new param("abatelin", "", 1, 0, 3),
	    damagepow=new param("damagecostpow", "", 1.5, 0, 6),
	    damagelin=new param("damagelin", "", 1, 0, 3),
	    backstop=new param("backstop", "$", 500, 0, 1000),
	    impfunc=new param("impfunc", new String[] {	"cws", "rice99", "tol02"} , "rice99");
    ;
    
    //for objective functions
    public float base, idw, iaw, iac, itw, iow, cumprtp, gtc, igwp, scaledownfac;
    
    boolean firsttime=true;
    List<region> regions;
    Map<region, Float> a1,  b1,  th1, th2, macgema, macgemb;
    
    public void precalc() {
	
	if (!firsttime) adjdisc();
	for (qtset qq :  qtsets) get(socreg.class).clearoldregions(qq);
	regions=((region)(get(socreg.class).regions.chosen)).reg;
	
	a1=interpolatefac(a1_jcm12, "JCM12", history.hydepop);
	b1=interpolatefac(b1_jcm12, "JCM12", history.hydepop);
	th1=interpolatefac(th1_jcm12, "JCM12", history.hydepop);
	th2=interpolatefac(th2_jcm12, "JCM12", history.hydepop);
	macgema=interpolatefac(macgema_jcm12, "JCM12", history.hydepop);
	macgemb=interpolatefac(macgemb_jcm12, "JCM12", history.hydepop);
    }
    
    public void postcalc() {
	if (firsttime) adjdisc();
//		if(scaleimcp.istrue()) scaledown();
    }
    //	debug("welfarechange: total, damage, abate :, "+(int) itw+", "+(int)idw+ ", "+(int)iaw);
    
    public void reportcosts() {
	log("emit2050fos, emit2050tot, conc, temp2150, iaw, idw,  ="+get(carboncycle.class).fossil.get(2050) +"\t"+get(carboncycle.class).totemit.get(2050) +"\t"+get(carboncycle.class).co2atppm.get(2200)+"\t"+get(glotemp.class).avchangeby.get(2150)+"\t"+iaw+"\t"+idw);
    }
    
    
    /*****************************************
     * ADJUST DISCOUNT
     * Either fix discount rate 2000 or prtp, the other will change depening on ineqav
     * Note: this only works after first socreg calcstep! Hence firsttime flag;
     *
     * old method: adjust prtp by dweight/dt at 2000 to keep effective discount rate constant
     * prtp.setval( prtp.getval() - 100f*(ineqav.getval()-oldineqav)*dgpcdt );
     * //double  oldineqav=-1; //initial flag -1 prevents running this before initial socreg. calcstep
     */
    
    void adjdisc() {
	socio soc= get(socio.class);
	float dgpcdt=(
		(soc.gdp.get(regman.world, 2000)  / soc.pop.get(regman.world, 2000) )
		/ (soc.gdp.get(regman.world, 1990) /soc.pop.get(regman.world, 1990)) -1f
		)/10f;
//		System.err.println("dgpcdt="+dgpcdt);
	firsttime=false;
	if (constdisc.istrue()) {
	    prtp.putval(effdisc2000.getval() - 100f*dgpcdt*ineqav.getval() );
	    prtp.changed=true;
	} else {
	    effdisc2000.putval(prtp.getval() + 100f*dgpcdt*ineqav.getval() );
	    effdisc2000.changed=true;
	}
    }
    
    
    //***********************************************************
    
    
    public void calcstep() {
	if (year >=fsy) {
	    if (year==fsy) ewbase();
	    if (year==fsy) {	cumprtp=1f; iaw=0; idw=0; itw=0; iow=0; gtc=0; iac=0; igwp=0;}
	    if (year>fsy && useprtp.istrue()) cumprtp*=(1f-prtp.getval()/100f);
	    
	    socio soc=get(socio.class);
	    for (region r : regions)  {
		float weight=ew(r);
		damagecost.set(r,dc(r));
		abatecost.set(r,ac(r));
		totalcost.set(r,damagecost.get(r)+abatecost.get(r));
		reducedgdp.set(r, soc.gdp.get(r)-totalcost.get(r));
		origwelf.set(r,  soc.gdp.get(r) * weight * cumprtp);
		damagewelch.set(r,  damagecost.get(r) * weight * cumprtp);
		abatewelch.set(r, abatecost.get(r) * weight * cumprtp);
		totalwelch.set(r, abatewelch.get(r) + damagewelch.get(r));
		iaw+=abatewelch.get(r); idw+=damagewelch.get(r); itw+=totalwelch.get(r); iow+=origwelf.get(r);
		
		iac+=abatecost.get(r)* cumprtp; igwp+=soc.gdp.get(r)* cumprtp;
		if (year<=2100)  gtc+=get(socreg.class).emitfosabate.get(r)*0.001f;
	    } //nr
	    for (qtset qq : qtsets) qq.calctot();
	    if (year==2100) {
		
		scaledownfac=0.0007f * gtc  /  (100f*iaw/iow);
		deb(" gtc="+gtc+" \t\t awelfloss= "+100f*iaw/iow+"% \t\t gwploss= " + 100f*iac/igwp+  " \t\t scaledown= "+scaledownfac);
	    }
	} //if
    } //end calcstep
    
    
    
    
    //************************************************
	    /*start by scaling to 0.7% per 1000GtC
	    but cannot optimise unless have a curve, so marginal is increasing
	    problem is that scaledownfac decreases (effect increases) as make more abatement => marginal costs decrease!
	     */
    
    
    public void scaledown() { //not very efficient!
	scaledownfac=0.0007f * gtc  /  (100f*iaw/iow);
	deb(" gtc="+gtc+" \t\t gwploss= "+100f*iaw/iow+"% /t/t scaledown= "+scaledownfac);
	iaw*=scaledownfac; itw=iaw+idw;
	for (int y=fsy; y<=gey; y++) for (region r : regions) {
	    abatecost.set(r, y, abatecost.get(r, y)*scaledownfac);
	    abatewelch.set(r, y,  abatewelch.get(r, y) * scaledownfac);
	    
	    totalcost.set(r, y, damagecost.get(r, y)+abatecost.get(r, y));
	    reducedgdp.set(r, y, get(socio.class).gdp.get(r, y) - totalcost.get(r, y));
	    totalwelch.set(r, y,  abatewelch.get(r, y) + damagewelch.get(r, y));
	}
    }
    
    
    public int nr(region r) {  	return regions.indexOf(r);     }
    //temporary fix - rather inefficient
    
    public float beta(region r) { return (float) (    macgem.istrue() ? (1f+scaleabate.getval()*(macgemb.get(r)-1f)) : abatepow.getval() ); }
    
    public float gdp(region r) {
	if (dyngdp.istrue() && year>fsy) return get(socio.class).gdp.get(r)*reducedgdp.get(r, year-1)/get(socio.class).gdp.get(r, year-1);
	else return get(socio.class).gdp.get(r);
    }
    
    public float alpha(region r) {
	return (float) (abatelin.getval() * (
		macgem.istrue() ? macgema.get(r)* scaleabate.getval()  / Math.pow(1000f, beta(r))
		: gdp(r) * b1.get(r) / Math.pow(get(socreg.class).emitfosbase.get(r), beta(r))
		));
    }
    
    public float ac(region r) {
	if (get(socreg.class).emitfosquota.get(r)<0) return Float.MAX_VALUE;
	float ac= (get(socreg.class).emitfosabate.get(r)>0) ? (float) ( alpha(r)*Math.pow(get(socreg.class).emitfosabate.get(r), beta(r)) ) : 0;
	if (usebackstop.istrue() && ac/get(socreg.class).emitfosabate.get(r)>(float) backstop.getval()/1000f) ac=(float) backstop.getval()/1000f*get(socreg.class).emitfosabate.get(r);
	
	if (ch4n2o.istrue()) {
	    //cost functions from Aaheim04 - but something wrong with power exponents!
	    float scale=get(carboncycle.class).fossil.get(year)/(1000f*sres.interp(sres.fosemit, get(futbasescen.class).scenario.getchosenindex(), year));
	    //			float ch4cost=(float)Math.pow(sres.interp(sres.ch4emit, year)*(1f-scale) / 61.18f , (1f/0.23f) ) * 1000f;
	    //			float n2ocost=(float)Math.pow(sres.interp(sres.n2oemit, year)*(1f-scale) / 0.46f , (1f/0.12f) ) * 1000f;
	    //from curve in chesnaye
	    float ch4red= sres.interp(sres.ch4emit, get(futbasescen.class).scenario.getchosenindex(), year)*(1f-scale) - 22; if (ch4red<0) ch4red=0; //first 22 are free
	    float ch4cost= 0.003f*ch4red*ch4red+ 0.0002f*ch4red*ch4red*ch4red;
	    ac+=ch4cost*get(socreg.class).emitch4.get(r, 1990)/get(socreg.class).emitch4.calctot(1990);
	    //			ac+=n2ocost*get(socreg.class).emitn2o[nr(r)][1990-gsy]/calctot(get(socreg.class).emitn2o , 1990);
	}
	
	return ac;
    }
    
    public float mac(region r) { return mac(r, module.year); }
    public float mac(region r,int year) {	//year-1 used by get(shares.class)
	return (float) ( beta(r)*alpha(r)*Math.pow(get(socreg.class).emitfosabate.get(r, year-1), beta(r)-1f) );
    }
    
    public float dc(region r) {
	if (impfunc.chosen=="cws") return (float)(gdp(r) * damagelin.getval() *a1.get(r) *Math.pow(get(glotemp.class).avchange.get(year) / 2.5, damagepow.getval()) );
	if (impfunc.chosen=="rice99") {
	    float dt=get(glotemp.class).avchange.get(year) - get(glotemp.class).avchange.get(1990), df=(float)(th1.get(r) * dt +th2.get(r) * dt*dt);
	    return gdp(r) * (float)damagelin.getval() * (df/1f+df)  ;
	}
	return 0;
    }
    
    public float ew(region r) { return ew(r, module.year); }
    public float ew(region r, int year) { //year-1 used by get(shares.class)
	//		if (welfarelog.istrue()) return (1f / gdp(nr));  this needs more thought!
	return (float) Math.pow((get(socio.class).pop.get(r)/gdp(r)) *base , ineqav.getval());
    }
    void ewbase() {
	if (dyngdp.istrue()) {	base=0; for (region r : regions)  base+=gdp(r); base/=get(socio.class).pop.get(regman.world) ; } else 	base=get(socio.class).gdp.get(regman.world) /get(socio.class).pop.get(regman.world);
	//if apply weights over time, keep the base from 2000, otherwise recalc each year
    }
    
    
    
    Map<region, Float> interpolatefac(double[] source, String sourcesetname, qtset weights) {
	int year=2002; //for the moment use weights only from 2002
	Map<region, Float> dest=new HashMap();
	List<region> sourceset=regman.allreg.find(sourcesetname).reg;
	
	for (region r : regions) {
	    float sumfac=0, sumweight=0;
	    Set<region> regnat=r.subreg(regman.nations);
	    for (region sr : sourceset)  {
		int ri=sourceset.indexOf(sr);
		for (region nat : sr.subreg(regman.nations)) if (regnat.contains(nat)) {
//			    System.err.println(r+" "+sr+" "+nat+" "+source[ri]+" "+weights.get(nat, year));
		    sumfac+=source[ri]*weights.get(nat, year);
		    sumweight+=weights.get(nat, year);
		}
	    }
	    dest.put(r, sumfac/sumweight);
//		    System.err.println(source+" "+r+" "+sumfac/sumweight);
	}
	return dest;
    }
    
    
    //***************************************************
    //these functions have been interpolated to fit JCM12 regions
    
    
    //nordhaus abate cost b1 b1*GDP*frac abatement^b2 -see climnegWP19
    static double[]
	    b1_jcm12={	0.07, 0.07, 0.05, 0.05, 0.10, 0.15, 0.10, 0.15, 0.10, 0.10, 0.10, 0.10},
	    //note b2 = 2.887 for all regions
	    
	    //nordhaus damagecost cost a1*GDP*(DT/2.5)^a2
	    a1_jcm12={	0.01102, 0.01102, 0.01174, 0.01174, 0.01000, 0.00857, 0.02093, 0.01523, 0.02903, 0.02903, 0.02903, 0.02903},
	    //note climnegWP19 has 0.015523 for China
	    //note a2=1.5 (default), raised to 2.0 in some climneg papers
	    
	    //functions from Nordhaus99:
	    th1_jcm12={	-0.0026,	-0.0070,	-0.0070,	-0.0010,	-0.0076,	-0.0076,	0.0039,	-0.0041,	0.0022,	0.0039,	0.0100,	0.0100	},
	    th2_jcm12={	0.0017,	0.0030,	0.0030,	0.0049,	0.0025,	0.0025,	0.0013,	0.0020,	0.0026,	0.0013,	0.0027,	0.0027 },
	    
	    //johan paper abatement cost G$ =a*R^b R in GtC
	    macgema_jcm12={	373.612, 337, 290.224, 241.278, 694.559, 694.559, 269.217, 199.020, 523.793, 496.158, 500, 235.499},
	    macgemb_jcm12={	1.220, 1.372, 1.251, 1.426, 1.100, 1.100, 1.279, 1.634, 1.209, 1.180, 1.2, 1.846};
    
} //end costs


	/*
	P1 TIDY old equity-weighting options
	 
	if ineqav=0, has no effect: effective bias to rich (gdp-weight)
	if ineqav=1, same as nordhaus pop-weight
	if ineqav>1, bias towards poor
	 
	note orig impacts assumed prop to (gdp/pop), then multiplied by pop (ie impact is proportional to gdp)
	pop-weight assumes  impacts prop to global av (gdp/pop) =>mult by av local (pop/gdp) * av (gdp/pop)
	note: should only apply this weighting to impacts that were formulated as proportional to income, not to those originally proportional to popn
	 
	another variant could be to use just oecd gdp/pop - if that's the source of impact valuation
	 */


	/*
	to improve:
	should be arrays for welfare as well as total gdp
	or is it the *change* in welfare from baseline? (as sum costs)
	need a parameter for the welfare function (3 variants - Johan ineq-avers, Tol logarithm, Nordhaus popweight),
	 
	also show the change in equity (gini?)
	 
	also need to calc total welfare for express costs as fraction
	but this is not trivial since the weight for the total w/g is not same as for marginal dw/dg!
	 
	discounting: curve should show future costs in terms of present value, but not integrated
	but how then to see the integral moving on the plot?
	 
	need to adjust leastcost to take into account welfare?
	(noting march04 analysis - that popweight has big effect when leastcost not with sresdist)
	 
	aha - problem with weighting is that it's not affecting the weight over time (variable discount rate)
	because we cancel by the totgdp/pop
	should also show effect of weighting on abate and damage costs separately, not only on total
	and ditto for discount rate
	maybe we should assume that impacts were calibrated prop to global-average gdp/cap in 1990?
	or prop to rich-country gdp/cap in 1990?
	 
	 
	 */

