/*
 Aviation and Shipping emissions, history and future
 note history is run in initsetup and never changes (hence no interactions)
 future depends on scenario from IPCC SR + stabilisation scaledown, assumed to be within SRES, hence follows globco2emit
 
 see text file in climate/data/gases/bunker for more info on history and scenarios
 */

package jcm.mod.soc;

import java.awt.Color;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.futbasescen;

public class AviaShipEmit extends module {
    
    public static int sy=1900, ey=2200; //note beware non-standard sy and ey can cause problem in derivative qtsets!
    public param<scen> aviascen=new param("Aviation Scenario", scen.values(), scen.Fa1);
    public param scaleavia=new param("Reduce for Stabilisation", true);
    public qtset secemit=new qtset("Aviation & Shipping CO2 Emissions", "mega&ton&carbon&per&yr", sy, ey);
    
    float avtotbase, matotbase, totbunk, avnomil, manomil, mainc, favdom, favA1, fmadom, fmaA1, scaledown;
    scen sc; int scenyear=0;
    socreg sr; globco2emit gc;
    
    //****************************** DATA ************************************
    // note av=aviation, ma=marine, A1=Annex1, DC=others, int=international, dom=domestic, mil=military
    public enum sec {
	Ship_A1_int(dkblue), Ship_DC_int(dkcyan), 	Ship_A1_dom(ltblue), 	Ship_DC_dom(cyan), 	Ship_mil(dkyellowgreen),
	Avia_A1_int(dkred),	Avia_DC_int(dkorange), 	Avia_A1_dom(pink), 	Avia_DC_dom(orange), 	Avia_mil(yellow),
	tot_int(dkgrey), 	tot_dom(grey), 	tot_Ship(blue), 	tot_Avia(red),	    tot_all(black), tot_all_base(green);
	Color col;  sec(Color c) { col=c; }
    }
    
    
    //below taken from table 6-2 of IPCC special report
    public enum scen {
	Fa1(new float[] {0.147f, 0.187f, 0.279f, 0.315f, 0.405f} , new float[]{2.0f, 2.8f, 4.3f, 5.1f, 7.2f} ),
	Fa2(new float[] {0.147f,0.187f,0.279f, 0.319f, 0.419f}, new float[]{2.0f, 2.8f, 4.3f, 4.7f, 5.6f}  ),
	Fc1(new float[] {0.147f, 0.187f, 0.279f, 0.265f, 0.231f}, new float[]{2.0f, 2.8f, 4.3f, 4.2f, 4.0f}  ),
	Fe1(new float[] {0.147f,0.187f,	0.279f, 0.382f,	0.640f}, new float[]{2.0f, 2.8f, 4.3f, 6.4f, 11.4f}  ),
	Eab(new float[] {0.147f, 0.179f,  0.255f,  0.463f, 0.983f}, new float[]{2.0f, 2.2f , 2.9f, 4.3f, 7.9f}  ),
	Edh(new float[] {0.147f, 0.224f,  0.385f, 0.690f, 1.452f}, new float[]{2.0f, 2.8f, 4.3f, 6.4f,  11.6f}  );
	//FA1h(new float[] {0.147f,0.187f, 0.279f, 0.344f, 0.479f}, new float[]{2.0f, 2.8f, 4.3f, 5.0f , 7.0f}  ), //note supersonic scenario, effect of NOx quite different, but paste data for use later
	public static int y[]= { 1990, 2000, 2015, 2025, 2050 };
	public float[] co2, nox;
//note nox emissions in Mt(NO2)!
	scen(float[] f1, float[] f2) {co2=f1; nox=f2;}
    }
    
    
    //********************* SETUP ***************************
    //note that bunker not shown in simplest complexity level!!!
    public void initsetup() {
	sr=get(socreg.class); gc=get(globco2emit.class);
	for (sec s : sec.values()) { secemit.reg(s).color=s.col; if (s.name().startsWith("tot")) { secemit.reg(s).type=qt.Type.total;   } }
	aviashiphistory(); //since this never changes, and run before rest, does not need to be in history interactions
	follows(globco2emit.class); //for future scaling
    }
    
    //************************************ HISTORY **************************
    void aviashiphistory() {
	
	float CO2fac=12f/44f;
	//data from UNFCCC for 2002:
	secemit.set(sec.Ship_A1_int, 2002, 204f*CO2fac);
	secemit.set(sec.Ship_A1_dom, 2002, 100f*CO2fac);
	secemit.set(sec.Avia_A1_int, 2002, 205f*CO2fac);
	secemit.set(sec.Avia_A1_dom, 2002, 240f*CO2fac);
	//assume DC same as A1 for marine-note reduced from 1.2
	secemit.set(sec.Ship_DC_int, 2002, secemit.get(sec.Ship_A1_int, 2002));
	secemit.set(sec.Ship_DC_dom, 2002, secemit.get(sec.Ship_A1_dom, 2002));
	//assume DC half A1 for aviation (see bunkernotes.txt)-note reduced from 0.6
	secemit.set(sec.Avia_DC_int, 2002, secemit.get(sec.Avia_A1_int, 2002)*0.5f);
	secemit.set(sec.Avia_DC_dom, 2002, secemit.get(sec.Avia_A1_dom, 2002)*0.5f);
	
	//OLD - this causes too big a discrepancy with IPCC -see bunkernotes.txt
	//set 2002 data, corrected such that total international bunker starts at 3.3% of fossil as per IEA data
	//note IEA assumes military is domestic, acc to UNFCCC05
	//float cf=0; for (sector s : sector.tot_int.subsec) cf+=s.emit_CO2_2002; cf=history.fosCO2.calctot(2002)*0.001f*0.033f/cf; //(1f-fracmil(2002))
	
	//scale aviation total to IPCC SR 187MtC in 2000 (assume inc mil) - note this must be changed if above fracs change
	float cf=187f *(history.fosCO2.calctot(2002)/history.fosCO2.calctot(2000)) / ( 445f *(1f+0.5f*0.97f) *CO2fac *(1f+fracmil(2000)) );
	for (sec s : sec.values()) if (s.name().contains("Avia") && !s.name().contains("mil")) 	secemit.set(s, 2002, secemit.get(s, 2002) *cf);
	//System.err.println("aviation scaled down from UNFCCC by "+cf); //currently about 0.92
	
	//extrapolate back in time
	for (int y=2002; y>=sy; y--) {
	    float rtot= history.fosCO2.calctot(y) / history.fosCO2.calctot(y+1);
	    
	    for (sec s : sec.values()) {
		if (s.name().contains("tot")) {
		    String tt=s.name().substring(4);
		    float t=0; for (sec ss : s.values()) if (!ss.name().contains("tot") && ss.name().contains(tt)) t+= secemit.get(ss,y); secemit.set(s, y, t);
		} else if (s==s.Avia_mil) {
		    float f=0; for (sec ss : s.values()) if (ss!=s.Avia_mil && ss.name().contains("Avia") ) f+=secemit.get(ss, y);secemit.set(s, y, f*fracmil(y));
		} else if (s==s.Ship_mil) {
		    float f=0; for (sec ss : s.values()) if (ss!=s.Ship_mil && ss.name().contains("Ship") ) f+=secemit.get(ss, y);secemit.set(s, y, f*fracmil(y)*0.25f); //guess frac mil for shipping is 1/4 that of avn
		}else if (y<2002) {
		    //% relative increase per year (as fraction of global total emissions) - note orig 4%/yr for Ax1-av pre 2000 & 6% for DC, now reduced to 2.5% & 4% (so avg 3% as IPCC)
		    float incperyr= (s.name().contains("Avia") && y<2000 ? 2.5f : 0 ) +( s.name().contains("DC") ? 1.5f : 0);
		    secemit.set(s, y, secemit.get(s,y+1)*(100f / (100f+incperyr)) * rtot);
		}
	    }
	} //y
	
	
    } //history
    
    //********************************** FUTURE ************************
    void setupfuture() {
//Note: this doesn't currently respond to scaling the total "bunker" in futbasescen or shares, which is a different qtset!
	
	sc=aviascen.chosen; scenyear=0;
	mainc=0.01f; //temporary guess to continue trend
	favdom=secemit.get(sec.Avia_A1_dom, fsy-1)/(secemit.get(sec.Avia_A1_int, fsy-1)+secemit.get(sec.Avia_A1_dom, fsy-1));
	favA1=secemit.get(sec.Avia_A1_int, fsy-1)/(secemit.get(sec.Avia_A1_int, fsy-1)+secemit.get(sec.Avia_DC_int, fsy-1));
	fmadom=secemit.get(sec.Ship_A1_dom, fsy-1)/(secemit.get(sec.Ship_A1_int, fsy-1)+secemit.get(sec.Ship_A1_dom, fsy-1));
	fmaA1=secemit.get(sec.Ship_A1_int, fsy-1)/(secemit.get(sec.Ship_A1_int, fsy-1)+secemit.get(sec.Ship_DC_int, fsy-1));
    }
    
    public void calcstep() {
	
	if (year==fsy) setupfuture();
	
	if (year >=fsy &&  year<=ey) {
	    favdom*=0.99f; favA1*=0.99f; //temporarily  changing fracs are guesses, later should extrapolate trends
	    fmadom*=0.99f; fmaA1*=0.99f; mainc*=0.99f;
	    if (year>sc.y[scenyear] && year<2050) scenyear++;
	    
	    avtotbase=1000f * ( (year-sc.y[scenyear-1])*sc.co2[scenyear]+(sc.y[scenyear]-year)*sc.co2[scenyear-1] ) / (sc.y[scenyear]-sc.y[scenyear-1]);
	    avnomil=avtotbase/(1f+fracmil(year));
	    
	    matotbase=(year==fsy) ? secemit.get(sec.tot_Ship, fsy-1) : matotbase* (1f+mainc);
	    manomil=matotbase/(1f+fracmil(year)*0.25f);
	    
	    totbunk=avnomil*(1f-favdom) + manomil*(1f-fmadom);
	    
	    /*
	     blending with SRES via topdownscale:
	     "true" implies scale all *except* bunker to fit the required total - the concept is that bunker has been implicitly included in SRES, so we need to remove it proportionally
	     note that for low SRES (B1 and A1T) this still produces unreasonable results (unless combine with a low aviation scenario)
	     maybe would be better to scale according to fraction of corresponding SRES scenario (eg Fa1:IS92A etc.)
	     
	     note emitfosquota is set in shares, which starts by copying emitfosbase, and later scaling down by same factor as below
	     
	     note, (only) after 2100, sresext applies a bottom up approach, so higher aviation scenario => higher total,
	     but not so much higher because other regional emissions started from lower base (since total fixed before 2100)
	     
	     note: it seems that switching scaledown on /off doesn't preserve the total CO2 emissions
	     - actually this is correct, due to feedbacks from aviation non-CO2 gases affecting the temperature and hence the carbon sinks
	     
	     */
	    
	    sr.emitfosbase.set("bunker", totbunk);
	    if (year <=2100) sr.emitfosbase.topdownscale(gc.fossilbase.get(), true);
	    else gc.fossilbase.set(sr.emitfosbase.calctot()); //repeating sresext
	    
	    scaledown= scaleavia.istrue() ? gc.fossil.get()/gc.fossilbase.get() : 1f;
	    sr.emitfosquota.set("bunker", totbunk*scaledown);
	    
	    avnomil*=scaledown; manomil*=scaledown;
	    
	    secemit.set(sec.tot_Avia, year, avtotbase*scaledown);
	    
	    secemit.set(sec.Avia_mil, year, avnomil*fracmil(year) );
	    secemit.set(sec.Avia_A1_int, year, avnomil*(1f-favdom)*favA1 );
	    secemit.set(sec.Avia_A1_dom, year, avnomil*favdom*favA1 );
	    secemit.set(sec.Avia_DC_int, year, avnomil*(1f-favdom)*(1f-favA1) );
	    secemit.set(sec.Avia_DC_dom, year, avnomil*favdom*(1f-favA1) );
	    
	    secemit.set(sec.tot_Ship, year, matotbase*scaledown);
	    secemit.set(sec.Ship_mil, year, manomil*fracmil(year)*0.25f );
	    secemit.set(sec.Ship_A1_int, year,  manomil*(1f-fmadom)*fmaA1 );
	    secemit.set(sec.Ship_A1_dom, year, manomil*fmadom*fmaA1 );
	    secemit.set(sec.Ship_DC_int, year, manomil*(1f-fmadom)*(1f-fmaA1) );
	    secemit.set(sec.Ship_DC_dom, year, manomil*fmadom*(1f-fmaA1) );
	    
	    for (sec s : sec.values()) {  //note copy of history - could move to enum to avoid duplication?
		if (s.name().contains("tot")) {
		    String tt=s.name().substring(4);
		    float t=0; for (sec ss : s.values()) if (!ss.name().contains("tot") && ss.name().contains(tt)) t+= secemit.get(ss,year); secemit.set(s, year, t);
		}
	    } //s
	} //year
    } //calcstep
    
    float fracmil(int year) { //fraction military aviation as proportion of non-military aviation,
	int[] y={0, 1945, 1976, 1992, 2015, 2050, 9999 }; float[] f= { 0.4f, 0.6f, 0.36f, 0.18f, 0.07f, 0.03f, 0.03f }; //from IPCC SR, +guess pre-1976
	int i=0; while (year>=y[i]) i++;
	float ff=( (year-y[i-1])*f[i]+(y[i]-year)*f[i-1] ) / (y[i]-y[i-1]);
	return ff/(1f-ff);
    }
    
} //class


//	float emit02;//CO2 Emissions 2002, in MtC
//	sec(Color c, float f1) {col=c; emit02=f1*12f/44f;}//convert CO2 to C
//	sec(Color c, sec ...ss ) {col=c;subsec=new HashSet(4);for (sec s : ss )subsec.add(s);}

