 /*
Regional Seasonal Climate
P4 regseacli doesn't pass the right parameter to map (gets socioregions not cliregions)
 P3 Fix:  ratiochangebase only works when both1 is selected from regcli quantity 
  */

package jcm.mod.reg;
import javax.swing.JLabel;
import jcm.core.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import static jcm.gui.gen.colfont.*;
import jcm.gui.gen.processdialog;
import static jcm.core.complexity.*;

public class regseacli extends module implements Runnable   {
    
    public void setinteractions() {
	setaffectedby(get(regcli.class));
    }
    
    public param ratioglobav=new param("ratio to global average change", expert, false);
    public param ratiochangebase=new param("ratio change to base after regional average", expert, false);
    public param regions=  regman.makeregionparam("cliregions");
    
    
    public qtset annualcycle=new qtset("seasonalcycle", 1, 12, complexity.expert) {
	public param getxscale() {	return new param(param.Type.Xscale,  "xscale", "month", 0, 1, 12); }
	public param getyscale() { 	return new  param(param.Type.Yscale,  "Yscale", (ratioglobav.istrue() ? "ratio to global average change" : ""),  0, 0, 3); }
	//problem is that yscale autoscale doesn't work before calc, and second loop.go doesn't force rescale
	//P2 annualcycle map doesn't make sense
    };
    
     public void initsetup() {
	regions.mycomplexity=complexity.expert;
	for (region r : ((region) regions.chosen).reg) annualcycle.get(r);
	super.initsetup();
    }
    
    
    public void postcalc() {
	if (pd==null || !pd.running ) pd=new processdialog(this, "Regional Seasonal Climate", new JLabel("Calculating Regional Seasonal Climate"), pinfo);
    }
    
    JLabel pinfo=new JLabel("month");
    processdialog pd;
    
    public void run() {
	loop.waitUntilLoopDone();
	region regset=(region) regions.chosen;
	regset.makepolys();
	annualcycle.map.clear();
	get(regcli.class).d1.stats();
	if (ratiochangebase.istrue()) get(regcli.class).d2.stats();
	
	for (int m=0; m<12; m++) {
	    get(regcli.class).month.choose(m); get(regcli.class).run();
	    for (region r : regset.reg) {
		pinfo.setText("month: "+m+"region: "+r.getName());
		r.makepolys();
		if (ratiochangebase.istrue()) annualcycle.set(r, m+1,  (float)( r.avg(get(regcli.class).d2)/ r.avg(get(regcli.class).d1)  ) );
		else annualcycle.set(r, m+1,  (float)(r.avg(get(regcli.class).d1) * (ratioglobav.istrue() ? 1f/get(regcli.class).d1.av : 1f) ) );
		//P1 FIX note d.av isn't the right thing to divide by in case of regcli both or ratio - meanwhile don't use ratioglobav for these cases
	    }
	}
	changed=true;  loop.gonow(false);
    } //run
    
} //class

	/*
	 for 4-seasons
	float[] sum3=new float[nr];
	 
	sum3[i]+= changeratio/3f;
	if (m % 3==2) {
	 annualcycle[i].a[12+(int)(m/3)]= sum3[i];
	sum3[i]=0;
	}
	 */




