//mapdata: a specific GCM or baseline climatology dataset (12 months)
//see also jcm/mod/regcli.java and jcm/pan/regclimap.java

package jcm.mod.reg;

import java.io.DataInputStream;
import java.io.EOFException;
import jcm.core.tls.fileio;
import static jcm.core.report.*;



public class mapdata {
    public byte[][] o; //original data (12 months)
    public float[] r; //real/restored data
    public int nmon, nlon, nlat, tot;
    public double max, min, range, fac=1;
    public double av, sd, sum, sumsq, area;
    
    public boolean gettingdata=false;
  
    
    //unpacks files saved with "convertdata"
    public boolean getdata(String dataset, String quantity) {
	if (!gettingdata) {	//avoid recall load before finished
	    gettingdata=true;
	    boolean gotduds=dataset.equals("baseline");
	    String filename=dataset+"."+quantity+".dat";
	    try {
		DataInputStream	datain = fileio.getDIS("data/gcmdata/"+filename);
		nmon=datain.readShort(); nlat=datain.readShort(); nlon=datain.readShort();
		min=datain.readFloat(); max=datain.readFloat();
		
		tot=nlon*nlat;
		range=(max-min);
		
		o =new byte[nmon][tot+1];
		r =new float[tot+1];
		
		if (gotduds) {
		    int i=0; int m=0; int j=0;
		    try {
			int q=0; boolean dud=false;
			
			do {
			    if (dud && j<q) {	o[m][i]=-1; i++; j++; } else {
				if (q==255) {	dud=true; j=0; q=datain.readUnsignedByte(); } else {
				    if (dud) dud=false;
				    else  {	o[m][i]=(byte)q; i++; }
				    q=datain.readUnsignedByte();
				}
			    }
			    if (i==nlat*nlon) {	i=0; m++; }
			} while (m<nmon);
			
		    } catch (EOFException e) {	deb("EOF m:"+ m + " i:"+i ); }
		}
		
		else {
		    for (int i=0; i<nmon; i++) {
			int got=0; do {	got+=datain.read(o[i],got,tot-got); } while (got<tot);
		    }
		}
		
		datain.close();
		stats();
		log("loaded "+filename+" av="+av+" sd="+sd+" min="+min+" max="+max);
		gettingdata=false;
		return true;
		
	    } catch (Exception e) {
		log("Mapdata Loading Problem: " + filename+ e.getMessage());
		log("Mapdata Loading Problem" + filename);
		for (int i=0; i<tot; i++)  for (int m=0; m<nmon; m++) o[m][i]=-1;
		gettingdata=false;
		return false;
	    }
	} //if
	return false;
    } //end run
    
    //restore one nmonth's data to original form
    public void restore(int m) {
	double f=range/254.0;
	for (int i=0; i<tot; i++){
	    if (o[m][i]==-1) r[i]=-999f; else r[i]= (float)( min + f* (o[m][i]>=0 ? o[m][i] : 256+o[m][i]) );
	}
	fac=1.0;
    }
    
    //calc statistics for this dataset
    public void stats() {
	double cosnlat; int k;
	sum=0; sumsq=0; area=0;
	for (int m=0; m<nmon; m++) {
	    restore(m);
	    for (int i=0; i<nlat; i++) {
		cosnlat=Math.sin((0.5+i)*Math.PI/nlat); //note sin assumes i is zero at north pole
		//area+=nlon*cosnlat;
		for (int j=0; j<nlon; j++) {
		    k=nlon*i+j;
		    if (r[k]>-999) {
			area+=cosnlat;
			sum += cosnlat * r[k];
			sumsq += cosnlat * r[k]*r[k];
		    }
		}}}
	av=sum/area;
	sd= Math.pow((sumsq/area -av*av),0.5);
    }
    
    //scale data by a factor
    public void scaledata(double newfac) {
	double fac2=newfac/fac; fac=newfac;
	for (int i=0; i<tot; i++) if (r[i]>-999) r[i]*=fac2;
	//			log("scaled by "+newfac);
    }
    
} //end class mapdata


