package jcm.mod.ogas;

import jcm.core.*;
import jcm.core.data.interpolator;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;

import jcm.mod.obj.futbasescen;
import jcm.mod.obj.sres;
import jcm.core.reg.region;
import jcm.mod.soc.*;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.globco2emit;

public class othgasemit extends module  {
    
    //*******************************************************
    //INTERACTIONS
    public void setinteractions() {
	follows(get(futbasescen.class), emitoption.chosen=="sresfix" || emitoption.chosen=="sresscale");
	follows(get(globco2emit.class), emitoption.chosen=="2000scale" || emitoption.chosen=="sresscale");
	// ||  ((region) (get(socreg.class).regions.chosen)).name.equals("EDGAR") ); this was for Match P1
	//follows(get(controller.class), (emitoption.chosen=="sresscale" && get(controller.class).objective.chosen!="nopolicy") || emitoption.chosen=="2000scale");
	//above shouldn't be necessary since carboncycle follows controller anyway
    }
    
    //*******************************************************
    //PARAMETERS
    //note: donothing added for attribution
    String[] emitoptions={	"sresfix", "sresscale", "2000fix", "2000scale", "donothing"};
    complexity[] emitcomplex={ normal, normal, normal, normal, experimental};
    
    public param
	    emitoption=new param("othgasemitoptions", emitoptions, "sresscale", emitcomplex),
	    addpermafrost=new param("addpermafrost", false, experimental);
    
    
    //*******************************************************
    //PLOTARRAYS
    public qt
	    ch4emit=new qt( "ch4" , green, simplest ),
	    n2oemit=new qt( "n2o" , brown),
	    soxemit=new qt( "sox" ,  blue, simplest ),
	    coemit=new qt(  "co" , dkgrey ),
	    vocemit=new qt( "voc" ,  yellowgreen ),
	    noxemit=new qt(  "nox",  orange);
    
    public qtset emitcurves=new qtset( 	ch4emit, n2oemit, soxemit, coemit, vocemit, noxemit, "othgasemitcurves", "tera&gram&per&yr");
    
    
    //*******************************************************
    //LOOP CALCS
    
    public void initsetup() {
	//must come after loaddata
	//ch4emit, coemit, soxemit filled by loaddata
	//adjust methane to match sres at 2000
	//NOTE: CH4 and N2O data  now overwritten by the sum from EDGAR from 1890 to 2000 -see history module
	for (int y=1860; y<2001; y++) ch4emit.set(y, ch4emit.get(y)* 323f / 380f);
	//fill 1750-1860
	for (int y=1750; y<1860; y++) ch4emit.set(y, ch4emit.get(1860) * (y-1750) / 110f);
	//adjust soxemit to match sres at 1990 (70.9) and connect linearly to 2000 (69.0)
	for (int y=0; y<1991; y++) soxemit.set(y, soxemit.get(y)*70.9f/soxemit.get(1990));
	for (int y=1991; y<2001; y++) soxemit.set(y, ((y-1990)*69.0f+(2000-y)*soxemit.get(1990))/10f);
	histnoxvoc();
	super.initsetup();
    }
    
    public void precalc() { scaleis92a();    }
    //note histn2o in atchem
    
    public void calcstep() {
	//P3 reCHECK interactions  with "donothing" othgasemit option
	if ( !emitoption.chosen.equals("donothing") &&  year>=2000) scalesresemit();
	
	//scaling N2O emissions prior to 1890 - do we still need this old fix for edgar?
	if (((region) (get(socreg.class).regions.chosen)).name.equals("EDGAR") && year==1890)  {
	    float emit1890=get(socreg.class).emitn2o.calctot();
	    for (int y=1750; y<=1890; y++)  n2oemit.set(y, emit1890*((float)(y-1750) / (float)(1890-1750)));
	}
	
	if (addpermafrost.istrue() && year>fsy) { 
	    float extrach4=700f*(16f/12f)*(year-2000)/50f; 
	    ch4emit.set(ch4emit.get()+extrach4); //experiment, add emissions from melting permafrost, apparently 700Gt on average over next century, note not yet any feedback from temperature
	}
	
    }
    
    //*******************************************************
    //EMISSIONS
    //(future only)
    
    float scale; float[] scgas=new float[6];
    
    //scale is92a to same 2000 values as SRES to match TAR calculations
    float[][][] scgasdata={	sres.soxemit, sres.ch4emit, sres.n2oemit, sres.coemit, sres.vocemit, sres.noxemit};
    void scaleis92a() {	for (int i=0; i<6; i++) {
	if (get(futbasescen.class).scenario.getchosenindex()==6) scgas[i]=(float)(scgasdata[i][0][0]/scgasdata[i][6][0]);
	else scgas[i]=1f;
    }}
    
    void scalesresemit() {
	//scale to CO2 - note use fossil CO2 emissions not total (inc landuse)
	scale =1f;
	int sc=get(futbasescen.class).scenario.getchosenindex();
	if (year>fsy && emitoption.chosen=="sresscale") scale=get(carboncycle.class).fossil.get(year)/get(globco2emit.class).fossilbase.get(); //(1000f*sres.interp(sres.fosemit, sc, year)
	if (year>2000 && emitoption.chosen=="2000scale" ) scale=get(carboncycle.class).fossil.get(year)/get(carboncycle.class).fossil.get(2000);
	
	int year1= (emitoption.chosen=="2000fix" ||  emitoption.chosen=="2000scale")  ? 2000 : year;
	
	soxemit.set(year, sres.interp(sres.soxemit, sc, year1)*scale*scgas[0]);
	ch4emit.set(year, sres.interp(sres.ch4emit, sc, year1)*scale); //*scgas[1]; //scgas doesn't help for CH4 is92a!
	n2oemit.set(year, sres.interp(sres.n2oemit, sc, year1)*scale*scgas[2]);
	coemit.set(year, sres.interp(sres.coemit, sc, year1)*scale*scgas[3]);
	vocemit.set(year, sres.interp(sres.vocemit, sc, year1)*scale*scgas[4]);
	noxemit.set(year, sres.interp(sres.noxemit, sc,  year1)*scale*scgas[5]);
	
	//hfcs -note cfcs constant
	//interpolation unnecessarily complicated as only use in 5-yr intervals?
	int schfc=(sc<3 ? 0 : sc<7 ? sc-2 : 2); //all A1 same, for TGCIA450 use B1
	int yeara=year+5, yearb=((emitoption.chosen=="sresfix" ||  emitoption.chosen=="sresscale") ? yeara : 2000);
	if ((yeara%5)==0 && yeara>1930 && yeara<=gey)
	    for (int g=0; g<12; g++) {
	    get(fgas.class).fgemit[g].set(yeara,  (sc==6 && (g<4 || g>6)) ?  0 :  interpolator.interphfc(sres.hfcemit, g, schfc, yearb)*scale);
	    //note is92a only has data for 3 gases
	    }
    }
    
    //calculate historical nox & voc by scaling to CO, only for plot not further calculations
    
    void histnoxvoc() {
	noxemit.set(2000, sres.interp(sres.noxemit, 0, 2000));
	vocemit.set(2000, sres.interp(sres.vocemit, 0, 2000));
	for (int year=1750; year<2000; year++) {
	    noxemit.set(year, noxemit.get(2000)*coemit.get(year)/coemit.get(2000));
	    vocemit.set(year, vocemit.get(2000)*coemit.get(year)/coemit.get(2000));
	}}
    
} //end class
