

package jcm.mod.ogas;

import java.util.*;
import jcm.core.*;
import jcm.mod.soc.AviaShipEmit;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.globco2emit;
import jcm.mod.cli.radfor;
import jcm.mod.soc.AviaShipEmit.scen;
import jcm.mod.soc.AviaShipEmit.sec;
import static jcm.gui.gen.colfont.*;
import static jcm.mod.soc.AviaShipEmit.*;
import static jcm.mod.ogas.gas.*;

public class AviationForcing extends module {
    
    static int sy=AviaShipEmit.sy, ey=AviaShipEmit.ey;
    AviaShipEmit ase; //convenient ref
    
    public qt rfi=new qt("Radiative Forcing Index", sy, ey, black); //radiative forcing index
    public qt rfnonco2=new qt("Aviation_Non-CO2",  olive); //, qt.Type.total);  // want it to be not total type for inc in RF -note also must have full timescale to include there
    public qt noxemit=new qt("nox-emit", "mega&ton&no2", sy, ey);
    
    public qtset gasrf=new qtset("Aviation Radiative Forcing", "watt&per&m2",sy, ey);
    public qtset rfis=new qtset("Radiative Forcing Index", rfi, sy, ey);
    
    public param horizon=new param("RFI time-horizon", "yr", 50, 1, 100, complexity.expert, red);
    public param tradeoff=new param("Update_TRADEOFF03", true, complexity.expert, dkgreen);
    public param inccirrus=new param("Include Cirrus", true, complexity.expert, dkblue);
    
    
    public void initsetup() {
	ase=get(AviaShipEmit.class);
	follows(ase);
	setaffectedby(get(carboncycle.class)); //due to nonlinear effect of cumulative concentrations on rf
	setaffectedby(get(radfor.class).excavia);
	setaffectedby(get(radfor.class).applyefficacy);
	for (gas g : aviagas) { gasrf.reg(g).color=g.col; if (g.name().startsWith("tot")) gasrf.reg(g).type=qt.Type.total; } //note none start with total at the moment
	//gasrf.add(rfnonco2);  //need to be total type if include here, but not for inc in RF plot
	//gasrf.addAction(showpan.pan("Plot %frac", lineplot.class, new Object[]{gasrf, "frac"}));
    }
    
    
    //***************************** IPCC and tradeoff forcing data ************************
    
    static final EnumSet<gas>
	    aviagas=EnumSet.of(co2, o3avia, ch4avia, h2oavia, sulphate, bc, contrails, cirrus),
	    scalebynox=EnumSet.of( o3avia, ch4avia),
	    scalebyco2=EnumSet.of( contrails, h2oavia, bc, sulphate)
	    ;
    
    static final EnumMap<gas, float[]> rf_fa1= new EnumMap(gas.class);
    static final EnumMap<gas, Float> tof= new EnumMap(gas.class);  //this is the ratio from tradeoff / scaledIPCC -in case of cirrus mid-range IPCC was used
    
    static {
	rf_fa1.put(co2, new float[]{ 0.016f, 0.025f, 0.038f, 0.048f, 0.074f }); tof.put(co2, 1f);
	rf_fa1.put(o3avia, new float[]{ 0.024f, 0.029f, 0.040f, 0.046f, 0.060f}); tof.put(o3avia, 23f/29f);
	rf_fa1.put(ch4avia, new float[]{ -0.015f, -0.018f, -0.027f, -0.032f, -0.045f}); tof.put(ch4avia, 9f/19f);
	rf_fa1.put(h2oavia, new float[]{0.002f, 0.002f, 0.003f, 0.003f, 0.004f }); tof.put(h2oavia, 1f);
	rf_fa1.put(sulphate, new float[]{-0.003f, -0.004f, -0.006f, -0.007f, -0.009f }); tof.put(sulphate, 4f/5f);
	rf_fa1.put(bc, new float[]{0.003f, 0.004f, 0.006f, 0.007f, 0.009f }); tof.put(bc, 3f/5f);
	rf_fa1.put(contrails, new float[]{0.021f, 0.034f, 0.060f, 0.071f, 0.100f }); tof.put(contrails , 8f/32f );
	tof.put(cirrus, 52f/28f);
	//total_ipcc(red, new float[]{ 0.048f, 0.071f, 0.114f, 0.137f, 0.193f });
    }
    
    
    //*********************************
    
    public void calcstep(){  if (year>=sy && year<=ey)     radfor(); }
    public void postcalc() {	rfi();     }
    
    
/*
 for CO2 concn we need to follow the history - as for responsibility (should extend that to sectors - wld also be useful for luc)
could assume sink prop to totsink (old resp "simplecarbon" method)?  but this will underestimate net sink for newly growing sector, as backfluxes not yet so big
//cumco2+=carboncycle.ppmpmtc* (secemit.get(sec.tot_av) - carboncycle.totsink.get(year-1)*cumco2/carboncycle.co2atppm.get(year-1) )
 => too high (2.5 in 2000)
 better to use simple accc-carbon model -no feedbacks but not bad near 2000?
 => too low (1.2 in 2000) -want 1.5 for match IPCC SR, *very temporarily* add 25%! (also not bad for Fa1 in 2050)
for other gases, can scale by noxemit or co2emit
 
 P3 for aviation methane this scaling is not very good - should implement a better method similar to that of responsibility
 */
    float cumco2=0; float[] acccbox=new float[4];
    float[] fa1_co2conc=new float[] {0.9f,1.5f, 2.5f, 3.5f, 6.0f };
    float scaledown;
    
    void radfor() { //called for each timestep
	carboncycle carboncycle=get(carboncycle.class);
	scaledown=(year>=fsy)  ? carboncycle.fossil.get()/get(globco2emit.class).fossilbase.get() : 1f;
	
	if (year==sy) { cumco2=0; for (int i=0; i<4; i++) acccbox[i]=0; }
	cumco2=1.25f*carboncycle.acccmod(acccbox, ase.secemit.get(AviaShipEmit.sec.tot_Avia));
	//System.err.println("avn co2 in "+year+": "+cumco2+" ppm ");
	gasrf.set(gas.co2,  carboncycle.co2rf.get(year-1)*cumco2/ (carboncycle.co2atppm.get(year-1) - (float) carboncycle.atppmprein ) );
	//(float)(get(udebclimod.class).rfco2double.getval()*Math.log(cumco2 / carboncycle.atppmprein)/Math.log(2.0)));
	
	//noxemit
	int i=0; while (year>scen.y[i] && i<scen.y.length-1) i++;
	scen sc=ase.aviascen.chosen;
	if (year>1990) noxemit.set( scaledown * ( (year-sc.y[i-1])*sc.nox[i]+(sc.y[i]-year)*sc.nox[i-1] ) / (sc.y[i]-sc.y[i-1])  );
	else noxemit.set(  sc.nox[0] *ase.secemit.get(sec.tot_Avia)/ ase.secemit.get(sec.tot_Avia, 1990)  ); //scale by co2
	//System.err.println("nox in "+year+" = "+noxemit.get());
	
	for (gas g :  scalebyco2 ) {
	    float rfpce=(year>1990) ? ( (year-sc.y[i-1])*rf_fa1.get(g)[i] /scen.Fa1.co2[i]+(sc.y[i] - year)*rf_fa1.get(g)[i-1] /scen.Fa1.co2[i-1] ) / (sc.y[i]-sc.y[i-1]) : rf_fa1.get(g)[0] /scen.Fa1.co2[0];
	    gasrf.set(g, ase.secemit.get(AviaShipEmit.sec.tot_Avia)*(rfpce/1000f) * get(radfor.class).getefficacy(g) );
	}
	
	for (gas g :  scalebynox ) {
	    //scale to ipcc rf/noxemit
	    float rfpne=(year>1990) ? ( (year-sc.y[i-1])*rf_fa1.get(g)[i] /scen.Fa1.nox[i]+(sc.y[i] - year)*rf_fa1.get(g)[i-1] /scen.Fa1.nox[i-1] ) / (sc.y[i]-sc.y[i-1]) : rf_fa1.get(g)[0] /scen.Fa1.nox[0];
	    gasrf.set(g, noxemit.get()*rfpne * get(radfor.class).getefficacy(g));
	}
	
	gasrf.set(gas.cirrus, inccirrus.istrue() ? gasrf.get(gas.contrails) : 0); //mid-range IPCC SR was same as contrails
	
	if (tradeoff.istrue())  for (gas g: aviagas)  gasrf.set(g, gasrf.get(g) * tof.get(g));
	
	float totnonco2=0; for (gas g: aviagas)  if (g!=g.co2) totnonco2+=gasrf.get(g);
	rfnonco2.set( get(radfor.class).excavia.istrue() ? 0 :  totnonco2 );
	
    } //radfor
    
    //P1 this double time loop is inefficient 
    void rfi() {
	for (int y=sy; y<ey; y++) {
	    if (y>ey-horizon.val) rfi.set(y, qt.dud);
	    else {
		float totg=0, totc=0;
		for (int yy=y; yy<(y+horizon.val); yy++) {
		    totc+=gasrf.get(gas.co2, yy);
		    for (gas g : aviagas)  totg+=gasrf.get(g, yy);
		}
//System.err.println("y="+y+" totc="+totc+" totg="+totg);
		rfi.set(y, totg/totc);
	    }
	}//y
    } //rfi
    
    
}
