/*
 STABILISATION
 
 ***************** Stabilisation Todo  *****************
P3 stabemit and constant don't work if chosen within initial setup - need to run stabconc first (fill in some years gap?)
 P2 Document maths of stabilisation method
P1 CHECK when kyoto put back, adjust the stabemit integral (as old system)
P1 IDEA could add alternative stabemit quartic controlling half-way point
P1 IDEA adapt Stabilisation definition for Peaking then falling curves
P1 IDEA Idea for paper: Explore probabilistic for 1.5 and 2.5C?
 
(OLD INFO:)
stabilise emissions, concentration, forcing, temperature, SLR
Stabilise concentration can generate IPCC "S"/"WRE" scenarios, initially developed Arendal autumn 2001
stabilise temperature iteration method improved Bern March 2002, extended to forcing/SLR LLN March 2003
stabilise emissions originally developed spring 2000 based on GCI-C&C
 */

package jcm.mod.obj;

import jcm.core.*;
import jcm.mod.math.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.carbon.carboncycle;
import jcm.mod.obj.globco2emit;
import jcm.mod.cli.*;
import jcm.mod.soc.*;
import static  jcm.core.report.*;

public class stabilisation extends module implements Runnable  {
    
    //*****************************************************
    //INTERACTIONS
    
    
    public void setinteractions() {
	affectsfutureonly=true;
	//follows(history.class); //removed aug06 (distorts interacmap): shouldn't be necessary: calcstep will always run after history, only be careful re precalcs
	//setaffectedby(get(controller.class).objective); //shouldn't be necessary - as controller affects globco2emit which affects one of the target indicators
	//setaffectedby(get(shares.class), get(shares.class).kyotop.istrue());
	//setaffectedby(get(shares.class).kyotop);
	
	//conditional interactions for parameter help to clarify options to user, but be careful of the statement order, as these also set *not*affectedby when condition not true
	//P1 code could be neater if used an enum for the options.
	//follows(history.class, indicator.chosen=="constant" || indicator.chosen=="stabemit"); //this seems to be necessary if opening for the first time - doesn't help
	setaffectedby(indicator.chosen=="constant", get(globco2emit.class));
	setaffectedby(indicator.chosen=="stabemit", get(globco2emit.class), stabemitlevel, sygrowth, quartic, stabemityear);
	setaffectedby(indicator.chosen=="stabemit" && quartic.istrue(), integralgt);
	setaffectedby(indicator.chosen=="stabconc", get(carboncycle.class),  stabconclevel, concscenmenu);
	setaffectedby(indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg", get(radfor.class), stabrflevel);
	setaffectedby(indicator.chosen=="stabtemp" || indicator.chosen== "stfuzzy", get(glotemp.class), get(glotemp.class).baseyear, stabtemplevel);
	setaffectedby(indicator.chosen== "stabsea", get(sealevel.class), stabsealevel, stabseayear);
	setaffectedby(indicator.chosen=="stabconc" || indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg" || indicator.chosen=="stabtemp" || indicator.chosen== "stfuzzy", stabyear, stabconcinitslope);
	
	setaffectedby(wre, indicator.chosen!="constant"); //always, as default, just here for clarity
	setaffectedby(wre.istrue(), stabconcstartyear);
	
	setaffectedby(indicator.chosen== "stfuzzy", get(stabtempfuzzy.class), damp);
	setaffects(indicator.chosen== "stfuzzy", get(stabtempfuzzy.class));
	
	//P2 add arrow association for stabemit here!
	get(carboncycle.class).conc.associate(stabconclevel);
	get(radfor.class).allrf.associate(stabrflevel);
	get(radfor.class).allrf2.associate(stabrflevel);
	get(glotemp.class).temp.associate(stabtemplevel);
	get(sealevel.class).sealevel.associate(stabsealevel);
	
    }
    
    //**************************************************
    //ADJUSTABLE PARAMETERS
    
    String[] indicators={	"stabemit", "stabconc",  "stabrf&allghg", "stabrf&allghgaero",  "stabtemp", "stabsea", "constant", "stfuzzy" };
    
    String[] concscenname={	"400ppm", "450ppm", "500ppm", "550ppm", "600ppm", "650ppm", "750ppm", "850ppm", "1000ppm", "user"};
    
    complexity[] indiccomplex=new complexity[]{ normal, simplest, expert, normal, normal, experimental, expert, experimental};
    
    int[] concscenlevel={	400, 450, 500, 550, 600, 650, 750, 850, 1000};
    
    public param  indicator=new param("indicator", indicators, "stabconc", indiccomplex) {
	public void precalc() {
	    if (chosen=="reduceintensity") get(shares.class).kyotop.flag=false;
	    resetguess();
	}
    };
    
    //IPCC-scenario menu
    //P1 can be confusing, when the scenario menu not consistent with the chosen levels - should all have a precalc
    public param  	    concscenmenu=new param("stabconcmenu", concscenname, "user") {  public void precalc() { if (chosen!="user") {
	stabconclevel.putval(concscenlevel[getchosenindex()]);
	stabyear.putval(2100+(concscenlevel[getchosenindex()] -450)/2.0); //set endyear as a func of endlevel as per IPCC S/WRE
    } }   };
    
    public param
	    //for stabilise concentration, forcing, temperature
	    stabyear=new param("stabyear", "year", 2100, 2030, (gey)-20, grey, simplest), //stabilisation year
	    stabconclevel=new param("stabconc&atlevel", "ppm", 450, 300, 1000, stabyear, black, simplest), 	//final concentration
	    stabconcinitslope=new param("stabconcinitslope", "ppm&per&year&squared", 0.02, -0.1, 0.1, expert, black),
	    stabrflevel=new param("stabrf&atlevel", "w&per&m2", 3.1, 1.5, 8.0, stabyear, green), 	//final total rf
	    stabtemplevel=new param("stabtemp&atlevel", "degcbase", 2.0, 1.0, 7.0, stabyear, brown), 	//final temperature
	    
	    wre=new param("wreopt", false, blue), 					//delay start year as Wigley-Richels-Edmonds proposal
	    stabconcstartyear=new param("stabconcstartyear", "", 2003, 1990, 2050, expert), 					//startyear fixed by WRE
	    
	    //for stabilise emissions
	    stabemityear=new param("stabemityear", "year", 2080, 2010, (gey)-20, red), 	//stabilisation year
	    stabemitlevel=new param("stabemit&atlevel", "mega&ton&carbon&per&yr", 2000, 0, 12000, stabemityear, red), 		//final emissions
	    sygrowth=new param("initgrow", "percent&per&yr", 1.5, -3.5, 3.5, expert, orange), 		//initial growth rate
	    quartic=new param("integralopt", false, expert),				//control integral (quartic curve)
	    integralgt=new param("integralgt", "giga&ton&carbon", 500, 150, 2000, expert),		//total emissions 2000-endyear in GtC
	    //P2 FIX note stabemit integral label incorrectly specifies to 2200!
	    
	    //for stabilise get(sealevel.class)
	    stabseayear=new param("stabseayear", "year", 2250, 2030, (gey)-20, expert), //stabilisation year
	    stabsealevel=new param("stabsea&atlevel", "metres", 0.75, 0.5, 3.0, stabseayear, expert),	//final total rf
	    
	    damp=new param("dampopt", false,  expert); 						//use damping in fuzzy control
    
    
    //*****************************************************
    //MAIN LOOP CALCULATIONS
    
    public void precalc() {
	if (!running) setstartyear();
    }
    
    public void calcstep() {
	carboncycle carboncycle=get(carboncycle.class);
	/*
	 if start year,  set target stabilisation curves ( must be within calcstep loop as kyoto may affect start)
	note: for stabtemp sy >= get(glotemp.class).baseyear+3, to get baseyear offset correction right (done in climate module at baseyear+2)
	 */
	if (year==sy) {
	    if (indicator.chosen=="stabemit") emittarget((int)stabemityear.getval(), stabemitlevel.getval());
	    if (  indicator.chosen=="stabconc") conctarget((int)stabyear.getval(), stabconclevel.getval());
	    //what was this for? if (!get(carboncycle.class).histdeforbymassbal.istrue()) enclosing all conctarget method
	    
	    if  ((indicator.chosen=="stabtemp" ||  indicator.chosen=="stabrf&allghgaero" ||  indicator.chosen=="stabrf&allghg" || indicator.chosen=="stabsea")  ) {
		setlevel();  //do this even within iteration, in case parameters continuously adjusted by user
		if (!running) { initialguess(); new Thread(this, "Stabilisation").start(); }
		conctarget( scy, co2stab, co2stabslope, co2end); //make new target co2 curve
	    }
	}
	
	if (year>=sy) {
	    
	    if (indicator.chosen=="stabemit") carboncycle.totemit.set(year, target[year-gsy]);
	    else  if (indicator.chosenname().startsWith("stab") ) carboncycle.totemit.set(year, carboncycle.inverseco2(target[year-gsy]));
	    //(year-sy)<10 ? 5 : 1));
	    //try to remove initial oscillations (due to feedbacks) by averaging with emissions trend - doesn't help - just increases wavelength
	    //if ((year-sy)<=10)  get(carboncycle.class).totemit.set(year, (get(carboncycle.class).totemit.get(year)+2f*get(carboncycle.class).totemit.get(year-1) - get(carboncycle.class).totemit.get(year-2))/2f);
	    
	    if  (indicator.chosen=="constant")  carboncycle.totemit.set(year, carboncycle.totemit.get(year-1));
	    if (indicator.chosen=="stfuzzy") get(stabtempfuzzy.class).calcstep();
	}
	
    } //end calcstep
    
    public void postcalc() {
	//correct target curve, and check whether goodenough
	if (indicator.chosen=="stabrf&allghgaero" ||  indicator.chosen=="stabrf&allghg" || (indicator.chosen=="stabtemp") || indicator.chosen=="stabsea") applycorrection();
    }
    
    //*****************************************************
    //target curve
    public float[] target= new float[gey-gsy+2];
    public void changeendyear(int oldey, int newey) { 	target=new float[newey-gsy+2];    }
    
    qt curvetocheck;
    
    //variables relating to initial gradient
    public int x0, sy=fsy, scy;
    float y0, dy0, d2y0;
    
    //iteration variables to be remembered between calls
    double targetlevel=0;
    double co2stab=0, co2staborig=0, stabcor=1.0, oldstabcor=1.0;
    double co2stabslope=0, co2stabslopeorig=0, stabslopecor=1.0, oldstabslopecor=0;
    //double co2mid=0, co2midorig=0, midcor=1.0, oldmidcor=1.0;
    double co2end=0, co2endorig=0, endcor=1.0, oldendcor=1.0;
    //	double co2endslope=0, co2endslopeorig=0, endslopecor=1.0, oldendslopecor=0;
    double olditw=Float.MAX_VALUE, oldco2stab;
    
    public boolean goodenough=false, running=false;
    public int stit=0; //number of iterations
    
    
    
    //**************************
    //INITIAL YEAR/GRADIENT
    
    void setstartyear() {
	//P1 CHECK land use in futbasescen now uses fsy instead of sy, this might cause problem in WRE/kyoto variants
	//set startyear for stabilisation curve, 2000 or after kyoto or after WRE delay
	sy=(get(shares.class).kyotop.istrue() ? 2013 : fsy);
	if (wre.istrue() && !get(shares.class).kyotop.istrue() ) delaystart();
    }
    
    
    //work out initial gradient and d2y/dx2
    float[] gradient(qt q, int x0) {
	float y=q.get(x0);
	/* if start before 2010 fix d2y0 to avoid effect of kinks in historical data
	 note this will only work for q=carboncycle.atppm
	 dy shouldn't be fixed because makes step in emissions if change carboncycle parameters, but we need to smooth it - use 5 years to avoid Pinatubo effect.
	 */
	float d2y= (x0<2010) ? (float)stabconcinitslope.getval()  /*0.02f 0.016f*/ :  (y -2f*q.get(x0-1)+q.get(x0-2));
	float dy=2.5f*d2y + (q.get(x0) - q.get(x0-5))/5f;
	return new float[] { y, dy, d2y};
    }
    
    //******** DELAY START *************************
    
    void delaystart() {
	if (wre.changed) stabconcstartyear.putval(2002+(int)((stabconclevel.getval()-350.0)/23.0) );
	delaystart(sy, (int)stabconcstartyear.getval());
	sy=(int)stabconcstartyear.getval();
    }
    
//beware that globco2emit comes after this in loop order
    void delaystart(int sy, int dsy) {
	param scenario=get(futbasescen.class).scenario;
	int oldsc=scenario.getchosenindex();
	scenario.choose(6);
	for (int y=sy; y<=dsy; y++) get(carboncycle.class).fossil.set(get(globco2emit.class).fossilbase.get(y));
	scenario.choose(oldsc);
    }
    
    
//	Old note?:  WRE started by following IS92a *(6.7/7.1) to connect with 2000 historical data
    
    
    //***************************************************
    //STABILISE EMISSIONS
    
    
    void emittarget(int xs, double ys) {
	double y0=get(carboncycle.class).totemit.get(sy), dy0=y0*sygrowth.getval()/100f;
	if (quartic.istrue()) mathcurve.quarticend(target, sy, xs, y0, dy0, ys, 0,  integralgt.getval()*1000f );
	else mathcurve.cubicend(target, sy, xs, y0, dy0, ys, 0) ;
	for (int x=xs; x<=gey; x++) target[x-gsy]= target[x-gsy]=(float)ys; //flat
    }
    
    
    //**************************
    //SET CONCN TARGET
    void conctarget(int xs, double ys) {	conctarget(xs, ys, 0, ys); }
    
    void conctarget(int xs, double ys,  double dys, double ye) {
	float[] gr=gradient(get(carboncycle.class).co2atppm, sy-1); //returns y0, dy0, d2y0
	//make the pade curve
	mathcurve.padequintic( target, sy-1,  xs, gr[0],  gr[1], gr[2], ys, dys, 0); //final 0 is d2ys
	//after CO2 stabilisation point
	if (xs<gey) {
	    if (dys==0 || (gey-xs<20)) for (int x=xs; x<=gey; x++) target[x-gsy]=(float)ye; //flat
	    else mathcurve.flatquadratic(target, xs, gey, ys, dys, ye);
	}
    } //end conctarget
    
	/* variants :
	growth 2000 = (7.77-4.20)*.471 =1.68 (emit-sink)*(ppmpgtc) ,	growth 1990 = (7.75-3.84)*.471 =1.84 ,	so d2y0 =  (1.68-1.84)/10 = -0.016
	could also fix dy0 =d2y0+1.65;
	double d2ys = padequartic( target, x0, xs, get(carboncycle.class).co2atppm[x0s],  dy0, d2y0, ys, dys);
	mathcurve.expdecay(target, xs, ys, dys, d2ys);
	mathcurve.simplepade (target, xs,  gey, ys, dys, d2ys, ye);
	 */
    
    //*****************************
    //STABILISE get(radfor.class) or TEMPERATURE by ITERATE CO2: guess CO2 stabilisation
    
    
    void setlevel() {
	if (indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg") {
	    curvetocheck= indicator.chosen=="stabrf&allghgaero" ? get(radfor.class).anthrorf : get(radfor.class).ghgrf;
	    targetlevel=stabrflevel.getval();
	    setstabconcyear(stabyear.getval());
	}
	if (indicator.chosen=="stabtemp") {
	    curvetocheck=get(glotemp.class).avchange;
	    targetlevel=stabtemplevel.getval()+get(glotemp.class).offset; //offset because model temperature relative to 1750 but parameter relative to baseyear!
	    setstabconcyear(stabyear.getval());
	}
	if (indicator.chosen=="stabsea") {
	    curvetocheck=get(sealevel.class).total;
	    targetlevel=stabsealevel.getval();
	    setstabconcyear(stabseayear.getval());
	}
    }
    
    void setstabconcyear(double stabconcyear) {
	scy=(int)stabconcyear;
	//fsy+(int)(1.0*(stabconcyear-fsy)); //note here can experiment setting co2 stab earlier than temp stab year
    }
    
    //**************************
    //INITIAL GUESS
    //initial guesses for CO2 concentration target curve for stabilise get(radfor.class) or temp iterations
    //if first step of iteration set co2stab, scy, co2end, co2slope (otherwise these reset in correct method called from postcalc)
    
    
    void initialguess() {
	if (indicator.chosen=="stabrf&allghgaero" || indicator.chosen=="stabrf&allghg") {
	    guessconcfromrf( targetlevel *  get(radfor.class).totalrf.get(scy) /  (indicator.chosen=="stabrf&allghgaero" ? get(radfor.class).anthrorf.get(scy) : get(radfor.class).ghgrf.get(scy)));
	}
	if (indicator.chosen=="stabtemp") {
	    guessconcfromrf(guessrffromtemp(targetlevel));
	}
	if (indicator.chosen=="stabsea") {
	    guessconcfromrf(guessrffromtemp(guesstempfromsealevel(targetlevel)));
	}
	//		stabtemplevel.min=1.0-get(glotemp.class).offset; stabtemplevel.max=7.0-get(glotemp.class).offset; //set permitted range relative to 1750
    }
    
    
    
    double guesstempfromsealevel(double sealeveltarget) {
	return (get(sealevel.class).total.get(scy)>0 ?  get(glotemp.class).avchange.get(scy) * sealeveltarget / get(sealevel.class).total.get(scy) : 2.0); //first guess - assume get(sealevel.class) proportional to temperature (in same year) - if get(sealevel.class) not yet calculated guess 2
    }
    double guessrffromtemp(double stabtemplevel) {	//called from precalc() -before steps
	//first guess - use ratio temp/get(radfor.class) if already calculated once, else use climate sensitivity assuming equilibrium
	return stabtemplevel*(get(glotemp.class).avchange.get(scy)>0 ? get(radfor.class).totalrf.get(scy)  / get(glotemp.class).avchange.get(scy) : get(udebclimod.class).val(udebclimod.cp.rfco2double)/get(udebclimod.class).val(udebclimod.cp.climsens) );
    }
    
    void guessconcfromrf(double guesstotrf) {
	double co2rf = guesstotrf * (get(radfor.class).totalrf.get(scy)>0 ?  get(carboncycle.class).co2rf.get(scy) / get(radfor.class).totalrf.get(scy)  : 0.85); //guess CO2 rf is same frac as current, or 85% if first time
	
	co2staborig= get(carboncycle.class).atppmprein * Math.exp(Math.log(2.0) * co2rf /get(udebclimod.class).val(udebclimod.cp.rfco2double) ); //find corresponding co2 concentration
	
	//note: old corrections remembered from previous solution -faster when dragging control
	co2stab=co2staborig*oldstabcor;
	//if (co2stab<stabconclevel.min) {	co2stab=stabconclevel.min; debug("can't drop CO2 below "+stabconclevel.min); } 	//catch impossible target
	co2stabslopeorig=0;
	co2stabslope=oldstabslopecor;
	co2endorig=co2stab;
	co2end=co2endorig*oldendcor;
    }
    
    
    //**************************
    //APPLY CORRECTION
    //for iteration: correct according to calculated rf or temp, called from postcalc()
    
    void applycorrection() {
	
	//correct level in stabilisation year
	stabcor=targetlevel / curvetocheck.get(scy);
	
	//gradient should be flat at stabilisation point (check twenty years gradient)
	stabslopecor= -0.05*(curvetocheck.get(scy+10)-curvetocheck.get(scy-10))  / curvetocheck.get(scy-1);
	
	//end level should be same as stab level: (check penultimate step - note use actual stab level rather than target level)
	endcor=curvetocheck.get(scy) / curvetocheck.get(gey-1);
	
	//end gradient should be flat (check last twenty years gradient)
	//endslopecor = -0.05*(curvetocheck[(gey-gsy)-1]-curvetocheck[(gey-gsy)-21]) / curvetocheck[sys-1];
	
	
	co2stab=carboncycle.atppmprein+(co2stab-carboncycle.atppmprein)*stabcor; if (co2stab<300) co2stab=300;
	if (stit<=6 || stabslopecor/oldstabslopecor <1.0)  	co2stabslope+=stabslopecor * (co2stab-carboncycle.atppmprein); //only use if iteration 0 - 6 or correction is getting smaller - avoid instability
	co2end=carboncycle.atppmprein+(co2end-carboncycle.atppmprein)*endcor; if (co2end<300) co2end=300;
	//if (stit<=4 || endslopecor/oldendslopecor <1.0)  co2endslope+=endslopecor * (co2stab-carboncycle.atppmprein);
	
	//stop iteration if impossible targets
	boolean impossible=(Double.isInfinite(co2stab) || Double.isInfinite(co2end) || Double.isNaN(co2stab) || Double.isNaN(co2end) || co2stab<300 || co2end<300) ;
	
	goodenough=( impossible || (
		(stabcor<1.01) && (stabcor>0.99) 	&& (stabslopecor<0.01) && (stabslopecor>-0.01)
		&& (endcor<1.01) && (endcor>0.99)  //&& (endslopecor<0.05) && (endslopecor>-0.05)
		) )	;
	/*
	 (stabcor<1.005) && (stabcor>0.995) 	&& (stabslopecor<0.02) && (stabslopecor>-0.02)
	&& (endcor<1.005) && (endcor>0.995) // && (endslopecor<0.01) && (endslopecor>-0.01)
	 */
	
	stit++;
	savecorrect();
	
    } //end applycorrection
    
    
    void savecorrect() {	//saving oldcorrect  makes iteration faster if dragging arrow
	oldstabcor=co2stab/co2staborig; oldstabslopecor=(co2stabslope-co2stabslopeorig) /  (co2stab-carboncycle.atppmprein);
	//oldmidcor=co2mid/co2midorig;
	oldendcor=co2end/co2endorig; //oldendslopecor=(co2endslope-co2endslopeorig) /   (co2stab-carboncycle.atppmprein);
    }
    void resetcorrect() {	oldstabcor=1.0; oldstabslopecor=0; /*oldmidcor=1.0;*/ oldendcor=1.0; /* oldendslopecor=0; */ }
    void resetguess() {	resetcorrect(); goodenough=false; } //see climate module
    
    
    public void run() {
	running=true;
	log(	"Stabilisation iteratation starting");
	//Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
	Thread.currentThread().yield();
	loop.waitUntilLoopDone();
	
	while (!goodenough && stit<20) {
	    changed=true;    loop.gonow(false);
	}
	log(	"Stabilisation iteratated "+stit+" times");
	stit=0;
	running=false;
	/*if (objective.chosen=="stabsea") resetcorrect(); else */
    }
    
       /*
     info for debugging - put after calc goodenough
    + " STAB= " + aa(co2stab) 	+" corr= " + aa(stabcor) + " slope= " + aa(co2stabslope) +" corr= "+aa(stabslopecor) 	//+ "MID= " + aa(co2mid) +" corr= "+ aa(midcor)
    + " END= " + aa(co2end) +" corr= "+ aa(endcor) 	+ " slope= " + aa(co2endslope) +" corr= "+aa(endslopecor)
    +" ok? "+goodenough+"\n" );
	double aa(double d) {	return ((int) (d*10000.0))/10000.0; }
	*/
    
} //end stabilisation class.







