
package jcm.mod.obj;
import jcm.mod.reg.*;
import static  jcm.core.report.*;



public class sres   {
    
    
    //***************************
    public static String[] scenname={	"A1B","A1T","A1F","A2","B1", "B2", "IS92a", "TGCIA450"};
    
    //****************************
    //ARRAYS FOR INTERP, FILLED BY LOADDATA
    //item, (region,) scenario, year
    //6 SRES scenarios +IS92a
    //12 regions + world + extra
    //11 year blocks (2000-2100 in 10yr intervals)
    
    //later maybe combine similar types?
    
    //global data
    public static float[][]
	    fosemit=new float[8][11],
	    lucemit=new float[8][11],
	    soxemit=new float[8][11],
	    ch4emit=new float[8][11],
	    n2oemit=new float[8][11],
	    noxemit=new float[8][11],
	    coemit=new float[8][11],
	    vocemit=new float[8][11]
	    ;
    public static float[][][] hfcemit=new float[12][7][11]; //gas, scenario, block - but why seven scenarios?
    
    //future regional data (6 scenarios)
    
    //12-region, 2000-2100. region 13 is total
    public static float[][][]
	    jcm12fos=new float[13][6][11], //note only 12 regions filled by loaddata - and these are fractions always adding up to 1000
	    jcm12pop=new float[13][6][11], //why six scenarios? - loaddata doesn't fill so many!
	    jcm12gdppc=new float[13][6][11],
	    jcm12enpc=new float[13][6][11]
	    ;
    //4-region, 1990-2100. region 0 is total
    public static float[][][]
	    sres4fos=new float[5][6][12],
	    sres4luc=new float[5][6][12],
	    sres4ch4=new float[5][6][12],
	    sres4n2o=new float[5][6][12],
	    sres4pop=new float[5][6][12],
	    sres4gdp=new float[5][6][12]
	    ;
    
    //ipcc calculated data for superimposing circles
    //rf: co2bern, co2isam ch4, n2o, tropo3, hfc, cfc, sa, bcoc(isam), total
    public  static float[][][]
	    rfdata=new float[10][7][11],
	    sldata=new float[7][6][11]
	    ;
    public  static float[][]
	    bernmid=new float[7][11],
	    tempchange=new float[7][11]
	    ;
    
    
    //**************************************************
    
    public  static void initsetup() {
	//TGCIA450
	fosemit[7]=new float[]{	7.97f, 8.78f, 8.89f, 7.97f, 6.70f, 5.69f, 4.64f, 3.19f, 2.74f, 2.25f, 1.77f, 1.49f, 1.55f, 1.81f, 2.13f, 2.38f, 2.48f, 2.42f, 2.27f, 2.07f, 1.86f, 1.70f, 1.57f, 1.48f, 1.41f, 1.36f, 1.33f, 1.29f, 1.26f, 1.21f, 1.15f};
	//split fos and lucf using fracs from B1, and then constant ratio from 2100
	lucemit[7]=new float[31];
	for(int i=0; i<11; i++) {	lucemit[7][i]=fosemit[7][i]*lucemit[4][i]/(lucemit[4][i]+fosemit[4][i]); fosemit[7][i]=fosemit[7][i]-lucemit[7][i]; }
	for(int i=11; i<31; i++) {	lucemit[7][i]=  fosemit[7][i]*lucemit[7][10]/(lucemit[7][10]+fosemit[7][10]); fosemit[7][i]=fosemit[7][i]-lucemit[7][i]; }
	
	soxemit[7]=new float[]{	66.0f, 60.7f, 54.5f, 47.9f, 33.9f, 24.6f, 18.9f, 14.7f, 11.8f, 9.2f, 7.5f, 7.1f, 6.6f, 6.1f, 5.6f, 5.1f, 4.8f, 4.6f, 4.5f, 4.4f, 4.4f, 4.3f, 4.2f, 4.1f, 4.0f, 3.9f, 3.8f, 3.7f, 3.6f, 3.5f, 3.4f};
	ch4emit[7]=new float[]{	323f, 358f, 397f, 433f, 436f, 436f, 423f, 393f, 357f, 310f, 266f, 263f, 254f, 242f, 229f, 217f, 210f, 206f, 204f, 188f, 171f, 157f, 146f, 138f, 132f, 127f, 124f, 121f, 117f, 113f, 108f};
	n2oemit[7]=new float[]{	6.80f, 6.90f, 7.00f, 7.10f, 7.20f, 7.26f, 7.09f, 6.88f, 6.67f, 6.38f, 6.09f, 6.06f, 5.88f, 5.64f, 5.39f, 5.17f, 5.03f, 4.95f, 4.91f, 4.49f, 4.03f, 3.66f, 3.38f, 3.17f, 3.02f, 2.92f, 2.84f, 2.77f, 2.70f, 2.60f, 2.47f};
	noxemit[7]=new float[]{	32.0f, 33.6f, 35.0f, 36.2f, 34.8f, 33.9f, 32.6f, 28.5f, 24.7f, 21.5f, 20.1f, 19.7f, 18.7f, 17.3f, 15.9f, 14.7f, 13.9f, 13.4f, 13.2f, 12.5f, 11.8f, 11.2f, 10.7f, 10.3f, 9.9f, 9.6f, 9.4f, 9.1f, 8.8f, 8.5f, 8.2f};
	coemit[7]=new float[]{	877f, 872f,  851f, 823f, 800f, 779f, 756f, 740f, 722f, 698f, 674f, 667f, 643f, 610f, 576f, 546f, 526f, 515f, 511f, 471f, 430f, 395f, 369f, 349f, 334f, 323f, 314f, 306f, 298f, 288f, 274f};
	vocemit[7]=new float[]{	141f, 156f, 160f, 154f, 134f, 116f, 96f, 78f, 68f, 58f, 50f, 49f, 47f, 44f, 40f, 37f, 35f, 34f, 34f, 32f, 30f, 28f, 27f, 26f, 25f, 24f, 23f, 23f, 22f, 21f, 21f};
	
    }
    
    
    //****************************
    //INTERPOLATION ROUTINES
    //linear interpolation between 10-year data
    
    //for global data float[sc][bk]
    public static float interp(float[][] data, int sc, int year) {
	int bk=(year-2000) / 10, by=year % 10;
	try {
	    return (float)((bk<10 || (sc==7 && bk<30)) ? ((double)(10-by)*data[sc][bk]+ (double)by*data[sc][bk+1]) /10f : sc==7 ? data[sc][30]  : data[sc][10] );
	} catch (Exception e) { log(e, "sres interp error: "+data+ " sc="+sc+ " bk="+bk+ " by="+by) ; return 0; }
    }
    
    
    
    //****************************
    public static void makegdpen() {
	//called at start-up after load data
	//multiply gdp and en by population (original from image was per-capita)
	//have to do this before interpolation, otherwise doesn't work for other region-sets
	//similar to history, separated for independance of modules
	for (int i=0; i<13; i++) {
	    for (int j=0; j<11; j++) for (int sc=0; sc<6; sc++)  {
		int scp=(sc==3 ? 1 : sc==5 ? 2 : 0); //pop is same for all A1+B1
		int scg=(sc>2 ? sc-2 : 0); //gdp is same for all A1T,F,B,
		if (sc==0 || sc>2) jcm12gdppc[i][scg][j] *=0.001f*jcm12pop[i][scp][j];
		jcm12enpc[i][sc][j] *=jcm12pop[i][scp][j];
	    }
	}
    }
    
    
    
} //end class


