/* GLOBAL CO2 EMISSIONS
linker class:
 takes global emissions from futbasescen and history and feeds to carboncycle,  othgasemit, shares etc. also follow this due to mitigation scaling rules
also partitions global fossil and landuse CO2  (whilst regional shares of LUC CO2 elsewhere as slow)
 
note todos in futureLUC
 
 */

package jcm.mod.obj;

import jcm.core.*;
import jcm.mod.carbon.*;
import jcm.mod.soc.*;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import jcm.mod.luc.CalcLucEmit;
import static jcm.gui.gen.colfont.*;

public class globco2emit extends module {
    
    //*********** PARAMS ***************
    public param potlucfrac=new param("potlucfrac%",  "", green, 1.0, 0, 2, expert); //fraction of accumulated luc emissions that is potential sink in one year
    public param potlucconvergence=new param("potlucfracConverg%",  "", green, 0.5, 0, 2, expert); //fraction of emissions/sink decrease
    public param fixedfrac=new param("fix luc/fossil stab", false, experimental);
    
    //0 is constant offset (use SRES trend, 100 is instant SRES, in between is convergence to SRES)
    public param fosconv=new param("foshistscenconv", "", dkbrown, 5f, 0f, 100f);
    public param lucconv=new param("luchistscenconv", "", dkgreen, 5f, 0f, 100f);
    
    
    //************** curves **************
    public qt fossil, lucf, totemit; //links to carboncycle, maybe move here later
    public qt  potlucbase=new qt("globpotlucbase", ltgreen, fsy, gey, expert),  potlucquota = new qt("globpotlucquota", dkgreen, expert);
    public qt   fossilbase=new qt("fossilemitbase" , dkred, fsy, gey),   lucfbase = new qt("lucemitbase" , dkorange, 2000, gey); //2000 for houghton case
    public qtset globco2curves;
    
    
    //***********************************
    
    //working variables
    carboncycle carb;
    futbasescen fbs;
    qtset emitfosbase, emitlucbase; //references
    private float alpha; //note this changes with step
    public float plf;
    public int fsyluc, sc;
    public boolean nopolicy, houghton;
    
    //************** setup ***************
    
    public void initsetup() {
	follows(history.class);
	follows(futbasescen.class);
	follows(sresext.class);
	follows(controller.class);
	//P3 CHECK OK: moved this link from futbasescen to here for efficiency and clarity - check it still works
	setaffectedby(AviaShipEmit.class); //because when bunker changes, have to re-scale rest, but calc of bunker has to come after globco2emit due to scaledown
	
	fbs=get(futbasescen.class);
	carb=get(carboncycle.class);
	fossil=carb.fossil; lucf=carb.lucf; totemit=carb.totemit;
	globco2curves=new qtset("globco2curves",  fossilbase, lucfbase, fossil, lucf, totemit, potlucbase, potlucquota);
	potlucquota.set(gsy,0);
	emitfosbase=get(socreg.class).emitfosbase; emitlucbase=get(socreg.class).emitlucbase;
	affectsfutureonly=true;
    }
    
    //*************************************
    public void precalc() {
	nopolicy=get(controller.class).objective.chosen.equals("nopolicy");
	plf=-(float)(potlucfrac.getval()/100f);
	sc=get(futbasescen.class).scenario.getchosenindex();
	houghton=get(CalcLucEmit.class).lucsource.chosen.equals("Houghton");
	fsyluc= houghton ? 2001 : 2003;
    }
    
    //*************CALCSTEP **********************************
    
    
    public void calcstep() {
	
	//potluc: based on fraction of cululative lucf emissions, including history
	if (year>gsy) potlucquota.set(potlucquota.get(year-1)+lucf.get(year-1)*plf);
	
	
	/*
	SRES period
	 
	 SCALING emitfosbase, note:
	sres4 data was not consistent with TAR sres totals (due to correction in TAR)
	old regional data from IMAGE12 was saved as a fraction of 1000, need to apply topdownscale to total (exc bunker) to correct this
	fossil scaling will affect sres extension and hence global total post 2100, but does not need to precede sresext in loop
	 
	 note emitlucbase must be calculated in futureLUC as it uses potentials for interpolating as well as SRES4
	note CH4 and N2O  top-down scaling  done in othgasemit and shares
	 
	 P2 STRUC in principle scaling in the wrong place, since only changes when futbasescen changes
	 could have 4 modules: globco2base, globco2pol, regco2base, regco2pol (and for each, also LUC/fossil... - especially for regpol),   but also consider sresext...
	 
	 want to remove aviashipemit affects futbasescen, i.e. re-use emitfosbase without re-interpolate
	 fossilbase is only changed by sres.fosemit and globalcorrfac, which is not changed by future bunker
	 the topdownscale subtracts bunker from the fossilbase, and scales the rest
	
	 */
	
	if (year>=fsy && year<=2100) {
	    fossilbase.set((float)(
		    1000f*sres.interp(sres.fosemit, sc, year)
		    +  (1f-fosconv.getval()/100f) * (  (year==fsy ? emitfosbase.calctot(year-1) : fossilbase.get(year-1))  - 1000f*sres.interp(sres.fosemit, sc, year-1) )
		    ));
	    emitfosbase.topdownscale(fossilbase.get(), true); //true implies exclude bunker -note aviashipemit will rescale after adding bunker (follows in loop)
	}
	
	
	if (year >=2000 && year<fsyluc) {  //case ivig or 2000 for houghton - use 5 year moving average of history
	    float a=0; for (int i=-5; i<0; i++) a+=lucf.get(year+i); lucfbase.set(a/5f);
	}
	
	if (year>=fsyluc && year<=2100) {
		    lucfbase.set((float)(
		    1000f*sres.interp(sres.lucemit, sc, year)
		    +  (1f-lucconv.getval()/100f) * (  lucfbase.get(year-1)  - 1000f*sres.interp(sres.lucemit, sc, year-1) )
		    ));
	} //year sres

	
	
	//note: fsyluc can be earlier than fsy with houghton
	if (year>=fsyluc && year<fsy) {
	    lucf.set(lucfbase.get());
	    totemit.set(fossil.get()+lucf.get());
	}
	
	
	//after 2100, base converges towards potlucbase
	if (year>2100) {
	    float fac = lucfbase.get(year-1) < potlucbase.get(year-1) ? 1f : (float)potlucconvergence.getval()/100f;
	    lucfbase.set(fac*potlucbase.get(year-1)+(1f-fac)* lucfbase.get(year-1) );
	}
	
	
	//calculate mitigation: proportional to fossil mitigation (relative to base)
	if (year >= fsy) {
	    
	    potlucbase.set(year==fsy ? potlucquota.get() : potlucbase.get(year-1) +lucfbase.get()*plf);
	    alpha=(lucfbase.get() - potlucbase.get())/fossilbase.get();
	    
	    if (nopolicy) {
		fossil.set(fossilbase.get());
		lucf.set(lucfbase.get());
		totemit.set(fossilbase.get()+lucfbase.get());
		
	    } else { //stabilisation or optimisation, assume totemit has been set
		
		lucf.set(
			fixedfrac.istrue()  ?  totemit.get()*lucf.get(fsy-1)/totemit.get(fsy-1)
			: (totemit.get()*alpha + potlucquota.get())/(1f+alpha)
			);
		
		fossil.set(totemit.get() -lucf.get());
		
		if (fossil.get()<0) { fossil.set(0); lucf.set(totemit.get()); }
	    }
	    
	}  //y>fsy
    } //calcstep
    
    
    
}  // end class
