/*
See also scenarios.todo, scimod.todo
  
P2 tidy up duplicate SRES data in calcstep
note: also no longer using sres4 fos, pop, gdp
 */

package jcm.mod.obj;
import jcm.core.*;
import jcm.core.data.interpolator;
import jcm.core.reg.region;
import jcm.mod.reg.*;
import java.util.*;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.carbon.carboncycle;
import jcm.mod.soc.*;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;

public class futbasescen extends module {
    
    //******************** PARAMS **********
    public param scenario=new param("sresmenu", sres.scenname, "B2", simplest);
    
    //************ WORKING VARIABLES **********
    
    public int sc, scre; //also used by futureLUC
    int scp, scg, sce;
    
    socreg socreg; socio socio;
    region regset;
    
    
    //*****************************
    //INIT SETUP
    
    public void initsetup() {
	follows(get(history.class));
	setaffectedby(get(socreg.class).regions);
	setaffectedby(get(controller.class).objective); //P2 WHY, CHECK? - maybe to restore emitch4 and emitn2o
	
	scenario.setcomplexity("IS92a", expert); scenario.setcomplexity("TGCIA450", experimental );
	sres.makegdpen();
	
	socio=get(socio.class);
	socreg=get(socreg.class);
    }
    
    public void precalc() {
	
	regset=(region)get(socreg.class).regions.chosen;
	scenequiv();
	
	new interpolator(sres.jcm12pop, "JCM12IMAGE", 2000, 10, scp, 1f).fill(socio.pop, regset, 2003, 2100, history.hydepop);
	new interpolator(sres.jcm12gdppc, "JCM12IMAGE", 2000, 10, scg, 1f).fill(socio.gdp, regset, 2001, 2100, history.hydepop);
	new interpolator(sres.jcm12enpc, "JCM12IMAGE", 2000, 10, sce, 1f).fill(socio.energy, regset, 2001, 2100, history.hydepop);
	new interpolator(sres.jcm12fos, "JCM12IMAGE", 2000, 10, scre, 1f).fill(socreg.emitfosbase, regset, 2003, 2100, history.fosCO2);
	new interpolator(sres.sres4ch4, "SRES4", 1990, 10, scre, 1f).fill(socreg.emitch4, regset, 2001, 2100, history.epaCH4, 2020);
	new interpolator(sres.sres4n2o, "SRES4", 1990, 10, scre, 1f).fill(socreg.emitn2o, regset, 2001, 2100, history.epaN2O, 2020);
//	new interpolator(sres.sres4fos, "SRES4", 1990, 10, scre, 1000f); //is this still needed?
	
	for (int y=2000; y<=2100; y++) {
	    socio.pop.calctot(y); socio.energy.calctot(y); socio.gdp.calctot(y);
	    //note emitfosbase calctot within top-downscaling in globco2emit
	}
	
    }
    
//**************************************
    
    void scenequiv() {
	sc=scenario.getchosenindex();
	scre= (sc==7 ? 4 : sc==6 ? 0  : sc); // use A1B for IS92A, B1 for TCGIA450 regional
	if (sc<8) {
	    scp=(sc==3 ? 1 : sc==5 ? 2 : 0); //pop is same for all A1+B1 (and TGCIA450)
	    scg=(sc==7 ? 2 : sc==6 ? 0  : sc>2 ? sc-2 : 0); //gdp is same for all A1T,F,B, IS92A, for TCGIA450 use B1
	    sce=(sc==7 ? 4 : sc==6 ? 0  : sc); //energy use A1B for IS92A, B1 for TCGIA450
	}
    }
    
    
    
} //end class


