/*
 Future Regional Land Use Change Emissions
 Separate from CalcLucEmit as different interactions
 Also separate from globco2emit, since this is module is quite slow (can be rate-limiting step when changing many params in loop)
 
 P3 POTLUC: potluc should take into account carbon fertilisation, also allow a bit more than history (eg for reclaiming arid lands), also include agric/pasture pre 1750 (more potential for europe/china)
 
 P3 document algebra of LUC scaling, and recheck at same time
 P3 recheck that sum of regional equals global in globco2emit, expecially post 2100
 P3 check still issue?? problem with future LUC following houghton, even with baseline scenario.  Also not consistent when going IVIG=>Houghton=>IVIG
 
 P2 REFIX effect of fixedfrac option (regional and global)
 P2 CHECK this is OK with optimisation!
 P2 table of parameters for LUC after 2100, consistent with each SRES
 P1 maybe "current" LUC emissions should be averaged over decade?
 
 
 */

package jcm.mod.luc;

import java.util.HashMap;
import java.util.Map;
import jcm.core.*;
import jcm.mod.carbon.*;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.sres;
import jcm.mod.obj.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import jcm.core.data.interpolator;
import jcm.mod.soc.*;
import static jcm.core.report.*;

public class futureLUC extends module {
    
    //***************** PUBLIC PARAMS /CURVES ****************
    
    public qtset
	    potlucregquotacurves=new qtset("regpotlucquota",  "mega&ton&carbon", expert),
	    potlucregbasecurves=new qtset("regpotlucbase",  "mega&ton&carbon", expert);
    
    public static qtset lucscenario = new qtset("LUC SRES", "mega&ton&carbon", 2000, 2100, experimental); //temporary, just to check totals OK
    
    //*********************** WORKING VARIABLES ***********
    region regset, sresreg;
    interpolator  sreslucinterpolator;
    
    CalcLucEmit cle; globco2emit gc; futbasescen fbs;
    
    Map<region, Float> potlucregbase=new HashMap(),  srespotluc=new HashMap(), srb4conv=new HashMap(), srinitial=new HashMap(), sreslucemit=new HashMap(), potlucregquota=new HashMap();
    Map<region, Map<region, Float>> weight=new HashMap();
    Map<region, Float> potluchist=new HashMap(); //historical - for nations (moved from CLE)
    
    boolean nopolicy;
    public boolean needtocalchist=true; //flag set true when sres run
    float scaledownquota, trend, convfac, fquota, totsres4, corrfac;
    int sc, scre;
    
    qtset emitlucbase, emitlucquota;
    
    
    //******************** INTERACTIONS ************
    public void initsetup() {
	follows(globco2emit.class);
	sresreg=regman.allreg.find("SRES4");
	cle=get(CalcLucEmit.class);
	gc=get(globco2emit.class);
	fbs=get(futbasescen.class);
	emitlucbase=get(socreg.class).emitlucbase;
	emitlucquota=get(socreg.class).emitlucquota;
	affectsfutureonly=true;
	lucscenario.reg(regman.allreg.find("TOTAL")).type=qt.Type.total;
    }
    
    //***************** LOOP METHODS ***********
    
    public void precalc() {
	regset=get(socreg.class).regions.chosen;
	for (qtset qq :  qtsets) get(socreg.class).clearoldregions(qq);
	sc=get(futbasescen.class).sc; scre=get(futbasescen.class).scre;
	sreslucinterpolator=new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f);
	nopolicy=get(controller.class).objective.chosen.equals("nopolicy");
    }
    
    public void calcstep() {
	
	if (year<gc.fsyluc) for (region r : regset.reg)  emitlucquota.set(r, emitlucbase.get(r)); //for history
	if (year==gc.fsyluc-1) {
	    //if (needtocalchist) { histpotluc(); needtocalchist=false; } //this was for efficiency but doesn't work with houghton=>ivig=>houghton?
	    histpotluc();
	    setupweights();
	}
	
	if (year>=gc.fsyluc) {
	    //potluc - based on previous year (note not inc history which is done in CLE
	    for (region r : regset.reg) {
		potlucregbase.put(r, potlucregbase.get(r)+emitlucbase.get(r,year-1)*gc.plf);
		potlucregquota.put(r, potlucregquota.get(r)+emitlucquota.get(r,year-1)*gc.plf);
		//just to record values of potluc for checking method, later delete  or calc only if needed
		potlucregbasecurves.set(r, potlucregbase.get(r) );
		potlucregquotacurves.set(r, potlucregquota.get(r) );
	    }
	}
	
	if (year>=gc.fsyluc) {
	    
	    float divisor= (year<=fsy) ? (gc.lucf.get(year-1) - gc.potlucquota.get(year-1))  : (gc.lucfbase.get(year-1) - gc.potlucbase.get(year-1));
	    scaledownquota=(get(carboncycle.class).lucf.get(year-1) -  gc.potlucquota.get(year-1)) /divisor; 	// based on previous year, because there is a feedback (luc=>fossil=>sd=>luc)
	    if (year==gc.fsyluc) { scaledownquota=1f; }
	    
	    //if  (year==gc.fsyluc) deb("futLUC scaledownquota from "+year+": " ); if (year<2008) deb("-"+scaledownquota);
	    
	    //initialise sresluc to sum of nations from history for same regions
	    totsres4=0;
	    for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
		if (year<=2100) {
		    lucscenario.set(sr, sreslucinterpolator.getdata(sr, year));
		    
		    //follow trend of SRES and also converge the gap
		    sreslucemit.put(sr, (float)(
			    lucscenario.get(sr)
			    +  (1f-gc.lucconv.getval()/100f) * (  sreslucemit.get(sr)  - lucscenario.get(sr, year-1))
			    ));
		    
		} else { // after 2100 - convergence towards the potluc
		    convfac= (sreslucemit.get(sr)  < srespotluc.get(sr)) ? 1f : (float)gc.potlucconvergence.getval()/100f;
		    sreslucemit.put(sr, convfac * srespotluc.get(sr) + (1f-convfac) * sreslucemit.get(sr)  ); //convergence to potluc
		}
		totsres4+=sreslucemit.get(sr);
	    }
	    
	    //scale down factor, to be consistent with globco2emit - if total very small, use same as previous year to avoid spike
	    if (totsres4>10 || totsres4<-10) corrfac=gc.lucfbase.get() / totsres4;
	    //if (year<2010) deb("year="+year+" corrfac="+corrfac);
	    
	    //regional emissions start at the potluc baseline then add
	    for (region r : regset.reg) {
		emitlucbase.set(r,   potlucregbase.get(r));
		emitlucquota.set(r,  potlucregquota.get(r));
	    }
	    
	    //apply SRES4 using weights for each region
	    for (region sr : sresreg.reg) if (!sr.name.equals("TOTAL")) {
		sreslucemit.put(sr, sreslucemit.get(sr)*corrfac);
		srespotluc.put(sr, srespotluc.get(sr) +  sreslucemit.get(sr) *  gc.plf );
		trend =  (sreslucemit.get(sr) - srespotluc.get(sr)) /  srinitial.get(sr);
		
		//if (year<2010)  		    System.err.println("year="+year+" reg="+sr.name+" trend="+trend + " srinitial= "+srinitial.get(sr));
		
		for (region r : regset.reg) { //note region loop inside 4region loop - potentially inefficient!
		    emitlucbase.set(r, emitlucbase.get(r) + weight.get(r).get(sr) * trend );
		    emitlucquota.set(r, emitlucquota.get(r) + weight.get(r).get(sr) * scaledownquota * trend );
		}
	    }
	    
	} //year
	
    } //calcstep
    
    
    
    
//********************** WEIGHTS  *********************
    void setupweights() {
	
	qtset histluc=cle.lucsource.chosen.equals("Houghton") ? LUCdata.lucCO2CAIT1 :  cle.lucemit ;
	float fu=cle.lucsource.chosen.equals("Houghton") ? 1f : 1000f;
	
	//set up initial emissions and potential emissions
	for (region sr : sresreg.reg) {
	    srespotluc.put(sr,0f);
	    float srli=0;
	    for (region rr : sr.subreg(regman.nations)) {
		srespotluc.put(sr, srespotluc.get(sr) + potluchist.get(rr) * gc.plf );
		for (int i=-5; i<0; i++) srli+=histluc.get(rr, gc.fsyluc+i)/(fu*5f); //average over 5 previous years to smooth blips
	    }
	    sreslucemit.put(sr,srli);
	    for (region rr : sr.subreg(regman.nations)) srinitial.put(sr, srli - srespotluc.get(sr));
	}
	
	for (region r : regset.reg) {
	    potlucregbase.put(r,0f); for (region rr : r.subreg(regman.nations)) 	potlucregbase.put(r, potlucregbase.get(r)+ potluchist.get(rr) * gc.plf );
	    potlucregquota.put(r, potlucregbase.get(r));
	}
	
	//calculate weights for small regions as frac of SRES regions
	for (region r : regset.reg) {
	    weight.put(r, new HashMap<region, Float>());
	    for (region sr : sresreg.reg) weight.get(r).put(sr, 0f);
	    for (region rr : r.subreg(regman.nations)) {
		for (region sr : sresreg.reg)  if (sr.contains(rr))
		    weight.get(r).put(sr, weight.get(r).get(sr) +
			    histluc.get(rr, gc.fsyluc-1)/fu -potluchist.get(rr) * gc.plf
			    );
	    }
//	    for (region sr : sresreg.reg) System.err.println(""+r+" "+sr+" "+weight.get(r).get(sr));
	} //r
    }
    
//****************HIST POTLUC *********************
    /*
     this is slow because calculates for all nations  for all historical years
    first part was previously in CalcLucEmit for efficiency (only recalc if history changed) but moved here for clarity
     P3 maybe reconsider if using nations in histpotluc  is really necessary - seems to be needed for weights interpolating from SRES4
     */
    
    void histpotluc() {
	
	for (region r: regman.nations.reg) {
	    potluchist.put(r,0f);
	    //fix the houghton/cait option
	    if (cle.lucsource.chosen.equals("IVIGmodel")) for (int y=1700; y<gc.fsyluc; y++)
		potluchist.put(r, potluchist.get(r)+ cle.lucemit.get(r,y)/1000f);
	    if (cle.lucsource.chosen.equals("Houghton")) for (int y=1850; y<gc.fsyluc; y++)
		potluchist.put(r, potluchist.get(r)+ LUCdata.lucCO2CAIT1.get(r,y)); ///1000f
	}
    }
    
} //class


//*****************************************

	/*
	 old convergence method
	if (year>2100 ) {
	    //gradual convergence towards the potluc
	    //note NO MORE ADJUSTING OF GLOBAL TOTAL TO BE CONSISTENT WITH THIS! - implement in globco2emit
	    for (region r : regset.reg) {
		fbase = emitlucbase.get(r, year-1) < potlucregbase.get(r) ? 1f : (float)gc.potlucconvergence.getval()/100f;
		fquota = emitlucquota.get(r, year-1) < potlucregquota.get(r) ? 1f : (float)gc.potlucconvergence.getval()/100f;
	 
		if (potlucregbase.get(r)>0) emitlucbase.set(r,  fbase * potlucregbase.get(r) + (1f - fbase) * emitlucbase.get(r, year-1) );
		else if (emitlucbase.get(r, year)<0) emitlucbase.set(r,0);
	 
		if (gc.fixedfrac.istrue() ) emitlucquota.set(r, emitlucquota.get(r, year-1)*get(carboncycle.class).lucf.get()/get(carboncycle.class).lucf.get(year-1));
		else {
		    if (potlucregquota.get(r)>0) emitlucquota.set(r, fquota * potlucregquota.get(r) + (1f - fquota) * emitlucquota.get(r, year-1));
		    else if (emitlucquota.get(r, year)<0) emitlucquota.set(r,0);
		}
	 
		potlucregbase.put(r, potlucregbase.get(r) + emitlucbase.get(r, year)*gc.plf);
		potlucregquota.put(r, potlucregquota.get(r) + emitlucquota.get(r, year)*gc.plf);
	    }
	} // post 2100
	 */


//*******************************
//old code ex futbasescen
//	new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 2003, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 1990, 10, scre, 1000f).fill(emitluc, regset, 1991, 2100, histdata.lucCO2);
//      new interpolator(sres.sres4luc, "SRES4", 2002, 10, scre, 1000f).fill(emitluc, regset, startscenluc, 2100, CalcLucEmit.lucCO2IVIG);

