/*
Static datasets and methods to load them, moved from CalcLucEmit
 ok CHRIS p1 changed all qtsets to mega
 
 */

package jcm.mod.luc;

import java.awt.Color;
import jcm.core.*;
import java.util.HashMap;
import java.util.Map;
import jcm.core.data.histdata;
import jcm.core.data.interpolator;
import jcm.core.data.pngdata;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import static jcm.gui.gen.colfont.*;
import static java.lang.Math.*;

public class LUCdata extends module {
    
    //*************************************
    //qtsets holding fixed data -same for all worlds
    public static qtset lucCO2Houghton = new qtset("Houghton LUC emit", "mega&ton&carbon", 1750, 2002); //orig data from 1850, but scaled back linearly to assuming zero at 1700
    public static qtset lucCO2UNFCCC = new qtset("UNFCCC LUC emit","mega&ton&carbon", 1990, 2002);
    public static qtset lucCO2CAIT = new qtset("CAIT LUC emit", "mega&ton&carbon", 1950,2000);
    public static qtset lucCO2CAIT1 = new qtset("CAIT/Houghton LUC emit", "mega&ton&carbon", 1850,2000); //interpolated from houghton
    public static qtset faoagr = new qtset("FAO Agriculture Area", "mega&m2", 1961, 2002);
    public static qtset faopast = new qtset("FAO Pasture Area", "mega&m2", 1961, 2002);
    
    // to read the grid files from EDGAR, need some fix in the country/ocean borders
    public static qtset edgarff = new qtset("EDGAR fossil", "mega&ton&carbon", 1890, 2000, complexity.experimental);
    public static qtset edgarluc = new qtset("EDGAR LUC", "mega&ton&carbon", 1890, 2000, complexity.experimental);
    
    //***************************************
    //other static data
    static boolean loadeddata=false, loadingdata=false;
    
    static Map<region, Float> countryArcviewAreas = new HashMap();
    
    //OK P4 transfor luTables to static byte array, since we have only 2 biome maps and often > 2 worlds, and it takes a lot of memory
    //as luTables hold a lot of data, use a primitive byte array to save memory and make it faster
    //note 2x8x720x360= 4147200 (4MB even as bytes)
    static int[] periods =     {1700, 1750, 1800, 1850, 1900, 1950, 1970, 1990, 2002};
    static byte[][][][] luTables = new byte[2][periods.length-1][][];  //[A/B][period][x][y]
    
    //note converted to enum for convenience of code using this, could in principle convert to enum of enums?
    public enum biomeclassification {
	A(
		new String[]  {
	    "Ocean","Cultivated land","Pasture","X","X",
	    "Ice","Tundra","Wooded tundra",
	    "Boreal forest","Cool conifer forest","Temperate mixed forest",
	    "Temperate deciduous forest",    "Warm mixed forest","Grassland/Steppe",
	    "Hot desert","Scrubland",	    "Savanna",
	    "Tropical woodland", "Tropical forest"
	},
	new Color[]  {
	    black, red, pink, black, black,
	    white, cyan, dkcyan,
	    browngreen, dkredgreen, dkyellowgreen,
	    yellowgreen, olive, orange,
	    yellow, brown, ltgreen,
	    green, dkgreen
	}
	),
	B(
		new String[] {
	    "Ocean",
	    "Cultivated land","Pasture", "Tropical Evergreen Forest/Woodland", "Tropical Deciduous Forest/Woodland",
	    "Temperate Broadleafed Evergreen Forest/Woodland", "Temperate Needleleafed Evergreen Forest/Woodland", "Temperate Decidous Forest/Woodland",
	    "Boreal Evergreen Forest/Woodland", "Boreal Deciduous Forest/Woodland", "Evergreen/Deciduous Mixed Forest/Woodland",
	    "Savanna", "Grassland/Steppe", "Dense Shrubland",
	    "Open Shrubland", "Tundra", "Hot Desert",
	    "Polar Deser/Rock/Ice"
	},
	new Color[]  {
	    black,
	    red, pink, dkgreen, green,
	    dkgrey, olive, yellowgreen,
	    dkredgreen, dkyellowgreen, browngreen,
	    ltgreen, orange, brown,
	    dkbrown, cyan, yellow,
	    white, black
	}
	);
	
	public String[] names;
	public Color[] colors;
	boolean loaded=false;
	biomeclassification(String[] n, Color[]c) { names=n; colors=c; } //constructor
    };
    
    public static biomeclassification defaultBC=biomeclassification.B;
    
    // *********** PRECALC ***********************
    //note, unusually this module-loop method can be static, since same for all worlds
    public void precalc() { if (!loadeddata) getdata();    }
    
    
    //******** GET DATA ************************************
    
    /* note, we only load static data once and it same for all worlds
     however it takes time which is not good for display of first plot.
     therefore this is also called from startJCM,
     and since there is possibility of simultaneous call from event dispatching thread
     we have to make sure that one waits for the other
     */
    public static void getdata() {
	if (loadingdata)  while (!loadeddata) { Thread.yield(); }
	if (loadeddata) return;
	loadingdata=true;
	reporttime("begin make region polygons");
	for (region r : regman.nations.reg) r.makepolys(); //this is essential if not done already
	reporttime("loading static LUCdata curve sets");
	loadStaticData();
	reporttime("Loading LUC Biome Data");
	loadHYDEdata(defaultBC); //note this replaces former call to CLE precalc
	reporttime("end CLE loaddata");
	loadeddata=true; loadingdata=false;
    }
    
    static void loadStaticData(){
	histdata.loaddata(faopast, "lucdata/FAO_pasture.csv", "\t", true, 1f, 1961, 2002, 1961);
	histdata.loaddata(faoagr, "lucdata/FAO_agriculture.csv", "\t", true, 1f, 1961, 2002, 1961);
	histdata.loaddata(lucCO2Houghton, "lucdata/houghtondata2000.csv", ";", true, 1f, 1850, 2000, 1850);
	
	String[][] countrya = fileio.loadtab("data/lucdata/Country_areas.csv", "\t");
	for (int y = 3; y < countrya.length; y++) {
	    region r = regman.allreg.find(countrya[y][0]);
	    float area =  Float.parseFloat(countrya[y][1]);
	    countryArcviewAreas.put(r, !countryArcviewAreas.containsKey(r) ? area : countryArcviewAreas.get(r)+area);
	}
	//histdata.loaddata(lucCO2UNFCCC, "UNFCCC_LUC_emit.tab", "\t", true, 12f/44f, 1990, 2002, 1990);
	histdata.loaddata(lucCO2UNFCCC, "lucdata/UNFCCC_LUC_emit_v1.tab", "\t", true, 1f, 1990, 2002, 1990);
	histdata.loaddata(lucCO2CAIT, "lucdata/CAIT_LUC_emit.tab", "\t", true, 0.001f, 1950, 2000, 1950);
	
	for (region r : regman.allreg.find("HOUGHTON").reg) {
	    for (int y=1750; y<1850; y++) lucCO2Houghton.set(r, y, lucCO2Houghton.get(r, 1850)*(y-1700)/150f );
	}
	
	new interpolator(lucCO2Houghton, "HOUGHTON", 1950, 1f).fill(lucCO2CAIT1, regman.nations, 1850, 2000, lucCO2CAIT);
	//new interpolator(jcm12en, "JCM12", 1900, 1, false).fill(energy, regset, 1900, 2000, hydepop);
//	loadEDGAR(); //metrhod to read the grid files from EDGAR, need some fix in the contry/ocean borders
    }
    
    static void loadHYDEdata(biomeclassification AB) {
	for (int p=0; p<periods.length-1; p++) {
	    String filename = "lu_"+AB+"_"+periods[p];
	    luTables[AB.ordinal()][p]  = pngdata.load("data/lucdata/"+filename+".png",  AB.colors );
	} //p
	AB.loaded=true;
    }
    
} //end class

    /*
    //method to read the grid files from EDGAR, need some fix in the contry/ocean borders
    static void loadEDGAR(){
//fire grid maps??
//        int w = 360, h = 180;
//        int[] EDGARperiods = new int[]{1890, 1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990, 1995, 2000};
//        //Map<edgar, int[]> fileperiod = new HashMap(); /P1 make as enumeration enum edgar{EDGAR13, EDGAR32, EDGAR32FT}
//
//        Map<Integer, int[]> fileperiod = new HashMap();
//        fileperiod.put(0, new int[]{1890, 1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990}); //kg CO2-C 0.000001f,
//        fileperiod.put(1, new int[]{1995}); //kg CO2  12f/44000000f,
//        fileperiod.put(2, new int[]{2000}); //kg CO2 12f/44000000f
//
//        Map<Integer, String[]> fileroot = new HashMap();
//        fileroot.put(0, new String[] {"CO2FC", "CO2FP", "CO2IN", "CO2DF"}); //11 periods //CO2BC is not included because has changed a lot in different versions of EDGAR and IPCC include in LULUC
//        fileroot.put(1, new String[] {"f1095co2.1x1", "f2095co2.1x1", "f3095co2.1x1", "f4095co2.1x1", "f5195co2.1x1", "f5495co2.1x1", "f5795co2.1x1", "f5895co2.1x1", "f6195co2.1x1", "f6295co2.1x1", "f8095co2.1x1", "i4195co2.1x1", "l4195co2.1x1"}); //f57XXco2, aviation has data just for 95 //13 items /1 period
//        fileroot.put(2, new String[] {"f1000co2.1x1", "f2000co2.1x1", "f3000co2.1x1", "f4000co2.1x1", "f5100co2.1x1", "f5400co2.1x1", "f5700co2.1x1", "f5800co2.1x1", "f6000co2.1x1", "f8000co2.1x1", "i4100co2.1x1", "l4100co2.1x1"}); //f60 = f 61+f62 //12 items /period /file:"l4100co2.1x1" is tab separated not comma, the original was changed
//
//        float[] fac = new float[]{0.000001f, 12f/44000000f, 12f/44000000f};
//
//        Map< Integer, float[][]> co2fosgrid = new HashMap();
//        Map< Integer, float[][]> co2lucgrid = new HashMap();
//
//        for (int i = 0; i < 3; i++) //edgar version
//            for (int p = 0; p < fileperiod.get(i).length; p++) // number of periods in edgar version
//                for (int n = 0; n < fileroot.get(i).length; n++) {//number of ff sectors + luc sector in edgar version
//            String gridname="";
//            String sp=""; //separator
//            int st; //start line
//            if(i==0){ gridname += fileroot.get(i)[n] + fileperiod.get(i)[p]+ ".txt"; st = 1; sp+="\t";
//            } else{ gridname += fileroot.get(i)[n]; st = 12; sp+=",";
//            }
//
//            if (n!=fileroot.get(i).length-1){ //just fossil until the last, then luc sector
//                float [][] data = griddata.load(gridname, sp, st, fac[i]);
//                for (int y=0; y<h; y++) for (int x = 0; x<w; x++) if (n!=0) data[x][y] = data[x][y] + co2fosgrid.get(fileperiod.get(i)[p])[x][y];
//                co2fosgrid.put(fileperiod.get(i)[p], data);
//            } else{
//                float [][] data = griddata.load(gridname, sp, st, fac[i]);
//                co2lucgrid.put(fileperiod.get(i)[p], data);
//            }
//
//                }//for EDGAR version, periods, and sectors(files)
//        Set<cell> cellseta = new HashSet();
//
//        for (region r : regman.nations.reg){
//            cellseta.clear();
//            int xo,yo, xd, yd, cell;
//            //double emit;
//            float xi, yi;
//            boolean inbox;
//
//            for (regpoly p : r.polyset) {
//                Area a = new Area(p);
//                Rectangle box=a.getBounds();
//
//                int step=5; // degree steps
//
//                for (xo=box.x; xo<(box.x+box.width); xo+=step) {
//                    xd=Math.min((box.x+box.width)-xo, step);
//                    for (yo=box.y; yo<(box.y+box.height); yo+=step) {
//                        yd=Math.min((box.y+box.height)-yo, step);
//                        if (a.intersects(xo,yo,xd,yd)) {
//                            inbox=a.contains(xo,yo,xd,yd);
//                            for (yi=+yo; yi<(yo+yd); yi+=1) {
//                                for (xi=xo; xi<(xo+xd); xi+=1) {
//                                    if (inbox || a.contains(xi,yi)) {
//                                        cell c = new cell();
//                                        c.lon = xi;
//                                        c.lat = yi;
//                                        cellseta.add(c);
//                                    }
//                                }
//                            }
//                        }
//                    }
//                } //polys
//            } //regav
//            int p0 =  1890;//to initialize the interpolator.linearinterp(edgarff, p0, p);
//            for (int p : EDGARperiods){ //perid index 1890, 1900, 1910, 1920, 1930, 1940, 1950, 1960, 1970, 1980, 1990, 1995, 2000
//                float emitff = 0;
//                float emitluc = 0;
//
//                for (cell c : cellseta) {
//                    int x = (int)(c.lon+180), y=(int)(-c.lat+90);
//                    try {
//                        emitff += co2fosgrid.get(p)[x][y];
//                        emitluc += co2lucgrid.get(p)[x][y];
//                    } catch (Exception e) {System.err.println(x + " " +y + e); e.printStackTrace();}
//                }//cellseta loop
//
//                edgarff.set(r, p, emitff);
//                edgarluc.set(r, p, emitluc);
//
//                if (p > 1890) for (int y = p0+1; y<p; y++) { // initialized before the periods loop
//                    interpolator.linearinterp(edgarff, p0, p);
//                    interpolator.linearinterp(edgarluc, p0, p);
//                }
//                p0 = p;
//            }//edgarperiods
//        }//regnations loop
//
//
    } // load edgar  //method to read the grid files from EDGAR, need some fix in the contry/ocean borders
     
     */
