/*
 OK P1 CHRIS FIX Burquina faso added China India
 ok p1 CHRIS fix 1 country all emissions dataset scale from kilo to mega
 *
 
 ok P3 CHRIS delete CAIT from countries emissions compare database: Houghton is splited to do it
 
 P2 FIX rescale countries to have the same areas of agriculture and pasture HYDE/FAO
P2 include SAGE database
P2 fix ocean to agric to past
 
 
 P2 improve dynamic interactions for clarity to user:
 options relating to 1 Biome/Country plot should ideally show only if the relevant qtset is used for output, how to check this?
 Note: already options disappear if not using IVIGmodel (ideally curves should too...)
 */

package jcm.mod.luc;

import java.util.*;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.reg.regpoly;
import jcm.mod.carbon.*;
import jcm.mod.reg.*;
import jcm.core.*;
import java.awt.Rectangle;
import java.awt.geom.*;
import static jcm.gui.gen.colfont.*;
import static java.lang.Math.*;
import jcm.mod.soc.*;
import static jcm.core.report.*;

public class CalcLucEmit extends module {
    
    //******** INTERACTIONS *************
    
    public void initsetup() {
	follows(get(LUCdata.class)); //this forces LUCdata to run first
	//note other interactions in soc.history
    }
    
    public void setinteractions() {
	for (param p : allparam) if (p!=lucsource) setaffectedby(p, lucsource.chosen.equals("IVIGmodel"));
	setaffectedby(landuseemit1990, lucsource.chosen.equals("Houghton"));
    }
    
    //******* PARAMS **********************
    
    public static String[] lucsources = new String[] {"IVIGmodel", "Houghton",  "Inverse"} ; //, "EDGAR"}; // "MATCH", "EDGAR", }; "IVIGdata", P1 remove IVIGdata
    public param lucsource = new param("LUC emit dataset", lucsources, "IVIGmodel", complexity.simplest);
    
    public param<LUCdata.biomeclassification> biomeclass = new param<LUCdata.biomeclassification>("Biome classification", LUCdata.biomeclassification.values(), LUCdata.defaultBC) {
	public void precalc() {
	    biomeList.setlist(chosen.names);
	    biomeList.choose("Cultivated land");
	    countryChosenBiomes.map.clear();
	    if (!chosen.loaded)  LUCdata.loadHYDEdata(chosen); //note: will only load if not already got this data
	}
    };
    
    
    
    //expert
    public param biomeList = new param("Biome chosen for plot", biomeclass.chosen.names, "Cultivated land", complexity.expert);
    public param countryList = new param("Country chosen for plot", (region[]) regman.nations.reg.toArray(new region[0]) , regman.nations.find("Brazil"), complexity.expert);
    public param FAO2002 = new param("use FAO agric/past rates of change", true, complexity.expert);
    public param vegcerror = new param("Vegetation Carbon uncertainty factor" ,"",  1, 0.8, 1.2, complexity.expert);
    public param isam = new param("Biome B/ISAM carbon content", true, complexity.expert);
    public param soildecayrate = new param("95% soil decay time" ,"",  20, 0.1, 30, complexity.expert); // name, default, maximum, minum
    public param soillossagric = new param("LUC agriculture carbon loss from soil (%)" ,"",  20, 0, 30, complexity.expert);
    public param soillosspast = new param("LUC pasture carbon loss from soil (%)" ,"",  5, 0, 20, complexity.expert);
    //land use emissions in 1990, MtCyr-1 Use 2158 for consistency with Houghton data (rather high), 1600 for old JCM setting to fit concn
    public param landuseemit1990=new param("lucfemit1990", "mega&ton&carbon&per&yr", 2158.09, 0, 3000, complexity.expert);
    
    //experimental
    public param simplemethod = new param("Simple soil emissions (IVIG31)", false, complexity.experimental);
    public param grassyon = new param("Grassy soil carbon", false, complexity.experimental);
    public param shiftcultivation = new param("Shifting cultivation", false, complexity.experimental);
    public param shiftcultfrac = new param("Shifting cultivation fraction" ,"",  0.05, 0.01, 0.1, complexity.experimental);
    public param agricfacerr = new param("Agric/Past error factor for selected country", "", 1, 0.5, 5, complexity.experimental);
    
    //***** CURVE SETS ********************************
    
    public qtset lucemit = new qtset("IVIG32 model LUC emission", "kilo&ton&carbon", 1700, 2002, 1);
    public qtset carbonstock = new qtset("IVIG32 model Carbon Stocks", "kilo&ton&carbon", 1700, 2002, 1);
    public qtset biomeChosenCountries = new qtset("1 Biome area all countries plot", "mega&m2", 1700, 2002, complexity.expert);
    public qtset countryChosenBiomes = new qtset("1 Country all biomes areas plot ", "mega&m2", 1700, 2002, complexity.expert);
    public qtset countryChosenAP = new qtset("1 Country FAOxModel areas plot","mega&m2", 1961, 2002, complexity.expert);
    public qtset countryChosenEmission = new qtset("1 Country all emissions datasets","mega&ton&carbon", 1700, 2002, complexity.expert);
    
    
    //***********************************
    //other changeable data
    Map<Integer, biomestock> biomestocks = new HashMap();
    Map<Integer, Map<Integer, Float>> bcm = new HashMap();
    Set<cell> cellset = new HashSet();
    float oldstock, newstock, countryModelArea, correcAFAO1970, correcPFAO1970;
    
    public int ccontentset; //for carbon content array biome A, B and B/ISAM
    
    //old testing method, no longer used
    public static void main(String[] args) {
	for (region r : regman.nations.reg) r.makepolys();
	new LUCdata().precalc();
	new CalcLucEmit().precalc();
    }
    
    //*************** LOOP method: PRECALC, RUNMODEL **********************************************
    public void precalc() {
	switch(biomeclass.getchosenindex()) {
	    case 0 : ccontentset = 0; break;
	    case 1 : ccontentset = !isam.istrue() ? 1 : 2;
	}
	if (lucsource.chosen.equals("IVIGmodel"))  runmodel();
	get(futureLUC.class).needtocalchist=true;
    }
    
    public void runmodel() {
	reporttime("begin CLE runmodel");
	countryChosenBiomes.map.clear();
	countryChosenAP.map.clear();
	for (region r : regman.nations.reg) { //nations    allreg.find("SRES4") CAI
	    //System.err.print(r+"\t");
	    findCells(r);
	    calcInitialStock(r);
	    setqtcolors(r);
	    
	    for (int i = 0; i < LUCdata.periods.length; i++) if (i != 0) { // if from 1750 to 1990
		if (i<8) calcBiomeChangeMap(i, i-1, r);
		for (int year = LUCdata.periods[i-1]+1; year <= LUCdata.periods[i]; year += lucemit.xstep) {
		    calcAreaChange(i, r, year);
		    calcEmit(i,r, year);
		} //years loop
	    } // if 1750 to 1990
	} // regions
	reporttime("end CLE runmodel");
    } // runmodel
    
    //**************** AREA CHANGE ***************************
    void calcAreaChange(int i, region r, int year)  {
	
	float area, totachange=0, totpchange=0, totFAOachange, totFAOpchange, totHYDEachange=0, totHYDEpchange=0,
		correcfaca, correcfacp, totaptransfer=0, available;
	
	//if (year>1700 && year < 1962) {} //TODO interpolation for the areas according to the history.hydepop
	
	if (year>1961 && FAO2002.istrue()) {
	    //calc FAO total change
	    totFAOachange = LUCdata.faoagr.get(r, year) - LUCdata.faoagr.get(r, year-1);
	    totFAOpchange = LUCdata.faopast.get(r, year) - LUCdata.faopast.get(r, year-1);
	    
	    //-----------------setting the tot(a)change the correcfac(a) and transfer from 1 to 2 when totHYDEachange == 0
	    totHYDEachange = 0; totHYDEpchange = 0;
	    
	    for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0 ) { // >0 ignore ocean changes
		area = bcm.get(f).get(t);
		if (t==1) totHYDEachange += area;
		if (f==1) totHYDEachange -= area;
	    } //f t loop
	    
	    if (totHYDEachange == 0){ //change bcm to have some flags when totHYDEachange == 0
		float flag = 10;
		if ( !bcm.containsKey(1)) bcm.put(1, new HashMap<Integer, Float>()); //then put in bcm the biomeFrom and create HAshmap
		if ( !bcm.get(1).containsKey(2)) bcm.get(1).put(2, flag); // setting bcm 1 <=> 2
		totHYDEachange -= flag;
	    } //if totHYDEachange == 0
	    
	    correcfaca = totFAOachange/totHYDEachange; //NOTE Should not have case where totHYDEachange is zero and there is always transfers from to biome 1
	    
	    //summing all transfer from 1<=>2
	    for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0) { // >0 ignore ocean changes
		area = bcm.get(f).get(t);
		if (t==1 && f==2) totaptransfer -= area*correcfaca;
		if (f==1 && t==2) totaptransfer += area*correcfaca;
	    } //f t loop
	    
	    //-----------------setting the tot(p)change the correcfac(p) and without transfer from 1 to 2
	    for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>1 && t>1 ) { // >0 ignore ocean changes and agric
		area = bcm.get(f).get(t);
		//if (f==2 && t!=1) totHYDEpchange -= area;
		if (f==2) totHYDEpchange += area; //NOTE it is being summed because it is necessary that all biomes change to 2 have the same pattern
		if (t==2) totHYDEpchange += area;
	    } //f t loop
	    
	    if (totHYDEpchange==0 ){ //if there is no biomes under change for pasture
		int biomeC=0; //biomeChosen
		float areaB=0;
		for (int b = 3; b < biomeclass.chosen.names.length; b++) // choose the biggest biome
		    if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea){
		    areaB = biomestocks.get(b).totarea; biomeC = b;
		    }
		float flag = 10;
		if ( !bcm.containsKey(biomeC)) bcm.put(biomeC, new HashMap<Integer, Float>()); //then put in bcm the biomeFrom and create HAshmap
		if ( !bcm.get(biomeC).containsKey(2)) bcm.get(biomeC).put(2, flag); // setting bcm 1 <=> 2
		totHYDEachange -= flag;
	    }
	    
	    correcfacp = (totHYDEpchange != 0) ? (totFAOpchange-totaptransfer)/totHYDEpchange : 1; //NOTE There are several cases where totHYDE(p)change is zero and there is transfers from to biome 2
	    
	    //main transfer loop
	    for (Integer f: bcm.keySet() ) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0) {
		
		area = bcm.get(f).get(t);
		if (f==1 || t==1) area *= correcfaca;
		if (f==2 && t!=1) area *= -correcfacp; //NOTE it is being subtracted because it is necessary that all biomes change to 2 have the same pattern
		if (f!=1 && t==2) area *= correcfacp;
		
		available = area >= 0 ? biomestocks.get(f).totarea : biomestocks.get(t).totarea; //because if neg later swap f && t in transfer
		
		if (available<abs(area)) {//checking if biome is going to zero
		    int biomeC=0; //biomeChosen
		    float areaB=0;
		    
		    for (Integer from: bcm.keySet()) for (Integer to : bcm.get(from).keySet()) { //checking other biomes under change to assign the change
			if (from>2 && areaB<biomestocks.get(from).totarea && biomestocks.get(from).totarea>area){biomeC = from; areaB=biomestocks.get(from).totarea; }
			if (to>2   && areaB < biomestocks.get(to).totarea && biomestocks.get(to).totarea>area){biomeC = to; areaB=biomestocks.get(to).totarea; }
		    }
		    
		    if (biomeC == 0) for (int b = 3; b < biomeclass.chosen.names.length; b++) //if there is no biomes under change choose the biggest
			if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea){
			areaB = biomestocks.get(b).totarea; biomeC = b;
			}
		    
		    if (area>0) if (biomeC > 2) f = biomeC;
		    if (area<0)if (biomeC > 2) t = biomeC;
		} //if checking negative biomes
		
		if(area>1 || area<-1) transfer(area, f, t);
		
	    } //for ft transfer loop
	    shiftcultivation();
	    
	    //***************************************** NOT FAO2002 ****************************
	} else {
	    for (Integer f: bcm.keySet() ) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0 ) { // >0 ignore ocean changes
		area = bcm.get(f).get(t);
		
		available = area >= 0 ? biomestocks.get(f).totarea : biomestocks.get(t).totarea; //because if neg later swap f && t in transfer
		if (available<abs(area)) {//checking if biome is going to zero
		    int biomeC=0; //biomeChosen
		    float areaB=0;
		    
		    for (Integer from: bcm.keySet()) for (Integer to : bcm.get(from).keySet()) { //checking other biomes under change to assign the change
			if (from>2 && areaB<biomestocks.get(from).totarea && biomestocks.get(from).totarea>area){biomeC = from; areaB=biomestocks.get(from).totarea; }
			if (to>2   && areaB < biomestocks.get(to).totarea && biomestocks.get(to).totarea>area){biomeC = to; areaB=biomestocks.get(to).totarea; }
		    }
		    
		    if (biomeC == 0) for (int b = 3; b < biomeclass.chosen.names.length; b++) //if there is no biomes under change choose the biggest
			if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea){
			areaB = biomestocks.get(b).totarea; biomeC = b;
			}
		    
		    if (area>0) if (biomeC > 2) f = biomeC;
		    if (area<0)if (biomeC > 2) t = biomeC;
		} //if checking negative biomes
		
		transfer(area, f, t);
		shiftcultivation();
	    } // for loop
	} //else !=fao2002
	
    } //calcAreaChange
    
    //********************* CALC EMIT ********************************
    void calcEmit(int i, region r, int year)  {
	
	//decayregrow
	newstock = 0;
	for (biomestock s : biomestocks.values()) {
	    s.decayregrow(lucemit.xstep);
	    newstock += s.totstock();
	}
	
	//emissions
	float emit = (oldstock - newstock)/(lucemit.xstep);
	if(Float.isNaN(emit) || Float.isInfinite(emit)) emit = 0;
	oldstock = Float.isNaN(newstock) ? oldstock : newstock; //correct problems in small islands
	
	//setting the qtsets
	lucemit.set(r, year, emit);
	carbonstock.set(r, year, oldstock);
	
	setcountryqts(r, year);
	
    } //calcAreaChange
    
    void transfer(float area, int f, int t) {
	if ( area<0 ) { int ff=f; f=t; t=ff; area=-area; }
	biomestocks.get(f).cutdown(area, biomestocks.get(t));
	biomestocks.get(t).setregrow(area, biomestocks.get(f));
    }
    
    //**************************** INITIAL STOCK ***********************
    void calcInitialStock(region r)  {
	
	biomestocks.clear();
	
	biomestocks.put(1, new biomestock(1, 0, this));
	biomestocks.put(2, new biomestock(2, 0, this));
	
	int bc=biomeclass.chosen.ordinal();
	
	for (cell c : cellset) {
	    int x = (int)(c.lon*2+359.5), y=(int)(-c.lat*2+180.5);
	    try {
		int biome = LUCdata.luTables[bc][0][x][y]; //set to 1700
		if (biome != 0) {
		    if (!biomestocks.containsKey(biome)) biomestocks.put(biome,new biomestock(biome,0, this));
		    biomestocks.get(biome).addarea(c.area);
		}
	    } catch (Exception e) {deb(e, x + " " +y ); }
	}
	
	setcountryqts(r, 1700);
	
	countryAreasCorrection(r);
	
	oldstock = 0f;
	
	for (biomestock bs : biomestocks.values()) {
	    oldstock += bs.totstock();
	    bs.potvegstock = bs.vegstock;
	    bs.potsoilstock = bs.soilstock;
	}
    }
    
    //******************************** BIOME CHANGE MAP *****************************
    void calcBiomeChangeMap(int b, int a, region r)  {
	
	int nstep = (LUCdata.periods[b] - LUCdata.periods[a])/lucemit.xstep; // step has to fit in the years difference
	int bc=biomeclass.chosen.ordinal();
	
	bcm.clear();
	for (cell c : cellset) { // run all cells in region r
	    int x = (int)(c.lon*2+359.5), y = (int)(-c.lat*2+180.5); // locates x and y
	    int biomeTo = LUCdata.luTables[bc][b][x][y]; //store the biome number to
	    int biomeFrom = LUCdata.luTables[bc][a][x][y]; // store the biome number from
	    
	    if (biomeTo != biomeFrom){
		//returns tru if conainskey (returns true if there is map for the key) return false
		
		if ( !bcm.containsKey(biomeFrom)) bcm.put(biomeFrom, new HashMap<Integer, Float>()); //then put in bcm the biomeFrom and create HAshmap
		
		if ( !bcm.get(biomeFrom).containsKey(biomeTo)) bcm.get(biomeFrom).put(biomeTo, 0f);
		
		bcm.get(biomeFrom).put(biomeTo, bcm.get(biomeFrom).get(biomeTo) + c.area / nstep); //TODO .put(method) alredy sum
		//bcm.get(biomeFrom).put(biomeTo, c.area / nstep);
		
	    } // if
	} // cell
    }//calcBiomeChangeMap
    
    
    
    void shiftcultivation(){
	if (shiftcultivation.istrue() && biomestocks.get(1).totarea>100000) {
	    float areaB = 0;
	    int B = 0;
	    for (int b = 3; b < biomeclass.chosen.names.length; b++)
		if(biomestocks.containsKey(b)) if (areaB < biomestocks.get(b).totarea) B = b;
	    
	    transfer(biomestocks.get(1).totarea * (float)shiftcultfrac.getval()/100, 1, B);
	    transfer(biomestocks.get(1).totarea * (float)shiftcultfrac.getval()/100, B, 1);
	}
    }
    
    void countryAreasCorrection(region r){
	float area, totHYDEachange=0, totHYDEpchange=0, prop, agricArea, pastArea, correcArea; // prop = proportion a/p change 1961-1700
	//calcBiomeChangeMap(6, r); //calc agric+past but it has to acummulate all bcm until that point!!! so from 0 to 6!!
	//if country has zero agric or past?
	//rule to increase as the population has increased history.hydepop
	//could apply to the interpolation of land use change for the periods?
	if (LUCdata.countryArcviewAreas.containsKey(r) && countryModelArea!= 0) {
	    //            calcBiomeChangeMap(6, 0, r); //bcm for 1970 to 1700
	    //            prop=1970-1700;
	    //            for (Integer f : bcm.keySet()) for (Integer t : bcm.get(f).keySet()) if (f>0 && t>0 ) { // >0 ignore ocean changes
	    //                area = bcm.get(f).get(t) * prop;
	    //                if (t==1) totHYDEachange += area;
	    //                if (f==1) totHYDEachange -= area;
	    //                if (t==2) totHYDEpchange += area;
	    //                if (f==2) totHYDEpchange -= area;
	    //            } //f t loop
	    //            agricArea = totHYDEachange+biomestocks.get(1).totarea;
	    //            pastArea = totHYDEpchange+biomestocks.get(2).totarea;
	    //            correcAFAO1970 = agricArea!=0 ? faoagr.get(r, 1970) / agricArea : 1;
	    //            correcPFAO1970 = pastArea !=0 ? faopast.get(r, 1970)/ pastArea : 1;
	    //            biomestocks.get(1).addarea(biomestocks.get(1).totarea*(correcAFAO1970-1));
	    //            biomestocks.get(2).addarea(biomestocks.get(2).totarea*(correcPFAO1970-1));
	    //            correcArea = ( ((countryArcviewAreas.get(r)-agricArea*correcAFAO1970-pastArea*correcPFAO1970) /
	    //                    (countryModelArea-agricArea*correcAFAO1970-pastArea*correcPFAO1970)) )-1;
	    //            for (int b = 3; b < 19; b++) if(biomestocks.containsKey(b)) biomestocks.get(b).addarea(correcArea*biomestocks.get(b).totarea);
	    correcArea = ((LUCdata.countryArcviewAreas.get(r)/countryModelArea)-1);
	    for (int b = 1; b <biomeclass.chosen.names.length; b++)
		if(biomestocks.containsKey(b)) biomestocks.get(b).addarea(correcArea*biomestocks.get(b).totarea);
	} // if !=0
    }// countryAreasCorrection
    
    void setcountryqts(region r, int year){
	//output areas
	float carea=0;
	
	biomeChosenCountries.set(r, year, biomestocks.containsKey(biomeList.getchosenindex()) ? biomestocks.get( biomeList.getchosenindex()).totarea : 0) ;
	
	if (r == countryList.getchosen()){
	    countryChosenAP.set("Model Agric",year, biomestocks.get(1).totarea);
	    countryChosenAP.set("FAO Agric",year, LUCdata.faoagr.get(r, year));
	    countryChosenAP.set("Model Past",year, biomestocks.get(2).totarea);
	    countryChosenAP.set("FAO Past",year, LUCdata.faopast.get(r, year) );
	    if (year<2003) countryChosenEmission.set("IVIG32 model",year, lucemit.get(r, year)*0.001f);
	    if (year>1989 && year<2003) countryChosenEmission.set("UNFCCC",year, LUCdata.lucCO2UNFCCC.get(r, year));
	    //if (year>1949 && year<2001) countryChosenEmission.set("CAIT",year, LUCdata.lucCO2CAIT.get(r, year));
	    if (year>1850 && year<2001) countryChosenEmission.set("CAIT/Houghton",year, LUCdata.lucCO2CAIT1.get(r, year));
	    
	}
	
	for (int b = 1; b <biomeclass.chosen.names.length; b++) if(biomestocks.containsKey(b)) { //
	    carea += biomestocks.get(b).totarea;// loop to setting the country areas
	    if(r == countryList.getchosen() && biomestocks.containsKey(b))
		countryChosenBiomes.set(biomeList.getname(b), year, biomestocks.get(b).totarea);
	} // loop biome areas
	
	
	countryModelArea = carea;
    } //output
    
    void setqtcolors(region r){
	if (r == countryList.getchosen()) {
	    countryChosenAP.add(new qt("Model Agric", red, 1962, 2002));
	    countryChosenAP.add(new qt("FAO Agric", dkred, 1962, 2002));
	    countryChosenAP.add(new qt("Model Past", pink, 1962, 2002));
	    countryChosenAP.add(new qt("FAO Past", magenta, 1962, 2002));
	    countryChosenEmission.add(new qt("IVIG32 model", red, 1700, 2002));
	    countryChosenEmission.add(new qt("UNFCCC", blue, 1990, 2002));
	    //countryChosenEmission.add(new qt("CAIT", pink, 1950, 2000));
	    countryChosenEmission.add(new qt("CAIT/Houghton", yellow, 1850, 2000));
	    
	    for (int b = 1; b < biomeclass.chosen.names.length; b++) if(biomestocks.containsKey(b))
		countryChosenBiomes.add(new qt(biomeList.getname(b), biomeclass.chosen.colors[b], 1700, 2002));
	}// getchosen if countryChosenEmission
    }
    
    void findCells(region r) {
	cellset.clear();
	int xo,yo, xd, yd, cell;
	double area=0, sum=0, sumarea=0, dudarea=0; float xi, yi;
	boolean inbox;
	
	for (regpoly p : r.polyset) {
	    Area a = new Area(p);
	    Rectangle box=a.getBounds();
	    
	    int step=5; //degree steps
	    
	    for (xo=box.x; xo<(box.x+box.width); xo+=step) {
		xd=Math.min((box.x+box.width)-xo, step);
		for (yo=box.y; yo<(box.y+box.height); yo+=step) {
		    yd=Math.min((box.y+box.height)-yo, step);
		    if (a.intersects(xo,yo,xd,yd)) {
			inbox=a.contains(xo,yo,xd,yd);
			for (yi=-0.25f+yo; yi<(-0.25f+yo+yd); yi+=0.5) {
			    area=Math.cos((Math.PI*yi)/180.0);
			    for (xi=0.25f+xo; xi<(0.25f+xo+xd); xi+=0.5) {
				if (inbox || a.contains(xi,yi)) {
				    cell c = new cell();
				    c.lon = xi;
				    c.lat = yi;
				    c.area = (float)(area * pow(1.8521 * 30, 2)); //IUGG equatorial radius Earth  6378.137 km, equatorial circumference 40,075 km // 1 nautical miles  = 1.852 kilometres  http://www.thetipsbank.com/convert.htm
				    cellset.add(c);
				}
			    }
			}
		    }
		}
	    }
	} //polys
    } //regav
    
} // end Calclucemit class

class cell {
    int potential, x, y;
    float lon, lat, area;
    int getx(float lon) { return 0;}
}

