//Sea-level rise
//adds ice-melt (glaciers and icecaps) 
//to the thermal expansion calculated in heatflux module 

	

package jcm.mod.cli;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;

import jcm.mod.*;

public class sealevel extends module {
	
	//*****************************************************
	//icecap sensitivities from IPCCTAR chap11 table 11.11
	//climodname={"GFDL_R15_a","CSIRO Mk2","HadCM3","HadCM2", "ECHAM4/OPYC", "CSM 1.0", "DOE PCM", "IPCC SAR"};
	double[] glsens={	0.12,0.16,0.09,0.10,0.03,0.15,0.14,0.3}; 
	double[] ansens={	-0.18,-0.37,-0.35,-0.21,-0.48,-0.31,-0.48,-0.21}; 
	
        //note glsens[get(udebclimod.class).model] gives an initialisation exception - as world is not created yet
	public param greenlandsens=new param("greenland_sensitivity", "", glsens[2], -0.5,  0.5, green, expert ); 
	public param antarcticasens=new param("antarctica_sensitivity", "", ansens[2], -0.5,  0.5, cyan, expert ); 
	
	public void seticecaptomod(udebclimod.gcm g) {
	//P4 FIX ICE CAP TO MOD, no longer works with AR4 GCMs
	    int m=2; //temporary
	    greenlandsens.putval(glsens[m]); antarcticasens.putval(ansens[m]); 
	} //called from climod
	
	//*****************************************************
	public void initsetup() {
		follows(get(glotemp.class)); 
		follows(get(udebclimod.class)); 
		greenlandsens.setaffectedby(get(udebclimod.class).climod); 
		antarcticasens.setaffectedby(get(udebclimod.class).climod); 
	}
	
	//*******************************************************
	//curves for plotting
	public qt
		thermexp=new qt("thermexp",  red),
		glacier=new qt("glaciers",  grey),
		longterm=new qt("rfia",  black),
		antarctica=new qt("antarctica",  cyan),
		greenland=new qt("greenland", green),
		freshwater=new qt("freshwater",  dkgreen, expert),
		other=new qt("Other",  brown),
		total=new qt("totsl", dkblue, simplest, qt.Type.total)
		; 
	
   public qtset sealevel=new qtset( thermexp, glacier, greenland, antarctica, longterm, freshwater, other, total, "sealevelrise", "metres", simplest);
 

	
	//*******************************************************
	//LOOP CALCULATIONS
	
	public void precalc() {	
	    glaciersetup(); 
	}
	
	public void calcstep() {
		
	    //note thermal expansion is calculated in udebclimod.thermalexpansion called from glotemp, since it depends on temporary state data inside other udebclimod arrays
		
		if (year>gsy) {
			glaciermelt(); 
			polarmelt(); 
			
			longterm.set(year, (float)(longterm.get(year-1)+0.00025)); //recovery from ice age
			
			//other factors: sedimentation and permafrost about 0.0002/yr
			//permafrost see tar11.2.6 0-0.23 mm/yr 1990-2100 and 0-0.05 1900-1990, +sedimentation 0-0.05 (constant?)
			other.set(year, (float)(other.get(year-1)+(year<1990 ? 0.00005 : 0.00017 ) )); 
			
			freshwater.set(year, 0); //0.001f*ns;
		}
		
		//add up total
		total.set(year, 
			thermexp.get(year)
			+glacier.get(year)+longterm.get(year)
			+antarctica.get(year)+greenland.get(year)
			+freshwater.get(year)+other.get(year)
			); 
		
	} //********* end calcstep **************
	
	
	public void save99() {	for (n=0; n<ng; n++) glac99[n]=glac[n]; }
	
	public void startstate(int startyear) {
		longterm.set(gsy, 0); antarctica.set(gsy, 0); greenland.set(gsy, 0); freshwater.set(gsy, 0); glacier.set(gsy, 0); other.set(gsy, 0); 
		if (startyear==2000) for (n=0; n<ng; n++) glac[n]=glac99[n]; 
		else for (n=0; n<ng; n++) glac[n]=totglac/ng; 
	}
	
	
	//*******************************************************
	//GLACIERS
	//glacier groups as per jesper interpretation of SAR method
	float totglac=0.5f; //total glacier ice as m sea-level
	float taul=70f, tauh=130f, deltatl=0.7f, deltath=3.0f; //tau is lifetime, deltat is temp for melting
	
	int ng=10, n; float eqglac; 
	float[] glac=new float[ng], glac99=new float[ng], tau=new float [ng], deltat=new float[ng]; 
	
	void glaciersetup() {
		//set up glacier groups
		for (n=0; n<ng; n++) {
			tau[n]=taul+(tauh-taul)*(float)n/(float)(ng-1); 
			deltat[n]=deltatl+(deltath-deltatl)*(float)n/(float)(ng-1); 
		}
	}
	void glaciermelt() {
		//small glaciers
		glacier.set(year, (float)totglac); 
		for (n=0; n<ng; n++) {
			//calc equilibrium left at this temperature
			eqglac=(totglac/ng)*(1.0f-get(glotemp.class).avchange.get(year)/deltat[n]); 
			if (eqglac<0) eqglac=0; 
			//then slow melting towards equilibrium
			//the 0.3 is a factor to match rates of melting in TAR -won't affect final melt (used to be 0.4)
			glac[n]-=0.3*(glac[n]-eqglac)/tau[n]; 
			glacier.set(year, glacier.get(year) -glac[n]); 
		}
	}
	//*******************************************************
	//POLAR ICECAPS
	
	
	void polarmelt() {
		double glsensfac=1.0+(get(glotemp.class).avchange.get(year)-1.5)*0.3; //to be multiplied, i.e. sens up by 25% per degree
		double ansensfac=get(glotemp.class).avchange.get(year)*0.05; //to be added not multiplied!
		/*
		need greenland and antarctica responding to longer term warming -see TARWG1 sec11.5.4.3
		from TAR fig 11.16 greenland melt mm/yr in 3000: 3C: 0.5 = 0.17/C, 5.5C: 1.8 =0.33/C , 8C: 2.4 = 0.3 /C
		text mentions 1mm/yr for 3C =0.33/C and 7 for 12C! = 0.57/C not inc precipitation
		av sensitivity from models 1990-2090 is 0.13/C (for about 1.5C avg rise)
		antarctica av sensitivity from models 1990-2090 is about -0.3C! (for about 1.5C avg rise)
		max loss total antarctic 2.5mm/yr for 8C = +0.32/C
		so sens increase could be about 0.6/6.5C ? but be conservative, use half this
		
		apply sensfacs only after 2100 to aim for consistency with tar!
		thought: could use boxtemp[ns][2] and [1] i.e. south or north ocean temp rather than the global average, since this will determine precipitation or ice-edge melting better,
		but TAR parameters already adjust global to local temps
		
		*/
		
		antarctica.set(year, (float)(antarctica.get(year-1) + ((year>2100 ? ansensfac : 0) + antarcticasens.getval()) * get(glotemp.class).avchange.get(year) * 0.001)); 
		greenland.set(year, (float)(greenland.get(year-1) + (year>2100 ? glsensfac : 1) * greenlandsens.getval() * get(glotemp.class).avchange.get(year) * 0.001)); 
		
	}
	
} //end sealevel class
	//************** end *******************
	

	