/*Radiative forcing: Module
 
Individual forcings are mostly calculated in other modules (atchem, fgas, aerosol,carbonccyle, aviaforcing etc .)
This module adds them all together, and also applies the split between l/o n/s boxes of glotemp model
 
 P3 CHRIS 6) Radiative Forcing-All Contributions-  when stacked just carbon dioxide and aviation_non-co2 are being plotted (this is due to qt.type=total)
 
 
 */

package jcm.mod.cli;
import jcm.core.*;
import jcm.mod.carbon.carboncycle;
import jcm.mod.ogas.*;
import jcm.mod.soc.AviaShipEmit;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import static jcm.mod.ogas.gas.*;


public class radfor extends module  {
    
    carboncycle carboncycle;     atchem atchem;     fgas fgas;     aerosol aerosol;	AviationForcing aviaf;
    
    //*****************************************************
    //PARAMETERS
    
    public param unifdist=new param("unif", false, expert) { public void precalc() { distribute(); }};
    public param only4gas=new param("4gas", false, experimental)	;  //not working-see note below
    public param excavia=new param("exclude aviation non-co2", false, complexity.expert)	;
    public param applyefficacy=new param("include efficacy factor", false, complexity.expert);
    
    
    
    //*******************************************************
    //PLOTARRAYS
    public qt
	    totalrf= new qt("totrf" ,red , simplest, qt.Type.total),
	    ghgrf= new qt("allghg" , greygreen, simplest, qt.Type.total),
	    anthrorf = new qt( "allghgaero",dkred , expert, qt.Type.total),
	    nlrf=new qt("rfnl"  , red ,  expert ),
	    norf=new qt( "rfno" , blue ,  expert  ),
	    sorf =new qt("rfso" ,  cyan ,  expert   ),
	    slrf =new qt( "rfsl"  ,  orange , expert   ),
	    //co2equivalent
	    co2eqghg=new qt("co2eq&allghg", purple , expert),
	    co2eqghgaero=new qt("co2eq&allghgaero" , pink , expert),
	    co2eqkyoto=new qt("co2eq&6gas", magenta , expert )
	    ;
    
    public qtset concequiv=new qtset(co2eqkyoto, co2eqghg, co2eqghgaero,  "co2equivconc", "ppm", expert);
    public qtset allrf=new qtset( totalrf, anthrorf, ghgrf, "allrf", "w&per&m2");
    public qtset allrf2=new qtset( totalrf, "allrfdetail", "w&per&m2", normal);
    public qtset regrf=new qtset( totalrf, nlrf, norf, sorf, slrf,  "regrf", "w&per&m2", expert);
    
    public qt[] splitrf={nlrf, norf, sorf, slrf}; //for easy access by udebclimod
    
    //*****************************************************
    //INITSETUP
    
    public void initsetup() {
	super.initsetup();
	carboncycle=get(carboncycle.class); atchem=get(atchem.class); aerosol=get(aerosol.class); fgas=get(fgas.class); aviaf=get(AviationForcing.class);
	follows(carboncycle);         follows(atchem);        follows(aerosol);        follows(fgas);	follows(aviaf);
	
	concequiv.add(carboncycle.co2atppm);
	allrf.add(carboncycle.co2rf, atchem.othgasrf,  fgas.fgasrf,  aerosol.aerorf, aerosol.natvrf, aviaf.rfnonco2);
	allrf2.add(
		carboncycle.co2rf,
		atchem.ch4rf, atchem.n2orf, atchem.tropo3rf, atchem.strath2orf,
		fgas.cfcrf, fgas.hfcrf, fgas.strato3rf,
		aerosol.sulfdirrf, aerosol.sulfindrf,   aerosol.bcrf, aerosol.ocrf,
		aerosol.solarrf, aerosol.volcanorf,
		aviaf.rfnonco2
		);
    }
    
    //**************** efficacy ********************************************************
    public float getefficacy(gas g) { return applyefficacy.istrue() ? g.efficacy : 1f; }
    
    
    //************ mainloop calculations **********************************
    //LOOP CALCULATIONS
    
    public void calcstep(){
	calctotals();
	calcsplit();
	calcequiv();
    }
    
    //****************************************************
    //DISTRIBUTE
    //distribute radiative forcing between N/S & L/O boxes of UDEB-climod
    //now this code become complex, could tidy using Jama matrices?
    //or use an enum for the four surface boxes, instead of the 0-3 indices
    
    double[] frac, splitnls=new double[4], splitnlw=new double[4], splitl=new double[4], splitsl=new double[4], splits=new double[4];
    
    void distribute() {
	if (unifdist.istrue()) {
	    for (int i=0; i<4; i++) {	splitnls[i]=1f; splitnlw[i]=1f; splitl[i]=1f; splitsl[i]=1f; splits[i]=1f; }
	} else {
	    frac=get(udebclimod.class).frac;
	    //new N/S  and L/O splits based roughly on table 6.4 , 6.11 in TAR
	    splitnls[0]=0.8*0.75/(0.75*frac[0]+0.25*frac[1]); splitnls[1]=splitnls[0]/3;
	    splitnls[3]=0.2*0.75/(0.75*frac[3]+0.25*frac[2]); splitnls[2]=splitnls[3]/3;
	    splitnlw[0]=0.6667*0.6667/(0.6667*frac[0]+0.3333*frac[1]); splitnlw[1]=splitnlw[0]/2;
	    splitnlw[3]=0.3333*0.6667/(0.6667*frac[3]+0.3333*frac[2]); splitnlw[2]=splitnlw[3]/2;
	    splitl[0]=0.6667/frac[0]; splitl[1]=0; splitl[3]=0.3333/frac[3]; splitl[2]=0;
	    splitsl[0]=0.3333*0.75/(0.75*frac[0]+0.25*frac[1]); splitsl[1]=splitsl[0]/3;
	    splitsl[3]=0.6667*0.75/(0.75*frac[3]+0.25*frac[2]); splitsl[2]=splitnls[3]/3;
	    splits[0]=0.25/0.5; splits[1]=0.25/0.5; splits[2]=0.75/0.5; splits[3]=0.75/0.5;
	}
    } //end distribute
    
    //old distribution of sulphate forcing:
    //fsul[0]=0.6667*0.9/(0.9*udebclimod.frac[0]+0.1*udebclimod.frac[1]); fsul[1]=fsul[0]/9;
    //fsul[3]=0.3333*0.9/(0.9*udebclimod.frac[3]+0.1*udebclimod.frac[2]); fsul[2]=fsul[3]/9;
    
    
    void calcsplit() {
	for (int i=0; i<4; i++) {
	    splitrf[i].set(year, (float)(
		    carboncycle.co2rf.get(year) +atchem.ch4rf.get(year) +atchem.strath2orf.get(year) +atchem.n2orf.get(year)  //well mixed ghgs - excluding tropo O3
		    +fgas.cfcrf.get(year) +fgas.hfcrf.get(year) 	//well mixed ghgs - excluding strato O3
		    +aerosol.natvrf.get(year)   			//solar & volcano - maybe volcano should split too?
		    +(aerosol.sulfdirrf.get(year) + aerosol.bcrf.get(year) +aerosol.ocrf.get(year) +aviaf.rfnonco2.get(year))*splitnls[i]  	//strong bias to northern land
		    +(aerosol.sulfindrf.get(year) + atchem.tropo3rf.get(year) )*splitnlw[i] 				//weaker bias to northern land
		    +fgas.strato3rf.get(year) *splits[i]							//bias to south
		    //				+albedorf.get(year) *splitl[i]								//all on land
		    //				+bioburnrf.get(year) *splitsl[i]							//bias to southern land
		    ));
	}
    }
    //******************************
    //TOTALS
    
    void calctotals() {
	if (get(radfor.class).only4gas.istrue()) {
	    ghgrf.set(year,   carboncycle.co2rf.get(year) + atchem.ch4rf.get(year) + atchem.n2orf.get(year) );
	    anthrorf.set(year,   ghgrf.get(year) + aerosol.sulfdirrf.get(year) +  aerosol.sulfindrf.get(year) );
	    totalrf.set(year,   anthrorf.get(year) );
	    //P2 CHECK / FIX only4gas option does not affect the calcsplit, so it is not useful, if it changes the totals from other classes, need to affect them, in order to restore after set false.
	} else {
	    ghgrf.set(year,   carboncycle.co2rf.get(year)  + atchem.othgasrf.get(year) +fgas.fgasrf.get(year) );
	    anthrorf.set(year,   ghgrf.get(year)  + aerosol.aerorf.get(year) +aviaf.rfnonco2.get(year));
	    totalrf.set(year,    anthrorf.get(year)  + aerosol.natvrf.get(year) );
	}
    }
    
    //*********************************
    //CO2 EQUIVALENTS
    public void calcequiv() { //note this must come after rf in loop!
	double  fac=Math.log(2.0) / get(udebclimod.class).val(udebclimod.cp.rfco2double) ;
	co2eqkyoto.set(year,  (float)(  carboncycle.atppmprein*   Math.exp( ( fgas.hfcrf.get(year) +atchem.ch4rf.get(year) +atchem.n2orf.get(year) +carboncycle.co2rf.get(year) ) *fac) ));
	co2eqghg.set(year,  (float)( carboncycle.atppmprein* Math.exp( (atchem.othgasrf.get(year) +fgas.fgasrf.get(year) +carboncycle.co2rf.get(year) ) *fac ) ));
	co2eqghgaero.set(year,  (float)( carboncycle.atppmprein* Math.exp( (atchem.othgasrf.get(year) +fgas.fgasrf.get(year) +carboncycle.co2rf.get(year) +aerosol.aerorf.get(year) ) *fac ) ));
    }
    
    
    
//*******************************************************
} //end radfor class



