//Climate model to calculate global temperature rise from radiative forcing
//Based on Wigley-Raper Upwelling-Diffusion Energy Balance model
//fitted to GCMs as documented in IPCC-TAR WG1 Appx 9.1
//and solved using eigenvector method
//also calculates thermal expansion due to sea-level rise

//Developed in Copenhagen spring 2001

//P2 CHRIS 8) world average temperature when stacked problems with measured data (average) after 2000. (shouldn't be stackable)


package jcm.mod.cli;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.
import jcm.mod.*;

public class glotemp extends module  {
    
    //*****************************************************
    //INTERACTIONS
    
    public void setinteractions() {
	follows(get(radfor.class));
	setaffectedby(get(udebclimod.class));
    } //end interactions
    
    
    //temperature baseyear: just affect temp-plot (& temps shown on regclimap) not model calculations
    //note must be at least 3 less than stabtemp startyear!
    public static param baseyear=new param("baseyear", "", 1865, 1760, 1997, blue);
    boolean initialhistdata=true;
    
    //*******************************************************
    //QTs
    
    //global average temp change, wrt 1750 -note other base years in glotemp module
    public qt   avchange=new qt(	"tempavfrom1750", brown , experimental);
    
    //note other qtsets below not used by the rest of the model, which use udebclimod avchange
    //however the result of the error calculation may be used in scripts
    public static qt
	    proxytemp=new qt( "tempproxy" ,  greygreen, 1750, 1991  ),
	    tempdata=new qt( "tempdata" , dkgreen, 1750, 2002, simplest ),
	    temptrend=new qt( "temptrend"  , green, 1750, 1999 );
    
    public qt
	    avchangeby=new qt(	"tempav", brown , simplest),
	    tempnl=new qt( "tempnl"  , red ,  expert ),
	    tempno=new qt( "tempno" , blue ,  expert  ),
	    tempso	=new qt(  "tempso" ,  cyan ,  expert   ),
	    tempsl	=new qt( "tempsl"  ,  orange , expert   );
    
    public qtset
	    temp=new qtset(avchange, avchangeby, tempdata, proxytemp, temptrend ,  "glotempcurves", "degcbase", simplest),
	    boxtemp=new qtset( tempnl, tempno, tempsl, tempso, "Box Temperature", "degcbase" )
	    ;
    
    
    /*****************************************************
     P3 changing baseyear is making too much recalc, could extract this histtemp to a separate module for clarity of interactions?
     but complex because carbon can use regional box temperatures
   */ 
    
    //************************************
    // CALCULATION STEPS
    
    
    public void initsetup() {
	for (int y=1750; y<1860; y++) tempdata.set(y, 0);
	//normalise tempdata and proxytemp to 1960-90
	for (int y=1860; y<2003; y++) tempdata.set(y, tempdata.get(y)-0.42f);
	for (int y=1750; y<1992; y++) proxytemp.set(y, proxytemp.get(y)+0.04f);
	temp.associate(baseyear);
	boxtemp.associate(baseyear);
    }
    
    public void startstate(int startyear) {	get(udebclimod.class).startstate(startyear); }
    public void save99() {	get(udebclimod.class).save99(); }
    
    public void calcstep() {
	udebclimod udeb=get(udebclimod.class); radfor rf=get(radfor.class);
	if (year>gsy)	udeb.tempupwellfb(avchange.get(year)); //a feedback on self, using last-year temp
	avchange.set(year, udeb.adjust(new float[] {rf.splitrf[0].get(year), rf.splitrf[1].get(year), rf.splitrf[2].get(year), rf.splitrf[3].get(year)} ));
	if (year==((int)baseyear.getval()  + 2))  calcoffset(); //do this at baseyear +2 (as 5yr average) Need in loop because used for stabilisation target
	get(sealevel.class).thermexp.set(year, udeb.thermalexpansion());
    }
    
    public void postcalc() {
	applyoffset(); calcerror();
	if (initialhistdata || baseyear.changed) histtemptrend();
    } //have to do at end because affects curve before baseyear too
    
    //*******************************************************
    public double error=0;
    
    
    public void calcerror() {
	//error for probabilistic calculations
	// must do after both avchangeby and histdata have been offset
	//assume proxy temp error 0.5C, measured temp error 0.05C+0.0015*(1950-year) up to 1950 (based on info from CRU faq)
	float sumdiff=0, sumdata=0, sumcalc=0, n=0, ct, mt, e;
	for (int y=gsy; y<2002; y++)  {
	    ct=avchangeby.get(y);
	    if (y<1860) {	mt=proxytemp.get(y); e=0.5f; } else {	mt=tempdata.get(y); e=0.05f+0.0015f*(y<1950 ? 1950-y : 0); }
	    sumdiff+=(ct-mt)*(ct-mt)/e;
	    sumcalc+=ct/e;
	    sumdata+=mt/e;
	    n+=1f/e;
	}
	error= Math.pow(sumdiff/n - (sumcalc/n - sumdata/n)* (sumcalc/n - sumdata/n), 0.5);
    }
    
    //********** normalise to baseyear ****************
    public double offset=0, oldoffset=1.0;
    
    //store offsets outside loop so remember old value if calcfutureonly
    float[] boxoffset=new float[4];
    qt[] boxtempqt=  {	tempnl, tempno, tempso, tempsl } ;
    
    public void calcoffset() {
	//normalise to baseyear temps -or actually +/-2yr average due to odd peaks
	//now apply to all the boxtemps separately
	//note hist data normalised in temptrend method as doesn't change unless baseyear changed
	oldoffset=offset; offset=0; for (int b=0; b<4; b++) boxoffset[b]=0;
	for (int i=0; i<5; i++) {
	    int dy=(int)baseyear.getval()+i-2; if (dy<gsy) dy=gsy;
	    offset+=(float)((avchange.get(dy))/5.0);
	    for (int b=0; b<4; b++) boxoffset[b]+=(float)((boxtempqt[b].get(dy))/5.0);
	}
    } //end calcoffset
    
    void applyoffset() {
	
	for (int y=0; y<=gey; y++) {
	    for (int b=0; b<4; b++) boxtempqt[b].set(y,  boxtempqt[b].get(y) -boxoffset[b]);
	    avchangeby.set(y, (float)(avchange.get(y)-offset));
	}
    }
    
    
    //******************************************
    //make historical tempdata trend - 7yr moving average
    
    void histtemptrend() {
	temptrend.set(gsy, 0);
	for (int y=gsy; y<=gsy+6; y++) temptrend.set(y, temptrend.get(y)+proxytemp.get(y) / 7.0f);
	for (int y=gsy+7; y<=1860; y++) temptrend.set(y-3,  temptrend.get(y-4)+(proxytemp.get(y)-proxytemp.get(y-7)) /7.0f);
	for (int y=1860; y<=1867; y++) temptrend.set(y-3,   temptrend.get(y-4)+(tempdata.get(y)-proxytemp.get(y-7)) /7.0f);
	for (int y=1868; y<=2002; y++) temptrend.set(y-3,    temptrend.get(y-4)+(tempdata.get(y)-tempdata.get(y-7)) /7.0f);
	
	//normalising to baseyear
	float htoffset=0;
	for (int i=0; i<5; i++) {
	    int dy= (int)baseyear.getval()+i-2; if (dy<gsy) dy=gsy; if (dy>2002) dy=2002;
	    htoffset+=(float)((baseyear.getval()>1862 ? tempdata.get(dy) : proxytemp.get(dy))/5.0);
	}
	float byoffset=temptrend.get((int)baseyear.getval());
	
	for (int y=gsy; y<=1991; y++) proxytemp.set(y, proxytemp.get(y)-htoffset);
	for (int y=gsy; y<=2002; y++) tempdata.set(y, tempdata.get(y)-htoffset);
	for (int y=gsy; y<=1999; y++) temptrend.set(y, temptrend.get(y)-byoffset);
	
	//flags for no data
	for (int y=gsy; y<gsy+3; y++) temptrend.set(y, -999);
	for (int y=gsy; y<1860;  y++) tempdata.set(y, -999);
	initialhistdata=false;
    }
    
	   /*
	     //****************************************************
	     //TEMPERATURE -  CARBONCYCLE FEEDBACK
	     these methods are called from carboncycle feedbacks
	     Need a temperature rise relative to preindustrial, based on the previous year,
	     because carboncycle precedes this module in the calculation loop
	    
	     Beware temperature normalisation to baseyear which isn't done until postcalc!
	     so if calcfutureonly boxtemp[0] and boxtemp[249] are still normalised (prev loop)
	     but boxtemp[250] isn't yet
	    
	     Actually taking sum/2 isn't correct - should weight by areas of N / S boxes!
	    
	     note october 2004: this isn't working with calcfutureonly in initial startup in period 1990-2000!
	    
	    
	    beware - these methods called even when this module is not changed so doesn't run loop methods!
	    eg when call carbonstorage - makes carboncycle run but doesn't change this
	    then problem is to undo the normalisation
	    
	    */
    public boolean usehisttempdata=false; //for feedbacks note: called from some scripts
    
    public double getoceantemprise() { return(gettemprise(1)); }
    public double getlandtemprise() { return (gettemprise(0)); }
    
    double gettemprise(int b) {
	if (usehisttempdata && year<2002) {     	//option for history use data normalised to 1850
	    float nfac=0, temprise;
	    for (int s=1848; s<1853; s++) nfac+=proxytemp.get(s)/5f;
	    temprise=(year<1860 ? proxytemp.get(year) : tempdata.get(year))-nfac;
	    return temprise* (b==0 ?  1.356 : 0.847); //higher on land than ocean
	} else {
	    return (year>1750? ((boxtempqt[b].get(year-1)+boxtempqt[3-b].get(year-1))
	    +(	((loop.calcfutureonly && year<=2000) || !changed) ? (boxoffset[b]+boxoffset[3-b]) : 0)
	    ) /2.0: 0);
	}
    }
    
    
} //end  class

 /*
     * P1 CHECK TIDY is old code below to adjust yscale origin depending on baseyear still useful?
     * //new scalemodel(scalemodel.Type.Y, "degcbase", -1.2, 3.2, 0.4, 1.0);
     * //this isn't working - affects only the hist data and not the scale!!
     * //scale moves up/down with baseyear so that curve doesn't move -but can be many instances of it
     *
     * public scalemodel getyscale() {	return new  scalemodel(allqt, getunits()) {
     * float oldoffset=avchangeby.a[200]-avchange.a[200];
     * public void setinteractions() {  setaffectedby(baseyear); super.setinteractions(); }
     * public void precalc() {
     * float offset=avchangeby.a[200]-avchange.a[200], change=offset-oldoffset; oldoffset=offset;
     * min.val+=change*scaleu; max.val+=change*scaleu;
     * }
     * }; }
     *
     */
   
