
   /*
	this module just includes the extra curves and calcs needed for an carbon storage plot
	separated from the main calculations because multiplying out the whole matrix is rather slow
    
    */

package jcm.mod.carbon;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import java.awt.Color;



public class carbonstorage extends module {
    
    public carbonstorage() { makecurves(); }
    
    public void setinteractions() {
	follows(carboncycle.class);
	setaffectedby(berncarbon.class); //so the MV matrix is kept
	//see also precalc
    }
    
    
    public void precalc() {
	get(carboncycle.class).changed=true; //force recalculate because depends on transient fields in berncarbon
	/*
	 note this won't trigger other changes affectby carboncycle because it comes after setallinteractions - but that's what we want (interface no need recalc heatfluxes)
	 also this comes after carbonycle in loop so miss out on the precalc, (but there isn't one yet)
	 seems to work so long as keep the MV matrix, 	 but not very robust to changes
	 alternative -call it preinterac -but not called by loop unless this already changed and needed, and we don't set needed until setinteractions
	 
	 note also: making this plot visible seems to upset the carboncycle slightly
	 seems to be connected with the ocean startstate - but that method is run ok
	 aha -it's to do with the temperature feedback on chemistry - no problem if off
	 */
    }
    
    int ncb=berncarbon.ncb;
    //"real" box contents for viewbox  -beware 100K memory!
    public float[][] cq=new float[ncb][gey-gsy+2];
    
    public void changeendyear(int oldey, int newey) { 	cq=new float[ncb][newey-gsy+2];   }
    
    public qt[] curve=new qt[cq.length];
    public qtset carbonstorage;
    
    public void makecurves() {
	int ncl=berncarbon.ncl;
	int cd=75 , cd2; //75=mixed layer depth
	for (int i=0; i<ncl; i++) {
	    int b= (int) (127+127.0*Math.cos((Math.PI*2)*(i-ncl/3)/ncl));
	    int r= (int) (127+127.0*Math.cos((Math.PI*2)*(i-(2*ncl)/3)/ncl));
	    
	    cd2=cd+(i<20 ? 49 :196);
	    String name=""+cd+"-"+cd2+"m";
	    curve[ncb-1-i]=new qt(cq[i],name, new Color(r,0,b) ) ;
	    cd=cd2;
	}
	
	String[] boxnames={"lsurf","hsurf", "hdeep" , "atmosphere", "green", "wood", "soil", "humus", "newprod"};
	Color[] boxcolor={ltblue, blue, dkblue, ltgrey, green, dkgreen, brown, dkbrown, yellowgreen};
	for (int i=0; i<9; i++) curve[ncb-1-(ncl+i)]=new qt(cq[ncl+i], boxnames[i], boxcolor[i]);
	
	carbonstorage=new qtset("carbonstoragecurves", "mega&ton&carbon", curve);
	super.initsetup();
    }
    
    public  void calcstep() {
	//below is whole matrix multiplication  - beware will be slow
	for (int n=0; n<ncb; n++) {
	    cq[n][year-gsy]=0;
	    for (int m=0; m<ncb; m++) cq[n][year-gsy]+=get(berncarbon.class).MV.getArray()[n][m]*get(berncarbon.class).ciq[m];
	}
	
    }
    
    
} //end class
