/*
Carbon Cycle sinks
Note this is only a linker/holder module, with some peripheral functions
The main carboncycle caculations are in berncarbon module
Emissions are in globco2emit
 */


package jcm.mod.carbon;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.ogas.*;
import jcm.mod.cli.*;
import jcm.mod.obj.*;
import jcm.mod.soc.*;

public class carboncycle extends module {
    
    //*****************************************************
    //INTERACTIONS
    
    public void initsetup() {
	follows(get(globco2emit.class));
	fillconcdata();
    }
    
    public void setinteractions() {
	setaffectedby(get(berncarbon.class), !accccarbon.istrue());
    } //end interactions
    
    
    
    //*****************************************************
    //PARAMS
    
    public param    accccarbon=new param("accccarbon", false, expert); //use ACCC simple carbon model
    
    public void startstate(int startyear) {    get(berncarbon.class).startstate(startyear); }
    public void save99() {  get(berncarbon.class).save99(); }
    
    //*******************************************************
    //PLOTARRAYS
    
    public static qt
	    co2atppmdata=new qt("atco2data" ,grey, 1750, 2004),
	    atincdata=new qt("atincdat", qt.Type.total,grey, 1751, 2004);
    
    public qt
	    totemit=new qt("totemit" ,brown, simplest, qt.Type.total),
	    fossil=new qt("fossilemit" ,red),
	    lucf = new qt("lucemit" ,orange),
	    totsink =new qt( "totsink" ,cyan, simplest, qt.Type.total),
	    ocsink = new qt("oceansink" ,blue),
	    tbsink = new qt("landsink" ,green),
	    atinc=new qt("atincmod", black, qt.Type.total),
	    co2atppm=new qt("atco2calc" ,black, simplest),
	    //radiative forcing -visible in radfor module
	    co2rf=new qt("co2rf" ,black );
    
    public qtset sosi=new qtset( fossil, lucf, totemit, atinc, atincdata, ocsink, tbsink, totsink, "atco2flux", "mega&ton&carbon&/&yr", simplest);
    public qtset conc=new qtset( co2atppm, co2atppmdata, "atco2conc", "ppm" , simplest);
    
    
    //****************************************************
    //CONSTANTS
    
    //ppmptc= ppmv per megaton carbon in the atmosphere
    public static final double ppmpmtc=0.000471, atppmprein=278f;
    
    
    //***************************************************
    //LOOP CALC ROUTINES
    
    
    public void calcstep() {
	
	//accccarbon simple IRF model
	if (accccarbon.istrue()) {
	    if (year==gsy) for (int i=0; i<4; i++) acccbox[i]=0;
	    co2atppm.set(year, (float) atppmprein+acccmod(acccbox, totemit.get(year) ));
	    ocsink.set(year, 0); tbsink.set(year, 0);
	    totsink.set(year,  (year>gsy) ? (float)( ( co2atppm.get(year) -co2atppm.get(year-1))/ppmpmtc ) - totemit.get(year) : 0 ); //need totsink for inverse concn method to work
	} else {
	    float[] state=get(berncarbon.class).addemit(totemit.get(year) );
	    //note includes temp feedbacks
	    
	    co2atppm.set(year, state[0]); tbsink.set(year,  -state[1]); ocsink.set(year,  -state[2]);
	    totsink.set(year, ocsink.get(year) +tbsink.get(year) );
	    if (year>1750) atinc.set(year, (float)((co2atppm.get(year) -co2atppm.get(year-1) )/ppmpmtc));
	}
	co2rf();
	
    } //end calcstep()
    
    public void postcalc() { calcerror(); }
    
    
    
    //*******************************************
    //INVERSECO2
    
    
    //hist landusechange by inverse from concentration (smoothed)
    public void inverseluc()  {     //called from history calcstep
	co2atppm.set(co2atppmdata.get());
	totemit.set(year, inverseco2(co2atppmdata.get(year) ));
	lucf.set(year, (float)((4.0*lucf.get(year-1) +(totemit.get(year) -fossil.get(year) ))/5.0));
    }
    
    //inverse formula: emissions from concentration
    public float inverseco2(double ctarget) { return  inverseco2( ctarget, 1); } //called above, by stabilisation and stabtempfuzzy
    public float inverseco2(double ctarget, int dt) {
	//project total sinks
	double projsink= totsink.get(year-1)  + (totsink.get(year-1)  - totsink.get(year-(1+dt)))/dt ;
	if ((projsink / totsink.get(year-1) )<0) projsink= 0;
	//+totsink[ns-1]+(totsink[ns-1]-totsink[ns-5])/4.0
	//if (year>2000 && year<2010) debug(ctarget , projsink ,  (float)( ( (ctarget - co2atppm.get(year-1) ) / ppmpmtc) - projsink));
	
	return (float)( ( (ctarget - co2atppm.get(year-1) ) / ppmpmtc) - projsink);
	//emissions = total co2 needed to add to atmosphere in this step , plus total sinks
	// ?(target is ppmv normalised to startyear-1)
	//-(target[(ssy-1)-gsy]-co2atppm.a[(ssy-1)-gsy])
    }
    
    
    //******************************************
    //CO2 RF and equivalents
    //note equivalents calculated in radfor, to get correct calculation order
    //note rfco2double param stored in get(udebclimod.class)
    void co2rf() {
	co2rf.set(year, (float)(get(udebclimod.class).val(udebclimod.cp.rfco2double)*Math.log(co2atppm.get(year) /atppmprein)/Math.log(2.0)));
    }
    
    
    //****************************************************
    //ERROR
    //store cumulative error wrt measured concentration
    public double error;
    
    public void calcerror() {
	float sumdiff=0, sumdata=0, sumcalc=0, n=0, c, m, e;
	for (int ns=1; ns<fsy-gsy+1; ns++) {
	    c=atinc.get(year) ; //co2atppm.get(year) ;note- changed jan06
	    m=atincdata.get(year) ; //co2atppmdata.get(year) ;
	    e=(ns>200 ? 0.1f : 0.5f); //assume bigger uncertainty pre 1950
	    sumdiff+=Math.abs((c-m)/e);//(c-m)*(c-m)/e;
	    sumcalc+=c/e;
	    sumdata+=m/e;
	    n+=1f/e;
	}
	error=sumdiff/n;
	//error= Math.pow(sumdiff/n - (sumcalc/n - sumdata/n)* (sumcalc/n - sumdata/n), 0.5);
    }
    
    
    //****************************************
    static void fillconcdata() {
	
	//from Keeling Mauna Loa 1959-2004
	double[] maunaloaCO2 = {316.00, 316.91, 317.63, 318.46, 319.02, 319.52, 320.09, 321.34, 322.13, 323.11, 324.60, 325.65, 326.32, 327.52, 329.61, 330.29, 331.16, 332.18, 333.88, 335.52, 336.89, 338.67, 339.95, 341.09, 342.75, 344.44, 345.86, 347.14, 348.99, 351.44, 352.94, 354.19, 355.62, 356.36, 357.10, 358.86, 360.90, 362.58, 363.84, 366.58, 368.30, 369.47, 371.04, 373.08, 375.61, 377.43  };
	
	//from Robertson 2001, 1500-1997 (second line starts 1750)
	//From ftp://ftp.ncdc.noaa.gov/pub/data/paleo/climate_forcing/robertson2001/trace_gas.txt
	double[] robertsonCO2 = { 282.2, 282.3, 282.3, 282.4, 282.4, 282.5, 282.5, 282.6, 282.6, 282.7, 282.7, 282.7, 282.8, 282.8, 282.9, 282.9, 282.9, 283, 283, 283.1, 283.1, 283.1, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.2, 283.1, 283.1, 283.1, 283.1, 283.1, 283, 283, 283, 283, 282.9, 282.9, 282.8, 282.8, 282.8, 282.7, 282.7, 282.7, 282.6, 282.5, 282.5, 282.4, 282.3, 282.2, 282.1, 282, 282, 281.9, 281.8, 281.7, 281.6, 281.5, 281.3, 281.2, 281.1, 280.9, 280.8, 280.6, 280.5, 280.4, 280.2, 280, 279.9, 279.7, 279.5, 279.3, 279.2, 279, 278.8, 278.6, 278.5, 278.3, 278.2, 278, 277.8, 277.6, 277.5, 277.3, 277.1, 276.9, 276.8, 276.7, 276.5, 276.4, 276.3, 276.1, 276, 275.9, 275.8, 275.7, 275.7, 275.6, 275.5, 275.5, 275.5, 275.4, 275.4, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.3, 275.4, 275.4, 275.4, 275.4, 275.5, 275.5, 275.5, 275.6, 275.7, 275.7, 275.8, 275.8, 275.9, 275.9, 276, 276, 276.1, 276.1, 276.1, 276.2, 276.2, 276.3, 276.3, 276.3, 276.3, 276.4, 276.4, 276.4, 276.4, 276.4, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.5, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.4, 276.5, 276.5, 276.5, 276.5, 276.5, 276.6, 276.6, 276.6, 276.6, 276.6, 276.7, 276.7, 276.7, 276.7, 276.7, 276.8, 276.8, 276.8, 276.8, 276.8, 276.9, 276.9, 276.9, 276.9, 276.9, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 276.9, 277,
	277, 277, 277.1, 277.1, 277.1, 277.2, 277.3, 277.3, 277.4, 277.5, 277.6, 277.7, 277.8, 277.8, 277.9, 278, 278.1, 278.2, 278.3, 278.5, 278.6, 278.7, 278.9, 279, 279.1, 279.3, 279.5, 279.6, 279.8, 279.9, 280.1, 280.2, 280.4, 280.5, 280.7, 280.8, 281, 281.1, 281.3, 281.4, 281.6, 281.8, 281.9, 282, 282.2, 282.3, 282.4, 282.6, 282.7, 282.8, 282.9, 283, 283.1, 283.2, 283.3, 283.4, 283.5, 283.6, 283.7, 283.7, 283.8, 283.9, 283.9, 283.9, 284, 284, 284, 284.1, 284.1, 284.2, 284.2, 284.2, 284.2, 284.3, 284.3, 284.3, 284.3, 284.3, 284.4, 284.4, 284.4, 284.4, 284.4, 284.5, 284.5, 284.5, 284.5, 284.5, 284.6, 284.6, 284.6, 284.6, 284.7, 284.7, 284.7, 284.8, 284.9, 284.9, 285, 285.1, 285.2, 285.3, 285.4, 285.5, 285.6, 285.7, 285.8, 285.9, 286, 286.2, 286.3, 286.5, 286.6, 286.8, 287, 287.2, 287.4, 287.6, 287.8, 288, 288.2, 288.4, 288.7, 288.9, 289.1, 289.4, 289.7, 289.9, 290.2, 290.5, 290.8, 291.1, 291.4, 291.7, 292, 292.3, 292.6, 292.9, 293.1, 293.4, 293.7, 294, 294.3, 294.6, 294.9, 295.2, 295.5, 295.8, 296.1, 296.4, 296.7, 297, 297.3, 297.6, 297.9, 298.2, 298.5, 298.9, 299.2, 299.6, 299.9, 300.2, 300.5, 300.9, 301.2, 301.5, 301.8, 302.2, 302.5, 302.9, 303.2, 303.5, 303.9, 304.2, 304.6, 304.9, 305.2, 305.6, 305.9, 306.2, 306.5, 306.8, 307.1, 307.4, 307.7, 308, 308.3, 308.5, 308.8, 309.1, 309.3, 309.5, 309.8, 310, 310.2, 310.5, 310.8, 311, 311.3, 311.7, 312, 312.4, 312.8, 313.2, 313.6, 314.1, 314.6, 315.1, 315.7, 315.8, 316.8, 317.5, 318.3, 318.8, 319.4, 319.9, 321.2, 322, 322.9, 324.5, 325.5, 326.2, 327.3, 329.5, 330.1, 331, 332, 333.7, 335.3, 336.7, 338.5, 339.8, 341, 342.6, 344.3, 345.7, 347, 348.8, 351.3, 352.8, 354, 355.5, 356.3, 357, 358.9, 360.9, 362.7, 363.8 };
	
	for (int y=1750; y<1959; y++) co2atppmdata.set(y, (float)robertsonCO2[y-1500]);
	for (int y=1959; y<2005; y++) co2atppmdata.set(y, (float)maunaloaCO2[y-1959]);
	for (int y=1751; y<2005; y++) atincdata.set(y, (float)((co2atppmdata.get(y) - co2atppmdata.get(y-1))/ppmpmtc));
    }
    
    
    //***************************************
    //  ACCC simple linear carbon cycle - added for MATCH exercise, only used if accc parameter selected
    float[] acccfrac={ 0.152f, 0.253f, 0.279f, 0.316f};
    float[] accctau ={ 9999999f, 171f, 18f, 2.57f} ; //note first is not used
    //for accc-simple-carbon
    public float[] acccbox=new float[4];
    
    
    public float acccmod(float[] box, float emit) {
	for (int i=0; i<4; i++) box[i]+= acccfrac[i]*emit *(float) ppmpmtc; //add emissions
	for (int i=1; i<4; i++) box[i]*=Math.exp(-1.0/accctau[i]); //decay
	float total=0; for (int i=0; i<4; i++) total+=box[i];
	return total;
    }
	/*
	IRF method
	float[] irf = new float[glos2];
	void makeirf() {
	for (int t=0; t<glos2; t++) {
	irf[i]= f0 + f1*Math.exp(-t/p1) + f2*Math.exp(-t/p2) + f3*Math.exp(-t/p3);
	}
	}
	 */
    
    
    
    
} //end carbon





