

package jcm.gui.plot;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.*;
import javax.swing.text.BadLocationException;
import jcm.core.*;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;

public class legend extends JScrollPane implements MouseMotionListener {
    
    qtset qq;
    boolean stacked=false;
    JEditorPane jep=new JEditorPane() {
	public void paintComponent(Graphics g) { lookandfeel.setAntiAlias(g); super.paintComponent(g); }
    };
    
    
    legend(qtset qq) {
	this.qq=qq;
	jep.setContentType("text/html;"); jep.setEditable(false);
	setViewportView(jep);
	makelabs(true);
	//setOpaque(false); jep.setOpaque(false);  viewport.setOpaque(false);
	getVerticalScrollBar().setPreferredSize(new Dimension(12, getPreferredSize().height));
	getHorizontalScrollBar().setPreferredSize(new Dimension(getPreferredSize().width, 12));
    }
    
    public void makelabs(boolean usetitle) {
	StringBuilder sb=new StringBuilder();
	sb.append("<body><font  style='font-size: "+(int)lookandfeel.fontSize.getval()+"pt ; font-family: Verdana, Arial, sans-serif;' >");
	Map<Object, qt> map=stacked ? qq.mapwithouttotal() : qq.map;
	for (qt q : map.values()) if (q.checkcomplexity()) {
	    sb.append((sb.length()>0 ?  "<br>" : "")+q.hashcolor()+ (usetitle ? labman.getTitle(q.name) : labman.getShort(q.name) )+"</font>");
	}
	sb.append("</font></body>");
	jep.getEditorKit().createDefaultDocument();
	jep.setText(sb.toString());
	jep.addMouseMotionListener(this);
	revalidate();
	//System.err.println("makelabs "+usetitle+" "+jep.getPreferredSize().height+" "+getHeight());
	if (usetitle && (jep.getPreferredSize().height>getHeight()  || jep.getMinimumSize().width>getWidth())) makelabs(false);
	repaint();
    }
    
    public void setBounds(int x, int y, int w, int h) { super.setBounds(x,y, w, h); makelabs(true); }
    
    public void mouseMoved(MouseEvent e) { //for popups, if find short show long
	//P1 popup title if short usually works but inefficient and not guaranteed to always find the right label (if similar)
	search : for (int i=64; i>0; i/=2) {
	    try {
		String s=jep.getText(jep.viewToModel(e.getPoint()), i);
		for (qt q : qq.map.values()) if (q.checkcomplexity() &&  labman.getShort(q.name).contains(s) ) { jep.setToolTipText( labman.getTitle(q.name)); break search; }
	    } catch (BadLocationException ex) {}
	}
    }
    public void mouseDragged(MouseEvent e) {}
    
} //legend




/*
   HashMap<qt,JLabel> leglab=new HashMap();
    qtset qq;
    Box box=Box.createVerticalBox();
 
    legend(qtset qq) {
	this.qq=qq;
	setViewportView(box);
	box.setBackground(Color.white);
	makelabs();
    }
 
 
    public void makelabs() {
	for (qt q : qq.map.values()) if (q.checkcomplexity()) {
	    if (!leglab.containsKey(q)) {
		JLabel l=new JLabel( breaklines(labman.getShort(q.name)));
		if (baseplot.bigfont) l.setFont(colfont.vbigbold);
		leglab.put(q, l);
		l.setForeground(q.color);
		box.add(l);
		l.setToolTipText(labman.getTitle(q.name));
	    }
	}
	for (Iterator<qt> it=leglab.keySet().iterator(); it.hasNext(); ) {
	    qt q=it.next();
	    if (!(qq.map.values().contains(q) && q.checkcomplexity() )) {
		box.remove(leglab.get(q)); it.remove();
	    }
	}
	revalidate(); repaint();
    }
 
    public String breaklines(String s) {
	if (s.length()>20) {
	    cs cs=new cs("<html>"+s); int i=20;
	    while ((i=cs.nextspace(i))<cs.s.length()) {cs.s.insert(i,"<br>"); i+=24; }
	    return cs.s.toString();
	}
	return s;
    }
 
    // public void expand() {   for (qt q : leglab.keySet()) if (q.checkcomplexity()) { leglab.get(q).setText( breaklines(labman.getTitle(q.name))); } }
    // public void contract() {  for (qt q : leglab.keySet()) if (q.checkcomplexity()) { leglab.get(q).setText( breaklines(labman.getShort(q.name))); } }
 
 */