
package jcm.gui.plot;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import jcm.core.*;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.paramValueChooser;

public class histoplot extends baseplot {
    
    param year;
    java.util.List regs=new ArrayList();
    
     public histoplot(qtset qq) { this (new Object[]{qq}); }
    public histoplot(Object[] args) {
	for (Object o : args) {
	    if (o instanceof qtset) qq=(qtset)o; 
	    try { scalesetup.add(Float.parseFloat(o.toString())); } catch (NumberFormatException e) {}
	}
	canaddextra=true;
	double minsy=Math.max(qq.qqa.sy, qq.qqb.sy), maxey=Math.min(qq.qqa.ey, qq.qqb.ey);
	year =new param("year", 2002, minsy, maxey, "year");
	register.addlink(this, year);
	setup();
	sort();
	//ysv.setPreferredSize(new Dimension(60, 400));
	plot.add(new paramValueChooser(year), BorderLayout.NORTH);
    }
    
    //******************************
    //override baseplot
    void makeplot() {   plot=new histo();  }
    
    public void doplot() { sort(); super.repaint(); }
//    public void setSize(Dimension d) { 	super.setSize(d); scale();     }
    
    void makescales() {
	for (Object o : qq.qqb.mapwithouttotal().keySet()) regs.add(o);
	//for (Object o : qqq.get(1).map.keySet()) if (qqq.get(0).map.containsKey(o)) regs.add(o);
	float sum=0, max=0;
	for (Object o : regs) {sum+=qq.qqb.reg(o).get((int)year.val); float f=calcratiotot(o);   if (f>max) max=f; }
	yscale=new param(param.Type.Yscale,  "Yscale", qq.qqa.units+"&per&"+qq.qqb.units,  0, 0, max);
	xscale=new param(param.Type.Xscale,  "Xscale", qq.qqb.units,  0, 0, sum);
    }
    
    
    Comparator comp=new Comparator() {
	public int compare(Object a, Object b) {return calcratio(a) > calcratio(b) ? 1 : calcratio(a) < calcratio(b)  ? -1 : 0; }
    };
    
    
    
    //******************************
    //RATIO
    float calcratio(Object o) {return calcratio(o, qq.qqa); }
    float calcratio(Object o, qtset qqy) {
	float fr= qq.qqb.reg(o).get((int)year.val); if (fr<=0) return 0;
	return qqy.reg(o).get((int)year.val) / fr;
    }
    
    float calcratiotot(Object o) {
	float f=0;  for (qtset qqy: qq.qqalist()) f+=calcratio(o, qqy); return f;
    }
    
    void sort() {
	Collections.sort(regs, comp);
	//for (Object o : regs) System.err.println(o.toString()+ " "+calcratio(o,1)); //" "+calcratio(o,2)+" "+calctotratio(o));
    }
    
    
    
    //**************************
    //PLOT HISTOGRAM
    class histo extends JPanel implements  MouseMotionListener {
	public  histo() {
	    addMouseMotionListener(this);
	}
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g);
	    lookandfeel.setAntiAlias(g);
	    int w=getSize().width, h=getSize().height;
	    
	    float xx=-xscale.min()*w/xscale.range(), x, yy, y;
	    for (Object o : regs) {
		if (o instanceof infob) g.setColor(((infob)o).getColor()) ;
		x=(qq.qqb.reg(o).get((int)year.val)*w/xscale.range());
		yy=h;
		
		for (qtset qqy : qq.qqalist()) {
		    y=(int)(calcratio(o, qqy)*h / yscale.max());
		    if (y<0) {
			g.setColor(Color.white);
			g.fillRect((int)xx+1, (int)yy+1, (int)x-2,  (int)-y-1);
		    } else g.fillRect((int)xx, (int)(yy-y)-1, (int)x,  (int)y-1);
		    g.setColor(variant(g.getColor()));
		    yy-=y;
		}
		
		xx+=x;
	     /*
	    y=(int)(calcratio(o, 1)*h/max);
	    g.fillRect((int)xx, (int)(yy-y), (int)x,  (int)y);
	    yy-=y;
	    y=(int)(calcratio(o, 2)*h/max);
	    if (y<0) g.setColor(Color.white);
	    g.fillPolygon(new int[]{(int)xx, (int)(xx+x), (int)(xx+x/2) }, new int[] {(int) yy, (int)yy, (int)(yy-y)}, 3 );
	      */
		
	    }
	    ready=true;
	} //paint
	
	
	
	//**************************
	//MOUSE
	public void mouseMoved(MouseEvent e) {
	    float xx=0, x;
	    findreg: for (Object o : regs) {
		x=(qq.qqb.reg(o).get((int)year.val)*getSize().width/xscale.max());
		if (xx+x > e.getX() && o instanceof infob) {
		    String s= "<html>"+((infob)o).hashcolor() +((infob)o).getName();
		    for (qtset qqy: qq.qqalist()) s+=" "+calcratio(o, qqy);
		    setToolTipText(s);
		    return;
		} else xx+=x;
	    }
	}
	
	public void mouseDragged(MouseEvent e) {	}
	
    } //histo class
    
}

//SortedMap<Object, Float> ratio=new TreeMap();
    /*
    class ratio implements Comparable<ratio> {
	Object o; Float f;
	ratio(Object o, Float f) {this.o=o; this.f=f;}
	public int compareTo(ratio r) { return (int)(f-r.f); }
    }
     */

