package jcm.gui.plot;

//this plot shows how the relationship beteen two qtsets changes (one is X, other is Y, time is not shown)

import jcm.core.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.paramValueChooser;
import static jcm.core.report.*;

public class XYplot extends baseplot {
    
    param sy, ey;
    
     public XYplot(qtset qq) { this (new Object[]{qq}); }
    public XYplot(Object[] args) {
	for (Object o : args) {
	    if (o instanceof qtset) qq=(qtset)o; 
	    try { scalesetup.add(Float.parseFloat(o.toString())); } catch (NumberFormatException e) {}
	}
	canaddextra=true;
	double minsy=Math.max(qq.qqa.sy, qq.qqb.sy), maxey=Math.min(qq.qqa.ey, qq.qqb.ey);
	sy =new param("from", 2002, minsy, maxey, "year") {  public void precalc() {ey.min=val-1; } };
	ey =new param("until", 2002, minsy, maxey, "year");
	register.addlink(this, sy); register.addlink(this, ey);
	setup();
	xsv.setMinimumSize(new Dimension(0,40));
	plot.add(new paramValueChooser(sy), BorderLayout.NORTH);
	plot.add(new paramValueChooser(ey), BorderLayout.NORTH);
    }
    
    public void doplot() { super.repaint(); }
    
    void makeplot() { plot =new scatter(); };
    
    void makescales() {
	yscale=qq.qqa.getyscale();
	xscale= qq.qqb.getyscale(); xscale.type=param.Type.Xscale;
    }
    
    
    
    //**********************************
    class scatter extends JPanel{
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g); //paint background
	    lookandfeel.setAntiAlias(g);
	    Graphics2D g2 = (Graphics2D) g.create();
	    AffineTransform oldat = g2.getTransform(); //copy it, because the valuechooser still needs the orginal
	    
	    float xsf=getWidth()/xscale.range(), ysf=-getHeight()/yscale.range(), xyf=xsf/ysf;
	    g2.scale( ysf, ysf);   //Have to scale same for x and y, otherwise relation pixel:real is not same for x and y,  therefore get distorted line shape
	    g2.translate(-xscale.min()*xyf, -yscale.max());
	    g2.setStroke(new BasicStroke(Math.abs(yscale.range())/250));
	    
	    for (qtset qqy: qq.qqalist()) plot( g2, qq.qqb, qqy, xyf, ysf);
	    
	    g2.setTransform(oldat); g2.dispose();
	    ready=true;
	}
	
	
    } //paint
    
    void plot(Graphics2D g2, qtset qqx, qtset qqy, float xyf, float ysf) {
	GeneralPath line = new GeneralPath();
	for (Object o : qqy.map.keySet()) if (qqx.map.containsKey(o)) {
	    g2.setColor(qqy.map.get(o).color );
	    
	    if ((int)sy.getval()<(int)ey.getval()) { //if years not same, draw line
		line.reset();
		line.moveTo(qqx.get(o,(int)sy.val)*xyf, qqy.get(o,  (int)sy.val) );
		for (int year=(int)sy.val+1; year<=(int)ey.val; year++) {
		    line.lineTo(qqx.get(o,year)*xyf, qqy.get(o,  year) );
		}
		try {
		    g2.draw(line);
		} catch (Error e) { deb(e, "line drawing error"); }
	    } //line
	    else { //circle
//		    g.setColor(qq.map.get(o).color );
//		    int rad=12;
//		    g.drawOval((int)(getWidth()*(qq2.get(o,(int)sy.val) -xscale.min()) / xscale.range()) -rad-1, (int)(getHeight()*(-qq.get(o,(int)sy.val) +yscale.max()) / yscale.range())-rad-1, rad+2, rad+2);
//		    g.drawOval((int)(getWidth()*(qq2.get(o,(int)sy.val) -xscale.min()) / xscale.range()) -rad, (int)(getHeight()*(-qq.get(o,(int)sy.val) +yscale.max()) / yscale.range())-rad, rad, rad);
		//below is graphics 2D version but it's ovals are terrible - aha not so bad if antialiased
		float rad=-12f/ysf; //f/ysf;
		g2.draw(new Ellipse2D.Float(qqx.get(o,(int)sy.val)*xyf - rad, qqy.get(o,  (int)sy.val) -rad, rad, rad ));
	    }
	} //qq
	
    } //scatter inner class
    
} //class