

package jcm.gui.nav;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.*;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.*;
import javax.swing.tree.*;
import jcm.core.*;
import jcm.core.itf.plotlink;
import jcm.gui.gen.*;
import jcm.gui.doc.*;
import static jcm.core.filter.filtertype;
import static jcm.core.filter.filtertype.*;
import jcm.core.filter.filtertype;
import static  jcm.core.report.*;


public class jcmTree extends JPanel implements TreeExpansionListener, plotlink {
    
    //************** FIELDS *************
    
    JTree tree;
    jcmTreeModel tm;
    final jcmTree treemaker=this;
    boolean insetup=false, firstsetup=true;
    
    Map<param, TreePath> visparams = new HashMap();
    infob io=null, oldio=null; //keeps track of current  iob clicked
    Rectangle tprect, oldtprect;
    jcmMenu pop=new jcmMenu();
    
    public static interacob restruclink=new interacob("tree struc link");
    static { register.setAlwaysOutput(restruclink); }
    
    param level=complexity.defaultcomplexity; //complexity.getcomplexityparam(); - for this would need to change a lot of infob methods - only when complexity is within filters
    Set<filtertype> filters=new HashSet( Arrays.asList(NeededParams, Curves, Maps) );
    
    //************* CONSTRUCTOR *******************
    
    public jcmTree(Object [] args) { 	setup(args);    }
    public jcmTree(Object  arg) { 	setup(new Object[]{arg});    }
    public jcmTree() { setup(new Object[0]); }
    
    public void setup(Object[] args) {
	makeNewModel(args);
	makeNewTree();
	addClickEffect();
	addRestrucLinks();
	setupPanel();
	expandPaths(args);
    }
    
    
    //************ NEW TREE MODEL ************
    //note dependence of initial root on filters
    //P2 eventually should include filters in tree args (to preserve setup)
    //P2 would be better to update paths when root changes, so they reopen
    //P2- avoid duplication between static and worlds re source..., would be better to blend them?
    
    public void makeNewModel(Object ...args) {
	
	//may receive args  either from setup or from dragging from another tree
	if (args.length>0 && args[0]!=null) {
	    infob initroot=null;
	    if (args[0] instanceof infob) initroot=(infob)args[0];
	    else {
		String s=args[0].toString().substring(1, args[0].toString().length()-1); //remove [] brackets
		initroot=world.worldsob.find(s); //try to find a world first, before finding the root struc ob for source code etc
		if (initroot==null) initroot= root.rootob.find(s);
		if (initroot==null) initroot=root.rootob;
	    }
	    tm=new  jcmTreeModel(initroot);
	    deb("init root of tree: "+initroot+" ("+initroot.getClass()+") "+initroot.getFullName() + " enabledobs "+ initroot.getEnabledObs(filters));
	}
	
	// otherwise it's either default setup or a filter-change
	else {
	    if (tm!=null && tm.root!=null && ((tm.root instanceof packageob && !(tm.root instanceof world)) || tm.root instanceof module)) tm=new  jcmTreeModel(tm.root); // in this case no change - but changing the model may help force refresh
	    else {
		tm=new  jcmTreeModel(root.rootob);
		//remove unnecessary single steps  (eg jcmroot - worlds - world1), depending on the chosen filters
		while (tm.getChildCount(tm.root)==1 && !tm.root.hasEnabledActions(filters)) tm.root=(infob)tm.getChild(tm.root, 0); //remove unnecessary steps in root
	    }
	}
    }
    
    public void makeNewTree() {
	tree=new JTree(tm);
	tree.setShowsRootHandles(true);
	jcmTreeCellRenderer  tcr=new jcmTreeCellRenderer();
	tree.setCellRenderer(tcr);
	tree.setCellEditor(tcr);
	tree.setRowHeight(0); //control to Renderer
	tcr.addCellEditorListener(new CellEditorListener() {
	    public void editingStopped(ChangeEvent e) { deb("edit stopped"); }
	    public void editingCanceled(ChangeEvent e) {  }
	});
	tree.setScrollsOnExpand(true);
	tree.setEditable(true);
	tree.setExpandsSelectedPaths(true);
	tree.setLargeModel(true);
	tree.addTreeExpansionListener(this);
	tree.addMouseListener(showpan.moulist);
	tree.addMouseMotionListener(showpan.moulist);
    }
    
    void addClickEffect() {
	tree.addMouseMotionListener(mma);
	tree.addMouseListener(ma);
	//pop.addMouseListener(ma);
    }
    
    void addRestrucLinks() {
	register.addlink(restruc, level);
	register.addlink(restruc, labman.language);
	register.addlink(restruc, restruclink);
//	register.addlink(restruc, filter);
//	register.addlink(restruc, param.filterenabled);
    }
    
    void setupPanel() {
	
	setPreferredSize(new Dimension(300,500));
	setName(tm.root.getName());
	
	setLayout(new BorderLayout());
	
	JScrollPane jsp=new JScrollPane();
	JToolBar ftb=filter.getToolBar(filters, restruc, level);
	
	jcmMenu tmenu=new jcmMenu("Tree", ftb);
	//tmenu.add(complexity.defaultcomplexity.getMenuItem());
	//tmenu.add(param.filterenabled.getMenuItem());
	//tmenu.add(docview.helpmode.getMenuItem());
	tmenu.add(imagesaver.copyaction(tree));
	tmenu.add(imagesaver.saveimagemenu(tree, "JCMtree"));
	tmenu.add(showpan.pan("About&treeMaker", docview.class, "treeMaker"));
	
	ftb.setMinimumSize(new Dimension(0,20));
	add(ftb, BorderLayout.NORTH);
	
	jsp.setViewportView(tree);
	add(jsp, BorderLayout.CENTER);
	//tree.setOpaque(false);
	//setBackground(getBackground().brighter());
	setOpaque(false);
	//tree.setBackground(getBackground().brighter());
	
    }
    
    
    
    //********** PAINT / COLLAPSE / EXPAND *************
    public void paintComponent(Graphics g) {
	lookandfeel.setAntiAlias(g);
	super.paintComponent(g);
	if (filters.contains(filtertype.NeededParams)) restruclink.changed=true;
//	if (param.filterenabled.istrue()) param.filterenabled.changed=true;
    }
    
    public Graphics getGraphics() {
	Graphics g=super.getGraphics();
	if (g!=null) lookandfeel.setAntiAlias(g);
	return g;
    }
    
    public void treeCollapsed(TreeExpansionEvent event) {
	for (param p : visparams.keySet())   if (!tree.isVisible(visparams.get(p))  || !tree.isExpanded(visparams.get(p) )   ) {
	    register.removelink(replot, p);
	}
	if (!insetup) savesetup();
	//if (!insetup)  deb("called from treeCollapsed "+event.getPath());
    }
    
    public void treeExpanded(final TreeExpansionEvent event) {
	addlinkpath(event.getPath());
	Enumeration<TreePath> e=tree.getExpandedDescendants(event.getPath()) ;
	while (e!=null && e.hasMoreElements()) addlinkpath(e.nextElement());
	if (!insetup) loop.golater("Tree Expanded");
	if (!insetup) savesetup();
    }
    
    //************ RESTRUC PLOTLINK ***********************
	/*
	 RESTRUC
       Changing complexity and additional worlds imply mutable tree structure
	    From complexity or worlds we know when structure changes,    problem is to force a redrawing, only easy way is to make an enitrely new tree, and reopen paths
	 
	 Restruc plotlink called when tree path structure must change, due to  complexity, language or world structure changed.
	 If checking whether params are needed, must also restructure after any change in interactions (i.e. any loop.go())
	 This is achieved by setting permalink.changed=true in the painting loop, also setting needed=false in doplot, so that loop doesn't clear the changed.
	 Should also restruc when derivative qtsets are added or removed (must affect tree from which change is made, but maybe not other trees)
	 
	 Beware restructuring  is slow!
	 Since dragging a value parameter since doesn't change structure, param set() sets changeinteractions=false, in order to skip this
	 */
    
    
    plotlink restruc=new plotlink() {
	public void doplot()  {
	    try {
		if (filters.contains(filtertype.NeededParams)) restruclink.needed=false;
//	    if (param.filterenabled.istrue()) param.filterenabled.needed=false;
		if (loop.changeTreeStruc) {
		    //deb"Tree ReStructured "+filters);
		    TreePath[] paths=getOpenPaths();
		    for (param p : visparams.keySet())  register.removelink(replot, p);
		    insetup=true; for (TreePath tp : paths) if (tree.isVisible(tp)) tree.collapsePath(tp); insetup=false;
		    //although tm doesn't necessarily change, it seems to help force Tree restruc, to find that it's a different object
		    makeNewModel();
		    tree.setModel(tm);
		    tree.treeDidChange();
		    expandPaths(paths);
		    for (int row=0; row<tree.getRowCount(); row++)   {
			TreePath tp=tree.getPathForRow(row);   Object oe=tp.getLastPathComponent();
			if (oe instanceof qtset && ((qtset)oe).getObs()!=null) for (Object o : ((qtset)oe).getObs()) if (o instanceof qtset && ((qtset)o).justadded) { tree.expandPath(tp); ((qtset)o).justadded=false; }
		    }
		}
		
	    } catch (Exception e) { deb("EXCEPTION: Tree plotting problem"); } // e.printStackTrace(); }
	}
	
	public boolean  isShowing() { return tree.isShowing(); }
    };
    
	  /* REPLOT ON PARAM CHANGED
     doplot below is called  when a parameter inside tree changes
     Note JTree works by copying images of  components, not displaying them directly
     So to force changed display we use TreeListener to check for changes in what's visible, and call treeDidChange
    (avoid reremaking whole tree, would scroll up and you lose the focus)
	   
     Link only to currently visible params, otherwise every param would be set output, and cannot detect which param calls isShowing,
     Note links use weak-references so will be garbage-collected if unattached to visible objects!
	   
	   Note this plotlink must be a public class in order to exclude from aram check needed for plot except (i.e. its the exception, so that params will disappear)
	   */
    plotlink replot=this; //just for clarity in code
    public void doplot()  {
	try {  tree.treeDidChange(); }  catch (Exception e) { deb(e, "Tree doplot => exception "); }
    }
    
    
    
    //**************** PATHS / SETUP *****************
    
    void savesetup() {
	List al=register.getargs(this);
	al.clear(); for (Object o :  getOpenPaths()) al.add(o);
//	String s="tree save: "; for (Object a : al) s+=al.toString();  System.err.println(s);
    }
    
    TreePath[] getOpenPaths() {
	List<TreePath> openPaths=new ArrayList();
	for (int row=0; row<tree.getRowCount(); row++) if (tree.isExpanded(row)) openPaths.add(tree.getPathForRow(row));
	//Enumeration<TreePath> e=tree.getExpandedDescendants(tree.getPathForRow(0));
	//while (e.hasMoreElements()) openPaths.add(e.nextElement());
	return openPaths.toArray( new TreePath[0]);
    }
    
    /*
     in case that a filter change pushes the tree root backwards,
    we want to expand paths that have same end even if different root, and also to always open the 'worlds' object
     */
    
    void expandPaths(Object[] args) {
	for (Object o : args)	{ if (o instanceof infob) o="["+o+"]"; if (o.toString().contains("disposed")) o=null; }
	
	insetup=true;
	for (int row=0; row<tree.getRowCount(); row++) {
	    String ep=endpath(tree.getPathForRow(row));
	    if (ep.equals("Worlds]")) tree.expandRow(row);
	    else for (Object o : args) if (o!=null) try {
		if (ep.equals(endpath(o)))  { /*deb("expanding: "+ep); */ tree.expandRow(row); }
	    } catch (Exception e) { deb(e, "Exception Expanding Tree Path:  "+o.toString() ); }
	}
	insetup=false;
    }
    
    String endpath(Object o) { String s=o.toString(); int i=s.lastIndexOf(", ");  return i>0 ? s.substring(i+2) : s.length()>0 ? s.substring(1) : ""; }
    
    void addlinkpath(TreePath tp) {
	Object oe=tp.getLastPathComponent();
	if (oe instanceof infob) for (Object o : ((infob)oe).getEnabledObs(filters))   if (o instanceof param) {
	    param p=(param)o; register.addlink(replot, p); visparams.put(p, tp);
	}
    }
    
    public infob getRoot() {return tm.root; } //used by iconfinder
    
    
//note: doesn't naturally get mouse moved events while over selected items, so have to add the listener to these, and translate origin of event
    
//******************** CLICK EFFECT ******************
    
    MouseMotionAdapter mma=new  MouseMotionAdapter()  {
	public void mouseMoved(MouseEvent e) {
	    if (e.getComponent()!=tree) e.translatePoint(e.getComponent().getX(), e.getComponent().getY());
	    
	    if (insidepopup(e)) return; 	    //necessary for Mac, although not for windows!
	    if (e.isConsumed()) return; //i.e. this doesn't work for mac?
	    
	    TreePath tp=tree.getPathForLocation(e.getX(), e.getY() );
	    if (tp==null) tp=tree.getPathForLocation(e.getX()-100, e.getY() );
	    if (tp!=null) {
		tprect=tree.getPathBounds(tp);
		//tprect.x-=1; tprect.y-=1; tprect.height+=1; tprect.width+=1;
		Object o=   tp.getLastPathComponent();
		io= (o!=null && o instanceof infob) ?  (infob)o : null;
	    } else io=null;
	    
	    if (oldio!=io)   {
		//deb("tree mma moved by "+e.getComponent()+ "from  "+oldio+" to "+io);
		
		Graphics2D g=(Graphics2D) tree.getGraphics();
		if (oldtprect!=null) { g.setColor(tree.getBackground()); g.draw(oldtprect);  }
		if (io!=null && tprect!=null) { g.setColor(io.color); g.draw(tprect); }
		pop.removeAll(); pop.list.clear(); pop.getPopupMenu().setVisible(false);
		if (io!=null) { io.fillMenu(pop, filters);  } else if (e.getX()>100) {     } //used to have copy/save image and about tree
		if (pop.list.size()>0)  pop.show(tree, Math.min(tprect.x+tprect.width-8, getWidth()-24), e.getY()-16);
		oldio=io;
		oldtprect=tprect;
	    }
	}
    };
    
    MouseAdapter ma=new  MouseAdapter()  {
	public void mouseExited(MouseEvent e)  {
	    //deb("tree ma exited "+e.getComponent());
	    if (e.getComponent()!=tree) e.translatePoint(e.getComponent().getX(), e.getComponent().getY());
	    if (insidepopup(e)) return;  if (e.isConsumed()) return;
	    //below is the lne causing trouble on mac, which anyway seems inessential
	    // if (!tree.contains(e.getPoint())) { pop.removeAll(); pop.list.clear(); pop.getPopupMenu().setVisible(false);}
	}
	public void mouseReleased(MouseEvent e)  {
	    if (!pop.getPopupMenu().contains(e.getPoint())) {
		TreePath tp=tree.getPathForLocation(e.getX(), e.getY() );
		if (tp!=null && tp!=tree.getPathForRow(0)) {
		    if (io!=null && tm.isLeaf(io)) {
			if (!(io instanceof param) && io.actions !=null && io.actions.size()>0) io.doFirstEnabledAction(filters);
		    } else {
			if (tree.isExpanded(tp)) tree.collapsePath(tp); else   tree.expandPath(tp);
		    }
		}
		//if (io!=null) docview.helponclick(io.getName());
	    }
	}
    };
    
    boolean insidepopup(MouseEvent e) {
	try {
	    return
		    pop.isPopupMenuVisible()
		    && e.getX()+e.getComponent().getLocationOnScreen().x>=pop.getPopupMenu().getLocationOnScreen().x
		    && e.getY()+e.getComponent().getLocationOnScreen().y>=pop.getPopupMenu().getLocationOnScreen().y;
	} catch (Exception ex) { deb(ex, "tree inside popup => exception "); return false; }
    }
    
//******* TREE MODEL ***************************
    class jcmTreeModel implements TreeModel  {
	
	public infob root;
	
	public jcmTreeModel(infob root) { this.root=root; }
	
	public Object getChild(Object parent, int index) {   return ((infob)parent).getEnabledObs(filters).get(index); }
	
	//when change complexity level, EnabledObs can become null
	public int getChildCount(Object parent) { if (isLeaf(parent)) return 0; return ((infob)parent).getEnabledObs(filters).size(); }
	
	public int getIndexOfChild(Object parent, Object child) { return  ((infob)parent).getEnabledObs(filters).indexOf(child); }
	
	public Object getRoot(){ return root; }
	
	public boolean 	isLeaf(Object node) { return !(node instanceof infob) || ((infob)node).getEnabledObs(filters)==null; }
	
	public void	addTreeModelListener(TreeModelListener l) {}
	public void 	removeTreeModelListener(TreeModelListener l) {}
	public void 	valueForPathChanged(TreePath path, Object newValue) {}
    }
    
    
    class jcmTreeCellRenderer implements TreeCellRenderer, TreeCellEditor {
	
	public Component getTreeCellRendererComponent(JTree tree,  Object value, boolean selected,boolean expanded,boolean leaf,int row,boolean hasFocus) {
	    return getc(value, false);
	}
	public Component getTreeCellEditorComponent(JTree tree,  Object value, boolean selected,boolean expanded,boolean leaf,int row) {
	    return getc(value, true);
	}
	
	
	Component getc( Object value, boolean editor)	 {
	    JComponent c=null;
	    if (value instanceof infob)  c= ((infob)value).getComponent("tree");
	    else if (value instanceof Action) c= new JButton((Action)value); //should no longer be used, since Actions now in a separate list
	    else if (c==null) c= new JLabel( value.toString());
	    //    if (!(editor && value instanceof param)) {
	    c.addMouseMotionListener(mma); c.addMouseListener(ma);
	    c.setBorder(new EmptyBorder(1,1,1,1));
	    //try { if (editor) c.setBackground(c.getBackground().darker()); } catch (Exception e) { deb(e, " in tree model getc "); }
	    return c;
	}
	
	public void removeCellEditorListener(CellEditorListener c) {}
	public void addCellEditorListener(CellEditorListener c) {}
	public void cancelCellEditing() {}
	public boolean  stopCellEditing() { return true; }
	public Object getCellEditorValue() {return null; }
	public boolean isCellEditable(EventObject anEvent) {return true; };
	public boolean shouldSelectCell(EventObject anEvent) {return true; }
	
    }
    
    /*
	 P2 NEW STRUC FOR TREE
	 Due to complexities and frequent restruc might be simpler and even more efficient to make own tree from scratch, using absolute layout, infob components(destroyed when folded)
	    Then param infobs would be showing regardless of selection, so would still need checkenabledforplotexcept, but not special plotlinks to tree
	    Would also lose specific look&feel implementations of the hooks, but could make them bigger
	 Note also efficiency problem - too many popup menus etc. retained in memory
	    See also notes in oldenabledcode.java
     */
    
    public void setAlignmentX(float alignmentX) {
    }
    
} //end worldtree

//OK seems done P3 maybe icons for extra actions could add to tree on mouseover?, or at least change background, like menu

