//*************** TABBED PANE*********************
//a TabbedPane with closeable  tabs (used with showpan mouselistener)
//P2 font of tab should adjust with colfont, but not obvious how to do this

package jcm.gui.nav;

import java.awt.*;
import java.awt.event.*;
import java.util.LinkedList;
import javax.swing.*;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import static jcm.core.report.*;

public class jcmTabbedPane extends JTabbedPane  {
    
    java.util.List<Rectangle> rect=new LinkedList();
    JSplitPane jsp;
    
    public jcmTabbedPane() {
	super();
	setPreferredSize(new Dimension(100,200));
	addMouseListener(showpan.moulist);
	addMouseMotionListener(showpan.moulist);
	//setBackground(showpan.bg);
	//setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT); //might be nicer but kills the tab-close button
	setOpaque(false);
	setFont(colfont.bigfont);
	showpan.addpanmenu(this);
    }
    
    
    //note there are a lot of tab paint and layout errors that don't seem to matter, so we catch them here
    
    public void doLayout() {    try {   super.doLayout();     } catch (Exception ex) {  }} //deb(ex, "tab layout error" ); }     }
    public void remove(Component c) {
	super.remove(c);
	try {  c.removeNotify(); }   catch (Exception e) { deb(e, " removing tabbed pane"); }
	c=null;
    }
    
    public void paintComponent(Graphics g) {
	try {
	    lookandfeel.setAntiAlias(g);
	    super.paintComponent(g);
	    rect.clear();
	    for (int i=0; i<getTabCount(); i++) {
		Rectangle r=getUI().getTabBounds(this, i);
		int w=8, h=8, x=r.x+r.width-4-w, y=r.y+r.height/2-h/2;
		rect.add(new Rectangle(x, y, w, h));
		g.setColor(Color.red);
		g.drawRect(x,y,w,h);
		g.drawLine(x+w,y, x, y+h);
		g.drawLine(x,y,x+w,y+h);
	    }
	} catch (Exception ex) { } // System.err.println("tab paint error" +ex);  ex.printStackTrace(); }
    }
    
    int intab(MouseEvent e) {
	for (int i=0; i<getTabCount(); i++) if (getUI().getTabBounds(this, i).contains(e.getPoint() )) return i; return -1;
    }
    
    void tryclose(MouseEvent e) {
	for (int i=0; i<getTabCount(); i++) {
	    if (rect.get(i).contains(e.getPoint())) remove(i);
	}
    }
    
} // jcmTabbedPane

