/*
Extension of Menu that is easier to write, gets label and icon automatically, incorporates complexity, sets font, adds to menubar/menu  if complexity OK
 
 JMenu stores a tree of PopupMenus which store Components, uses a lot of memory and are not easily changeable
 Instead we want to make the Components on demand, only after checking enabled / complexity, and changing language and font, and incorporating changes e.g. param value changes
 
 P1 efficiency:  popups don't really need new jcmMenu object, just the set of menuFillers and the popup-listener
 Beware funny effect of accumulating menus if adding a param menuitem fails
 
 */

package jcm.gui.nav;

import java.awt.Component;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.Icon;
import javax.swing.event.*;
import jcm.core.*;
import jcm.core.itf.hasComplexity;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.gui.doc.labman;
import jcm.gui.gen.*;
import static jcm.core.report.*;

public class jcmMenu extends JMenu implements plotlink, MenuListener, PopupMenuListener, hasComplexity {
    
    public String name;
    public complexity mycomplexity=complexity.simplest;
    public complexity getComplexity() { return mycomplexity; }
    public List list=new ArrayList(8); //list of all items added to the menu
    static Map<Object,String> names=new WeakHashMap(8); //static to avoid several menus storing refs to same names
    List<menuFiller> mfs;
    boolean firsttime=true;
    public Set<filter.filtertype> filters;
    public infob treeroot;
    Icon icon;
    
    //********CONSTRUCTOR************
    //  public jcmMenu() {this(""); }
    
    public jcmMenu(Object ... args) {
	super();
	for (Object o : args) {
	    if (o instanceof infob && treeroot==null) { treeroot=((infob)o); if (name==null) name=((infob)o).name; /*System.err.println("made tree menu "+((infob)o).name); */ continue; }
	    if (o instanceof filter.filtertype) { filters=EnumSet.of((filter.filtertype)o); name=((filter.filtertype)o).toString()+"Menu";  }
	    if (o instanceof Set) filters= (Set<filter.filtertype>)o;
	    if (o instanceof String) name=(String)o;
	    if (o instanceof complexity) mycomplexity=(complexity)o;
	    if (o instanceof menuFiller) addFiller((menuFiller)o);
	    if (o instanceof Component) addPopupListener((Component)o);
	}
	if (name!=null) { //it's not a popup menu
	    setText(labman.getShort(name));
	    icon=iconFinder.findIcon(name);
	    setIcon(icon);
	    setFont(colfont.normalfont);
	    register.addlink(this, labman.language);
	    register.addlink(this, lookandfeel.fontSize);
	    register.addlink(this, complexity.defaultcomplexity);
	    addMenuListener(this);
	}
    }
    
    //************ ADD *******************
    // instead of adding items to the menu, just add them to the list now, add them to the menu only when it is selected
    //not sure what's use of returning JMenuItem, but superclass requires it
    
    public void add(Object ... oo) { for (Object o : oo) list.add(o); }
    public void add(infob i) { list.add(i); }
    public JMenuItem add(Action a) { list.add(a); return null;}
    public JMenuItem add(String s) { list.add(s); return null;}
    public JMenuItem add(JMenuItem mi) { list.add(mi); 	return null;  } //this includes another jcmMenu, or Radio for params etc.
    public JMenuItem add(Component  c) { list.add(c); return null; }
    public void addSeparator() { list.add("---");  }
    
    public void addFiller(menuFiller f ) { if (mfs==null) mfs=new ArrayList(3); mfs.add(f); }
    public  void addPopupListener(Component listener) { listener.addMouseListener(popupListener);   }
    
    // *********************** FILL *************************
    
    public void fillPopup() {
	if (treeroot!=null || mfs!=null) list.clear();
	if (treeroot!=null) treeroot.fillTreeMenu(this);
	if (mfs!=null) for (menuFiller mf : mfs) mf.fillMenu(this);
	
	for (Object o : list) { if (o!=null) try {
	    if (o.equals("---")) { super.addSeparator(); continue; }
	    if (o instanceof hasComplexity && !complexity.check(((hasComplexity)o))) continue;
	    JMenuItem mi=makeMenuItem(o);
	    if (mi!=null) { 
		mi.updateUI(); //necessary for substance when adding another Menu
		mi.setFont(colfont.normalfont);
		if (mi.getIcon()==null) mi.setIcon(iconFinder.findIcon(mi.getText()));
		if (!names.containsKey(o)) names.put(o, mi.getText()); //only put once, otherwise text contains the conversion after process by labman (but maybe already does...)
		mi.setText(labman.getShort(names.get(o))); //go back to labman each time, in case kept object, but changed language (P2 need to check this works!)
		
//	    mi.setText(o instanceof param ? labman.getTitle(mi.getText()) : labman.getShort(mi.getText()));
		super.add(mi);
	    }
	} catch(Exception e) { deb(e," for menuItem "+o); }
	}
    }
    
    public JMenuItem makeMenuItem(Object o) {
	//{ jcmMenu m=(jcmMenu)o;  if (m.firsttime) m.setUI(getUI()); m.firsttime=false; }  //necessary for Substance Look and Feel
	if (o instanceof param && (filters==null || (filters.contains(filter.filtertype.AllParams) || filters.contains(filter.filtertype.NeededParams)))) return ((param)o).getMenuItem();
	if (o instanceof infob) return new jcmMenu((infob)o, filters); //return ((infob)o).fillTreeMenu(new jcmMenu(((infob)o).name, filters));
	if (o instanceof JMenuItem) return (JMenuItem)o;
	if (o instanceof String) return new JMenuItem((String)o);
	if (o instanceof Action) { JMenuItem mi = createActionComponent((Action)o);  mi.setAction((Action)o); return mi; } //copied from JMenu implementation
	return super.add("OBJECT: "+o);
    }
    
    //************* RESPOND *****************
    //public boolean isShowing() { return true; } //otherwise hidden menus will never get a doplot call
    
    public void doplot() {
	//setVisible(System.currentTimeMillis()%2==0);
//		complexity.check(this));  //doesn't seem to work!
//	if (this.isTopLevelMenu()) {
//	    JMenuBar bar=(JMenuBar)getParent();
//	    bar.revalidate(); bar.repaint();
//	}
	if (!complexity.check(this)) {
	    setText(""); setIcon(null);
	} else {
	    setFont(colfont.normalfont);
	    setIcon(icon);
	    setText(labman.getShort(name)); //may have changed, if language changed
	}
    }
    
    public void menuSelected(MenuEvent e) { fillPopup(); }
    public void menuDeselected(MenuEvent e) { removeAll(); }
    public void menuCanceled(MenuEvent e) { removeAll(); }
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) { }
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) { removeAll(); }// System.err.println("popup will become invisible"); }
    public void popupMenuCanceled(PopupMenuEvent e) { removeAll(); } //System.err.println("popup canceled");}
    
    
    //***************** POPUP  MENU ************
    public void show(Component c, int x, int y) {
	JPopupMenu jpop=getPopupMenu();
	jpop.setInvoker(c);
	fillPopup();
	jpop.show(c, x, y);
	jpop.addPopupMenuListener(this);
    }
    
    public Component getInvoker() { return getPopupMenu().getInvoker(); }
    
    MouseListener popupListener = new  MouseAdapter()  {
	public void mousePressed(MouseEvent e) {   maybeShowPopup(e); 	}
	public void mouseReleased(MouseEvent e) {   maybeShowPopup(e); 	}
	private void maybeShowPopup(MouseEvent e) {
	    if (e.isPopupTrigger()) { show(e.getComponent(), e.getX(), e.getY());    }
	}
    };
    
    //*****************************************
    
} //end class

