package jcm.gui.doc;
import jcm.core.*;
import jcm.core.itf.plotlink;
import jcm.core.tls.cs;
import jcm.core.tls.txt;
import jcm.gui.nav.showpan;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.text.html.HTMLDocument.HTMLReader.FormAction;
import jcm.core.itf.hasSetupInfo;
import static jcm.gui.doc.label.*;
import jcm.gui.doc.label.langcode;
import jcm.gui.doc.label.smd;
import jcm.core.jcmAction;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.core.itf.menuFiller;
import static  jcm.core.report.*;


public class docview extends JPanel implements DocumentListener, plotlink, menuFiller, hasSetupInfo {
    
    public String page="mainmenu";
    public static docview current; //so "help mode" will find most recently opened docview
    
    public param<langcode> language=new param("languagemenu", label.langcode.values(), labman.language.chosen);
    // public static param helpmode=new param("helpmode", false); //affects treemaker and interacmap
    
    JSplitPane jsp=new JSplitPane();
    JTextField search=new JTextField(),  key=new JTextField(), tfs=new JTextField(), tfm=new JTextField(), tfc=new JTextField(), tfi=new JTextField();
    JLabel jlc= new JLabel(" cat "), jli=new JLabel(" info "), jls= new JLabel(" sho "), jlm= new JLabel(" med "), jld=new JLabel(" chg ");
    JLabel changeddate=new JLabel("");
    JTextArea tal=new JTextArea(), tal2=new JTextArea();
    //JEditorPane tal=new JEditorPane(), tal2=new JEditorPane();
    JCMEditorPane ep=new JCMEditorPane();
    JPanel edit=new JPanel(new GridBagLayout());
    Stack<String> history=new Stack();
    label curlab;
    label.langcode lang;
    
    
    boolean changepage=true, showedit=false, showhtml=false;
    
    
    //********* CONSTRUCT ***************
    public docview() { this("welcome"); }
    public docview(Object o) { this(o.toString()); }
    //note: showpan doesn't find constructors unless exactly same type (not subtype)
    
    public docview(String startpage) {
	page=page.trim().replace(" ", "_"); //do not allow spaces in keys - convert to underline
	setLayout(new BorderLayout());
	jsp.setName("JCM5 Documentation");
	jsp.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
	jsp.setPreferredSize(new Dimension(400,600));
	add(jsp, BorderLayout.CENTER);
	setPreferredSize(new Dimension(400,600));
	
	tfs.getDocument().addDocumentListener(this); tfm.getDocument().addDocumentListener(this);
	tfc.getDocument().addDocumentListener(this); tfi.getDocument().addDocumentListener(this);
	tfc.setPreferredSize(new Dimension(50,16));
	
	tal.getDocument().addDocumentListener(this);
	tal.setFont(jcm.gui.gen.colfont.normalfont); tal2.setFont(jcm.gui.gen.colfont.normalfont);
	tal2.setEditable(false); tal2.setForeground(jcm.gui.gen.colfont.brown);
	tal2.setWrapStyleWord(true); tal.setWrapStyleWord(true);
	tal.setLineWrap(true);  tal2.setLineWrap(true);
	//tal.setContentType("text/html;");
	
	JSplitPane editsp=new JSplitPane(JSplitPane.VERTICAL_SPLIT, new JScrollPane(tal), new JScrollPane(tal2) );
	editsp.setResizeWeight(0.7);
	
	GridBagConstraints c = new GridBagConstraints();
	c.gridy=0;   c.fill=c.HORIZONTAL;
	c.gridx=0;  edit.add(jlc, c); c.gridx=1; edit.add(tfc, c);  c.gridx=2; edit.add(jli, c); c.gridx=3; edit.add(tfi,c);
	c.gridy=1;  c.gridx=0;  edit.add(jls, c); c.gridx=1; c.gridwidth=c.REMAINDER; edit.add(tfs, c);
	c.gridy=2; c.gridx=0;  edit.add(jlm, c);  c.gridx=1; edit.add(tfm, c);
	c.gridy=3; c.gridx=0;   edit.add(jld, c); c.gridx=1; edit.add(changeddate, c);
	c.gridy=4; c.weightx=1; c.weighty=1;  c.fill=c.BOTH;
	c.gridx=0; edit.add(editsp, c);
	
	JPanel docpan=new JPanel(new BorderLayout());
	JCMEditorPane top=new JCMEditorPane();
	top.setText(autodoc.maketopmenu());
	docpan.add(top, BorderLayout.NORTH);
	docpan.add(new JScrollPane(ep), BorderLayout.CENTER);
	
	jsp.setLeftComponent(docpan);
	jsp.setRightComponent(edit);
	jsp.setResizeWeight(1);
//    public void setSize(Dimension d) { super.setSize(d); setDividerLocation(-1); }
	
	current=this;
	page=startpage;
	setpage(page);
	register.addlink(this, complexity.defaultcomplexity);
	language.register(); //check, will this mean it never disposes resource?
	register.addlink(this, language);
	new jcmMenu(tal, this); new jcmMenu(tal2, this);
	makemenus();
    }
    
    public void removeNotify() { if (current==this) current=null;    }
    
    
    
    //************** HELPMODE *********
    
    
//    public static void helponclick(final String name) {
//	if (helpmode.istrue()) {
//	    if (current==null) {
//		SwingUtilities.invokeLater(new Runnable(){  public void run()  {  showpan.makepan(docview.class, name);  } } );
//	    } else { current.setpage(name); showpan.toFront(current); }
//	}
//    }
    
    //************* MENUS*************
    void makemenus() {
	final JMenuBar mb =new JMenuBar();
	mb.add(language.getMenuItem());
	mb.add(complexity.defaultcomplexity.getMenuItem());
	
	jcmMenu editmenu=new jcmMenu("Edit Doc");
	editmenu.add(new JCheckBoxMenuItem(new jcmAction("Edit Doc Source") { public void act() {
	    showedit=!showedit; if (showedit) { edit.setVisible(true); jsp.setDividerLocation(0.6); setpage(page); } else edit.setVisible(false); /* else setDividerLocation(-1); */
	}}));
	editmenu.add(new JCheckBoxMenuItem(new jcmAction("Show HTML") { public void act() {
	    showhtml=!showhtml; ep.setContentType("text/"+(showhtml ? "plain;" : "html;")); ep.setup(); showpage();
	}}));
	editmenu.addSeparator();
	editmenu.add(labman.loadchangesaction);
	editmenu.add(labman.savechangesaction);
	editmenu.add(labman.savecopyaction);
	editmenu.addSeparator();
	editmenu.add(showpan.pan(labdoctable.class));
	editmenu.add(showpan.pan("New Doc Window", docview.class, page));
	editmenu.add(showpan.pan("Help about Edit-Doc", docview.class, "EditDoc"));
	
/*
 P3 removed change key until checked its working
	editmenu.add(new jcmAction("Change Key") { public void act() {
	    String newkey=JOptionPane.showInputDialog(ep, "New name for this label/doc item?", curlab.key).trim().replace(" ", "_");
	    label blank=new label(curlab.key, curlab.cat); blank.set(langcode.en, smd.i, "old key!");  blank.setchanged(); labman.addLabel(curlab.key, blank);
	    curlab.key=newkey; curlab.setchanged(); labman.addLabel(newkey, curlab);
	    setpage(newkey);
	}});
 */
	
	mb.add(editmenu);
	key.setPreferredSize(new Dimension(120,16));
	
	mb.add(new JLabel("key"));  	mb.add(key);
	key.addActionListener(new jcmAction("Goto Item") { public void act() {   setpage(key.getText()); }});
	//JOptionPane.showInputDialog(ep, "Go to / make label/doc with code:", curlab.key)
	mb.add(new JLabel("search"));  	mb.add(search);
	search.addActionListener(new jcmAction("Search") { public void act() {   labman.search(search.getText(), false, false); setpage("docsearch"); }});
	//JOptionPane.showInputDialog(ep, "Go to / make label/doc with code:", curlab.key)
	
	
	SwingUtilities.invokeLater(new Runnable() { public void run() {   edit.setVisible(false);  add(mb, BorderLayout.NORTH);  }});
    }
    
    
    //********** JCMEditorPane ******************
    public class JCMEditorPane extends JEditorPane implements HyperlinkListener, MouseListener  {
	public JCMEditorPane() {
	    setContentType("text/html;");
	    setup();
	    //beware below might make it slower!
	    fixkit();
	}
	
	void fixkit() { //suggestion from http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6222200
	    EditorKit kit = getEditorKit();
	    if (kit instanceof HTMLEditorKit) {
		((HTMLEditorKit)kit).setAutoFormSubmission(false);
	    }
	}
	
	public void paintComponent(Graphics g) {  lookandfeel.setAntiAlias(g);   super.paintComponent(g); }
	
	void setup() {
	    setEditable(false);
	    addHyperlinkListener(this);
	    addMouseListener(this);
	    
	    try{
		((HTMLDocument) getDocument()).setBase(register.class.getResource("/png/"));
	    } catch (Exception e) {	deb(e); }
	}
	
	public void mouseExited(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {
//	    Element elem = ((HTMLDocument) getDocument()).getCharacterElement(viewToModel(e.getPoint()) ); //getParagraphElement
//	   System.out.println(elem);
	}
	
	
	//  HTMLDocument.Iterator i=((HTMLDocument) getDocument()).getIterator(new HTML.Tag("Ben"));
	
	//********** LINK  / ACTION *********************
	public void hyperlinkUpdate(HyperlinkEvent e) {
	    
	    if (e.getEventType()==HyperlinkEvent.EventType.ACTIVATED) log("linkto: "+e.getDescription());
	    if (e.getEventType()==HyperlinkEvent.EventType.ACTIVATED) {
		String s=e.getDescription();
		if (e instanceof FormSubmitEvent) {
		    s=((FormSubmitEvent)e).getData();
		    deb("HTML Form data: "+((FormSubmitEvent)e).getData());
		    s=s.replace("=", "!");
		} 
		if (s.startsWith("#")) {  ep.scrollToReference(e.getDescription().substring(1)); return; }
		if (s.indexOf("!")>0) {
		    String[] ss= txt.split(s, "!");
		    if (ss[0].equals("source")) showpan.makepan(sourceview.class, "source/"+ss[1].replace(".", "/")+".java");
		    if (ss[0].equals("setup")) setup.loadpacksetup(ss[1].replace(".", "/"));
		    return;
		} else setpage(s);
		
	    }
	}
    }
    
//****** EDIT ********************************
    
    
    public void changedUpdate(DocumentEvent e) {  updatedoc(e);  }
    public void removeUpdate(DocumentEvent e) {  updatedoc(e); }
    public void insertUpdate(DocumentEvent e) {  updatedoc(e); }
    
    public void updatedoc(DocumentEvent e) {
	if (curlab!=null && !changepage) {
	    if (curlab.cat=="new")  labman.addLabel(page, curlab);
	    Document doc=e.getDocument();
	    if (e.getDocument()==tal.getDocument() ) curlab.set(lang, smd.d, nullifempty(tal.getText()));
	    else if (doc== tfm.getDocument()) curlab.set(lang, smd.m, nullifempty(tfm.getText()));
	    else if (doc== tfs.getDocument()) curlab.set(lang, smd.s, nullifempty(tfs.getText()));
	    else if (doc== tfi.getDocument()) curlab.set(lang, smd.i, nullifempty(tfi.getText()));
	    else if (doc== tfc.getDocument()) { curlab.cat=tfc.getText(); curlab.setchanged(); labman.category.add(tfc.getText());} //beware adds new cat for every character edited!
	    showpage();
	}
    }
    
    String nullifempty(String s) { return s.equals("") ? null : s; }
    
//****** SET / SHOW PAGE********************************
    public void setpage(String newpage) {
	newpage=newpage.trim().replace(" ", "_"); //spaces not allowed in keys
	if (newpage.equals("back")) { if (!history.isEmpty()) page=history.pop(); } else { history.push(page);  page=newpage; autodoc.visited.add(newpage); String ss=""; for (String s : history) ss+=s+" ";  }
	
//if (history.isEmpty() ||  !p.equals(history.peek()))
	deb("show doc page "+page);
	
	curlab=labman.getLabel(page);
	
	if (curlab==null) curlab=new label(page, "new" );     //note, we don't register in labman.ldm unless it's edited
	
	changepage=true;
	labman.currentlangchooser=language;
	
	tfs.setText(curlab.getorig(language.chosen, smd.s)); 	//tfs.setText(labman.getshort(page));
	tfm.setText(curlab.getorig(language.chosen, smd.m)); 	//tfm.setText(labman.getlabel(page));
	tfi.setText(curlab.getorig(language.chosen, smd.i));
	tfc.setText(curlab.cat);
	
	tal.setText(curlab.getorig(language.chosen, smd.d)); //tal.setText(labman.ldm.getdoc(page));
	infob i= autodoc.findob(page); tal2.setText((i==null) ? "" :  i.getExtraDoc());
	
	key.setText(page);
	changepage=false;
	
	setName(page);
	
	showpage();
    }
    
    
    public void  savesetup() {
	java.util.List al=register.getargs(this);
	al.clear(); al.add(page);
//if (al.size()==0) al.add(page); else al.set(0,page); //problem is that showpan adds the arg after making component => get welcome x2
    }
    
//called when the param changes
    public void doplot() { setpage(page); }
    
    public void showpage() {
	lang=(label.langcode)language.chosen;
	long changed=0; for (smd t : smd.values()) changed=Math.max(changed, curlab.getchanged(lang, t));
	changeddate.setText(changed==0 ? "" : new Date(changed).toGMTString());
	
	labman.currentlangchooser=language;
//	String font=append("<font size="+(int)(lookandfeel.fontSize.getval()/4f)+" >");
//	ep.setText(font+autodoc.makedoc(page)+"</font>");
	ep.setText(autodoc.makedoc(page));
	labman.currentlangchooser=labman.language;
	
	final Rectangle r= changepage ? new Rectangle(1,1,1,1) : new Rectangle(ep.getVisibleRect()) ; r.x=0; r.width=ep.getWidth()-10;
	SwingUtilities.invokeLater(new Runnable() { public void run() {      ep.scrollRectToVisible(r);  }});
    }
    
    public void fillMenu(jcmMenu popup) {
	String text=((JTextArea)popup.getInvoker()).getText();
	popup.add("goto subcomponent: ");
	cs s=new cs(text);
	int i=0, j; while ((i=s.s.indexOf("", i)+2)>1) {
	    j= s.nextspace(i);
	    final String link=s.s.substring(i,j);
	    popup.add(new jcmAction(link) { public void act() {   setpage(link); }});
	    i=j;
	}
    }
    
} //end class
