/*WORLD
manages parallel worlds structure
creates and initialises modules of each new world
 */

package jcm.core;

import java.awt.Color;
import java.util.*;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.showpan;
import jcm.gui.nav.jcmTree;
import static jcm.gui.gen.colfont.*;
import static jcm.core.report.*;

public class world extends packageob  {
    
    public static List<world> worlds=new LinkedList(); //used by loop to run mods, and by plot to find divideby options
    public static packageob worldsob=new packageob("Worlds"); // infob at base of tree, contains all worlds
//note packageob adds the Doc and Tree actions and sets complexity simplest, also adds extradoc
    static {
	worldsob.addAction( filter.filtertype.Worlds, addWorld());
	root.rootob.addOb(worldsob);
    }
    
    static Icon wi=iconFinder.findIcon("world");
    public static String defname="World 1";
    
    //********** WORLD FIELDS *******************
    
    public List<module> mods=new LinkedList(); //for loop calculation order
    Map<Class, module> modmap=new LinkedHashMap();  // for modules to  lookup other modules (see get methods)
    //(note mods and modmap separate because use Collections.sort)
    
    //********** CONSTRUCT WORLD ***************
    
    public world(String s) { 	this(s,  (s.equals(defname)) ? Color.black : rcol()); }
    
    public world(String s, Color col) {
	name=s;
	color=col;
	mycomplexity=complexity.simplest;
	worlds.add(this);
	worldsob.addOb(this);
	//root.addOb(this);
	addAction(filter.filtertype.Worlds, new jcmAction("RemoveWorld") {     public void act() { disposeWorld(true);   }  });
	addAction(filter.filtertype.Worlds,new jcmAction("ReNameWorld") {    public void act() { name=JOptionPane.showInputDialog(null, "Enter new name for "+name);  update(); } });
	addAction(filter.filtertype.Worlds,new jcmAction("SetColorOfWorld")  {    public void act() { color=new JColorChooser().showDialog(showpan.mf,  "Choose Colour for "+name, color);  update();  } });
	//note a very different style of chooser is shown if you use Substance
	addAction(filter.filtertype.Doc); //in packageob - but we are overriding that construcutor
	addAction(filter.filtertype.Tree);
	
	makemods(); //setup modules
    }
    
    // *********** called from  SETUP *********
    static boolean spareworld=false;
    
    static void update() { //refresh trees and menus
	jcmTree.restruclink.changed=true; loop.golater("World Update");
    }
    
    public static void makeworld(String name, Color color) { //called from setup
	if (spareworld)  { world w=world.worlds.get(0);  w.name=name; w.color=color; spareworld=false; }  // reuse the first world
	else new world(name, color);
    }
    
    public static void disposeAllButOne() { //called at beginning of setup
	while (worlds.size()>1) {
	    try { worlds.get(1).disposeWorld(false); } catch (Exception ex) { deb(ex, "setup remove old worlds error "); }
	}
	if (worlds.size()>0) spareworld=true;
    }
    
    
    //***************** ADD WORLD ************
    
    public static jcmAction addWorld() {
	return new jcmAction("AddWorld") {          public void act() {
	    String name=JOptionPane.showInputDialog(null, "Enter name for new world ");
	    new world(name);
	    //showpan.makepan(jcmTree.class, "["+name+"]", wi);
	    update();
	}  };
    }
    //************************ DISPOSE WORLD *******************
    
    public void disposeWorld(boolean newthread) {
	deb("Disposing world: "+name);
	worldsob.obs.remove(this);
	worlds.remove(this);
	if (newthread) disposeLater(); //used when called from menu/tree action - includes update
	else { disposethis(); jcmTree.restruclink.changed=true; loop.gonow(); } //used by setup - note setup has own thread, NOT event dispatch thread
	//note: gonow() is important, if golater() as in update, setup crashes when called from menu with >1 world
    }
    //root.obs.remove(this);
    
    //***************** GET *****************
    //get module or world
    
    public world get(String name) { 	for (world w : worlds) if (w.name.equals(name)) return w; return null;   }
    
    public <T extends module> T  get(Class<T> c) { return  (T) modmap.get(c);    }
    
    //***************** SETUP MODULES  ************
    //called from world constructor
    void makemods() {
	obs=(worldtree(root.rootob.find("jcm.mod")) ).obs; //constructs the world
	
	jcm.core.data.loaddata.getdata(this); //aim to remove this eventually
	log("Setting up modules");
	for (module mod : mods)	{
	    log("-"+mod);
	    try {
		mod.initsetup(); mod.register();
	    } catch (Exception e) { deb(e, "Error in Initsetup of  "+mod.getName()); }
	}
	
    }
    
    //************** WORLD TREE ***********
    //worldtree copies root, but referring to specific module instances, creating as necessary
    
    public infob worldtree(infob orig) {
	
	if (orig.getObs()!=null) { //implies orig was a directory (package)
	    
	    infob copy=new packageob(orig.getName(), orig.color, orig.priority);
	    
	    for (infob o : orig.getObs())  {
		infob hh=worldtree(o); //recursive
		if (hh!=null && (hh instanceof module || ( hh.getObs()!=null && hh.getObs().size()>0)))  copy.addOb(hh);
		if (hh instanceof module) hh.color=copy.color;
	    }
	    return copy;
	}
	return module.createMod(orig, this); 	//orig was not a package, so might be a module class
    }
    
    /* note re setup order:
	 putting initsetup in constructor  doesn't work because it's called before the params etc exist so they don't get their owners set
	 but in some cases we want to call register AFTER initsetup (so initsetup can make references to other worlds)
     
	 also  initsetup must be after loaddata, should not depend on mod order
	 also making  plot/table menu after initsetup allows dynamically created qtsets to be found
     */
	/*add check?
		out.message("Run Model :..."); modlist.sealevel.output=true; loop.go(); //alternatively, could just make loaddata run, do rest when see what plots visible?
		out.message("Check Sealevel 2100="+modlist.sealevel.total.a[350]);
	 */
    
    
} //end class

