/*
 All load/save operations should pass through this class, even for simple methods,
 so that  file-chooser dialogs, security-exception alerts etc. can be harmonised to work in Java WebStart, and from local Jar, etc.
 
 Most methods are static,
 however instances can also store info about generalised file, that can work from Java WebStart as well as local filesystem
 
 */


package jcm.core.tls;
import java.awt.Component;
import java.awt.image.BufferedImage;

import java.net.URL;
import java.io.*;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import javax.imageio.ImageIO;
import javax.swing.*;
import javax.jnlp.*;
import static jcm.core.report.*;

public class fileio {
    
    
    //%%%%% PUBLIC INPUT %%%%%%%%%%%
    
    //used by loadstring, pngdata, iconFinder, backImage
    public static URL getURL(String filename) {
	return fileio.class.getResource("/"+filename);
    }
    /*
	Note: getURL works for netbeans, lone jar, and java-webstart
	ClassLoader.getSystemResource(filename) works for lone jar but maybe not on web?
	xx.class.getResource("../../"+filename) works within netbeans but not lone jar
     */
    
    //*********************************
    //used by world tree and for defaultsetup
    public static Enumeration<JarEntry>  getJarEntries(URL u) {
	try {
	    JarURLConnection j =(JarURLConnection)u.openConnection();
	    return j.getJarFile().entries();
	} catch (Exception e) { log(e, "Can't find Jar of : " +u);  return null; }
    }
    
    
    
    //********* STREAMS of binary data ************************
    //used internally
    
    static InputStream getStream(final String filename) {
	return fileio.class.getResourceAsStream("/"+filename);
    }
    static InputStream getStream(final File file) {
	try { return new FileInputStream(file); } catch (IOException e) { deb(e); return null; }
    }
    
    static BufferedInputStream getBuffStream(final String filename) {
	return new BufferedInputStream(getStream(filename));
    }
    
    
    static LineNumberReader getLNR(String filename) {
	return new LineNumberReader(new BufferedReader(new InputStreamReader(getStream(filename))));
    }
    
    //used by mapdata, loaddata
    public static DataInputStream getDIS(String filename) {
	return new DataInputStream(getBuffStream(filename));
    }
    
    static InputStream getStreamFromDialog(String subfolder, String name, String title) {
	try {
	    try {
		File f=getFileFromDialog(subfolder, name, title,  "load");
		return new FileInputStream(f);
	    } catch (SecurityException e) {
		FileContents fc=jwsfos().openFileDialog(null, null);
		return fc.getInputStream();
	    }
	} catch (Exception e) { msg(e, "Problem Opening File"); return null; }
    }
    
    
//********** LOAD table *************************
//gets data from within JAR
//used by iconfinder, setup, matdata, griddata, histdata, LUCdata, regman, backImage
    public  static String[][] loadtab(String filename, String separator) {
	return loadtab(getStream(filename), separator);
    }
    
//gets data from local file
//used by above, + lookandfeel, setup, script
//should not be public any more, as not compatible with JNLP
    public  static String[][] loadtab(File file, String separator) {
	return loadtab(getStream(file), separator);
    }
    
    public  static String[][] loadtabfromdialog(String subfolder, String name, String title, String separator) {
	return loadtab(getStreamFromDialog(subfolder, name, title), separator);
    }
    
    public  static String[][] loadtabfrompersist(String subfolder, String name, String separator) {
	try {
	    try {
		File f=new File(fileio.getOutDir(subfolder), name);
		return loadtab(f, separator);
	    } catch (SecurityException e) {
		URL u=new URL(jwsbs().getCodeBase() , name); //note don't use subfolder
		return loadtab(jwsps().get(u).getInputStream(), separator);
	    }
	} catch (Exception e) { deb(e); return null; } //msg(e, "Can't Load Persistence File"); 
    }
    
    static String[][] loadtab(InputStream is, String separator) {
	LineNumberReader lnr=new LineNumberReader(new BufferedReader(new InputStreamReader(is)));
	StringTokenizer st;	String s;
	ArrayList<String[]> as=new ArrayList();
	try {
	    while ((s=lnr.readLine())!=null) {
		st = new StringTokenizer(s, separator);
		ArrayList<String> a= new ArrayList();
		while (st.hasMoreTokens()) a.add(st.nextToken().trim());
		as.add(a.toArray(new String[a.size()]));
	    }//while
	} catch (IOException e) { deb(e); }
	
	return (String[][]) as.toArray(new String[as.size()][]);
    }
    
//*************** LOAD STRING *****************
    
//used by labman, sourceview, regman
    public static String loadstring(String filename) {	return loadstring(filename, null); }
    
//used by labman
    public static String loadstring(String filename, String encoding ) {    return loadstring(getBuffStream(filename), filename, encoding); }
    public static String loadstring(File file,  String encoding) {	return loadstring(new BufferedInputStream(getStream(file)), file.getAbsolutePath(), encoding); }
    
//not used
    static String loadstring(File file) {	return loadstring(new BufferedInputStream(getStream(file)), file.getAbsolutePath(), null); }
    
    static String loadstring(BufferedInputStream bis, String filename, String encoding ) {
	StringBuffer sb=new StringBuffer(); int db;
	try {	new InputStreamReader(bis, encoding); } catch (Exception e) {	encoding=null; }
	try {
	    if (encoding!=null) {
		InputStreamReader isr= new InputStreamReader(bis, encoding);
		while ( (db=isr.read())!=-1	) sb.append((char)db); //used to use readnext method -why?
		isr.close();
	    } else {
		while ((db=bis.read())!=-1) {	sb.append((char)db); }
		bis.close();
	    }
	} catch (IOException e) {
	    if (getURL(filename)==null) { log(e, "Couldn't locate file: "+filename); return ""; }
	    log(e, "IO Error loading "+filename);  return "";
	}
	return sb.toString();
    }
    
//this method can cause seize-up because never returns -1 at end of stream
    static  int readnext(InputStreamReader isr ) {
	try {
	    return isr.read();
	} catch (IOException e) {
	    deb(e);
	    try { isr.skip(1); } catch (IOException e2)  { deb(e2, "noskip "); }
	    return 0; }
    }
    
//****************************
//no longer used (as won't work from JAR)
    public static String loadtextfile(String filename) {
	try {
	    StringBuffer sb=new StringBuffer(); int db;
	    FileReader fr=new FileReader(filename);
	    while ((db=fr.read())!=-1) {	sb.append((char)db); }
	    fr.close(); return sb.toString();
	} catch (IOException e) {  log(e, "IO Error loading "+filename); return "";  }
    }
    
//********** LOAD FLOAT array ***********************
//used by scripts - currently none - note use of File will cause security exception in java-webstart
    
    static  float[] loadfloat(String a, int len) {
	try {
	    DataInputStream dis = new DataInputStream(new FileInputStream(new File(a)));
	    float[] f=new float[len]; for (int i=0; i<len; i++)  f[i]=dis.readFloat();
	    dis.close();
	    return f;
	} catch (IOException e) {	log(e, "loadfloat: "+a); return null; }
    }
    
    
//%%%%%%%%%%%%% SAVE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
//****************** DIRECTORIES *******************************
    static String outdirname="jcmout";
    static File outdir=null;
    static FileContents lfc;
    public static String lastloaded=null;
    
    static File getOutDir() {
	if (outdir!=null) return outdir;
	String base= (fileio.class.getClassLoader().toString().contains("jnlp")) ? "user.home" : "user.dir";
	File f=new File(System.getProperty(base)+File.separator+outdirname);
	makedir(f);
	outdir=f;
	return f;
    }
    
    public static File getOutDir(String subfolder) {
	File f=new File(getOutDir(), subfolder);
	makedir(f);
	deb("dirpath= "+f.getAbsolutePath()+ " "+f.isDirectory());
	return  f;
    }
    
    public static void setDefDir() {
	try {
	    try {
		outdir=getFileFromDialog("", "", "Choose Default Directory", "select");
		makedir(outdir);
	    } catch (SecurityException e) {
		lfc=jwsfos().openFileDialog(null, null);
	    }
	} catch (Exception e) { msg(e, "Can't Select Directory"); }
    }
    
    static void makedir(File f) { 	if (!f.isDirectory()) try { f.mkdir(); } catch (Exception e) { msg(e, "Couldn't Make Directory "+f.getAbsolutePath()); } }
    
    
//******   SAVE TEXT FILE ***************************
    
//used by pngdata test
    public static void savetextfile(String name, String text) {
	try { savetextfile(new FileWriter(new File("").getPath()+name), text); } catch (IOException e) {	msg(e, "Couldn't Save "+name); }
    }
    
    
//used by labman
    public static void savetextfile(File dir, String name, String text, String encoding) {
	String s=dir.getPath()+"/"+name;
	try {  savetextfile(new OutputStreamWriter(new FileOutputStream(s), encoding) , text);  } catch (IOException e) {	msg(e, "Couldn't Save "+s); }
    }
    
    //used by setup for saving current on closing
    public static void savetextfile(String subfolder, String name, String text) {
	try {
	    try {
		File f=new File(getOutDir(subfolder), name);
		savetextfile(new FileWriter(f), text);
	    } catch (SecurityException e) {
		URL u=new URL(jwsbs().getCodeBase() , name); //note don't use subfolder'
		PersistenceService ps=jwsps();
		try { ps.create(u, 10000);  } catch (Exception e2) {} // msg (e2, "Problem Creating JNLP Persistence file");}
		savetextfile(new OutputStreamWriter(ps.get(u).getOutputStream(true)), text);
	    }
	} catch (IOException e) {	msg(e, "Couldn't Save "+name); }
    }
    
    
    
//does the real work from above, -also called directly by setup.savesetupdialog
    public static void savetextfile(OutputStreamWriter f, String text) {
	try {
	    for (int a=0; a<text.length(); a+=100) {	int b=(text.length()-a); f.write(text, a, b>100 ? 100 : b); f.flush(); }
	    log("- saved OK"); f.close();
	} catch (IOException e) {msg(e, "Couldn't Save Text File "); };
    }
    
//******************** INSTANCE ********************
// instance of a file with info and outputstream, to use both locally or by JWS in sandbox
    
    public String subfolder, name, extension, fullname;
    public OutputStream os;
    boolean usingJWSsandbox=false;
    
//constructor used by scripts
    public fileio(File f) {
	try {
	    fullname=f.getName();
	    os=new FileOutputStream(f);
	} catch (IOException e) { msg(e, "Can't Get File "+fullname); os=null; }
    }
    
//constructor to get a file from a dialog (either normal or JWS-jnlp)
    public fileio(String subfolder, String suggestname, String extension, String title, String action){
	this.subfolder=subfolder; name=suggestname; this.extension=extension; fullname=name+"."+extension;
	try {
	    File f=getFileFromDialog(subfolder, fullname, title, action);
	    fullname=f.getName();
	    try { os=new FileOutputStream(f); } catch (IOException e) { msg(e, "Can't Get File "+fullname); os=null; }
	} catch (SecurityException e) {
	    usingJWSsandbox=true;
	    os=new ByteArrayOutputStream();
	}
    }
    
//save (JWS) or  flush+close this file
    public void save() {
	try {
	    //JWS FileSaveService wants an inputstream ready to save,so we first have to fill the outputstream (eg with ImageIO), then call this method
	    if (usingJWSsandbox) {
		InputStream is=new ByteArrayInputStream(((ByteArrayOutputStream)os).toByteArray());
		lfc=jwsfss().saveFileDialog(null, null, is, name+"."+extension); //subfolder, new String[]{extension}
		//note, using the subfolder as hint doesn't help, nor does the extensions, nor does the name - but at least with null it remembers the last folder
		fullname=lfc.getName();
	    } else {
		os.flush(); os.close();
	    }
	    log("Saved "+fullname+" OK");
	} catch (Exception e) { msg(e, "Problem Saving "+fullname); }
    }
    
    
//************** FileChooser DIALOG *******************
    
//used by labman
//also indirectly by fileio constuctor, called from datable and imagesaver, and by getStreamFromDialog
    public static File getFileFromDialog(String dirpath, String filename, String title, String action) {
	JFileChooser fc=new JFileChooser(getOutDir(dirpath));
	fc.setDialogTitle(title);
	fc.setSelectedFile(new File(filename));
	Component c=jcm.gui.nav.showpan.mf;
	if (filename.equals("")) fc.setFileSelectionMode(fc.DIRECTORIES_ONLY); //used for saving labdoc
	int result= action=="save" ? fc.showSaveDialog(c) : action=="load" ? fc.showOpenDialog(c) : fc.showDialog(c, action) ;
	return (result== JFileChooser.APPROVE_OPTION) ? fc.getSelectedFile() : null;
    }
    
    
//***************** Java WebStart JNLP ********************************
    static BasicService jwsbs() { try { return (BasicService) ServiceManager.lookup("javax.jnlp.BasicService"); } catch (Exception e) { msg(e, "JNLP error: "); return null; }}
    static PersistenceService jwsps() { try { return (PersistenceService) ServiceManager.lookup("javax.jnlp.PersistenceService"); } catch (Exception e) { msg(e, "JNLP error: "); return null; }}
    static FileSaveService jwsfss() { try { return (FileSaveService) ServiceManager.lookup("javax.jnlp.FileSaveService"); } catch (Exception e) { msg(e, "JNLP error: "); return null; }}
    static FileOpenService jwsfos() { try { return (FileOpenService) ServiceManager.lookup("javax.jnlp.FileOpenService"); } catch (Exception e) { msg(e, "JNLP error: "); return null; }}
    static ExtendedService jwses() { try { return (ExtendedService) ServiceManager.lookup("javax.jnlp.ExtendedService"); } catch (Exception e) { msg(e, "JNLP error: "); return null; }}
    

    
} //end class



	/*
	 public static void setcodebase(String[] args) {
		String classpath, codebase;
		if (args.length<1) {
			//classpath=System.getProperty("java.class.path"); codebase=classpath.substring(2,classpath.length()-4);
			codebase=System.getProperty("user.dir").substring(1)+System.getProperty("file.separator")+"jcm";
		} else codebase=args[0];
	 
		 try {
		root.codebase=  new URL("file://"+codebase);
			} catch (MalformedURLException e) {	deb(e); }
	 
	}
	 
	 
	 
	static String testfile(String s) {
		StringBuffer sb=new StringBuffer("testfile output ");
	    try {
		int db;
		FileReader fr=new FileReader(s);
		    while ( (db=fr.read())!=-1) sb.append((char)db);
		    fr.close();
		} catch (Exception e) {	deb(e, "testfile error "); }
	    return sb.toString();
	}
	 */

/*    	    saveimage(b, typeIO, getOutputStreamFromDialog(c, suggestname, typeEX, "Save Image"), suggestname);
    static void saveimage(BufferedImage b, String type, OutputStream os, String messagename) {
	if (os!=null){
	    //SwingUtilities.invokeLater(new Runnable() { public void run() {
	    try {
		ImageIO.write(b, type,  os);
		log("saved image: "+messagename);
	    } catch (Exception e) {	msg(e, "Couldn't Save Image File "+messagename); }
//            }});
	}
    }
 */


/****************** Environment  ******************
 public enum env { localjar, netbeans, JWSsandbox, JWSallp; }
 static { deb("Runtime Environment="+getenv()); }
 
 //test with new JFileChooser() doesnt work: FileChooser initialises, crash when try to read from user.dir
 static env getenv() {
 Exception ex=null;
 try { File.listRoots() ;  return env.localjar;  } catch (Exception e) {}
 try {  jwsbs(); return env.JWSallp; } catch (Exception e) {}
 return null;
 //	} catch (Exception e) { deb(e); return null; }
 }
 */

/************************************
 //note its possible to do this the other way around, getting a filecontents then saving to it
 } else try {
 lfc=fss.saveAsFileDialog(null, new String[]{extension}, lfc);
 fullname=lfc.getName();
 os=lfc.getOutputStream(true);
 } catch (IOException e2) { msg(e2, "Can't Get File "+fullname); os=null; }
 
 if (lfc!=null) {
 os.flush(); os.close();
 } else {
 
 */
