/*
PERSISTENCE OF JCM SETUP (BOTH PARAMETERS AND WINDOWS)
 */

package jcm.core;
import jcm.core.itf.hasSetupInfo;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.showpan;
import jcm.core.tls.fileio;
import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import jcm.gui.nav.jcmMenu;
import static jcm.core.complexity.*;
import jcm.gui.doc.labman;
import jcm.gui.gen.splash;
import jcm.gui.nav.jcmTree;
import static jcm.core.report.*;


public class setup  {
    
    public static String savedir="setup", current="current";
    public static boolean loadcurrent=true, restart=false;
    
    static Rectangle orig, newr; static float sx=1f, sy=1f;
    static JFrame mf; //set on loading
    static Set<JComponent> onTop=new HashSet(8); //only used during loading (to avoid references)
    
    
    //**************** SETUP MENU **************************************
    
    public static void fillMenu(jcmMenu setupm) {
	setupm.add(new jcmAction("Reset All Parameters", simplest) {	public void act() {	register.resetall(); loop.gonow(); }});
	setupm.add(new jcmAction("Reset Sci-Model Params") {	public void act() {	register.resetallmod(); loop.gonow(); }});  //check if any sci params not owned by  a module?
	//setupm.add(new jcmAction("Reset All including Layout") {	public void act() {	loadsetup(fileio.loadtab("defsetup/default.jcms", "\t"));  }});
	setupm.addSeparator();
	setupm.add(new jcmAction("Load Setup") {	public void act() {	loadsetupdialog();  }});
	setupm.add(new jcmAction("Save Setup") {	public void act() {	savesetupdialog();  }});
	setupm.add(new jcmAction("Set Directory") {	public void act() {	fileio.setDefDir();  }});
	setupm.addSeparator();
	makemenu(setupm, root.rootob.find("defsetup"));
	setupm.addSeparator();
    }
    
    static void makemenu(jcmMenu m, infob io) {
	for (infob o : io.getObs() ) {
	    if (o.getObs()!=null) {
		final String s1=o.toString().substring(o.toString().lastIndexOf(".")+1);
		jcmMenu m2=new jcmMenu(s1, simplest);
		makemenu(m2, o);
		m.add(m2);
	    } else {
		final String s1=o.toString(); int ld=s1.lastIndexOf(".");
		final String s2=s1.substring(s1.lastIndexOf(".", ld-1)+1,  ld), s3=s1.substring(0, ld).replace(".", "/")+".jcms";
		m.add(new jcmAction(s2, simplest) {	public void act() {loadsetup(fileio.loadtab(s3, "\t"), s2); }} );
	    }
	}
    }
    
    
    
    //************** SAVE ****************************************
    public static void savesetupdialog() {
	fileio f=new fileio(savedir, current, "jcms", "Save Setup", "save" );
	fileio.savetextfile(new OutputStreamWriter(f.os), savesetup());
	f.save();
    }
    
    public static void savesetupdefault() {
	fileio.savetextfile(savedir, current+".jcms", savesetup());
    }
    
//***********************************************
    public static String savesetup() {
	mf=showpan.mf;
	String list="";
	for (world w : world.worlds) list+="world\t"+w.getName()+"\t"+w.getColor().getRed()+"\t"+w.getColor().getGreen()+"\t"+w.getColor().getBlue()+"\n";
	for (interacob i : register.alliobs) {
	    if (i instanceof param && !((param)i).isdefault()  ) list+="param\t"+((param)i).save();
	    if (i instanceof qtset ) {
		qtset qq=(qtset)i;  if (qq.temporary){
		    list+=
			    "qtset\t"+qq.owner.getFullName()+"\t"+qq.type
			    +(qq.qqb!=null ? "\t"+qq.qqb.getFullName() : "")
			    +(qq.name.startsWith("Compare&") ? "\t"+qq.name : "")
			    +"\n";
		}
	    }
	}
	
	list+=savemainwin();
	list+=recordSplit((JSplitPane) mf.getContentPane())+"\n";
	
	panloop: for (WeakReference<JComponent> wrc : register.winmap.keySet()) {
	    if (wrc.get()==null || wrc.get().getParent()==null)  continue panloop;
	    if (!wrc.get().getRootPane().isShowing()) continue panloop; //gets rid of closed external or internal frames
	    list+=savecomp(wrc);
	}
	return list;
    }
    
    
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//************ LOAD - variants  ******************************************
    
    
    public static boolean  loadcurrentsetup() {
	try {
	    if (loadcurrent && loadsetup(fileio.loadtabfrompersist(savedir,  current+".jcms",  "\t"), current)) return true;
	} catch (Exception e) { deb(e); }
	return loadpacksetup("default");
    }
    
    static boolean  loadsetupdialog() {
	return loadsetup(fileio.loadtabfromdialog(savedir, current+".jcms",  "Load Setup", "\t"), fileio.lastloaded);
    }
    
    public static boolean  loadpacksetup(String s) {
	return loadsetup(fileio.loadtab("defsetup/"+s+".jcms", "\t"), s);
    }
    
    
//october 06: put in separate thread, as works ok from initial startup
    static boolean  loadsetup(final String[][]list, final String name) {
	if (SwingUtilities.isEventDispatchThread()) {
	    new Thread("Setup Thread") { public void run() { loadsetup2(list, name); }}.start();
	    return true;
	} else  return loadsetup2(list, name);
    }
    
//************** LOAD all items **************************************
    static boolean  loadsetup2( String[][]list, String name) {
	if (list.length==0) return false;
	deb("setup start");
	closeold();
	
	
	//note: calling the event dispatching thread separately for each item allows elements to display one at a time - otherwise swing puts all 'show' to the end of the queue'
	for (final String[] s: list) {
	    try {
		if (SwingUtilities.isEventDispatchThread() ) setup(s); //no longer used
		else SwingUtilities.invokeAndWait(new Runnable() { public void run() { setup(s); }});
	    } catch (Exception ex) { String a=""; for (String ss : s) a+=" _ "+ss; deb(ex, "setup error "+a ); }
	}
	
	//call loop in same thread, waiting until above all done
	try {
	    if (SwingUtilities.isEventDispatchThread() )  loop.gonow();
	    else SwingUtilities.invokeAndWait(new Runnable() { public void run() { loop.gonow(); }});
	} catch (Exception ex) { deb(ex, "setup loop go error "); }
	
	setontop();
	deb("setup finished");
	
	if (restart) { restart=false; loadcurrentsetup(); }
	
	return true;
    }
    
    static void setname(String name) {
	showpan.mf.setTitle(showpan.mf.getTitle()+" :-"+name);
    }
    
    static void setontop() {
	for (JComponent c : onTop) showpan.toFront(c);
	onTop.clear();
    }
    
//****************** LOAD- SETUP one item ******************
    static void setup(final String[] s) {
	if (restart) return;
	if (s.length==0) return;
	
//temporary - convert old setups
	if (s[0].equals("worlds")) {  for (int i=1; i<s.length; i++) { String[] s2=new String[2]; s2[0]="world";  s2[1]=s[i]; setup(s2); } return; }
	if (s[0].equals("window") && s[1].equals("Main")) {  String[] s2=new String[6]; s2[0]="mainwin"; s2[1]=s[4]; s2[2]=s[5]; s2[3]=s[2]; s2[4]=s[3]; s2[5]="maximised"; setup(s2); return; }
	if (s[0].equals("window")) {
	    String[] s2=new String[s.length+1]; s2[0]="panel";
	    s2[1]=s[1];  s2[2]=s[4]; s2[3]=s[5]; s2[4]=s[2]; s2[5]=s[3]; s2[6]="true";
	    for  (int i=6; i<s.length; i++) s2[i+1]=s[i];
	    setup(s2);  return;
	}
	
	interacob i; param p;
	mf=showpan.mf;
	loop.waitUntilLoopDone();
	
	String all="setup: "; for (String ss : s) all+=" \t "+ss;
	splash.report(all);
	
	try {
	    if (s[0].equals("world")) {
		String wname=s[1];
		Color wcol=(s.length>2)  ? new Color(Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])) : Color.black;
		world.makeworld(wname, wcol);
	    }
	    
	    if (s[0].equals("param") && (i=register.findiobfullname(s[1]) )!=null) {
		((param)i).load(s[2]);
		if (mf!=null) mf.validate();
	    }
	    
	    if (s[0].equals("qtset") && (i=register.findiobfullname(s[1]) )!=null) {
		qtset base=(qtset)register.findiobfullname(s[1]);
		qtset other=(s.length>3 ? (qtset)register.findiobfullname(s[3]) : null );
		qt.Type dty=null; for (qt.Type ty : qt.Type.values()) if (ty.toString().equals(s[2])) dty=ty;
		if (dty==null) deb("can't match type "+s[2]); else {
		    if (s.length>3 && s[3].startsWith("Compare&")) base.addderiv(base.compareworld(s[3].substring(8)));
		    else base.addnewderiv(dty, other);
		}
	    }
	    
	    if (s[0].equals("split")) {
		if (mf==null) showpan.makeMainframeDefSize();
		applySplit(s, 1, (JSplitPane) mf.getContentPane());
	    }
	    
	    
	    if (s[0].equals("mainwin")) setmainwin(s);
	    if (s[0].equals("panel"))  loadcomp(s);
	    
	    // mf.setResizable(true); mf.setMaximizedBounds(null); //allow resizing and maximising only after finished setup
	} catch (Exception e) { deb(e,"setup error "); }
    } //setup one item
    
    
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// ***************** SETUP MAIN  WINDOW **************
    
    static String savemainwin() {
	Point loc=mf.getLocationOnScreen(); loc.translate(8,8); //maximising  can shift left pos to -4 , on wrong screen, hence the translate
	boolean mfonscreen= (showpan.screenbounds().contains(loc));
	return "mainwin"+ sizelocinfo(mf)+"\t"+(mfonscreen ? mf.getExtendedState() == JFrame.MAXIMIZED_BOTH ? "maximised" : "normal" : "other_screen")+"\n";
    }
    
    static void setmainwin(String[]s) {
	
	orig=new Rectangle(pin(s[1]), pin(s[2]), pin(s[3]), pin(s[4]));
	
	if (s.length>5 && s[5].equals("maximised")) {
	    if (mf==null) mf=showpan.makeMainframeMaximised();
	    mf.setExtendedState(JFrame.MAXIMIZED_BOTH);
	    newr=showpan.screenbounds();
	} else {
	    newr= (s[5].equals("other_screen")) ? orig :  orig.intersection(showpan.screenbounds());
	    if (mf==null) mf=showpan.makeMainframe(newr);
	    else mf.setBounds(newr);
	}
	
	jcm.gui.gen.lookandfeel.setFontSizeForFrame();
	//jcm.gui.gen.colfont.setFontSize();
	
	mf.validate();
	setwindim();
	deb("main window: scale: "+sx+" "+sy+" origpos:  "+orig.x+" "+orig.y+" newpos: "+newr.x+" "+newr.y);
//	mf.setResizable(false); mf.setMaximizedBounds(mf.getBounds()); //prevent resizing during setup - maximised doesn't work'
	Thread.currentThread().yield();
    }
    
    static void setwindim() {
	newr=mf.getBounds();
	sx=(float)newr.width/orig.width; sy=(float)newr.height/orig.height;
    }
    
// ************** close open windows etc. *******************
    static void closeold() {
	loop.waitUntilLoopDone();
	deb("removing old window refs");
	try {
	    for ( WeakReference<JComponent> wrc : register.winmap.keySet()) if (wrc.get()!=null) {
		showpan.dispose(wrc.get());
	    }
	} catch (Exception ex) { deb(ex, "setup dispose error "); }
	
	register.winmap.clear();
	
	deb("removing old worlds");
	world.disposeAllButOne();
	
	deb("reset all");
	jcmTree.restruclink.changed=true; //forces trees to replot
	complexity.defaultcomplexity.changed=true; //forces menus to replot?
	//reset params and run loop (in case any affect window layout etc.)
	register.resetall();
	deb("loop go now");
	loop.gonow();
	
	System.gc();
    }
    
//**************** PANELS  ********************
    static String savecomp(WeakReference<JComponent> wrc) {
	JComponent c=wrc.get();
	//isShowing() || )  { //otherwise lose hidden tabs
	// if (!c.isShowing()) showpan.toFront(c);
	
	
	if (c.isShowing()) onTop.add(c);
	if (c instanceof hasSetupInfo) ((hasSetupInfo)c).savesetup();
	
	String info="panel\t"+c.getClass().getName() + sizelocinfo(c)+"\t"+c.isShowing() ;
	
	for (Object o : register.winmap.get(wrc)) {
	    if (o instanceof WeakReference) o=((WeakReference)o).get();
	    if (o instanceof Object[]) for (Object oo : (Object[])o) info+="\t"+getname(oo);
	    else info+="\t"+getname(o);
	}
	info+="\n";
	return info;
    }
    
    static void loadcomp(String[]  s) {
	
	try {
//	    if (mf==null) mf=showpan.makeMainframeDefSize();
	    int a1=7;
	    int nargs=s.length-a1;
	    Object args;
	    if (nargs>1) {
		Object[] args2=new Object[nargs];
		for (int a=0; a<nargs; a++)  args2[a]=findob(s[a1+a]);
		args=args2;
	    } else args=findob(s[a1]);
	    
	    setwindim(); //in case mf was resized during the process
	    Point p=convert(new Point(Integer.parseInt(s[2]), Integer.parseInt(s[3])));
	    Container co=showpan.findContainerAbsolute(p);
	    
	    //below co==null is almost duplicating showpan.show (called from makepan) but not exactly same as here we have absolute point
	    if (co==null) { Point p2=new Point(p); p2.translate(-20,-20); co=showpan.findContainerAbsolute(p2); }
	    if (co==null) { Point p2=new Point(p); p2.translate(20,20); co=showpan.findContainerAbsolute(p2); }
	    if (co==null) { co=new JFrame(labman.getTitle(s.length>7 ? s[7]: s[1])); co.setLocation(p); }
	    
	    JComponent c =showpan.makepan((Class<JComponent>)Class.forName(s[1]), args, co);
	    c.setPreferredSize(convert(new Dimension(Integer.parseInt(s[4]), Integer.parseInt(s[5]))));
	    if (Boolean.parseBoolean(s[6])) onTop.add(c);
	    //loop.go(); //shouldn't be necessary, one loop at end of setup should suffice
	    
	} catch (Exception e ) { deb("setup window error"+ e); }
    }
    
//loc=new Point(loc.x-mf.getX(), loc.y-mf.getY());
//c.setLocation(loc); //expt oct06
    
//Point q=co.getLocationOnScreen();
//deb("point "+p+" co: "+q);
    
//***************  SIZE LOC*********
    static String sizelocinfo(Component c) {
	try {
	    Dimension d=c.getSize();
	    Point p =(
		    c.isShowing()  ? c.getLocationOnScreen()
		    : (c.getParent()!=null && c.getParent().isShowing()) ? c.getParent().getLocationOnScreen()
		    : new Point(50,50)
		    //new Point(c.getLocation().x+c.getParent().getLocationOnScreen().x, c.getLocation().y+c.getParent().getLocationOnScreen().y
		    );
	    if (p.x<0) p.x=0; if (p.y<0) p.y=0;
	    return "\t"+p.x+"\t"+p.y+"\t"+d.width+"\t"+d.height;
	} catch (Exception e) { deb(e+" for sizeloc of "+c); return "\t50\t50\t50\t50"; }
    }
//    public static Component getsizecomp(JComponent c) {
//	return (c instanceof treemaker) ? c : c.getRootPane().getParent();
//    }
    
    static  Point convert(Point p) { return new Point(newr.x+(int)(sx*(p.x-orig.x)), newr.y+(int)(sy*(p.y-orig.y))); }
    static Dimension convert(Dimension d) {return new Dimension((int)(sx*d.width), (int) (sy*d.height)); }
    
// ************ only used by calcscript **************
    public static void setsizeloc(JComponent c,  Point p, Dimension d) {
	JTabbedPane jtp=showpan.findTabbedPane(c);
	if (jtp!=null)  {
	    c.setPreferredSize(convert(d));
	    jtp.getParent().validate();
	} else setsizeloc(c.getRootPane().getParent(), convert(p), convert(d) );
    }
    
    public static void setsizeloc(Container c,  Point p, Dimension d) {
	c.setLocation(convert(p));
	c.setSize(convert(d));
	mf.validate();
	Thread.currentThread().yield();
    }
    
//****************** SPLIT PANES ****************
    static String recordSplit(JSplitPane jsp) {
	String s="split\t"+jsp.getOrientation()+"\t"+ jsp.getDividerLocation();
	Component c=jsp.getTopComponent();
	s+=  "\t"+ ((c instanceof JSplitPane) ?recordSplit( (JSplitPane)c) : (c instanceof JTabbedPane) ? "tab" : "dtp");
	c=jsp.getBottomComponent();
	s+=   "\t"+((c instanceof JSplitPane) ?recordSplit( (JSplitPane)c) : (c instanceof JTabbedPane) ? "tab" : "dtp");
	return s;
    }
    
    static int applySplit(String[] s, int i, JSplitPane jsp) {
	int orient=Integer.parseInt(s[i]);
	int divloc=(int) (Integer.parseInt(s[i+1])* (orient==jsp.HORIZONTAL_SPLIT ? sx : sy));
	
	jsp.setOrientation(orient);  jsp.setDividerLocation(divloc);
	
	i+=2;
	if (s[i].equals("split")) { JSplitPane jsp2=new JSplitPane(); jsp2.setResizeWeight(0.5); jsp.setTopComponent(jsp2); i=applySplit(s, i+1, jsp2); } else  {  jsp.setTopComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp()); i++; }
	if (s[i].equals("split")) { JSplitPane jsp2=new JSplitPane(); jsp2.setResizeWeight(0.5);  jsp.setBottomComponent(jsp2); i=applySplit(s, i+1, jsp2); } else  {  jsp.setBottomComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp()); i++; }
	Thread.currentThread().yield();
	return i;
    }
    
    
//******************* MISC *********************************
    
    static int pin(String s) { return Integer.parseInt(s); }
    
    static Object findob(String s) {
	Object o=register.findiobfullname(s);
	return o!=null ? o : s.equals("null") ? null : s;
    }
    
    
    static String getname(Object o) { return o==null ? "null" : (o instanceof infob) ? ((infob)o).getFullName() : o.toString(); }
    
//*****************************************************************
    
} //end class

    /*
	     try {
	    ObjectOutputStream oos=new ObjectOutputStream(new FileOutputStream(file));
	    oos.writeObject(c); oos.close();
	    } catch (IOException e) { e.printStackTrace(); }
     */

