    /*
    REGISTER
   Static register of interacobs, for interactions
   Also register of open windows and plotlinks
     
   Note no register of infobs that are not interacobs (mainly Qts, Regions, and package infobs)
   This might  be useful for  auto-documentation , but would be necessary to dispose carefully to avoid memory leak
     
     */

package jcm.core;

import java.lang.ref.WeakReference;
import java.util.*;
import javax.swing.JComponent;
import jcm.core.itf.plotlink;
import static jcm.core.report.*;


public class register {
    
    //public static interacob jcmmainwin=new interacob("main-win");
    //static {  jcmmainwin.register(); jcmmainwin.output=true; }
    
    //****************************
    //FIELDS
    
    //static register for looping through all iobs
    public static Vector<interacob> alliobs=new Vector();
    
    //Links to plots/components: use Weak References so that this list does not prevent objects from being garbage collected after closing
    //P1 STRUC maybe should make the interacob a weak reference too, for the case of disposing of parallel worlds?
    public static Map<interacob, Set<WeakReference<plotlink>>> plotlinkmap=new HashMap();
    public static Set<plotlink> plotqueue=new HashSet();  //plotqueue prevents doplot being called multiple times if has several links -note only used for temporary store
    public static Map<WeakReference<JComponent>, List> winmap=new LinkedHashMap();
    
    public static plotlink permalink=new plotlink() { public void doplot(){} public boolean isShowing() { return true; }     };
    
    static String on="", cn="", newcn;
    
    //*******************************
    //PLOTLINK
    public static void addlink(plotlink p, interacob ... ios ) {
	for (interacob i : ios) {
	    if (plotlinkmap.get(i)==null) plotlinkmap.put(i, new HashSet(4));
	    plotlinkmap.get(i).add(new WeakReference(p));
	}
    }
    
    public static void setAlwaysOutput(interacob ... ios) { addlink(permalink, ios); }
    
    public static void removelink(plotlink p, interacob i ) { plotlinkmap.get(i).remove(p); if (plotlinkmap.get(i).size()==0) plotlinkmap.remove(i); }
    
    public static void setoutputforplot() {
	for (Map.Entry<interacob, Set<WeakReference<plotlink>>> me : plotlinkmap.entrySet())
	    for (WeakReference<plotlink> p : me.getValue())  {
		if (p.get()!=null && p.get().isShowing() )  me.getKey().output =true;
		//log(me.getKey()+" output "+p.get().getClass());
	    }
    }
    
    
    public static void doplots() {
	plotqueue.clear();
	for (Map.Entry<interacob, Set<WeakReference<plotlink>>> me : plotlinkmap.entrySet())
	    if (me.getKey()!=null && me.getKey().changed) for ( WeakReference<plotlink> p : me.getValue())  if (p!=null && p.get()!=null && p.get().isShowing()) plotqueue.add(p.get());
	     for (plotlink p : plotqueue) try { p.doplot(); } catch (RuntimeException e) { deb(e, "Error in Plotting! detail below:");  }
	    plotqueue.clear(); //avoid keeping references, allow garbage collection
    }
    
    //****************************
    
    public static boolean checkneededforplotexcept(interacob i, Class t) {
	if (!i.checked) {
	    i.checked=true;
	    try {
		if (plotlinkmap.get(i)!=null) for (WeakReference<plotlink> p :  plotlinkmap.get(i)) if (p.get()!=null && !t.isInstance(p.get()) &&p.get().isShowing()) {i.checked=false; return true; }
		//log(i+" needed for "+p.get());
		for (interacob i2 : i.vaffects) if (checkneededforplotexcept(i2, t))  {i.checked=false; return true; }
	    } catch (Exception e) { deb(e, "CheckNeededForPlot problem: "); }    
	    //this is suceptible to concurrent modification exception - need to reset checked otherwise never recovers
	    //note only way to avoid concurrent modification is to use iterator.remove or iterator.add - so need to stop loop running twice!
	    i.checked=false; return false;
	}
	return false;
    }
    
    
    
    //*******************************
    //WINMAP
    
    public static void addargs(JComponent com, Object ... args) {
	List al=getargs(com);
	for (Object o : args) al.add(o instanceof infob ? new WeakReference(o) : o);
    }
    
    public static List getargs(JComponent com) {
	for (Map.Entry<WeakReference<JComponent>, List> me : winmap.entrySet()) if (me.getKey().get()==com) return me.getValue();
	List al=new ArrayList(); winmap.put(new WeakReference(com), al); return al;
    }
    
    
    //this is called from startup to check if any tree is visible, might have other uses
    public static Set getComponentsOfType(Class t) {
	Set s=new HashSet();
	for (WeakReference<JComponent> wr : winmap.keySet()) if (t.isInstance(wr.get()))  s.add(wr.get());
	return s;
    }
    
    //****************************
    //FIND IOB with specified name
    public static interacob findiobfullname(String seek) {
	for (interacob i : alliobs) if (i.getFullName().equals(seek) || i.getFullName().equals(seek.replace("_", " "))) return i; return null;
    }
    
    public static interacob findiob(String seek) {
	/*
	//use ownername.name to specify in case of ambiguity
	 not currently used
	 int s=seek.indexOf(".",0);
	if (s>0) {
	    String ownername=seek.substring(0,s), seekname=seek.substring(s+1);
	    for (iob i : alliobs) if (!(i.disposed) && (i.name.equals(seekname) || (i.name+i.name2).equals(seekname)) && i.owner.getname().equals(ownername) ) return i;
	} else {
	 */
	String n=seek.substring(seek.lastIndexOf(".")+1);
	//System.out.println("seeking "+n);
	for (interacob i : alliobs) if (
		!(i.disposed)
		&& (i.name.equals(n) || i.name.equals(seek) || i.name.equals(seek.replace("_", " ")))
		//&& ( (i.owner.name== i.name) || (!i.name.equals(i.getClass().getSimpleName()) )) 	//this ensures it's unique! -i.e. autodoc doesn't find carbon.scale while looking for scale
		) return i;
	String seek2=seek.toLowerCase(); if (!seek2.equals(seek)) return findiob(seek2);
	return null;
    }
    
    public static String findiobinfo(String seek) {
	interacob i=findiob(seek); if (i!=null) return i.type()+(i.owner!=i ? " of "+i.owner.name : "") ; else return "";
    }
    
    //****************************
    //STATIC METHODS CALLED FROM LOOP
    //ALLINTERACTIONS, ALLEFFECTS, NEEDED, CHANGED, RESET
    
    static public void setallinteractions() {
	for (interacob i : alliobs) i.output=false;
	for (interacob i : alliobs) i.setinteractions();
	setoutputforplot(); //depends on registered plotlinks
	for (interacob i : alliobs) i.needed=false;
	for (interacob i : alliobs) if (i.output) neededloop(i);
	for (interacob i : alliobs) if (i.changed) changedloop(i);
    }
    
    /*
    //set interactions for specific iob changed and needed - for iteration
    //assume no change in fundamental interactions
    static public void setchangedifneeded(interacob c, interacob n) {	setchangedifneeded(new interacob[]{	c}, new interacob[]{	n}); }
    static public void setchangedifneeded(interacob[] c, interacob[] n) {
	if (n!=null) {
	    for (interacob i : alliobs)  i.needed=false;
	    for (interacob j : n) neededloop(j);
	}
	for (interacob j : c) changedloop(j);
    }
     */
    
    //****************************
    //RECURSIVE NEEDED & CHANGED LOOPS
    
    static void neededloop(interacob thisiob){	//recursive needed loop
	if (!thisiob.needed) {	//only if not already done!
	    thisiob.needed=true;
	    for (interacob i : thisiob.vaffectedby) neededloop(i);
	}
    } //end needed rec
    
    static void changedloop(interacob thisiob){	//recursive changed loop
	if (!thisiob.checked) {	//only if not already done!
	    thisiob.changed=true; thisiob.checked=true;
	    for (interacob i : thisiob.vaffects) changedloop(i);
	    thisiob.checked=false;
	}
    }
    
    //RESET
    //resets all iobs, so long as they were registered!
    public static void resetall() {	for (interacob i : alliobs) if (i instanceof param) ((param)i).reset(); loop.calcfutureonly=false;     }
    public static void resetallmod() { for (interacob i : alliobs) if (i instanceof param && i.owner instanceof module) ((param)i).reset(); loop.calcfutureonly=false;     }
    
} //end class

