/*region class:
 both an individual country/polygon, and a set that is made of other regions
 P3 IDEA colors for regions: if not specified, make a variant of bigger regions - (although easier to do this in reverse, or easier to specify...?)
 P1 STRUC could split region into types: region defined by edges, region defined by corners, sum of regions, regionset, other...
OK  P3 coastlines not quite additive - work out why -related to lakes? also not consistent re include begin/end edge -see regpoly
 p2 small bug in plotting polygons for south american regions
 
 */

package jcm.core.reg;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.*;

import jcm.core.*;
import jcm.gui.doc.autodoc;
import jcm.mod.reg.*;
import static jcm.core.report.*;


public class region extends infob  {
    
    public boolean dud=false, wrapping=false, included=false, fixedpoly=false, sea=false; //note fixedpoly used for TGCIA
    public region superset=regman.allreg;
    public ArrayList<String> altnames=new ArrayList(0);
    public ArrayList<String> simpaltnames=new ArrayList(0);
    public List<region> reg=new ArrayList();
    public Vector<regpoly> polyset=new Vector();
    List<edge> edges=new LinkedList();
    edge startedge;
    float coast=0, area=0;
    
    //***************************************************
    //constructors
    public region(String s) { name=s; }
    public region(String s, Color c) { name=s; color=c;}
    public region() {	name="unnamed region"; }
    
    //***************************************************
    //NAME / COLOR / DOC
    
    public void setcols(Color[] cols)  {	for (int i=0; i<reg.size(); i++ ) reg.get(i).color=cols[i]; }
    public Color[] getcols() { Color[] cols=new Color[reg.size()+1]; for (int i=0; i<reg.size(); i++) cols[i]=reg.get(i).getColor(); cols[reg.size()]=Color.black; return cols; }
    
    public String getName() {	return (altnames.size()>0) ?  altnames.get(0) : name; }
    public String[] getnames() {	String[] names=new String[reg.size()+1]; for (int i=0; i<reg.size(); i++) names[i]=reg.get(i).name; names[reg.size()]="world"; return names; }
    
    public String getExtraDoc() { return   docSubReg()+"aboutregions"+"<hr>";     }
    
    public String docSubReg() {
	String s="", s2="";
	//Set<region> subr= subreg(regman.nations);
	if  (reg.size()>1) { for (region r : reg) s+="<li>"+ r.hashcolor()+autodoc.link(r.name, r.getName())+"</font>"; s= "==`subreg== <ul>"+s+"</ul>"; }
	Set<region> supr=new HashSet(); for (region r : regman.allreg.reg) if (r.reg.contains(this)) supr.add(r);
	if  (supr.size()>1) { for (region r : supr) s2+="<li>"+ r.hashcolor()+autodoc.link(r.name, r.getName())+"</font>"; s2= "==`supreg== <ul>"+s2+"</ul>"; }
	return s+s2;
    }
    
    
    //***************************************************
    //SUBREGIONS
    
    public boolean isset() { return reg.size()>0; }
    
    public boolean checkfind(String s) {
	return findo(s)!=null;
    }
    
    public region find(String s) { //find or make
	region r=findo(s);
	if (r==null) { r=new region(s); reg.add(r); }
	return r;
    }
   /*
    Map<String, String> check=new HashMap();
    if (!s.equals(r.name)){
	    if (check.containsKey(r.name) && !check.get(r.name).equals(s)) System.err.println(s+" => "+r.name+ " "+ check.get(r.name));
	    check.put(r.name, s);
	}
    */
    static String[] ignore=new String[]{ ",", " &", " and", "the", " of", " is.", " isl.",  " isls", " islands", " island",  " rep.", " republic", "fr. ", "french ", "saint ", "st. ", "."  };
    static String[] spacer=new String[]{"-", "/", "  "};
    
    static String simplify(String s) {
	String s2=s.toLowerCase();
	for (String i : ignore) s2=s2.replace(i, "");
	for (String i : spacer) s2=s2.replace(i, " ");
	s2=s2.trim();
	return s2;
    }
    
    public region findo(String s) {
	for (region r : reg) if (r.name.equals(s)) return r;
	for (region r : reg) for (String an : r.altnames) if (an.equals(s)) return r;
	String s2=simplify(s);
	for (region r : reg) for (String an : r.simpaltnames) if (an.equals(s2)) return r;
	return null;
    }
    
    public boolean contains(region cr) {	//recursive
	if (cr==this) return true;
	if (isset()) for (region r: reg ) if (r.contains(cr)) return true;
	return false;
    }
    
    public boolean contains(Point p) {	for (Polygon poly : polyset) if (poly.contains(p.x,p.y)) return true; return false; }
    
    //comparing order
    boolean lt(region r) {	return name.compareTo(r.name)<0; }
    boolean gt(region r) {	return name.compareTo(r.name)>0; }
    
    //find sub-regions of this one within a destination set -used by histdata split,  people, interpolatereg
    public Set<region> subreg(region r) { return subreg(new HashSet(r.reg)); }
    public Set<region> subreg(qtset qq) { return subreg(qq.map.keySet()); }
    
    public Set<region> subreg(Set<Object> destset) {
	Set<region> set=new HashSet();
	for (region sr : reg) sr.addsubreg(set, destset);
	if(set.size()==0)  addsubreg(set, destset);
	if (destset.contains(this) && !set.contains(this)) set.add(this);
	// ((source.map.containsKey(r) && !subregs.contains(r)  )? source.get(r, y)*fac : 0));
	return set;
    }
    
    void addsubreg(Set<region> set, Set<Object> destset) {
	if (destset.contains(this)) set.add(this);
	else for (region sr : reg)  sr.addsubreg(set, destset); //recursive
    }
    
    
    //***************************************************
    //POLYGONS
    static String edgelist; static Set<edge> includededge=new HashSet(); //note assumes will never call two makepolys concurrently
    
    //make polygon corresponding to a particular region
    public void makepolys() {
	if (!fixedpoly) { polyset.clear();  edgelist=" \n "+getName()+" edges from "; coast=0; includededge.clear(); addpoly(this); }
	//float area=calcarea();
	//if (coast!=0) System.err.println(edgelist+ " coast: "+coast); //"\ngetName()
	//System.err.println(" \n "+getName()+" coast="+coast+" area="+area+" ratio="+coast/area);
//	try {
//	    float ava=jcm.mod.luc.LUCdata.countryArcviewAreas.get(this).intValue();
//	    System.err.println(getName()+" area="+(int)area+" ava="+(int)ava+" err%="+(int)(100f*(area/ava-1f)));
//	} catch (Exception e) {}
    }
    
    //semi- recursive : poly and contains info always belongs to initial region
    //P1 for multi-country polygons, the last corner is always cut
    
    public void addpoly(region ir) {
	String debug=" region "+ir.name;
	try {
	    if (ir.isset()) {
		for (region r : ir.reg) if (r!=ir) r.included=false;
		for (region r : ir.reg)  { debug+=" "+r.name; if (!r.included) { addpoly(r); debug+=":start "; } else  debug+=":inc "; }
	    } else {
		if (ir.fixedpoly) { //only for TGCIA boxes
		    polyset.add(ir.polyset.firstElement());
		    ir.included=true;
		}
		if (ir.startedge!=null && !includededge.contains(ir.startedge)) {
		    //(follow around the edges anticlockwise)
		    edge e=ir.startedge, eo=e;
		    region et, er, el; regpoly p=null; float len;
		    do {
			debug +=" \tEdge "+(e!=null ? e.info() : " null");
			//if not internal edge, add edge
			if ( !(contains(e.left) && contains(e.right)))  {
			    if (p==null) { eo=e; p=new regpoly(); polyset.add(p); p.wrapping=false;  }
			    p.addedge(e, e.left==ir);
			    includededge.add(e);
			    if ((e.left==ir && e.right.sea) || (e.right==ir && e.left.sea)) { len=e.length()*60f*1.852f;  coast+=len; edgelist+="   "+ir+"-"+(e.left==ir ? e.right : e.left)+" "+len;  }
			}
			//move on to next edge (/region)
			if (e.left==ir) {	et= e.to; er=e.right; el=e.left; } else {	et= e.from; er= e.left; el=e.right ; }
			if (contains(et)) {	ir=et; ir.included=true;  e= ir.lt(er)  ? ir.fef(er, el)   : er.fet(ir, el) ; } else {	e=   ir.lt(et)  ? ir.fef(et, er) : et.fet(ir, er) ; }
		    } while (e!=eo && (p==null || !p.wrapping)  && !includededge.contains(e));
		    //if (!mapproj.notwrap(fp.x,op.x)) {	p.wrapping=true; wrapping=true; }
		}
	    }
	} catch (RuntimeException ex) {	deb(ex, debug); }
    }
    
    //******************** AREA ************************
    /*
     general formula for area of any polygon (without holes), taken from Gauss-Green formula
     modified to take into account curvature of earth by scaling each x by cos latitude (note shearing will not change the area)
     this will be OK for most country-sized polygons in which internal curvature is not a big factor
     in principle could remove holes (lakes) if remove math.abs and make sure all polygons (inc holes) numbered with interior on left
     */
    float calcarea() {
	float sum=0; for (Polygon p : polyset) sum+=calcarea(p); return sum;
    }
    
    float calcarea(Polygon p) {
	float sum=0;
	for (int i=0; i< p.npoints; i++)  {
	    int j=(i+1) % p.npoints;
	    sum+=p.xpoints[i]*Math.cos((Math.PI*p.ypoints[i])/180.0)*p.ypoints[j] - p.xpoints[j]*Math.cos((Math.PI*p.ypoints[j])/180.0)*p.ypoints[i];
	}
	return Math.abs(sum/2f)*60f*60f*1.852f*1.852f;
    }
    
    
    
    //***************************************************
    //INTERPOLATE AVERAGE
    //interpolate average for each polygon, from an instance of mapdata (GCM data, baseline climatology etc)
	/*
	 may need to put back regman.allreg.resetdud(); which was called by regcli.precalc(iob) when new dataset
	public static void resetdud () {	for (Enumeration e = reg.elements() ; e.hasMoreElements() ; ((region) e.nextElement()).dud=false ); }
	 
	P1 ENH  Polygon.contains(x,y) is very inefficient for large polygons - it traces every edge segment
	So when bounding box is large, it's checking edges a long way away
	Hence map draws more efficiently with many small polygons despite increased total number of edges
	Could split into subboxes and use contains(x1,y1,x2,y2) method? but that doesn't work in MS-JVM
	name below works with both, but slow in MSJVM
	 */
    
//area=(float)(cos((Math.PI*yi)/180.0)* pow(1.8521 * 30, 2)); //IUGG equatorial radius Earth  6378.137 km, equatorial circumference 40,075 km // 1 nautical miles  = 1.852 kilometres  http://www.thetipsbank.com/convert.htm;
    
    //note this code is almost duplicated in CalcLucEmit - should generalise -also make general way of extracting areas
    //(do this by generalising mapdata to cope with biome maps?)
    
    public float avg(mapdata griddata) {
	if ( (name.startsWith("PAC_") &&name.length()==6)) dud=true; else dud=false;
	if (dud || wrapping) return -999;
	int xo,yo, xi, yi, xd, yd, cell;
	double area=0, sum=0, sumarea=0, dudarea=0;
	boolean inbox;
	//		makepolys(); // -only when changed - which mapplot should ensure!
	for (regpoly p : polyset) {
	    Rectangle box=p.getBoundingBox();
	    
	    int step=5; // degree steps
	    for (xo=box.x; xo<(box.x+box.width); xo+=step)	{
		xd=Math.min((box.x+box.width)-xo, step);
		for (yo=box.y; yo<(box.y+box.height); yo+=step) {
		    yd=Math.min((box.y+box.height)-yo, step);
		    if (p.intersects(xo,yo,xd,yd)) {
			inbox=p.contains(xo,yo,xd,yd);
			for (yi=yo; yi<(yo+yd); yi++) {
			    area=Math.cos((Math.PI*yi)/180.0);
			    for (xi=xo; xi<(xo+xd); xi++)	{
				if (inbox || p.contains(xi,yi)) {
				    cell=findcell(xi,yi,griddata);
				    try {
					if (griddata.r[cell]!=-999) {	sum+=griddata.r[cell]*area; sumarea+=area; } else dudarea+=area;
				    } catch (NullPointerException e) { dudarea+=area; }
				}
			    }
			}
		    }
		}
	    }
	} //polys
	if (sumarea>dudarea) {	dud=false; return (float)(sum/sumarea); } else {	dud=true; return -999; }
    } //regav
    
    int findcell(int x, int y, mapdata d) {
	int xx=(int)(0.5+d.nlon*((x+360)%360)/360.0);
	int yy=(int)(0.5+d.nlat*(90-y)/180.0);
	return yy*d.nlon+xx;
    }
    
    
    
    //***************************************************
    //EDGES
    
    edge fef(region r, region f) {	for (edge e : edges) if (r==e.right && f==e.from) return e; return null; }
    edge fet(region r, region t) {	for (edge e : edges) if (r==e.right && t==e.to) return e; return null; }
    
    edge addedge(String r, String f, String t)	{
	startedge=new edge(this, superset.find(r), superset.find(f), superset.find(t));
	edges.add(startedge);
	superset.find(r).startedge=startedge;
	return startedge;
    }
    
    //*****************************************************
    //methods called by loaddata
    public void addedge(String[] item) {
	edge e= addedge(item[1], item[2], item[3]);
	e.p=new Point[item.length-4];
	for (int j=4; j<item.length; j++) e.p[j-4]=parsepoint(item[j]);
    }
    
    //E, W, N, S edges, format of TGCIA regions - note this will trim the half degrees because Polygon only accepts ints
    public void defbox(String[] s) {
	regpoly p=new regpoly();
	p.addPoint(pi(s[5]), pi(s[2]));
	p.addPoint(pi(s[5]), pi(s[3]));
	p.addPoint(pi(s[4]), pi(s[3]));
	p.addPoint(pi(s[4]), pi(s[2]));
	polyset.addElement(p); fixedpoly=true;
	superset.find("TGCIA").reg.add(this);
    }
    
    public void addsub(String[] item) {	for (int j=2; j<item.length; j++) 	reg.add(superset.find(item[j])); }
    public void subtract(String[] item) {	for (int j=2; j<item.length; j++) 	reg.remove(superset.find(item[j])); }
    public void addset(String[] item) {	for (int j=2; j<item.length; j++) {	region rr= superset.find(item[j]); for (region r : rr.reg ) reg.add(r); }	}
    
    public static int pi(String s) {	return Integer.parseInt(s.substring(0, s.length()-2)); }
    public static Point parsepoint(String item) {
	int k=nsew(item.substring(0,1));
	return new Point(xs*Integer.parseInt(item.substring(k+2,item.length())), ys*Integer.parseInt(item.substring(k,k+2)) );
    }
    
    //interpret NSEW info in datafile
    static int xs=1, ys=1; //assume start N, E
    public static int nsew(String c) {
	int k=1;
	if (c.equals("N"))  ys=1;
	else if (c.equals("S")) ys=-1;
	else if (c.equals("E")) xs=1;
	else if (c.equals("W")) xs=-1;
	else if (c.equals("!")); //to skip comments
	else k=0;
	return k;
    }
    //*****************************************************
    
    
} //end class




