/* projection (grid, polar, etc.)
P1 IDEA STRUC  Convert projection  to Graphics2D?, maybe could use enumeration rather than subclasses?
*/

package jcm.core.reg;

import java.awt.*;
 
import jcm.core.param;
import static jcm.core.report.*;

public class mapprojection  {
    
    int top, left, ploth, plotw, sl; //sl=startlongitude
    public static mapprojection[] projections={ new gridprojection(), new coslatprojection(), new polarprojection()};
    public static param getparam() { param p= new param("projection", projections, projections[1]) ; deb(p.chosen.toString());  return p;}
    
    public void setsize(int l, int t, int w, int h, int s) {	left=l; top=t; plotw=w; ploth=h; sl=s; }
    double xf(int xx) { return (xx -left)/(double)plotw; }
    double yf(int yy)  { return (yy-top)/(double)ploth; }
    
    public Point translate(int x, int y) {	return translate((double)x, (double)y); }
    public Point translate(double x, double y) { return new Point(left+ (int)(plotw*x),  top +(int)(ploth*y)); }
    public Point translateback(int xx, int yy) { return new Point((int)xf(xx), (int)yf(yy)); }
    
    public Polygon translate(Polygon a) {
	Polygon b=new Polygon(); Point p;
	for (int i=0; i<a.npoints; i++) {
	    if (i==0 || notwrap(a.xpoints[i], a.ypoints[i], a.xpoints[0], a.ypoints[0])) {
		p=translate(a.xpoints[i], a.ypoints[i]);
		b.addPoint(p.x, p.y);
	    }
	}
	return b;
    }
    public boolean notwrap(Point a, Point b) {	return notwrap(a.x, a.y, b.x, b.y); }
    public boolean notwrap(int x1, int y1, int x2, int y2) {    return Math.abs(wrap(x1+sl)-wrap(x2+sl))<180; }
    int wrap(int x) {	return (x+540)%360-180; }
    
    
} //end class

//SPECIFIC IMPLEMENTATIONS

class gridprojection extends mapprojection {
    public String toString() { return "grid"; }
    public Point translate(double x, double y) { return new Point(
	    left +plotw*(wrap((int) (x+sl))+180)/360,
	    top +(int)(ploth*(90-y)/180)
	    );   }
    public Point translateback(int xx, int yy) { return new Point(
	    wrap((int)(360*xf(xx) +180 -sl)) ,
	    90-(int)(180*yf(yy))
	    ); }
} //end class

class coslatprojection extends mapprojection {
    public String toString() { return "coslat"; }
    public Point translate(double x, double y) { return new Point(
	    left+(int)(plotw*(0.5+(wrap((int) (x+sl))/360.0)*Math.cos(Math.PI*y/180.0))),
	    top +(int)(ploth*(90-y)/180)
	    ); }
    public Point translateback(int xx, int yy) {
	int y=90-(int)(180*yf(yy));
	return new Point(
		wrap((int)((xf(xx) - 0.5)*360.0/Math.cos(Math.PI*y/180.0)) +360 -sl) ,
		y
		);
    }
} //end class

class polarprojection extends mapprojection {
    public String toString() { return "polar"; }
    public Point translate(double x, double y) { return new Point(
	    left+(int)(plotw*(  (y>0 ? 0.25 : 0.75) - Math.cos(Math.PI*(x+sl)/180)* (Math.abs(y)/y)*0.25* (90-Math.abs(y))/90 )),
	    top+(int)(ploth*(0.5+0.5*Math.sin(Math.PI*(x+sl)/180)*(90-Math.abs(y))/90))
	    ); }
    public Point translateback(int xx, int yy) {
	int ns=(xf(xx)>0.5 ? -1 : 1 ) ;
	double xf= 4.0*(xf(xx)>0.5 ? xf(xx) - 0.75 : xf(xx) - 0.25 );
	double yf= 2.0*(yf(yy)-0.5)  ;
	return new Point(
		wrap(- sl + (int)( (xf*ns<0 ? 360 : 180) -ns*Math.atan( yf / xf ) *180.0 / Math.PI) ) ,
		(int)(90.0* ns*(1.0-Math.pow(yf*yf + xf*xf, 0.5)))
		); }
    public boolean notwrap(int x1, int y1, int x2, int y2) {    return y1 * y2 >0;    }
} //end class




