 /*
 set of QTs with common units, from which a plot or table may be created
  
  */

package jcm.core;

import java.awt.Color;
import java.util.*;
import javax.swing.Action;
import jcm.core.itf.plotlink;
import jcm.gui.doc.autodoc;
import jcm.core.itf.menuFiller;
import jcm.core.reg.region;
import jcm.gui.nav.showpan;
import jcm.gui.plot.*;
import jcm.gui.doc.labman;
import static  jcm.gui.gen.colfont.*;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import static jcm.core.report.*;


public class qtset extends interacob implements plotlink,  menuFiller {
    
    public Map<Object, qt> map=new LinkedHashMap();
    public Set<param> assocparams;
    public qt  total=null;
    public qt current=null;
    public int sy=module.gsy, ey=module.gey, xstep=1; //duplicating qt!
    public String units="";
    boolean setcolor=false, gotmap=false;
    public boolean justadded=false;
    public qt.Type type=qt.Type.normal;
    
    public qtset qqa, qqb; //for derivatives, similar use as qa and qb in qt
    public  java.util.List<qtset> extraqq;
    
    
    //******** CONSTRUCTOR ************
    
    public qtset(Object ...args) {
	
	int sc=0, ic=0;
	color=null;
	for (Object o : args) {
	    
	    if (o instanceof qtset) {
		if (qqa==null) {
		    qqa=(qtset)o;
		    color=qqa.color; name=qqa.name; units=qqa.units;
		    sy=qqa.sy; ey=qqa.ey; xstep=qqa.xstep;
		} else qqb=(qtset)o;
		setaffectedby((qtset)o);
	    }
	    if (o instanceof Color) { color=(Color)o; }
	    if (o instanceof interacob) { owner=(interacob) o; setaffectedby((interacob) o); name=owner.name;    }
	    if (o instanceof complexity) { mycomplexity=(complexity)o; }
	    if (o instanceof qt.Type) type=(qt.Type)o;
	    
	    if (o instanceof qt[]) for (qt q : (qt[])o) add(q);
	    if (o instanceof qt) add((qt)o);
	    if (o instanceof String) {
		switch (sc) {
		    case 0: name=(String)o; break;
		    case 1: units=(String)o; break;
		}
		sc++;
	    }
	    if (o instanceof Number) { //duplicating qt!
		int i=((Number) o).intValue();
		switch (ic) {
		    case 0: sy=i; break;
		    case 1: ey=i; break;
		    case 2: xstep=i; break;
		}
		ic++;
	    }
	} //o
	
	
	if (mycomplexity==null) { if  (map.size()>0) mincomplexity(map.values()); else mycomplexity=complexity.normal; }
	if (color==null) color= rcol(owner.color);
	
	addAction(filter.filtertype.Curves, showpan.pan("Plot", lineplot.class, this));
	if (type==type.ratio) {
	    addAction(filter.filtertype.Curves, showpan.pan("Histogram", histoplot.class, this));
	    addAction(filter.filtertype.Curves, showpan.pan("Scatter/XYplot", XYplot.class, this));
	}
	if (gotmap) addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));
	addAction(filter.filtertype.Curves, showpan.pan("Table", datable.class, this));
	addAction(filter.filtertype.Doc);
    }
    
    //****************************************************
    
    public void associate(param ... pp) {
	if (assocparams==null) assocparams=new HashSet(3);
	for (param p : pp) assocparams.add(p);
    }
    
    public void changeendyear(int oldey, int newey) {
	if (ey==oldey) {
	    ey=newey;
	    for (qt q : map.values()) q.changeendyear(oldey, newey);
	    changed=true;
	}
    }
    
    
//**********************ADD**************************
    public void add(Object o, qt q) {
	map.put(o, q);
	if (o==jcm.core.reg.regman.world && q.type==qt.Type.normal) q.type=qt.Type.total;
	if (total==null && q.type==qt.Type.total) total=q; //note total is set to the first qt of type=total
	if (mycomplexity==null) mincomplexity(map.values());
	if (q.owner==q) q.owner=this;
    }
    
    public void add(qt ... qq) { for (qt q : qq) add(q.name, q);  }
//public void addextra(qt q, String s) { map.put(s, q); setaffectedby((interacob)q.owner); }
    
//********************GET SET FIND ***************
    
    public qt reg(Object r)  {
	if (map.containsKey(r)) return map.get(r);
	
	if (r instanceof region && !gotmap) { gotmap=true; addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this)); }
	
	qt q=null;
	switch (type) {
	    case difference :   case sum :  case ratio : q =new qt(qqa.map.get(r), qqb.map.get(r), type, owner); break;
	    case frac : case rate : case integral : q =new qt(qqa.map.get(r), type, owner); break;
	    default :
		if (r instanceof infob) { infob ri=(infob)r; q =new qt(ri.getName(), ri.getColor(), sy, ey, xstep, this);   } else q =new qt(r.toString(), Color.black, sy, ey, xstep, this);
	}
	if (mycomplexity!=null && r instanceof region) q.mycomplexity=mycomplexity;
	add(r, q); return q;
    }
    //System.err.println("creating qt for "+r+" in "+name+" "+qqa.map.get(r) );
    
    public infob find(String name) { //used by autodoc
	infob o=super.find(name); if (o!=null) return o;
	for (Object oo : map.keySet()) if (oo.toString().equals(name)) return map.get(oo);
	return null;
    }
    
    //below are convenience combinations - should make more diverse names!
//be careful: get can add a new region to map when not intended => mystery errors, should throw exception!
    
    public float get(Object r, int year) { return reg(r).get(year); }
    public float get(Object r) {return reg(r).get();}
    public float get(int year) {return current.get(year);}
    public float get() {return current.get();}
    
    public void set(Object r, int year, float f) { reg(r).set(year, f); }
    public void set(int year, float f) { current.set(year, f); }
    public void set(Object r,  float f) { reg(r).set( f); }
    public void set(float f) { current.set(f); }
    public void setreg(Object r) { current=reg(r); }
    
//**************** SCALE, MINMAX, TOTAL ************
    
    
    public String getunits() {	return units; }
    public param getxscale() {
	return new param(param.Type.Xscale,  "Xscale", "year", 0, Math.max(sy,1800), Math.min(ey,2200), 50);
    }
    
    public param getyscale() { 	return new  param(param.Type.Yscale,  "Yscale", units,  0, getmin(), getmax(), 1); }
    
    public float getmax() {	float max=Float.MIN_VALUE; for (qt q : map.values()) if (q.checkcomplexity()) max=Math.max(max, q.getmax()); return max; }
    public float getmin() { float min=Float.MAX_VALUE; for (qt q : map.values()) if (q.checkcomplexity()) min=Math.min(min, q.getmin()); return min; }
    
    public float getmax(boolean stacked) { //used by lineplot for scaling stacked plot: note this may be rather slow!
	if (!stacked) return getmax();
	float max=Float.MIN_VALUE; for (int year=sy; year<ey; year+=xstep) {
	    float tot=0; for (qt q : mapwithouttotal().values()) tot+=q.get(year); if (tot>max) max=tot;
	}
	return max;
    }
    
//note - used by futurebasescen -ignores dud
    public float calctot() { return calctot(module.year); }
    public float calctot(int year) {
	if (total==null) total=reg(jcm.core.reg.regman.world);
	float f;
	total.set(year, 0); for (qt q : mapwithouttotal().values()) {f=q.get(year); if (f!=qt.dud) total.set(year, total.get(year)+f); }
	return total.get(year);
    }
    
    public void topdownscale(float global) { topdownscale(global, false); }
    public void topdownscale(float global, boolean excludebunker) {
	float regtot=calctot(), f;
	if (excludebunker) { regtot-=get("bunker"); global-=get("bunker");  }
	//float bu=regional.get("bunker");
	if (regtot>0) for (qt q : map.values()) if ( !(excludebunker && q.name.equals("bunker"))) { f=q.get(); if (f!=qt.dud) q.set(f*global/regtot); }
	
	//if (get("bunker")>0) System.err.println("TDS "+name+" "+regtot+" "+global+"bunker= "+bu+" => "+get("bunker"));
    }
    
    public Map<Object, qt> mapwithouttotal() {
	Map<Object, qt>  m=new LinkedHashMap();
	//note some qtsets eg aerosol have more than one total
	for (Map.Entry<Object, qt> me : map.entrySet()) if (me.getValue().type!=qt.Type.total) m.put(me.getKey(), me.getValue());
	return m;
    }
    
    //recently added to loop
    public void postcalc() {
	//if (total!=null) for (int y=sy; y<=ey; y+=xstep) calctot(y); //for plots - BUT causes big problem with carbon cycle totemit!
	if (type==qt.Type.integral) {
	    for (qt q : map.values()) q.calcintegral();
	}
    }
    
    
    //************************** POPUP MENU **********************
    
    public void fillMenu(jcmMenu pop) { fillMenu(pop, filter.all()); }
    public void fillMenu(jcmMenu pop, Set<filter.filtertype> fs) {
	super.fillMenu(pop, fs); //permanent actions
	//creating new actions (below) each time this is called may use up a lot of memory?
	pop.addSeparator();
	if (fs.contains(filter.filtertype.Curves)) {
	    jcmMenu submenu=new jcmMenu("CreateVariant");
	    submenu.add(new jcmAction( "percent&change&per&yr") { public void act() {  addnewderiv(qt.Type.rate); }});
	    submenu.add(new jcmAction( "percent&of&total") { public void act() {  addnewderiv(qt.Type.frac); }});  //this used to be added in reg below only for region qtsets!
	    submenu.add(new jcmAction( "integral") { public void act() {  addnewderiv(qt.Type.integral); }});
	    submenu.add(makederivmenu(qt.Type.ratio));
	    submenu.add(makederivmenu(qt.Type.difference));
	    submenu.addSeparator();
	    if (world.worlds.size()>1) submenu.add(compareworldmenu());
	    submenu.addSeparator();
	    submenu.add(refresh);
	    pop.add(submenu);
	    pop.addSeparator();
	    
	    if (temporary) {
		pop.add(new jcmAction("Remove") { public void act() { qtset.this.removederiv(); }} );
	    }
	}
    }
    
    
//*************** DERIVATIVE QTSETS **************
    public void addnewderiv(qt.Type dty) { addderiv(makederiv(dty)); }
    public void addnewderiv(qt.Type dty, qtset other) { addderiv(makederiv(dty, other)); }
    public qtset makederiv(qt.Type dty) { return makederiv(dty, null); }
    
    public qtset makederiv(qt.Type dty, qtset other) {
	String dname=(other==null ?  name+"&"+dty : name+"&"+(dty==dty.ratio ? "per" : dty==dty.sum ? "plus" : dty==dty.difference ? "minus" : "")+"&"+other.name);
	String dunits= (dty==dty.rate ? units+"&percent&per&year" : dty==dty.integral ? units+"&integral" : dty==dty.frac ? "percent" : dty==dty.ratio ? units+"&per&"+other.units : units);
	
	qtset qd=new qtset(this, other, dty, dname, dunits, sy, ey, xstep);
	if (other==null) {
	    for (Object k : (dty== dty.frac ? mapwithouttotal().keySet() : map.keySet())) qd.add(k, new qt(map.get(k), dty, this) ); //ref to this only really necessary for frac type -see qt get
	} else {
	    for (Object k : map.keySet()) if (other.map.containsKey(k))  qd.add(k, new qt(map.get(k), other.map.get(k), dty, this ) );
	    qd.setaffectedby(other);
	}
	qd.type=dty; qd.setaffectedby(this); //shouldn't be necessary
	qd.register();
	return qd;
    }
    
    public  qtset compareworld(String name) {
	//for (Object key : map.keySet()) deb("check: "+key+ " = "+name+" ? "+key.equals(name));
	for (Object key : map.keySet())  if (key.toString().equals(name)) return compareworld(map.get(key));
	return null;
    }
    
    public  qtset compareworld(qt q) {
	deb("compare worlds "+q.name);
	qtset cwq=new qtset("Compare&"+q.name, units, sy, ey, xstep);
	cwq.register();
	for (world w : world.worlds)  for (module m : w.mods)  for (qtset mqq : m.qtsets)  if (mqq.name.equals(name))  {
	    for (Object key : map.keySet()) if (map.get(key)==q)  try {
		cwq.add(w.name, new qt(mqq.map.get(key).geta(), w.name, w.color , sy, ey, xstep));
	    } catch (NullPointerException e) { deb("cannot find curve "+key+" for "+w.name); }
	    cwq.setaffectedby(m);
	}
	return cwq;
    }
    
    public void addderiv(qtset qd) {
	if (qd==null) return;
	addOb(qd);
	qd.temporary=true;
	qd.justadded=true; //signal to tree to open it
	jcmTree.restruclink.changed=true;
	qd.owner=this;
	qd.gotmap=gotmap;
	loop.golater("qtset addderiv");
    }
    
    public void removederiv() {
	owner.removeOb(this);
	disposeLater();
    }
    
    public void refreshregs() { //for plots, need to change region set...
	if (type!=qt.Type.normal) {
	    map.clear(); for (Object o : type==type.frac ? qqa.mapwithouttotal().keySet() :  qqa.map.keySet()) reg(o);
	}
    }
    
//************************** FIND POTENTIAL DIVBY *****************
    
    public Map<module, List<qtset>> potdivby ;
    Action refresh=new jcmAction("Refresh Options") {  public void act() { forcecalc(); findpotdivby();  }};
    
//for temporary plotlink to self, to force calc, is this the best way?
    public void forcecalc() { if (changed) {  register.addlink(this, this); loop.gonow(); register.removelink(this, this); } }
    public boolean isShowing() { return true; }
    public void doplot() {}
    
    
    public void findpotdivby() {
	potdivby.clear();
	for (world w : world.worlds)  for (final module m : w.mods) {
	    List<qtset> fit=new LinkedList();
	    for (final qtset qqd : m.qtsets)  if (!qqd.equals(qtset.this)) {
		checkoverlap : {
		    if (qqd.name.equals(this.name)) { fit.add(qqd);  break checkoverlap; } // always include if same name, even if not same regions yet
		    for (Object o : qqd.map.keySet()) if (map.containsKey(o)) { fit.add(qqd);  break checkoverlap; } //include if some common regions
		}
	    }
	    if (fit.size()>0) potdivby.put(m,fit);
	}
    }
    
    public jcmMenu makederivmenu(qt.Type aty) {
	if (potdivby==null) { potdivby=new HashMap();  findpotdivby(); }
	if (potdivby.size()>0)  {
	    jcmMenu dm=new jcmMenu(aty+":");
	    //same name in other worlds
	    for (java.util.List<qtset> qqs : potdivby.values()) for (qtset qqd : qqs) if (qqd.name.equals(this.name)  && checkunitsmatch(qqd, aty)) dm.add(dbaction(qqd.getworld().name, qqd, aty));
	    //others in same module
	    dm.addSeparator();
	    if (potdivby.get(getmodule()) !=null ) for (final qtset qqd : potdivby.get(getmodule()))
		if (qqd.checkcomplexity() && checkunitsmatch(qqd, aty)) dm.add(dbaction(qqd.getTitle(), qqd, aty));
	    dm.addSeparator();
	    //other modules
	    for (module m : potdivby.keySet()) if (m!=getmodule()) {
		jcmMenu submenu=new jcmMenu(labman.getTitle( m.getFullName()));
		for (final qtset qqd : potdivby.get(m)) if (qqd.checkcomplexity()  && checkunitsmatch(qqd, aty)) submenu.add(dbaction(qqd.getTitle(), qqd, aty));
		if (submenu.list.size()>1) dm.add(submenu);
		if (submenu.list.size()==1)  dm.add(submenu.list.get(0));
		//note it might be zero, due to complexity
	    }
	    return dm;
	}
	return null;
    }
    
    boolean checkunitsmatch(qtset qqd, qt.Type aty) {
	if (aty==aty.ratio) return true;
	qtset qqc= (aty==aty.extra ? qqa : this);
	return  qqc.units.substring(units.indexOf("&")+1).equals(qqd.units.substring(qqd.units.indexOf("&")+1));
	//assumes there is a mega/giga etc. before &, see also method units.sameAs, however qtset units is just a string
    }
    
    Action dbaction(String name, final qtset qqd, final qt.Type aty) {
	return new jcmAction(name)  { public void act() {
	    if (aty==aty.ratio)  addnewderiv(qt.Type.ratio, qqd);
	    if (aty==aty.difference)   addnewderiv(qt.Type.difference, qqd);
	    if (aty==aty.extra) addExtra(qqd);
	}};
    }
    
    public jcmMenu compareworldmenu() {
	jcmMenu cwm=new jcmMenu(" Compare Worlds... ");
	for (final qt q : map.values())   cwm.add(new jcmAction("Compare&"+q.name) {
	    public void act() {  addderiv(compareworld(q)); }
	});
	return cwm;
    }
    
    
    /****************  EXTRAQQ ****************
     extraqq is used by histoplot and XYplot, only initialised if needed
     does not make any new qtset, just makes a List of qtsets, starting with qqa if exists
     note old method called from histoplot removed the previous extraqq, so maximum of three - but in principle more could be possible
     */
    
    void addExtra(qtset qe) {
	if (extraqq==null) { extraqq=new ArrayList(3); if (qqa!=null) extraqq.add(qqa); }
	extraqq.add(qe);
	setaffectedby(qe); //beware this interaction will remain until disposed! -  although adding extra is called by a plot!
	changed=true;
	loop.golater("qtset addextra"); //this will make plots repaint
    }
    
    public List<qtset> qqalist() {
	return extraqq!=null ?  extraqq : Collections.singletonList(qqa);
    }
    
    
    
//****************** AUTO-DOC *********************************
    
    public String getExtraDoc() {
	return docUnits()+docCurves()+"----"+docInteracs()+autodoc.javacode(this);
    }
    
    
    public String docUnits() {
	String s="==Units==";
	s+="units: "+labman.getTitle(units)+"<br>";
	s+="timescale (years) "+sy+"-"+ey +" (step "+xstep+")<br>";
	return s;
    }
    
    public String docCurves() {
	String s="==Curves==";
	if (type!=type.normal && type!=type.total) s+=labman.getTitle(type+"&of&")+qqa.docSummary()+"<br>";
	else if (map.size()==0) s+="nocurvesyet";
	//s+=type+"<br>"; for non-normal type should link to qtset qqa and qqb instead?
	s+="<ul>"; for (qt q : map.values()) if (q.checkcomplexity()) s+="<li>"+q.docSummary(); s+="</ul>";
	return s;
    }
    
//***********************************************************
} //end class



/* no longer used -
 
	    if (o instanceof Object) Objectset=(Object)o;
	    if (o instanceof float[][]) {
		System.out.println("\nusing float[][] constructor of qtset\n");
		try {
		    int nr=0; for (float[] f : ((float[][]) o)) {  map.put(Objectset.reg.get(nr), new qt(f) ); nr++; }
		} catch (NullPointerException e) { System.out.println("Objectal qt - Objectset null!"); }
	    }
    public jcmMenu addcurvemenu(final qtset qq) {
	jcmMenu addcurve=new jcmMenu(" Add Curve... ");
	for (world w : world.worlds) {
	    for (final module m :w.mods)  {
		jcmMenu submenu=new jcmMenu(m.getfullname());
		for (final qtset qqd : m.qtsets)  if (!qqd.equals( qq) && qq.units.equals(qqd.units)) {
		    jcmMenu submenu2=new jcmMenu(qq.getName());
		    for (final qt q : qqd.map.values()) {
			final String name=(m.world!=qq.getworld() ? m.world.name : "")+"&"+q.name;
			submenu2.add(new AbstractAction(name) {
			    public void actionPerformed(ActionEvent e) {
				qq.addextra(q, name); loop.go(); doplot();
			    }
			});
		    }
		    submenu.add(submenu2);
		}
		if (submenu.getMenuComponentCount()>1) addcurve.add(submenu);
		if (submenu.getMenuComponentCount()==1)  addcurve.add(submenu.getMenuComponent(0));
	    }
	}
	return addcurve;
    }
 */

