

 /*
   QT= quantity timeseries
 see also qtset, module
  
  Note this is an infob but not interacob (to avoid too many interactions & additional overhead)
  
  INFO ABOUT QT TYPE
  A normal-type qt just stores data in an array.
  Difference, sum, ratio or rate qts store only references to other qts (qa and qb) and calculate on demand (see get method)
  This can save memory and makes code simpler but increases calculation work if repeated often,
  (therefore better to use for occasional end-of-pipe (eg plots) rather than for inner-loop qts)
  
  Note: poss alternative to calc-on-demand could be for qtset to implement interacob/module calc methods
  
   Integral stores data, since not efficient to recalc from beginning for each year
  
  Type total also stores data, but is excluded from "map without total" used for some calcs and stacked plots, also can auto-calc total if needed
  
  */

package jcm.core;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.core.tls.*;
import jcm.core.reg.region;
import java.awt.Color;
import java.util.*;

public class qt extends infob {
    
    //******FIELDS***********************
    
    private float[] a; //main array to store data, this is private, so could change the internal data storage structure (e.g. variable timestep)
    
    public int sy=module.gsy, ey=module.gey, xstep=1; //start and end years, x-step (could replace with an x-scale?)
    public static float dud=-999; //flag for no valid data
    
    public enum Type {normal, difference, sum, rate, ratio, total, frac, integral, extra }
    public Type type=Type.normal;
    qt qa, qb;
    
    
    
    //********CONSTRUCTOR*********************
    
    public qt(Object ...args) {
	int  ic=0;
	mycomplexity=complexity.normal;
	boolean clone=false;
	
	argloop: for (Object o : args) {
	    if (o instanceof qt) {
		if (qa==null) {
		    qa=(qt)o;
		    color=qa.color; name=qa.name;
		    sy=qa.sy; ey=qa.ey; xstep=qa.xstep;
		} else qb=(qt)o;
		continue argloop;
	    }
	    if (o instanceof Boolean) { clone=(Boolean) o; }
	    if (o instanceof interacob) { owner=(interacob) o; }
	    if (o instanceof float[]) {	a=(float[])o; }
	    if (o instanceof Color) {	color=(Color) o; }
	    if (o instanceof complexity) { mycomplexity=(complexity) o; }
	    if (o instanceof String) { name=(String)o; }
	    if (o instanceof Number) {
		int i=((Number) o).intValue();
		switch (ic) {
		    case 0: sy=i; break;
		    case 1: ey=i; break;
		    case 2: xstep=i; break;
		}
		ic++;
	    }
	    if (o instanceof Type) type=(Type)o;
	} //args
	
	if (a==null && (type==Type.normal || type==Type.total || type==type.integral)) a=new float[1+(ey-sy)/xstep];
	if (type==Type.integral) calcintegral();
	
	if (clone) {
	    if ((type==Type.normal || type==Type.total) && qa.xstep==xstep) System.arraycopy(qa.a, (sy-qa.sy)/xstep, a, 0, a.length);
	    else for (int y=sy; y<=ey; y+=xstep) set(y, qa.get(y));
	}
    }
    
    //******** CLONE *********************
    //this copies the qt, and it's data. Resulting type is always normal, links to qa,qb or owner are not copied, thus it is independent of the original.
    public qt cloneIndependent(Object ... args) {
	Object[] args2=new Object[args.length+2]; args2[0]=true; args2[1]=this; System.arraycopy(args,0,args2,2,args.length);	
	return new qt(args2);  // return new qt(true, this, args);
    }
    
    
    //********** CHANGE YEAR ************
    public void changeendyear(int oldey, int newey) {
	if (ey==oldey) {
	    if (a!=null) { //copy, slow!
		float[] b=new float[1+(newey-sy)/xstep];
		System.arraycopy(a, 0, b, 0, Math.min(a.length, b.length)); 
		a=b;
	    }
	    ey=newey;
	}
	if (qa!=null) qa.changeendyear(oldey, newey); 	if (qb!=null) qb.changeendyear(oldey, newey); //maybe unecessary if already found via another qtset?
    }
    
    //****** GET,  SET ***********************
    //        P2 STRUC make qt get() more efficient as  called very frequently
    //       P2 diverse names of get/set methods to make modules clearer
    
    public float get() {return get(module.year); }
    
    public float get(int year) {
	switch (type) {
	    case difference :  { return (qa!=null && qb!=null && qa.get(year)!=dud && qb.get(year)!=dud  ) ?  qa.get(year) - qb.get(year) : dud; }
	    case sum :  { return (qa!=null && qb!=null && qa.get(year)!=dud && qb.get(year)!=dud  ) ?  qa.get(year) + qb.get(year) : dud; }
	    case ratio  :  { return (qa!=null && qb!=null && qa.get(year)!=dud && qb.get(year)!=dud && qb.get(year)!=0 ) ?  qa.get(year)/qb.get(year) : dud; }
	    case frac  :  { return (qa.get(year)!=dud) ?  100*qa.get(year)/((qtset)owner).calctot(year) : dud; }
	    case rate :  { return (qa.get(year)!=dud && qa.get(year-xstep)!=dud && qa.get(year-xstep)!=0 ) ?  (100f*qa.get(year)/qa.get(year-xstep) -100f)/xstep  : dud; }
	    case integral :  //same as below
	    default : if (year>=sy && year <=ey) {float f= a[(year-sy)/xstep]; if (!Float.isNaN(f)) return f; } 
	    return dud;
	}
    }
    
    void calcintegral() { //note called from both constructor and qtset postcalc
	float tot=0;
	for (int y=sy; y<=ey; y+=xstep ) {
	    tot+=(qa.get(y)!=dud ? qa.get(y) : 0); //note ignores dud
	    a[(y-sy)/xstep]=tot;
	}
    }
    
    
    public void set(int year, float f) { if (year>=sy && year <=ey) 	a[(year-sy)/xstep]=f; }
    public void set(float f) { set(module.year, f); }
    
    public boolean gotdata(int year) {	return year>=sy && year<=ey && get(year)!=dud && !Float.isNaN(get(year)) && !Float.isInfinite( get(year)); }
    
    public int getyear(int n) {	return sy+xstep*n; }
    public int getn(int year) {	return (year-sy)/xstep; }
    
    public float[] geta() {	return a; }
    
    public int getlength() { return type==Type.normal  || type==Type.total?  a.length : qa.a.length ;    }
    
    //********************* MAX /MIN ************
    float getmax() {
	float max=Float.MIN_VALUE;
	for (int y=sy; y<ey; y+=xstep) if ( get(y)>max  && get(y)!=dud) max=get(y);
	return max;
    }
    
    float getmin() {
	float min=Float.MAX_VALUE;
	for (int y=sy; y<ey; y+=xstep) if ( get(y)<min  && get(y)!=dud) min=get(y);
	return min;
    }
    
//****************** DOC / INFO ************
    
    public String curveinfo() {
	String name2=labman.convertkey(name);
	return "<li>"+autodoc.hexcolor(color)+labman.getShort(name2)+(labman.getTitle(name2) !=labman.getShort(name2) ? " "+labman.getTitle(name2) : "")+"}- %% >>"+name2+" %%";
    }
    
    
    public String getLabel(){  return labman.getTitle(name); } //note for qt switched from short form (very short, for legend) to medium form
    
    public String docSummary() { 
	String name2=labman.convertkey(name);
	return  hashcolor()+ autodoc.link(name2, getTitle()+labman.getShortIfDifferent(name2))+  "</font> " + "%"+name2+"<br>"; 
    }
//" <br>%%"+ getIcon()+ labman.getDoc(name)+"%%<br>"; } //problem is that doesn't stop further parsing
    public String getExtraDoc() { return  docOwner()+autodoc.javacode(owner) ;     }
    
} //end class






