 /*
 module: superclass of all the main science calculation modules
 is an owner of params and qtsets
 has loop methods (maybe move to interface?)
  
  */

package jcm.core;

import java.util.*;
import jcm.core.itf.modloop;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import static jcm.core.report.*;

public class module extends interacob implements modloop {
    
    
    //*********** FIELDS ************
    public world world;
    public boolean affectsfutureonly=false;
    
    public boolean err; //used by loop to flag RuntimeExceptions
    
    
    public Vector<qtset> qtsets=new Vector();
    public Vector<param> allparam=new Vector();
    
    public String getFullName() {	return  world.name+"&"+name; }
    
//************ STATIC TIME ***************
    public static int year=0; //time variable changed before loop calcstep - shared by all modules
    //constants specifying years: global start year, global end year,  future start year
    //note gey is user-adjustable, fsy is changed occasionally as data is updated
    static public int    gsy=1750,   fsy=2003,    gey=2200;
    
    
    // ************ CREATE MODULE **************
    public static module createMod(infob orig, world w) {
	module mod;
	//first check if we have already got this module in this world
	try {
	    mod= w.get( (Class<? extends module>) Class.forName(orig.getName()) );
	    if (mod!=null) return mod;
	} catch (ClassNotFoundException e) {   deb(e);  } //should never be thrown, while we search a JAR made of classes
	
	//make a new instance of module
	try {
	    Class c=w.getClass().getClassLoader().loadClass(orig.getName());
	    if (module.class.isAssignableFrom(c)) {
		mod= (module)(c.newInstance());
		mod.world=w;
		mod.checkinfo();
		//mod.register(); moved AFTER  initsetup
		w.mods.add(mod);
		w.modmap.put(mod.getClass(), mod);
		return mod;
	    }
	} catch (Exception e) {  deb(e); }
	return null; //new infob(ss);
    }
    
    
    
    //****************************
    //INITSETUP & REGISTER
    //world first creates all modules, then for each one calls first initsetup then register
    
    public void initsetup() {	}
    
    public void register() {     //extends interacob register to find fields of qtsets, params etc.
	super.register();
	
	Set s= jcm.core.tls.ref.getallobs(this);
	
	for (Object o : s) {
	    if (o instanceof infob)  ((infob) o).owner=this;
	    if (o instanceof interacob  && o!=this) {
		((interacob)o).register();
		//if (o instanceof param) params.addOb(o); else
		addOb((infob)o);
	    }
	    if (o instanceof qtset)  { qtsets.add((qtset)o); ((qtset)o).setaffectedby(this);  }
	    if (o instanceof param) { allparam.add((param)o); ((param)o).setaffects(this); }
	}
	
	/*
	 This causes too much trouble with the documentation of intermediate infobs, and also with the hideenabledobs
	//if contains both params and curves, make sub_infobs for tree
	if (allparam.size()>3 && qtsets.size()>0) {
	    infob params = new infob(name+"&Params");
	    for (param p : allparam) { removeOb(p); params.addOb(p); }
	    params.mincomplexity();
	    addOb(params);
	}
	if (qtsets.size()>3 && allparam.size()>2) {
	    infob  curves= new infob(name+"&Curves") ; //for trees and menus
	    for (qtset qq : qtsets) { removeOb(qq); curves.addOb(qq); }
	    curves.mincomplexity();
	    addOb(curves);
	}
	 */
	if (mycomplexity==null) mincomplexity();
	
	addAction(filter.filtertype.Doc);
	addAction(filter.filtertype.interacmap);
	addAction(filter.filtertype.Tree);
	addAction(filter.filtertype.Source);
    } //register
    
    
    //****************** MOD ORDER ****************
    static void setmodorder(world w) {
	boolean changed=false;  int nit=0;
	do {  changed=false; nit++;
	for (module m : w.mods) for (module mf : m.follows) if (m.order<=mf.order) { m.order=mf.order+1; changed=true; }
	} while (changed && nit<=100);
	if (nit>100) log("Circular module dependencies! "); //stops infinite loop
	Collections.sort(w.mods);
	//String s="Module order: "; for (module m : mods) {s+=m+" ( F:  "; for (module mf : m.follows) s+=mf+", "; s+=") "; } System.out.println(s);
    }
    
    
    //*******************************
    //MODLOOP methods
    
    //before main calc loop
    public void precalc() {} //note some params also have a precalc method, which runs before any modules
    public void startstate(int startyear) {}
    
    //calc just one timestep in time loop
    public void calcstep() {}
    
    //save state in 1999 for calc future only
    public void save99() {}
    
    //after main loop
    public void postcalc() {}
    
    //*******************************
    //refer to other modules
    
    public <T extends module> T    get(Class<T> c) { return world.get(c); }
    
    
    //*******************************
    //set order
    Set<module> follows=new HashSet();
    public int order=0; //calculation order
    
    public void setaffectedby(Class c) { setaffectedby(get(c)); }
    public void setaffectedby(Class c, boolean b) { setaffectedby(get(c), b); }
    public void follows(Class c) { follows(get(c), true); }
    public void follows(Class c, boolean b) { follows(get(c), b); }
    
    public void follows(module m) { follows(m, true); }
    public void follows(module m, boolean b) {
	if (b) follows.add(m); else follows.remove(m);
	setaffectedby((interacob)m, b);
    }
    
    public int compareTo(infob o) {
	int i=0;
	if (o instanceof module) i= (order-((module)o).order);
	if (i!=0) return i; else return super.compareTo(o);
	// note it's important not to return 0, or considered equal and not added to Sets such as infob Obs'
    }
    
    
    // ********* CHECK TIME SPENT ***************
    static long lasttimecheck = System.currentTimeMillis(), oldtime = lasttimecheck;
    
    public  static void reporttime(String info){
	lasttimecheck = System.currentTimeMillis();
	deb(info+": time since last report "+(lasttimecheck - oldtime)+" ms"); oldtime = lasttimecheck;
    }
    
    public static void debug(Object ... args) { String s=""; for (Object o : args) s+="\t\t"+o.toString(); deb(s); }
    
    // *********** AUTO DOC ****************
    String doccurves="", docparams="";
    
    public String getExtraDoc() {
	doccurves="";
	for (qtset qq : qtsets) if (qq.checkcomplexity())  { doccurves+="<li> "+qq.docSummary();   }
	if (doccurves.length()>0) doccurves= "===@qtsets=== <ul> "+doccurves+ " </ul>";
	docparams="";
	for (param p : allparam) if (p.checkcomplexity()) {  docparams+="<li> "+p.docSummary(); }
	if ( docparams.length()>0) docparams= "===@Params=== </ul> "+docparams+ " </ul>";
	
	return (doccurves.length()>0 ? " ---- ^curves " : "") + (docparams.length()>0 ? " ---- ^params " : "") + " ---- ^interacs ";
    }
    
    public String getSpecificDoc(Object ... args) {
	if (args[0].equals("curves")) return doccurves;
	if (args[0].equals("params")) return docparams;
	if (args[0].equals("interacs")) return docInteracs()+" ---- "+autodoc.javacode(this);
	return "<p><b>!specific doc request "+args[0] +" for "+name+" no longer implemented!</b><p> ";
    }
    
 
} //end module


//******************************

/*SUBMODULE
not currently used
P1 STRUC / TIDY replace submodule by paramset similar to qtset, for better organising menus?
 
   /*
public Vector<module> submod=new Vector();
if (o instanceof module && o!=this) submod.add((module)o); //not currently used
 
    public module(Object ... args) {
	for (Object a : args) {
	    if (a instanceof module) {	owner=(iob) a; }
	    if (a instanceof param[]) {	for (param p : (param[])a) allparam.add(p); }
	    if (a instanceof Color) {	color=(Color) a; }
	    if (a instanceof complexity) { mycomplexity=(complexity) a; }
	    if (a instanceof String) {  name=(String)a; }
	}
	register();
	//		initsetup(); -getiobs in constructor crashes startup!
    }
 */



