/*
 Main calculation loop through iobs, modules, etc.
 See notes at end
 */

package jcm.core;
import java.awt.Dialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import static jcm.core.register.*;
import static jcm.core.module.*;
import static jcm.core.report.*;
import jcm.gui.nav.showpan;


public class loop   {
    
    
    //***********************************
    public static boolean
	    calcfutureonly=false, //affects both pans and mods -may be set true by controls
	    checkmemory=false;
    
    //************* CHECK PERFORM ********************************
    public static param checkperform=new param("loopinfo", false, complexity.expert);
    
    static long inttime=0, tottime=0, oldtime=0, newtime=0, timediff=0, timelastgc=0;
    static String info="";
    
    
    
    //************* END YEAR *************
    public static param modendyear=new param("Model End Year", "", 2200, 2100, 3000, complexity.expert) {
	public void set(double d) { // before loop starts, for effect of setting changed
	    for (interacob i : register.alliobs) {  i.changeendyear(gey, (int)d);  i.changed=true; }
	    if (endyear==module.gey) endyear=(int)d;
	    gey=(int)d;
	    super.set(d);
	}
    };
    
    public static int startyear=gsy, endyear=gey;
    
    //***************** STARTING LOOP  *********************
    //queuing system to avoid two loops running at the same time, but also don't accumulate loop calls
    //see notes in loopreg.todo
    
    private static boolean  settogo=false, swingbusy=true; //for queuing loop calls
    public static boolean  changeTreeStruc=true;  //used by tree, to avoid replotting tree within an iteration
    //P2 STRUC tree and interacmap need to replot (slow) if interactions changed, but often they don't especially if call from calc loop - maybe separate loop call from setallinteractions?
    private static Object looplock=new Object(), swinglock=new Object();
    private static Thread loopthread=null;
    private static JOptionPane jop=null;
    
    /*set loop to go as soon as possible, and wait for result before continuing this thread
    should use this from calculation scripts, iterations, plot setup etc.
     
     problem can arise during reset:
     setup thread calls resetall
     look and feel updated
     that triggers big work in AWT thread, presumable ith invoke&Wait somewhere,
     but AWT thread is already blocked by the setup thread...
     */
    
    
    public static void gonow()  { gonow(true); } //by default, assume treestruc has changed
    
    public static void gonow(boolean cts)  {
	settogo=true;
	boolean ok=waitUntilLoopDone(); //if already running, maybe started before recent changes set
	if (ok && settogo && loopthread==null) {
	    changeTreeStruc=cts; runloop();
	} else waitUntilLoopDone(); //if another waiting thread got priority and restarted loop before this
    }
    
    /*
     set loop to go once everything else has finished
     (e.g. after any other loop finished  AND after GUI ready (eg buttons respond)
     note this doesn't wait for result - will return immediately
     
      should use this from most actions responding to mouse events
     a background thread waits while loop is busy
     then queues the call to end of event dispatching thread (wait for any GUI response)
     then runs loop if it is still needed (might not be, if another thread cancelled settogo)
     
     note: the waiting has its own thread, but the loop itself is run in event dispatching thread, otherwise parameters can be changed in the middle of a loop
     P3 reconsider golater and params
     */
    
    public static void golater() { golater("Run Later", true); }
    public static void golater(String name) { golater(name, true); }
    public static void golater(String name, final boolean cts) {
	changeTreeStruc=cts;
	if (settogo) return;
	settogo=true;
	new Thread(name) {
	    public void run() {
		final boolean ok=waitUntilLoopDone();
		SwingUtilities.invokeLater(new Runnable() { public void run() { if (ok && settogo && loopthread==null)  { changeTreeStruc=cts; runloop(); }}});
		//waitForSwing();
		//if (ok && settogo && loopthread==null)  { changeTreeStruc=cts; runloop(); }
	    }
	}.start();
    }
    
    public static void waitForSwing() {
	swingbusy=true;
	SwingUtilities.invokeLater(new Runnable() { public void run() { swingbusy=false; synchronized(swinglock) { swinglock.notifyAll(); }}});
	while (swingbusy) { synchronized(swinglock) { try {  swinglock.wait(); } catch (InterruptedException e) {} } }
    }
    
    public static boolean waitUntilLoopDone() {
	if (loopthread==null) return true;
	if (loopthread==Thread.currentThread()) {    deb("!\t"+Thread.currentThread().getName()+" called waitUntilLoopDone from within own loop! ");    return false; 	}
	if (SwingUtilities.isEventDispatchThread()) {  deb("!\tEvent Dispatching Thread cannot wait for "+loopthread.getName()+" ... loop skipped");  return false; }
	
	String threadinfo="\t... ."+Thread.currentThread().getName()+" is waiting for "+loopthread.getName()+" which is busy doing: ";
	while (loopthread!=null) {
	    synchronized (looplock)  {
		deb(threadinfo+" "+info); threadinfo="-...(waiting)... ";
		try {
		    looplock.wait(4000); //will stop once notifyAll is called at end of runloop
		} catch (InterruptedException e) { deb("looplock wait interrupted"); }
	    }
	}
	deb("-... ok go now");
	return true;
    }
    
    private static void runloop() {
	loopthread=Thread.currentThread();
	String name=loopthread.getName();
	settogo=false;
//	deb("loop started by "+name);
//	startcheck(5000);
	try {
	    mainloop();
	} catch (Exception e) { deb(e, "Exception caught by runloop from "+name+ " doing "+info); }
//	deb("-finished loop OK");
	synchronized (looplock) { loopthread=null; looplock.notifyAll(); }
    }
    
    
//***************** MAIN CALCULATION LOOP **********
    
    private static void mainloop() {
	info="";
	boolean check=checkperform.istrue();
	
	if (check) {  oldtime=System.currentTimeMillis(); tottime=oldtime; }
	
	//************* INTERACTIONS **************
	//if (repeat || scin) setchangedifneeded(itc, itn);
	info="interactions";
	try {
	    setallinteractions();
	    jcm.gui.gen.interacmap.reset();
	} catch (RuntimeException e) {	log(e, "Loop Interactions Problem"); }
	
	if (check) {
	    for (interacob i : alliobs) i.timespent=0;
	    inttime= System.currentTimeMillis() - oldtime;
	}
	
	//for (interacob i : alliobs) if ( (i instanceof param) && ((param)i).type==param.Type.Xscale && i.changed) deb(" "+i+" changed");
	//for (interacob i : alliobs) if ( (i instanceof param) && i.needed) deb(" "+i+" needed");
	
	//************ PRECALC ***************
	for (interacob i : alliobs) if ( (i instanceof param) && i.needed && i.changed && !i.skip) {
	    try {
		info="precalc "+i.name;
		//deb("loop called "+i.name+ "precalc");
		((param)i).precalc();
		if (check) checktimespent(i);
	    } catch (RuntimeException e) {	catcher(e, 1, i, false); }
	}
	
	//************* MODLOOP **************
	//should world really be outer loop? - not if interactions between worlds!
	for (world w : world.worlds)  {
	    info="world "+w.name;
	    module.setmodorder(w);
	    
	    /*
	 calcfutureonly is only for efficiency, but not currently working correctly:
	 currently only sres, shares and stabilisation set affectsfutureonly=true
	should check this between needed and changed loops? -ie should depend only on the trigger of the change, if needed
	     */
	    calcfutureonly=true; for (module m : w.mods) if (m.needed && m.changed) calcfutureonly&=m.affectsfutureonly;
	    startyear=(calcfutureonly ? 2000 : 1750);
	    //if (calcfutureonly)	deb("calcfutureonly");
	    
	    //main loop of modules through timesteps
	    for (module m : w.mods) m.err=false;
	    
	    for (module m : w.mods) if (m.needed && m.changed)
		try {
		    info="precalc "+m.name;
		    m.precalc();
		    if (check) checktimespent(m);
		} catch (RuntimeException e) {	catcher(e, 2, m, false); }
	    
	    
	    for (int y=startyear; y<=endyear; y++) {
		module.year=y;
//if (y%50==0) deb("\nyear "+y);
		for (module m : w.mods) if (m.needed &&m.changed){
		    try {
			info="calcstep "+m.name+" "+y;
			if (y==startyear) m.startstate(startyear);
			m.calcstep();
			if (y==1999) m.save99();
			if (check) checktimespent(m);
		    } catch (RuntimeException e) {	if (!m.err) {	m.err=true; catcher(e, y, m, false); }}
		    if 	(module.year!=y) log("! module year="+module.year+" loop y="+y+" mod="+m.name); //check that module year not changed, except by this loop!
		}
	    }
	    
	    //********************* POSTCALC*************
	    for (module m : w.mods) if (m.needed && m.changed)
		try {
		    info="postcalc "+m.name;
		    m.postcalc();
		    if (check) checktimespent(m);
		} catch (RuntimeException e) {	catcher(e, 2, m, false); }
	    
	    for (interacob i : alliobs) if ( (i instanceof qtset) && i.needed && i.changed && !i.skip) {
		try {
		    info="postcalc "+i.name;
		    ((qtset)i).postcalc();
		    if (check) checktimespent(i);
		} catch (RuntimeException e) {	catcher(e, 1, i, false); }
	    }
	    
	} //worlds loop
	
	//********************** PLOTS, RESET, CHECKS ************
	info="doplots";
	try {
	    doplots(); //plot plotlinks -see register
	} catch (RuntimeException e) {	log(e, "Loop Doplots Problem"); }
	
	info="ending loop";
	//cancel iobs changed since all done
	for (interacob i : alliobs) if (i.needed && i.changed && !i.skip) i.changed=false;
	
	if (check) reporttimespent();
	
	if (checkmemory) info=("memory: free="+(int)(100.0*Runtime.getRuntime().freeMemory()/Runtime.getRuntime().totalMemory())+"%");
	
	//force garbage collect, but not too frequently (eg when dragging param)
	long time=System.currentTimeMillis(); if ((time-timelastgc)>5000) { System.gc();  timelastgc=time; }
	
	if (checkmemory) log(info+" after-gc= "+(int)(100.0*Runtime.getRuntime().freeMemory()/Runtime.getRuntime().totalMemory())+"%");
	
	calcfutureonly=false;
	changeTreeStruc=true;
	
    } //mainloop
    
//********************** DEBUG **************
    static void catcher(RuntimeException e, int y, interacob i, boolean owneff) {
	String problem="runtime exception in loop year "+y+" "+i.owner.name+(owneff ? " effectof " : ".")+i.name+" => "+e;
	log(e, problem);
    }
    
//		try {	deb("waiting for input"); System.in.read(); } catch (Exception e) {	}
    
    
//****************** PERFORMANCE *********************************
    
    static void checktimespent(interacob i) {
	newtime=System.currentTimeMillis();
	i.timespent+=newtime-oldtime;
	oldtime=newtime;
	if (i.timespent==0) i.timespent=-1; //so report
    }
    
    static void reporttimespent()  {
	tottime=System.currentTimeMillis()-tottime;
	info="LOOP (time /ms)  total: "+tottime+ " interactions: "+inttime+" ";
	for (interacob i : alliobs) 	if (i.timespent!=0) {
	    info+=( (i.owner.getName()==i.name ? "" : i.owner.getName()+".") + i.name+": "+i.timespent+" ");
	}
	log(info);
    }
    
//************************************************
} //end loop class




/***********************************************
 
 // experimental - not currently used - see notes below
 class runner extends Thread {
 
 public void run() {
 if (!loop.inmainloop) {  loop.mainloop(); return; }
 if (loop.inmainloop && !loop.waiting) {
 loop.waiting=true;
 setPriority(Thread.MIN_PRIORITY);
 while (loop.inmainloop) try { sleep(100); } catch (InterruptedException e) { }
 loop.waiting=false;
 loop.mainloop();
 }
 }//run
 
 }//end runner
 
 
 public static interacob[] itc, itn; //to stop output plotting during iterations
 public static boolean	    repeat=false, scin=false, //used for iteration - OLD remove!
 
 */
/*****************************************************
 /*
 private static void startcheck(final int duration) {
 new Thread("Loop Checker") {
 //	    Dialog d;
 public void run() {
 while (loopthread!=null) {
 synchronized (looplock)  {
 try {    sleep(duration); 	} catch (InterruptedException e) { deb("loop checker interrupted"); }
 if (loopthread==null && jop==null) {
 //			jop=new JOptionPane( "Stop operation?", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
 //			d=jop.createDialog(showpan.mf,  "JCM loop may be stuck!");
 //			d.setModal(false); d.setVisible(true); try { d.toFront(); } catch (Exception e) {};
 deb(loopthread.getName()+" doing "+info);
 }
 }
 //		    if (jop!=null) deb("option chosen="+jop.getValue());
 //if (((Integer)jop.getValue()).intValue()==JOptionPane.YES_OPTION) { loopthread.stop(); loopthread=null; }
 } // no longer busy
 //		if (d!=null) { d.setVisible(false); d.dispose(); d=null; jop=null; }
 }
 }.start();
 }
 */
