/*
Extension of Action that is easier to write, and has complexity
 */
package jcm.core;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import jcm.core.itf.hasComplexity;
import jcm.gui.doc.labman;
import static jcm.core.report.*;

public class jcmAction extends AbstractAction implements hasComplexity {
    
    complexity mycomplexity;
    public complexity getComplexity() { return mycomplexity; }
    
    public jcmAction(String s) { this(s, complexity.normal); }
    public jcmAction(String s, complexity c) { 	super(s); mycomplexity=c;    }
//    public jcmAction(String s, complexity c) { 	super(labman.getShort(s)); mycomplexity=c;    }
    
    public void actionPerformed(ActionEvent e) { act(); }
    public void act() {}; //to overwrite
    
    public jcmAction clone(String s) { try {  jcmAction a= (jcmAction) super.clone(); a.putValue(Action.NAME, s); a.mycomplexity=mycomplexity; return a; } catch (CloneNotSupportedException e) { deb(e); return null; } }
    
}
