 /*
 This class is extended by many objects that have name, color, documentation, complexity etc.
 including all iobs (modules, params, qtsets) but also others (qts, regions)
  */

package jcm.core;

import java.util.*;
import javax.swing.*;
import java.awt.Color;
import jcm.core.itf.hasComplexity;
import jcm.core.itf.menuFiller;
import jcm.gui.doc.*;
import jcm.gui.gen.*;
import jcm.gui.nav.*;
import jcm.core.tls.ref;
import jcm.script.calcscript;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.filter.filtertype.*;
import static jcm.core.filter.filtertype;
import static jcm.core.report.*;

public class infob implements menuFiller,  Comparable<infob>, hasComplexity {
    
    
    //****************************
    //FIELDS
    // data about this infob [ keep to a minimum as there are many infobs - eg all curves, all regions! ]
    
    public String name=getClass().getSimpleName();
    /*
   name should be same as #codes in labdoc files, used for labels, documentation and scripting
   note names not necessarily unique, but owner.getname()+name usually unique
     */
    
    public infob owner=this;
    
    public Set<infob> obs; // descendents in the tree
    public Map<jcmAction, filter.filtertype> actions; // appear in tree / menus / popups
    
    //these affect the display of a component
    public complexity mycomplexity;
    public Color color=Color.black;
    
    public double priority=1, cump=0; //higher number displayed higher in tree/menu
    public boolean disposed=false;	//if true, no longer active, should be ignored and evenutally garbage-collected
    
    
    
//******************************
    //CONSTRUCTOR
    public infob() { color=rcol(); } //a basic constructor to prevent superclasses calling below, even if they have own (Object ... args) constructor
    
    public infob(Object... args) {
	color=null;
	for (Object o : args) {
	    if (o instanceof infob) { owner=(infob)o; if (color==null)  color=(this instanceof  world) ? rcol() :  rcol(owner.color); }
	    if (o instanceof String) { 	name=(String)o;  checkinfo();    }
	    if (o instanceof Color) color=(Color)o;
	    if (o instanceof Number) priority=((Number)o).floatValue();
	}
	if (color==null) color=Color.black;
    }
    
    //**************** DEFAULT COLORS / PRIORITIES **********
    //convenient to put here rather than in each module separately - but maybe even better to load a text file?
    
    public void checkinfo() {
	for (Object[] oo : setupinfo) if (removepackagename(name).equals((String)oo[0])) { priority=(Double)oo[1]; if (oo.length==3) color=(Color)oo[2]; return; }
    }
    
    static Object[][] setupinfo=new Object[][] {
	{"mod", 2.0},
	{"obj", 6.0, dkblue}, { "soc", 5.0, brown}, {"luc", 4.5, green}, {"carbon", 4.0, black}, {"ogas", 3.0, dkgreen}, { "cli", 2.0, dkred}, { "reg", 1.0, dkpurple},
	{"socreg", 2.0}, {"controller", 2.0}, {"costs", 0.8},  {"optimisation", 0.8},  {"othgasemit", 2.0 }, {"carboncycle", 2.0}, {"carbonatechemistry", 0.8},
	{"radfor", 2.5}, {"glotemp", 2.0}, { "udebclimod", 1.5}
    };
    
//**************************** ACTIONS *****************************
    
    public void addAction(jcmAction a) { addAction(null, a); }
    public void addAction(filter.filtertype f, jcmAction a) {
	if (actions==null) actions=new LinkedHashMap();
	actions.put(a, f);
    }
    public void addAction(filter.filtertype f) {
	if (actions!=null && actions.containsValue(f)) return; //for unique actions, only make once
	if (f==f.Doc) addAction( f, showpan.pan("Doc&"+name, docview.class, name));
	if (f==f.Tree) addAction(f, showpan.pan("Tree",  jcmTree.class, "["+this+"]"));
	if (f==f.interacmap) addAction(f, showpan.pan("interacmap", interacmap.class, this));
	if (f==f.Source) addAction(f, showpan.pan("Source" , sourceview.class, getSourceFileName()));
	if (f==f.Data) addAction(f, showpan.pan("Data", sourceview.class,  getDataFileName()) );
    }
    
    //this converts the last / to a ., since root
    String getDataFileName() { String f=getName().replace(".", "/"); int i=f.lastIndexOf("/"); if (i>0 && i<f.length()) f=f.substring(0,i)+"."+f.substring(i+1,f.length()); return f; }
    String getSourceFileName() { String s=((this instanceof module) ? getClass().getName() : getName()); return  "source/"+s.replace(".", "/")+".java"; }
    
    void addClassActions() {
	try {
	    final Class c=Class.forName(getName()) ;
	    if (java.lang.reflect.Modifier.isPublic(c.getModifiers())) addAction(filtertype.Source); //checking public is avoids finding inner classes for which no separate source file
	    if ( calcscript.class.isAssignableFrom(c)) 	addAction( filtertype.Scripts, new   jcmAction(c.getSimpleName()) {	public void act() {    try {  ((calcscript)c.newInstance()).start();  } catch (Exception ex) {deb(ex, "Problem Starting Script");}}});
	} catch (ClassNotFoundException e) {
	    addAction(filtertype.Data);
	}
    }
    
    public boolean hasEnabledActions(Set<filtertype> fs) { if (actions!=null)  for (jcmAction a : actions.keySet()) if (checkenabled(a, fs)) return true; return false; }
    
    public void doFirstEnabledAction(Set<filtertype> fs) {
	if (actions!=null) for (jcmAction a : actions.keySet()) if (checkenabled(a, fs)) { a.act(); return; }
    }
    
//********COMPLEXITY**********************
    void mincomplexity() { mincomplexity(getObs()); }
    void mincomplexity(Collection<? extends infob> obs) { //sets complexity according to minimum of containing obs
	if (obs!=null) {
	    mycomplexity=experimental;
	    for (infob o : obs) mycomplexity=o.getComplexity().compareTo(mycomplexity)<0 ? o.getComplexity() : mycomplexity ;
	}
    }
    
    public complexity getComplexity(){ return mycomplexity!=null ? mycomplexity : complexity.normal; }
    public boolean checkcomplexity() { return complexity.check(getComplexity()); }
    
//************** ENABLED *******************
    public boolean checkenabled(Action a, filter.filtertype f) { return (actions.get(a)==null || actions.get(a)==f); }
//return f.toString().equals(a.getValue(a.NAME).toString());
    public boolean checkenabled(Action a, Set<filter.filtertype> fs) { for (filter.filtertype f : fs) if (checkenabled(a,f)) return true; return false; }
    
    public boolean checkenabled(filter.filtertype f) { return checkenabled(Collections.singleton(f)); }
    public boolean checkenabled(Set<filter.filtertype> fs) {
	if (!checkcomplexity()) return false;
	if (this instanceof param && (fs.contains(AllParams) || (fs.contains(NeededParams) && ((param)this).checkneededforplot()) 	)) return true;
	if (this instanceof qtset && fs.contains(Curves)) return true;
	if (actions!=null) for (Action a : actions.keySet()) if (checkenabled(a, fs)) return true;
	if (obs!=null) for (infob o : obs) if (o.checkenabled(fs)) return true;
	return false;
    }
    
    
//*************** FILL MENU *************
    
    public void fillMenu(jcmMenu m) {
	fillMenu(m, filter.all());
    }
    
    public void fillMenu(jcmMenu m, Set<filter.filtertype> fs) {
	if (actions!=null) for (Action a : actions.keySet()) if (fs==null || checkenabled(a, fs)) m.add(a);
    }
    
    public static EnumSet singleaction =EnumSet.of(Doc, Scripts, Source, Data, Maps);
    
    public void fillTreeMenu(jcmMenu m) {
	List<infob> enabobs=getEnabledObs(m.filters);
	if (m.isTopLevelMenu() && enabobs!=null && enabobs.size()==1 && !hasEnabledActions(m.filters)) { enabobs.get(0).fillTreeMenu(m); return; } //if only one item in tree, skip to it
	fillMenu(m, m.filters);
	if (enabobs!=null) for (infob i : enabobs)    {
	    if (m.filters.size()==1 && singleaction.containsAll(m.filters) && i.getEnabledObs(m.filters)==null && i.actions!=null) {
		for (jcmAction a : i.actions.keySet()) if (i.actions.get(a)==m.filters.iterator().next()) m.add(a.clone(i.name));
	    } else m.add(i);
	}
	if (m.filters.size()==1) m.add(showpan.pan(docview.class, "About&"+m.filters.iterator().next()+"Menu"));
    }
    
    
//******** WORLD **********************
    public world getworld() {
	if (owner instanceof world) return (world)owner;
	if (owner instanceof module) return ((module)owner).world;
	if (owner ==this) return null;
	return owner.getworld();
    }
    
    public module getmodule() {
	if (owner instanceof module) return (module)owner;
	if (owner ==this) return null;
	return owner.getmodule();
    }
    
//********* OBS, OWNER  *******************
    public infob getOwner(){  return owner; }
    public Set<infob> getObs(){  return obs; }
    
    public List<infob> getEnabledObs(Set<filter.filtertype> fs) {
	if (obs==null) return null;
	List<infob> eo=new ArrayList();
	for (infob o : obs) if (o!=null && o.checkenabled(fs)) eo.add(o);
	if (eo.size()>0) return eo; else return null;
    }
    
    public void addOb(infob b) {
	if (getObs()==null) obs=new TreeSet();
	getObs().add(b);
	b.priority+=cump; cump+=0.01; //cump increases, so we preserve the adding order (if no other criteria)
    }
    
    public int compareTo(infob b) {
	int i= (int)Math.signum(b.priority-priority);
	if (i==0) i=name.compareTo(b.name);
	if (i==0) return (this.equals(b)) ? 0 : this.hashCode()-b.hashCode(); //note important not to return zero unless they are really equal objects
	return i;
    }
    
//	   else return a.getClass().getName().compareTo(b.getClass().getName());
    
    public void removeOb(Object h) { getObs().remove(h); }
    
    public infob find(String s) { return find(this, s); }
    public infob find(Object orig, String s) {
	String s2=s.toLowerCase();
	if (obs!=null) {
	    for (infob o : obs) if (o.toString().equals(s)) return o;
	    for (infob o : obs) if (o.toString().toLowerCase().equals(s2)) return o;
	    for (infob o : obs) if (o !=orig) { infob oo=o.find(orig, s); if (oo!=null) return oo; } //recursive, beware loops!
	}
	return null;
    }
    
//******** DISPOSE ****************************
//clear all Obs and all children, beware recursive!
//note extended by interacob, but also called directly from world
    
    //P3 dispose should be synchronized with loop
    public void disposeLater() {
	//must run outside of loop - also maybe slow so let gui respond first
	SwingUtilities.invokeLater(new Runnable(){ public void run() {
	    loop.waitUntilLoopDone();
	    disposethis();
	    jcmTree.restruclink.changed=true;
	    loop.gonow();
	}});
    }
    
    void disposethis() {
	if (disposed || ref.isstatic(this, owner)) return;   //avoid infinite loop in case circular owner links, and also ignore static iobs
	disposed=true;
	name+="&disposed";
	if (obs!=null) { for (infob i : obs)  i.disposethis();	obs=null; }
    }
    
    
//***********COLOR ***************
    
    public Color getColor() { return color; }
    public String hashcolor() {   return hashcolor(getColor()); }   //color for html use in Jlabels
    public static String hashcolor(Color c) {   return "<font color=#"+hex2(c.getRed())+hex2(c.getGreen())+hex2(c.getBlue())+" >";    }
    public static String hex2(int x) { return (x<16 ? "0" : "")+Integer.toHexString(x); }
    public static Color rcol() {	return new Color((int)(255*Math.random()),(int)(255*Math.random()),(int)(255*Math.random())).darker(); }
    public static Color rcol(Color b) {	if (b==null) return rcol();
    else          return new Color((int)(127f*Math.random()+b.getRed()/2f),(int)(127f*Math.random()+b.getGreen()/2f),(int)(127f*Math.random()+b.getBlue()/2f)).darker();
    }
    
//************* NAME AND DOC ***************
    
    public String toString() {return getName(); }
    public String getName(){  return name; }
    public String getFullName() {	return  (owner != this ? owner.getFullName()+"&" : "") +name; }
    public String getNameWithWorld() { return world.worlds.size()>1 ? (getworld() != null ? getworld().name+"&" : "null&") +name : name; }
    public static String removepackagename(String s) {	int i= s.indexOf("."); return i>0 ? removepackagename(s.substring(i+1)) : s ; }
    public String type() { return getClass().getSimpleName(); } //for modules, same as name, but for params and qtsets different
    
    public String getLabel(){  return labman.getShort(name); } //note for qt, switched to getTitle as the short form is very short (for legend)
    public String getTitle(){  return labman.getTitle(name); }
    
    public String getExtraDoc() { return ""; }
    
    public String getSpecificDoc(Object ... args) {
	return "<p><b>!specific doc request "+args[0] +" for "+name+" no longer implemented!</b><p> ";
    }
    
    public String docSummary() {
	try {
	    getClass().forName(name);  String n2=removepackagename(name);  return autodoc.link(n2)+  "</font> " + "%"+n2+"<br>";
	} catch (ClassNotFoundException e) {  return autodoc.link(this)+  "</font> " + "%"+labman.convertkey(name)+"<br>";  }
    }
    
    public String docOwner() {
	return (owner!=this) ? "<nobr>%%cogs `memberof  "+ autodoc.link(owner.name)+"%%</nobr><br>" : "";
    }
    
//************ COMPONENT  & MENU & ICON ********************************
//maybe this should move to gui package?
    
    public JComponent getComponent(Object ... args) {
	//used by treemaker, circmenu, qtset, param, overridden by param
	Box b=Box.createHorizontalBox();
	//new jcmMenu(b, this);
	JLabel jl=new JLabel(getLabel(), getIcon(), SwingConstants.LEFT);
	jl.setForeground(getColor());
	jl.setFont(colfont.normalfont);
	b.add(jl);
	b.addMouseListener(showpan.moulist);
	b.addMouseMotionListener(showpan.moulist);
	showpan.moulist.cimap.put(b, this);
	return b;
    }
    
    
    public Icon getIcon() { return iconFinder.findIcon(this); }
    
    
} //end class
