
package jcm.core.data;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.net.*;
import java.io.*;
import javax.imageio.*;
import jcm.mod.luc.LUCdata;
import jcm.core.tls.fileio;
import static jcm.gui.gen.colfont.*;
import static  jcm.core.report.*;


public class pngdata {
    
	/*
	 Load / save map data from png file
	 Currently used only for LUCdata,
	 but might later be generalised for other maps
	 */
    

    
    //*************************************
    public static void save(int[][] table, String filename, Color[] cols) {
	
	int w=table.length, h=table[0].length;
	
	//       	BufferedImage bi=javax.imageio.ImageIO.read(u);
	
	byte[] red=new byte[19], green=new byte[19], blue=new byte[19];
	
	for (int i=0; i<19; i++) {
	    red[i]=(byte)cols[i].getRed();
	    green[i]=(byte)cols[i].getGreen();
	    blue[i]=(byte)cols[i].getBlue();
	}
	
	IndexColorModel icm=new IndexColorModel(5, 19, red, green, blue);
	
	BufferedImage bi=new BufferedImage(w, h, BufferedImage.TYPE_BYTE_INDEXED, icm);
	
	
	for (int x=0; x<w; x++) for (int y=0; y<h; y++)
	    bi.setRGB( x,y, cols[table[x][y]].getRGB() ) ;
	
	File f = new File(filename);
	if (f!=null){
	    try {
		ImageIO.write( bi, "png",  f);
		log("saved image: "+f);
	    } catch (Exception ex) {	log(ex, "Error in saving image file"); };
	}
	
    }
    
    //*************************************
    public static byte[][] load(String filename, Color[] cols){
	int w = 720, h = 360;
	
	//File f = new File("source/data/"+filename); // does not work from jar
	
	URL u=fileio.getURL(filename); // equals to URL u = pngdata.class.getResource("/data/"+filename);
	byte[][] data = new byte[w][h];
	
	try {
	    BufferedImage bi2 = javax.imageio.ImageIO.read(u);
	    //StringBuffer a = new StringBuffer();
	    
	    for (int y = 0; y<h; y++) {
		for (int x=0; x<w; x++){
		    //a.append((char)(findbiome(bi2.getRGB(x,y))));
		    data[x][y] = (findbiome(bi2.getRGB(x,y), cols));
		}
		//a.append("\n");
		//deb(a);
	    }
	    
	} catch (Exception ex) {log(ex, "Error loading image file"); };
	return data;
    }//load
    
    //*************************************
    static byte findbiome(int rgb, Color[] cols) {
	Color ic=new Color(rgb);
	for (byte i=0; i<cols.length; i++) if (cols[i].equals(ic)) return i;
	return 0;
    }
    
    //*************************************
    //test reload
    public static void main(String[] args) { test(); }
    
    public static void test() {
	File f = new File("test.png");
	try {
	    BufferedImage bi2=javax.imageio.ImageIO.read(f);
	    int w=720, h=360;
	    StringBuffer a=new StringBuffer();
	    for (int y=0; y<h; y++) {
		for (int x=0; x<w; x++) a.append((char)(96+findbiome(bi2.getRGB(x,y), LUCdata.biomeclassification.A.colors)));
		a.append("\n");
		//deb(a);
	    }
	    fileio.savetextfile("test.txt",a.toString());
	} catch (Exception ex) {log(ex, "Error in loading image file"); };
    } //test
    
}

