package jcm.core.data;

public class matchdata  {
    
    //***************************************
    //extra aerosol scenario added temporarily for UNFCCC intercomparison on attribution of climate change
    //1860-2100
    public static double[][] hadleyaerosol={
	{	-0.002000,-0.030000}, {	-0.002350,-0.033000}, {	-0.002700,-0.036000}, {	-0.003050,-0.039000}, {	-0.003400,-0.042000}, {	-0.003750,-0.045000}, {	-0.004100,-0.048000}, {	-0.004450,-0.051000}, {	-0.004800,-0.054000}, {	-0.005150,-0.057000}, {	-0.005500,-0.060000}, {	-0.005850,-0.063000}, {	-0.006200,-0.066000}, {	-0.006550,-0.069000}, {	-0.006900,-0.072000}, {	-0.007250,-0.075000}, {	-0.007600,-0.078000}, {	-0.007950,-0.081000}, {	-0.008300,-0.084000}, {	-0.008650,-0.087000}, {	-0.009000,-0.090000}, {	-0.009350,-0.093000}, {	-0.009700,-0.096000}, {	-0.010050,-0.099000}, {	-0.010400,-0.102000}, {	-0.010750,-0.105000}, {	-0.011100,-0.108000}, {	-0.011450,-0.111000}, {	-0.011800,-0.114000}, {	-0.012150,-0.117000}, {	-0.012500,-0.120000}, {	-0.012850,-0.123000}, {	-0.013200,-0.126000}, {	-0.013550,-0.129000}, {	-0.013900,-0.132000}, {	-0.014250,-0.135000}, {	-0.014600,-0.138000}, {	-0.014950,-0.141000}, {	-0.015300,-0.144000}, {	-0.015650,-0.147000},
	{	-0.016000,-0.150000}, {	-0.016640,-0.155200}, {	-0.017280,-0.160400}, {	-0.017920,-0.165600}, {	-0.018560,-0.170800}, {	-0.019200,-0.176000}, {	-0.019840,-0.181200}, {	-0.020480,-0.186400}, {	-0.021120,-0.191600}, {	-0.021760,-0.196800}, {	-0.022400,-0.202000}, {	-0.023040,-0.207200}, {	-0.023680,-0.212400}, {	-0.024320,-0.217600}, {	-0.024960,-0.222800}, {	-0.025600,-0.228000}, {	-0.026240,-0.233200}, {	-0.026880,-0.238400}, {	-0.027520,-0.243600}, {	-0.028160,-0.248800}, {	-0.028800,-0.254000}, {	-0.029440,-0.259200}, {	-0.030080,-0.264400}, {	-0.030720,-0.269600}, {	-0.031360,-0.274800}, {	-0.032000,-0.280000}, {	-0.032640,-0.285200}, {	-0.033280,-0.290400}, {	-0.033920,-0.295600}, {	-0.034560,-0.300800}, {	-0.035200,-0.306000}, {	-0.035840,-0.311200}, {	-0.036480,-0.316400}, {	-0.037120,-0.321600}, {	-0.037760,-0.326800}, {	-0.038400,-0.332000}, {	-0.039040,-0.337200}, {	-0.039680,-0.342400}, {	-0.040320,-0.347600}, {	-0.040960,-0.352800},
	{	-0.041600,-0.358000}, {	-0.042240,-0.363200}, {	-0.042880,-0.368400}, {	-0.043520,-0.373600}, {	-0.044160,-0.378800}, {	-0.044800,-0.384000}, {	-0.045440,-0.389200}, {	-0.046080,-0.394400}, {	-0.046720,-0.399600}, {	-0.047360,-0.404800}, {	-0.048000,-0.410000}, {	-0.051680,-0.425600}, {	-0.055360,-0.441200}, {	-0.059040,-0.456800}, {	-0.062720,-0.472400}, {	-0.066400,-0.488000}, {	-0.070080,-0.503600}, {	-0.073760,-0.519200}, {	-0.077440,-0.534800}, {	-0.081120,-0.550400}, {	-0.084800,-0.566000}, {	-0.088480,-0.581600}, {	-0.092160,-0.597200}, {	-0.095840,-0.612800}, {	-0.099520,-0.628400}, {	-0.103200,-0.644000}, {	-0.106880,-0.659600}, {	-0.110560,-0.675200}, {	-0.114240,-0.690800}, {	-0.117920,-0.706400}, {	-0.121600,-0.722000}, {	-0.125280,-0.737600}, {	-0.128960,-0.753200}, {	-0.132640,-0.768800}, {	-0.136320,-0.784400}, {	-0.140000,-0.800000}, {	-0.141600,-0.804400}, {	-0.143200,-0.808800}, {	-0.144800,-0.813200}, {	-0.146400,-0.817600},
	{	-0.148000,-0.822000}, {	-0.149600,-0.826400}, {	-0.151200,-0.830800}, {	-0.152800,-0.835200}, {	-0.154400,-0.839600}, {	-0.156000,-0.844000}, {	-0.157600,-0.848400}, {	-0.159200,-0.852800}, {	-0.160800,-0.857200}, {	-0.162400,-0.861600}, {	-0.164000,-0.866000}, {	-0.165600,-0.870400}, {	-0.167200,-0.874800}, {	-0.168800,-0.879200}, {	-0.170400,-0.883600}, {	-0.172000,-0.888000}, {	-0.173600,-0.892400}, {	-0.175200,-0.896800}, {	-0.176800,-0.901200}, {	-0.178400,-0.905600}, {	-0.180000,-0.910000}, {	-0.183400,-0.913800}, {	-0.186800,-0.917600}, {	-0.190200,-0.921400}, {	-0.193600,-0.925200}, {	-0.197000,-0.929000}, {	-0.200400,-0.932800}, {	-0.203800,-0.936600}, {	-0.207200,-0.940400}, {	-0.210600,-0.944200}, {	-0.214000,-0.948000}, {	-0.217400,-0.951800}, {	-0.220800,-0.955600}, {	-0.224200,-0.959400}, {	-0.227600,-0.963200}, {	-0.231000,-0.967000}, {	-0.234400,-0.970800}, {	-0.237800,-0.974600}, {	-0.241200,-0.978400}, {	-0.244600,-0.982200},
	{	-0.248000,-0.986000}, {	-0.251400,-0.989800}, {	-0.254800,-0.993600}, {	-0.258200,-0.997400}, {	-0.261600,-1.001200}, {	-0.265000,-1.005000}, {	-0.268400,-1.008800}, {	-0.271800,-1.012600}, {	-0.275200,-1.016400}, {	-0.278600,-1.020200}, {	-0.282000,-1.024000}, {	-0.285400,-1.027800}, {	-0.288800,-1.031600}, {	-0.292200,-1.035400}, {	-0.295600,-1.039200}, {	-0.299000,-1.043000}, {	-0.302400,-1.046800}, {	-0.305800,-1.050600}, {	-0.309200,-1.054400}, {	-0.312600,-1.058200}, {	-0.316000,-1.062000}, {	-0.319400,-1.065800}, {	-0.322800,-1.069600}, {	-0.326200,-1.073400}, {	-0.329600,-1.077200}, {	-0.333000,-1.081000}, {	-0.336400,-1.084800}, {	-0.339800,-1.088600}, {	-0.343200,-1.092400}, {	-0.346600,-1.096200}, {	-0.350000,-1.100000}, {	-0.347800,-1.093800}, {	-0.345600,-1.087600}, {	-0.343400,-1.081400}, {	-0.341200,-1.075200}, {	-0.339000,-1.069000}, {	-0.336800,-1.062800}, {	-0.334600,-1.056600}, {	-0.332400,-1.050400}, {	-0.330200,-1.044200},
	{	-0.328000,-1.038000}, {	-0.325800,-1.031800}, {	-0.323600,-1.025600}, {	-0.321400,-1.019400}, {	-0.319200,-1.013200}, {	-0.317000,-1.007000}, {	-0.314800,-1.000800}, {	-0.312600,-0.994600}, {	-0.310400,-0.988400}, {	-0.308200,-0.982200}, {	-0.306000,-0.976000}, {	-0.303800,-0.969800}, {	-0.301600,-0.963600}, {	-0.299400,-0.957400}, {	-0.297200,-0.951200}, {	-0.295000,-0.945000}, {	-0.292800,-0.938800}, {	-0.290600,-0.932600}, {	-0.288400,-0.926400}, {	-0.286200,-0.920200}, {	-0.284000,-0.914000}, {	-0.281800,-0.907800}, {	-0.279600,-0.901600}, {	-0.277400,-0.895400}, {	-0.275200,-0.889200}, {	-0.273000,-0.883000}, {	-0.270800,-0.876800}, {	-0.268600,-0.870600}, {	-0.266400,-0.864400}, {	-0.264200,-0.858200}, {	-0.262000,-0.852000}, {	-0.259800,-0.845800}, {	-0.257600,-0.839600}, {	-0.255400,-0.833400}, {	-0.253200,-0.827200}, {	-0.251000,-0.821000}, {	-0.248800,-0.814800}, {	-0.246600,-0.808600}, {	-0.244400,-0.802400}, {	-0.242200,-0.796200},
	{	-0.240000,-0.790000}
    };
    
    
    //************************************************
    //Data for MATCH Paper1
    //13 regions
    //1890-1970 in 10yr blocks, then every year until 2100 (for scenario A2)
    //"Canada" "USA" "Latin America" "Africa" "OECD Europe" "Eastern Europe" "Former USSR" "Middle East" "India + S. Asia" "China + C.P. Asia" "East Asia" "Oceania" "Japan"
    
    public static float interp(float[][] data, int reg, int year) {
	int bk=(year-1890) / 10,  by=year % 10;
	return ((float)(10-by)*data[bk][reg]+ (float)by*data[bk+1][reg]) /10f;
    }
    
    public static  float[][] matchco2fos=new float[][]{	//MtC
	{	7.7f, 178f, 4.2f, 5.1f, 130f, 16.1f, 5.3f, 0.4f, 5.2f, 7f, 1.5f, 4.5f, 8.4f},
	{	11.6f, 260.9f, 6.5f, 7.5f, 193f, 23.9f, 8.1f, 0.6f, 8.8f, 10.4f, 2.3f, 6.6f, 12.5f},
	{	17.7f, 395.8f, 10.4f, 11.3f, 292.2f, 36.2f, 12.4f, 1f, 18.5f, 15.7f, 3.6f, 10f, 19f},
	{	20.9f, 472.5f, 16.2f, 13f, 342.5f, 41.8f, 15.6f, 1.5f, 23.8f, 18.3f, 4.4f, 11.6f, 21.9f},
	{	26.6f, 525.9f, 21.5f, 15.5f, 422.1f, 54.3f, 45.1f, 1.8f, 31.6f, 19f, 6.8f, 11f, 27.3f},
	{	27.9f, 494.7f, 29.7f, 24.1f, 444.9f, 65.1f, 138.3f, 7.1f, 39.5f, 24.4f, 9.5f, 14.6f, 41.2f},
	{	48.1f, 766.6f, 45.1f, 36.9f, 418.6f, 130f, 218.1f, 14.1f, 31.2f, 35.6f, 7.7f, 21.5f, 31.3f},
	{	60.6f, 932.2f, 96.9f, 62.7f, 584.6f, 250.9f, 455.7f, 37.3f, 65f, 206.6f, 20.4f, 33.6f, 70.2f},
	{	96.6f, 1168.6f, 149.4f, 87.3f, 914.1f, 239.8f, 587.2f, 85.4f, 146f, 266.4f, 33f, 48f, 224.7f},
	{	98.8f, 1190f, 148.7f, 87.9f, 922.1f, 240.2f, 616.8f, 93.1f, 148.1f, 266.4f, 33.2f, 49f, 230.9f},
	{	104.1f, 1254.6f, 157.6f, 92.6f, 951.6f, 246.8f, 646.7f, 103f, 168.8f, 278.6f, 36.3f, 51.3f, 238.1f},
	{	109.4f, 1304.2f, 171.9f, 101.4f, 1005.2f, 256.9f, 689.1f, 119.6f, 131.7f, 295f, 39.9f, 55.3f, 266.7f},
	{	111.5f, 1261.3f, 178.4f, 104.8f, 980.2f, 264.3f, 733f, 124.3f, 174.9f, 301.3f, 40.5f, 58.2f, 264.9f},
	{	108.4f, 1203.7f, 180.8f, 106.6f, 934.7f, 279.6f, 786.9f, 123.3f, 163.2f, 344.6f, 42.7f, 59.7f, 248.1f},
	{	112.9f, 1281.1f, 192.9f, 117.2f, 992.7f, 295.5f, 828.3f, 142.3f, 165.6f, 361.8f, 44.4f, 60.6f, 258.7f},
	{	116.5f, 1324.2f, 201.6f, 119.1f, 981.7f, 306.4f, 846.6f, 147f, 193.4f, 405.5f, 51.6f, 64.5f, 260.9f},
	{	117.4f, 1346.9f, 214f, 124f, 1005.5f, 321.1f, 875.6f, 154.7f, 167.2f, 452.6f, 57.3f, 63f, 277.1f},
	{	121.9f, 1352.2f, 226.5f, 134.6f, 1055.9f, 324.3f, 890.6f, 161.1f, 168.2f, 466.6f, 61.1f, 64.1f, 284.6f},
	{	122.8f, 1289.5f, 235.7f, 139.5f, 1009.9f, 329.1f, 925.7f, 158.5f, 179.7f, 532.7f, 62.9f, 67f, 278f},
	{	117.7f, 1274.4f, 238f, 139.8f, 966.4f, 321.5f, 916.7f, 159.6f, 188.5f, 526f, 63.7f, 66.8f, 270.5f},
	{	112.4f, 1201.8f, 243.1f, 141.3f, 929.9f, 325.2f, 927.9f, 164.1f, 191.2f, 546f, 65.4f, 69.1f, 256.7f},
	{	109.8f, 1198.1f, 235.3f, 142.9f, 922.7f, 329.5f, 933.6f, 172.8f, 202.6f, 574.9f, 70.2f, 65.2f, 257.9f},
	{	115.6f, 1249.4f, 240.9f, 149.8f, 923.6f, 335.2f, 945.4f, 176f, 214f, 620.2f, 73.4f, 67.3f, 276.5f},
	{	115.9f, 1256.6f, 242.6f, 155.5f, 935.5f, 347.7f, 1011.7f, 185.1f, 232.6f, 661.8f, 78f, 70.5f, 270.9f},
	{	113.8f, 1247.6f, 246.3f, 157.2f, 939.4f, 354.2f, 960.6f, 192.5f, 243.8f, 705.3f, 81.7f, 70.2f, 267.9f},
	{	117.3f, 1288.7f, 258.5f, 162.9f, 945.2f, 358.1f, 992.5f, 204.1f, 227.5f, 752.8f, 86.7f, 73.7f, 271.9f},
	{	125.7f, 1345.8f, 261.4f, 167.7f, 949.3f, 346.8f, 1008.5f, 212.3f, 232.4f, 805.5f, 87.6f, 76.3f, 292.6f},
	{	129.8f, 1357f, 267.1f, 173.9f, 952f, 339f, 1020.7f, 222.6f, 205.3f, 839.4f, 95.7f, 80.5f, 304.4f},
	{	122.5f, 1324.8f, 270.3f, 177.5f, 954.2f, 297f, 1192.7f, 239.6f, 202.2f, 851.5f, 116.2f, 81.7f, 317.5f},
	{	120.9f, 1312.5f, 279.8f, 180.9f, 969.5f, 294.3f, 1133f, 245.5f, 217.5f, 831f, 125f, 82.4f, 324.3f},
	{	124.7f, 1331.2f, 286.8f, 185.9f, 947.4f, 286.1f, 973.6f, 261.7f, 229.7f, 865.4f, 131.5f, 84f, 326.1f},
	{	125.5f, 1379.2f, 299.5f, 185.2f, 930.5f, 270f, 931.3f, 273.4f, 239.8f, 1040.3f, 147.5f, 85f, 322.5f},
	{	130.4f, 1405.8f, 317.7f, 187.2f, 938.2f, 264.8f, 852.3f, 283.2f, 252.7f, 1090.9f, 157.4f, 86.5f, 334.9f},
	{	134.5f, 1428.1f, 322.1f, 197.7f, 950.7f, 270.3f, 824.6f, 292f, 273.2f, 1187.4f, 171f, 89.2f, 336.5f},
	{	136.6f, 1451.3f, 332.5f, 202.3f, 954.8f, 267.1f, 789.3f, 305.2f, 291.4f, 1224.8f, 181.9f, 90.8f, 341.6f},
	{	138.6f, 1474.5f, 342.9f, 206.8f, 958.9f, 263.9f, 753.9f, 318.4f, 309.6f, 1262.2f, 192.9f, 92.5f, 346.7f},
	{	140.7f, 1497.7f, 353.2f, 211.3f, 962.9f, 260.7f, 718.5f, 331.6f, 327.8f, 1299.5f, 203.8f, 94.1f, 351.9f},
	{	142.7f, 1521f, 363.6f, 215.9f, 967f, 257.5f, 683.1f, 344.8f, 346f, 1336.9f, 214.7f, 95.8f, 357f},
	{	144.8f, 1544.2f, 374f, 220.4f, 971.1f, 254.3f, 647.7f, 358.1f, 364.2f, 1374.3f, 225.7f, 97.4f, 362.2f},
	{	146.5f, 1560.2f, 394.1f, 228.9f, 981.9f, 258.7f, 654.8f, 371.1f, 382.6f, 1422.4f, 234.4f, 99f, 362.1f},
	{	148.1f, 1576.2f, 414.2f, 237.4f, 992.7f, 263f, 662f, 384.2f, 401f, 1470.6f, 243.2f, 100.7f, 362.1f},
	{	149.8f, 1592.3f, 434.3f, 246f, 1003.5f, 267.4f, 669.2f, 397.2f, 419.4f, 1518.8f, 251.9f, 102.3f, 362.1f},
	{	151.5f, 1608.3f, 454.5f, 254.5f, 1014.3f, 271.8f, 676.3f, 410.3f, 437.8f, 1566.9f, 260.7f, 104f, 362.1f},
	{	153.2f, 1624.3f, 474.6f, 263f, 1025.2f, 276.1f, 683.5f, 423.3f, 456.2f, 1615.1f, 269.4f, 105.6f, 362f},
	{	154.9f, 1640.4f, 494.7f, 271.5f, 1036f, 280.5f, 690.6f, 436.4f, 474.6f, 1663.3f, 278.1f, 107.2f, 362f},
	{	156.6f, 1656.4f, 514.8f, 280f, 1046.8f, 284.9f, 697.8f, 449.4f, 493f, 1711.4f, 286.9f, 108.9f, 362f},
	{	158.3f, 1672.4f, 534.9f, 288.5f, 1057.6f, 289.2f, 704.9f, 462.5f, 511.4f, 1759.6f, 295.6f, 110.5f, 361.9f},
	{	160f, 1688.5f, 555f, 297.1f, 1068.4f, 293.6f, 712.1f, 475.5f, 529.9f, 1807.7f, 304.4f, 112.2f, 361.9f},
	{	161.7f, 1704.5f, 575.1f, 305.6f, 1079.2f, 298f, 719.2f, 488.6f, 548.3f, 1855.9f, 313.1f, 113.8f, 361.9f},
	{	163.7f, 1726.9f, 612f, 322.3f, 1095.2f, 305.2f, 731.2f, 515.4f, 584.3f, 1917.8f, 326.7f, 115.1f, 363.5f},
	{	165.7f, 1749.3f, 648.9f, 339f, 1111.1f, 312.4f, 743.2f, 542.1f, 620.4f, 1979.6f, 340.3f, 116.5f, 365f},
	{	167.6f, 1771.8f, 685.7f, 355.7f, 1127.1f, 319.6f, 755.1f, 568.9f, 656.4f, 2041.5f, 354f, 117.8f, 366.6f},
	{	169.6f, 1794.2f, 722.6f, 372.4f, 1143f, 326.8f, 767.1f, 595.7f, 692.5f, 2103.4f, 367.6f, 119.1f, 368.1f},
	{	171.6f, 1816.6f, 759.5f, 389.1f, 1159f, 334f, 779.1f, 622.5f, 728.6f, 2165.2f, 381.2f, 120.5f, 369.7f},
	{	173.6f, 1839f, 796.4f, 405.7f, 1174.9f, 341.2f, 791f, 649.3f, 764.6f, 2227.1f, 394.8f, 121.8f, 371.2f},
	{	175.6f, 1861.4f, 833.2f, 422.4f, 1190.9f, 348.5f, 803f, 676f, 800.7f, 2288.9f, 408.4f, 123.1f, 372.8f},
	{	177.6f, 1883.8f, 870.1f, 439.1f, 1206.8f, 355.7f, 815f, 702.8f, 836.8f, 2350.8f, 422f, 124.5f, 374.4f},
	{	179.6f, 1906.2f, 907f, 455.8f, 1222.7f, 362.9f, 826.9f, 729.6f, 872.8f, 2412.7f, 435.6f, 125.8f, 375.9f},
	{	181.6f, 1928.7f, 943.8f, 472.5f, 1238.7f, 370.1f, 838.9f, 756.4f, 908.9f, 2474.5f, 449.3f, 127.1f, 377.5f},
	{	183.9f, 1951.4f, 969.6f, 492.8f, 1252.3f, 376.8f, 850.4f, 782.6f, 951.1f, 2538f, 460.7f, 129.2f, 381.5f},
	{	186.2f, 1974.2f, 995.3f, 513f, 1266f, 383.5f, 861.9f, 808.8f, 993.2f, 2601.5f, 472.1f, 131.3f, 385.4f},
	{	188.5f, 1996.9f, 1021.1f, 533.3f, 1279.6f, 390.1f, 873.4f, 835f, 1035.4f, 2665f, 483.5f, 133.4f, 389.4f},
	{	190.8f, 2019.7f, 1046.8f, 553.5f, 1293.2f, 396.8f, 884.9f, 861.2f, 1077.6f, 2728.5f, 494.9f, 135.5f, 393.4f},
	{	193.1f, 2042.4f, 1072.6f, 573.8f, 1306.9f, 403.5f, 896.4f, 887.4f, 1119.8f, 2792f, 506.4f, 137.6f, 397.4f},
	{	195.4f, 2065.2f, 1098.3f, 594f, 1320.5f, 410.2f, 907.8f, 913.6f, 1162f, 2855.5f, 517.8f, 139.7f, 401.4f},
	{	197.7f, 2088f, 1124.1f, 614.3f, 1334.1f, 416.8f, 919.3f, 939.8f, 1204.2f, 2919f, 529.2f, 141.8f, 405.4f},
	{	200f, 2110.7f, 1149.8f, 634.5f, 1347.7f, 423.5f, 930.8f, 966f, 1246.3f, 2982.5f, 540.6f, 143.9f, 409.3f},
	{	202.3f, 2133.5f, 1175.6f, 654.8f, 1361.4f, 430.2f, 942.3f, 992.2f, 1288.5f, 3046f, 552.1f, 146f, 413.3f},
	{	204.6f, 2156.2f, 1201.3f, 675f, 1375f, 436.9f, 953.8f, 1018.4f, 1330.7f, 3109.5f, 563.5f, 148.1f, 417.3f},
	{	205.9f, 2167.2f, 1207.4f, 693.6f, 1373.7f, 437.5f, 959.2f, 1034.3f, 1368.5f, 3145f, 573.3f, 149.8f, 420.4f},
	{	207.2f, 2178.2f, 1213.6f, 712.3f, 1372.5f, 438.1f, 964.5f, 1050.3f, 1406.3f, 3180.6f, 583.2f, 151.5f, 423.4f},
	{	208.5f, 2189.2f, 1219.7f, 730.9f, 1371.2f, 438.8f, 969.9f, 1066.3f, 1444.1f, 3216.1f, 593f, 153.2f, 426.4f},
	{	209.8f, 2200.2f, 1225.8f, 749.5f, 1369.9f, 439.4f, 975.2f, 1082.3f, 1481.9f, 3251.7f, 602.9f, 154.8f, 429.5f},
	{	211.1f, 2211.2f, 1231.9f, 768.1f, 1368.6f, 440.1f, 980.6f, 1098.3f, 1519.6f, 3287.2f, 612.7f, 156.5f, 432.5f},
	{	212.4f, 2222.2f, 1238f, 786.7f, 1367.4f, 440.7f, 986f, 1114.3f, 1557.4f, 3322.8f, 622.5f, 158.2f, 435.5f},
	{	213.6f, 2233.2f, 1244.1f, 805.3f, 1366.1f, 441.4f, 991.3f, 1130.3f, 1595.2f, 3358.3f, 632.4f, 159.9f, 438.6f},
	{	214.9f, 2244.2f, 1250.2f, 823.9f, 1364.8f, 442f, 996.7f, 1146.3f, 1633f, 3393.9f, 642.2f, 161.6f, 441.6f},
	{	216.2f, 2255.2f, 1256.4f, 842.5f, 1363.5f, 442.6f, 1002f, 1162.3f, 1670.8f, 3429.5f, 652.1f, 163.3f, 444.6f},
	{	217.5f, 2266.2f, 1262.5f, 861.1f, 1362.3f, 443.3f, 1007.4f, 1178.2f, 1708.6f, 3465f, 661.9f, 165f, 447.7f},
	{	218.1f, 2282.2f, 1265.2f, 881f, 1361.6f, 442.8f, 1013.8f, 1196.1f, 1746.2f, 3499.6f, 672.6f, 166.2f, 445.9f},
	{	218.7f, 2298.2f, 1267.8f, 900.8f, 1360.9f, 442.4f, 1020.3f, 1213.9f, 1783.9f, 3534.2f, 683.3f, 167.4f, 444.1f},
	{	219.3f, 2314.2f, 1270.5f, 920.7f, 1360.3f, 441.9f, 1026.7f, 1231.8f, 1821.6f, 3568.8f, 693.9f, 168.5f, 442.3f},
	{	219.9f, 2330.2f, 1273.2f, 940.5f, 1359.6f, 441.5f, 1033.1f, 1249.6f, 1859.3f, 3603.5f, 704.6f, 169.7f, 440.5f},
	{	220.4f, 2346.2f, 1275.9f, 960.3f, 1358.9f, 441f, 1039.6f, 1267.4f, 1897f, 3638.1f, 715.3f, 170.9f, 438.7f},
	{	221f, 2362.2f, 1278.6f, 980.2f, 1358.3f, 440.6f, 1046f, 1285.3f, 1934.6f, 3672.7f, 726f, 172.1f, 436.9f},
	{	221.6f, 2378.2f, 1281.2f, 1000f, 1357.6f, 440.1f, 1052.5f, 1303.1f, 1972.3f, 3707.3f, 736.6f, 173.3f, 435.2f},
	{	222.2f, 2394.2f, 1283.9f, 1019.9f, 1356.9f, 439.7f, 1058.9f, 1320.9f, 2010f, 3741.9f, 747.3f, 174.5f, 433.4f},
	{	222.8f, 2410.2f, 1286.6f, 1039.7f, 1356.3f, 439.2f, 1065.3f, 1338.8f, 2047.7f, 3776.5f, 758f, 175.7f, 431.6f},
	{	223.4f, 2426.2f, 1289.3f, 1059.6f, 1355.6f, 438.8f, 1071.8f, 1356.6f, 2085.4f, 3811.1f, 768.7f, 176.8f, 429.8f},
	{	225.1f, 2441.7f, 1306.2f, 1089.8f, 1357f, 438.8f, 1082.9f, 1390.8f, 2116f, 3856f, 779.1f, 177.9f, 427.8f},
	{	226.8f, 2457.2f, 1323.2f, 1120.1f, 1358.4f, 438.9f, 1094f, 1424.9f, 2146.6f, 3900.9f, 789.5f, 179f, 425.8f},
	{	228.5f, 2472.8f, 1340.1f, 1150.3f, 1359.9f, 438.9f, 1105.1f, 1459.1f, 2177.1f, 3945.8f, 799.9f, 180f, 423.9f},
	{	230.2f, 2488.3f, 1357.1f, 1180.6f, 1361.3f, 439f, 1116.2f, 1493.2f, 2207.7f, 3990.7f, 810.3f, 181.1f, 421.9f},
	{	231.9f, 2503.9f, 1374f, 1210.8f, 1362.7f, 439f, 1127.3f, 1527.4f, 2238.3f, 4035.6f, 820.7f, 182.1f, 419.9f},
	{	233.6f, 2519.4f, 1391f, 1241.1f, 1364.2f, 439.1f, 1138.4f, 1561.6f, 2268.9f, 4080.5f, 831.1f, 183.2f, 417.9f},
	{	235.3f, 2535f, 1407.9f, 1271.3f, 1365.6f, 439.1f, 1149.5f, 1595.7f, 2299.5f, 4125.4f, 841.6f, 184.3f, 416f},
	{	237f, 2550.5f, 1424.9f, 1301.6f, 1367f, 439.1f, 1160.7f, 1629.9f, 2330.1f, 4170.3f, 852f, 185.3f, 414f},
	{	238.7f, 2566.1f, 1441.8f, 1331.8f, 1368.5f, 439.2f, 1171.8f, 1664f, 2360.7f, 4215.2f, 862.4f, 186.4f, 412f},
	{	240.3f, 2581.6f, 1458.8f, 1362.1f, 1369.9f, 439.2f, 1182.9f, 1698.2f, 2391.3f, 4260.1f, 872.8f, 187.5f, 410f},
	{	242.1f, 2593.3f, 1480.8f, 1389f, 1375.4f, 438.6f, 1194.7f, 1731.4f, 2409.5f, 4317.6f, 886.2f, 188.7f, 407.7f},
	{	243.9f, 2605f, 1502.8f, 1416f, 1380.9f, 437.9f, 1206.5f, 1764.6f, 2427.8f, 4375f, 899.7f, 189.9f, 405.5f},
	{	245.6f, 2616.7f, 1524.7f, 1443f, 1386.4f, 437.3f, 1218.3f, 1797.7f, 2446f, 4432.4f, 913.1f, 191.2f, 403.2f},
	{	247.4f, 2628.4f, 1546.7f, 1469.9f, 1391.9f, 436.7f, 1230.1f, 1830.9f, 2464.3f, 4489.8f, 926.5f, 192.4f, 400.9f},
	{	249.2f, 2640.1f, 1568.7f, 1496.9f, 1397.4f, 436f, 1241.8f, 1864.1f, 2482.5f, 4547.3f, 940f, 193.6f, 398.6f},
	{	250.9f, 2651.8f, 1590.7f, 1523.8f, 1402.9f, 435.4f, 1253.6f, 1897.3f, 2500.8f, 4604.7f, 953.4f, 194.9f, 396.4f},
	{	252.7f, 2663.5f, 1612.7f, 1550.8f, 1408.4f, 434.7f, 1265.4f, 1930.5f, 2519f, 4662.1f, 966.8f, 196.1f, 394.1f},
	{	254.4f, 2675.2f, 1634.7f, 1577.8f, 1413.9f, 434.1f, 1277.2f, 1963.6f, 2537.3f, 4719.6f, 980.3f, 197.3f, 391.8f},
	{	256.2f, 2686.9f, 1656.7f, 1604.7f, 1419.5f, 433.4f, 1289f, 1996.8f, 2555.5f, 4777f, 993.7f, 198.6f, 389.5f},
	{	258f, 2698.6f, 1678.7f, 1631.7f, 1425f, 432.8f, 1300.8f, 2030f, 2573.8f, 4834.4f, 1007.2f, 199.8f, 387.2f},
	{	261.2f, 2724.9f, 1718.1f, 1658.3f, 1437f, 433.2f, 1318f, 2055.1f, 2580f, 4908.6f, 1026.6f, 201.3f, 386.1f},
	{	264.4f, 2751.2f, 1757.4f, 1685f, 1449f, 433.6f, 1335.1f, 2080.3f, 2586.3f, 4982.8f, 1046f, 202.7f, 384.9f},
	{	267.6f, 2777.5f, 1796.8f, 1711.7f, 1461f, 434f, 1352.3f, 2105.4f, 2592.5f, 5057.1f, 1065.4f, 204.2f, 383.7f},
	{	270.8f, 2803.8f, 1836.2f, 1738.3f, 1473f, 434.4f, 1369.5f, 2130.6f, 2598.7f, 5131.3f, 1084.9f, 205.6f, 382.5f},
	{	274f, 2830.1f, 1875.5f, 1765f, 1485f, 434.8f, 1386.6f, 2155.7f, 2604.9f, 5205.5f, 1104.3f, 207.1f, 381.4f},
	{	277.2f, 2856.4f, 1914.9f, 1791.7f, 1497f, 435.2f, 1403.8f, 2180.9f, 2611.2f, 5279.7f, 1123.7f, 208.5f, 380.2f},
	{	280.4f, 2882.7f, 1954.2f, 1818.3f, 1509f, 435.6f, 1421f, 2206f, 2617.4f, 5353.9f, 1143.2f, 210f, 379f},
	{	283.6f, 2909f, 1993.6f, 1845f, 1521f, 436f, 1438.1f, 2231.2f, 2623.6f, 5428.1f, 1162.6f, 211.4f, 377.8f},
	{	286.8f, 2935.3f, 2033f, 1871.6f, 1533.1f, 436.4f, 1455.3f, 2256.3f, 2629.9f, 5502.3f, 1182f, 212.8f, 376.6f},
	{	290f, 2961.6f, 2072.3f, 1898.3f, 1545.1f, 436.9f, 1472.5f, 2281.4f, 2636.1f, 5576.6f, 1201.5f, 214.3f, 375.5f},
	{	294.9f, 3005.7f, 2131.3f, 1925.1f, 1558.5f, 437.8f, 1495.5f, 2295.9f, 2642.3f, 5653.7f, 1225.2f, 216.1f, 376.9f},
	{	299.7f, 3049.8f, 2190.2f, 1951.8f, 1571.9f, 438.8f, 1518.5f, 2310.4f, 2648.5f, 5730.9f, 1249f, 217.8f, 378.4f},
	{	304.6f, 3093.8f, 2249.1f, 1978.6f, 1585.3f, 439.8f, 1541.5f, 2324.9f, 2654.7f, 5808f, 1272.8f, 219.6f, 379.9f},
	{	309.5f, 3137.9f, 2308f, 2005.4f, 1598.8f, 440.7f, 1564.5f, 2339.3f, 2660.9f, 5885.2f, 1296.5f, 221.3f, 381.4f},
	{	314.3f, 3181.9f, 2366.9f, 2032.1f, 1612.2f, 441.7f, 1587.5f, 2353.8f, 2667.1f, 5962.3f, 1320.3f, 223.1f, 382.8f},
	{	319.2f, 3226f, 2425.8f, 2058.9f, 1625.6f, 442.7f, 1610.5f, 2368.3f, 2673.3f, 6039.4f, 1344.1f, 224.9f, 384.3f},
	{	324.1f, 3270.1f, 2484.8f, 2085.6f, 1639f, 443.7f, 1633.5f, 2382.8f, 2679.5f, 6116.6f, 1367.8f, 226.6f, 385.8f},
	{	328.9f, 3314.1f, 2543.7f, 2112.4f, 1652.5f, 444.6f, 1656.6f, 2397.2f, 2685.8f, 6193.7f, 1391.6f, 228.4f, 387.2f},
	{	333.8f, 3358.2f, 2602.6f, 2139.2f, 1665.9f, 445.6f, 1679.6f, 2411.7f, 2692f, 6270.9f, 1415.4f, 230.2f, 388.7f},
	{	338.7f, 3402.2f, 2661.5f, 2165.9f, 1679.3f, 446.6f, 1702.6f, 2426.2f, 2698.2f, 6348f, 1439.1f, 231.9f, 390.2f},
	{	343.6f, 3446.7f, 2727.1f, 2191f, 1693.4f, 447.1f, 1726f, 2435.2f, 2716.5f, 6411.6f, 1460.9f, 232.4f, 391.8f},
	{	348.5f, 3491.2f, 2792.6f, 2216.1f, 1707.5f, 447.7f, 1749.5f, 2444.3f, 2734.9f, 6475.1f, 1482.7f, 232.9f, 393.5f},
	{	353.3f, 3535.6f, 2858.2f, 2241.2f, 1721.5f, 448.2f, 1772.9f, 2453.4f, 2753.2f, 6538.7f, 1504.5f, 233.4f, 395.1f},
	{	358.2f, 3580.1f, 2923.8f, 2266.3f, 1735.6f, 448.8f, 1796.3f, 2462.5f, 2771.6f, 6602.2f, 1526.2f, 234f, 396.8f},
	{	363.1f, 3624.6f, 2989.3f, 2291.4f, 1749.7f, 449.3f, 1819.8f, 2471.6f, 2790f, 6665.8f, 1548f, 234.5f, 398.4f},
	{	368f, 3669f, 3054.9f, 2316.5f, 1763.8f, 449.8f, 1843.2f, 2480.7f, 2808.3f, 6729.3f, 1569.8f, 235f, 400f},
	{	372.9f, 3713.5f, 3120.5f, 2341.6f, 1777.8f, 450.4f, 1866.7f, 2489.7f, 2826.7f, 6792.8f, 1591.5f, 235.5f, 401.7f},
	{	377.8f, 3757.9f, 3186f, 2366.7f, 1791.9f, 450.9f, 1890.1f, 2498.8f, 2845f, 6856.4f, 1613.3f, 236f, 403.3f},
	{	382.7f, 3802.4f, 3251.6f, 2391.8f, 1806f, 451.5f, 1913.5f, 2507.9f, 2863.4f, 6919.9f, 1635.1f, 236.5f, 405f},
	{	387.6f, 3846.9f, 3317.1f, 2416.8f, 1820f, 452f, 1937f, 2517f, 2881.7f, 6983.5f, 1656.8f, 237f, 406.6f}
    };
    
    public static float[][] matchco2luc=new float[][]{	//MtC
	{	0.3f, 1.7f, 250.5f, 65.5f, 4.9f, 1.9f, 7.4f, 2.3f, 32.1f, 47.7f, 75.6f, 0.3f, 0.8f},
	{	0.3f, 1.8f, 301.2f, 73.3f, 4.8f, 2f, 7.9f, 2.3f, 34.6f, 48.5f, 88.8f, 0.3f, 0.8f},
	{	0.3f, 1.9f, 354.1f, 84.6f, 4.6f, 2f, 8.4f, 2.5f, 37f, 50f, 104.9f, 0.3f, 0.9f},
	{	0.3f, 2f, 412.2f, 98.6f, 4.4f, 2f, 9f, 2.6f, 39.7f, 51.3f, 123.9f, 0.3f, 0.9f},
	{	0.4f, 2.1f, 457.2f, 113.5f, 4.2f, 2f, 9.4f, 2.8f, 42.5f, 52.2f, 143.8f, 0.4f, 1f},
	{	0.4f, 2.4f, 481f, 131.1f, 4.1f, 1.9f, 8.3f, 3.1f, 45.6f, 52.7f, 165f, 0.4f, 1f},
	{	0.4f, 2.3f, 475.7f, 150.2f, 4.3f, 1.7f, 8.1f, 3.4f, 48.6f, 52.7f, 186.3f, 0.4f, 1.2f},
	{	0.4f, 2.5f, 539.2f, 181.1f, 4f, 1.7f, 8.3f, 3.9f, 59.1f, 56.8f, 224.5f, 0.5f, 1f},
	{	4.9f, 34.6f, 594.8f, 221.8f, 9.3f, 1.6f, 8.3f, 4.3f, 72.4f, 73.5f, 279.5f, 10f, 0.9f},
	{	4.9f, 34.5f, 594.8f, 222.4f, 9.1f, 1.6f, 8.3f, 4.4f, 73.3f, 74.4f, 280f, 10f, 0.8f},
	{	4.9f, 34.4f, 594.9f, 223.1f, 9f, 1.5f, 8.4f, 4.4f, 74.2f, 75.3f, 280.5f, 10f, 0.7f},
	{	4.9f, 34.3f, 594.9f, 223.8f, 8.9f, 1.5f, 8.4f, 4.4f, 75.1f, 76.2f, 281f, 10f, 0.7f},
	{	4.9f, 34.2f, 594.9f, 224.5f, 8.9f, 1.5f, 8.5f, 4.5f, 76.1f, 77f, 281.4f, 10f, 0.6f},
	{	4.9f, 34.1f, 594.9f, 225.2f, 8.8f, 1.5f, 8.5f, 4.5f, 77f, 77.8f, 281.9f, 10f, 0.5f},
	{	4.8f, 33.9f, 595f, 226f, 8.7f, 1.5f, 8.3f, 4.6f, 77.9f, 78.4f, 282.3f, 10f, 0.5f},
	{	4.8f, 33.8f, 595f, 226.8f, 8.7f, 1.5f, 8.1f, 4.6f, 78.9f, 78.9f, 282.8f, 10f, 0.4f},
	{	4.8f, 33.6f, 595f, 227.7f, 8.7f, 1.5f, 7.9f, 4.7f, 79.8f, 79.4f, 283.2f, 10f, 0.4f},
	{	4.8f, 33.5f, 595f, 228.5f, 8.6f, 1.5f, 7.7f, 4.7f, 80.8f, 79.9f, 283.6f, 10f, 0.3f},
	{	4.8f, 33.3f, 595.1f, 229.4f, 8.5f, 1.4f, 7.4f, 4.8f, 81.8f, 80.4f, 284.1f, 10f, 0.2f},
	{	3.9f, 29f, 578.2f, 228.3f, 7.5f, 1.4f, 7.4f, 4.8f, 80.8f, 78.4f, 281.8f, 10f, 0.2f},
	{	3f, 24.8f, 561.3f, 227.2f, 6.4f, 1.3f, 7.3f, 4.8f, 79.8f, 76.3f, 279.5f, 10.1f, 0.5f},
	{	2.1f, 20.6f, 544.5f, 226.3f, 5.3f, 1.2f, 7.3f, 4.8f, 78.9f, 74.3f, 277.3f, 10.2f, 0.6f},
	{	1.2f, 16.3f, 527.6f, 225.4f, 4.4f, 1.1f, 7.2f, 4.9f, 78f, 72.3f, 275.1f, 10.2f, 0.6f},
	{	0.2f, 12.2f, 510.7f, 224.5f, 3.7f, 1.1f, 7.1f, 4.9f, 77.1f, 70.4f, 272.8f, 10.3f, 0.6f},
	{	0.3f, 8.7f, 493.8f, 223.7f, 3.7f, 1f, 7.1f, 5f, 77.2f, 68.5f, 270.5f, 10.6f, 0.7f},
	{	0.3f, 5.2f, 476.8f, 222.9f, 3.7f, 1f, 7f, 5f, 77.2f, 66.6f, 268.3f, 10.8f, 0.7f},
	{	0.3f, 3.4f, 459.9f, 222.1f, 3.9f, 1f, 6.9f, 5.1f, 77.3f, 64.8f, 266f, 11f, 0.8f},
	{	0.3f, 10.9f, 443f, 221.4f, 4.3f, 1f, 6.8f, 5.1f, 77.4f, 62.9f, 263.7f, 11.2f, 0.9f},
	{	0.3f, 13.2f, 426f, 220.6f, 4.5f, 1f, 7.1f, 5.1f, 77.5f, 61f, 261.4f, 11.4f, 0.9f},
	{	0.4f, 13f, 412f, 220.2f, 4.6f, 1f, 6.6f, 5.2f, 77.7f, 59.4f, 259.6f, 11.5f, 1f},
	{	0.4f, 13.8f, 397.9f, 219.7f, 4.7f, 1.1f, 6.4f, 5.2f, 77.9f, 57.7f, 257.7f, 11.7f, 1f},
	{	0.4f, 14f, 384.4f, 219.5f, 4.9f, 1.3f, 7.2f, 5.3f, 78.4f, 56f, 255.9f, 11.9f, 1f},
	{	0.4f, 14.4f, 370.3f, 219.1f, 4.3f, 1.4f, 7.7f, 5.3f, 79.9f, 54.3f, 254f, 12.1f, 1.1f},
	{	0.4f, 14f, 356.3f, 218.6f, 4.5f, 1.4f, 6.4f, 5.4f, 81.5f, 52.5f, 252.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 360.2f, 221f, 4.5f, 1.4f, 6.4f, 5.5f, 78.5f, 50.6f, 242.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 364.1f, 223.3f, 4.5f, 1.4f, 6.4f, 5.5f, 75.5f, 48.6f, 233.6f, 12.3f, 1.1f},
	{	0.4f, 14f, 368f, 225.7f, 4.5f, 1.4f, 6.4f, 5.6f, 72.5f, 46.7f, 224.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 371.9f, 228.1f, 4.5f, 1.4f, 6.4f, 5.7f, 69.4f, 44.7f, 214.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 375.8f, 230.5f, 4.5f, 1.4f, 6.4f, 5.7f, 66.4f, 42.8f, 205.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 373.8f, 229.3f, 4.5f, 1.4f, 6.4f, 5.7f, 68.6f, 44.2f, 212.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 371.8f, 228.1f, 4.5f, 1.4f, 6.4f, 5.7f, 70.8f, 45.6f, 219f, 12.3f, 1.1f},
	{	0.4f, 14f, 369.8f, 226.9f, 4.5f, 1.4f, 6.4f, 5.6f, 73f, 47f, 225.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 367.8f, 225.6f, 4.5f, 1.4f, 6.4f, 5.6f, 75.1f, 48.4f, 232.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 365.8f, 224.4f, 4.5f, 1.4f, 6.4f, 5.6f, 77.3f, 49.8f, 239.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 363.8f, 223.2f, 4.5f, 1.4f, 6.4f, 5.5f, 79.5f, 51.2f, 246f, 12.3f, 1.1f},
	{	0.4f, 14f, 361.9f, 222f, 4.5f, 1.4f, 6.4f, 5.5f, 81.7f, 52.6f, 252.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 359.9f, 220.8f, 4.5f, 1.4f, 6.4f, 5.5f, 83.8f, 54f, 259.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 357.9f, 219.5f, 4.5f, 1.4f, 6.4f, 5.4f, 86f, 55.4f, 266.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 355.9f, 218.3f, 4.5f, 1.4f, 6.4f, 5.4f, 88.2f, 56.8f, 272.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 359.5f, 220.5f, 4.5f, 1.4f, 6.4f, 5.5f, 89.5f, 57.7f, 277.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 363f, 222.7f, 4.5f, 1.4f, 6.4f, 5.5f, 90.9f, 58.6f, 281.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 366.6f, 224.9f, 4.5f, 1.4f, 6.4f, 5.6f, 92.2f, 59.4f, 285.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 370.2f, 227.1f, 4.5f, 1.4f, 6.4f, 5.6f, 93.6f, 60.3f, 289.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 373.8f, 229.3f, 4.5f, 1.4f, 6.4f, 5.7f, 94.9f, 61.1f, 293.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 377.3f, 231.5f, 4.5f, 1.4f, 6.4f, 5.7f, 96.2f, 62f, 297.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 380.9f, 233.7f, 4.5f, 1.4f, 6.4f, 5.8f, 97.6f, 62.9f, 302f, 12.3f, 1.1f},
	{	0.4f, 14f, 384.5f, 235.8f, 4.5f, 1.4f, 6.4f, 5.8f, 98.9f, 63.7f, 306.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 388f, 238f, 4.5f, 1.4f, 6.4f, 5.9f, 100.3f, 64.6f, 310.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 391.6f, 240.2f, 4.5f, 1.4f, 6.4f, 6f, 101.6f, 65.5f, 314.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 391f, 239.9f, 4.5f, 1.4f, 6.4f, 5.9f, 100.5f, 64.8f, 311f, 12.3f, 1.1f},
	{	0.4f, 14f, 390.4f, 239.5f, 4.5f, 1.4f, 6.4f, 5.9f, 99.4f, 64f, 307.6f, 12.3f, 1.1f},
	{	0.4f, 14f, 389.8f, 239.1f, 4.5f, 1.4f, 6.4f, 5.9f, 98.3f, 63.3f, 304.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 389.2f, 238.8f, 4.5f, 1.4f, 6.4f, 5.9f, 97.2f, 62.6f, 300.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 388.6f, 238.4f, 4.5f, 1.4f, 6.4f, 5.9f, 96.1f, 61.9f, 297.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 388f, 238f, 4.5f, 1.4f, 6.4f, 5.9f, 95f, 61.2f, 293.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 387.4f, 237.7f, 4.5f, 1.4f, 6.4f, 5.9f, 93.8f, 60.5f, 290.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 386.8f, 237.3f, 4.5f, 1.4f, 6.4f, 5.9f, 92.7f, 59.7f, 287f, 12.3f, 1.1f},
	{	0.4f, 14f, 386.2f, 236.9f, 4.5f, 1.4f, 6.4f, 5.9f, 91.6f, 59f, 283.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 385.7f, 236.6f, 4.5f, 1.4f, 6.4f, 5.9f, 90.5f, 58.3f, 280.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 382.8f, 234.8f, 4.5f, 1.4f, 6.4f, 5.8f, 88.8f, 57.2f, 274.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 380f, 233.1f, 4.5f, 1.4f, 6.4f, 5.8f, 87.1f, 56.1f, 269.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 377.1f, 231.3f, 4.5f, 1.4f, 6.4f, 5.7f, 85.4f, 55f, 264.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 374.3f, 229.6f, 4.5f, 1.4f, 6.4f, 5.7f, 83.7f, 53.9f, 258.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 371.4f, 227.8f, 4.5f, 1.4f, 6.4f, 5.6f, 82f, 52.8f, 253.6f, 12.3f, 1.1f},
	{	0.4f, 14f, 368.6f, 226.1f, 4.5f, 1.4f, 6.4f, 5.6f, 80.3f, 51.7f, 248.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 365.7f, 224.3f, 4.5f, 1.4f, 6.4f, 5.6f, 78.5f, 50.6f, 243.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 362.9f, 222.6f, 4.5f, 1.4f, 6.4f, 5.5f, 76.8f, 49.5f, 237.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 360f, 220.8f, 4.5f, 1.4f, 6.4f, 5.5f, 75.1f, 48.4f, 232.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 357.2f, 219.1f, 4.5f, 1.4f, 6.4f, 5.4f, 73.4f, 47.3f, 227.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 354.3f, 217.3f, 4.5f, 1.4f, 6.4f, 5.4f, 71.7f, 46.2f, 221.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 351.5f, 215.6f, 4.5f, 1.4f, 6.4f, 5.3f, 70f, 45.1f, 216.6f, 12.3f, 1.1f},
	{	0.4f, 14f, 348.6f, 213.9f, 4.5f, 1.4f, 6.4f, 5.3f, 68.3f, 44f, 211.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 345.8f, 212.1f, 4.5f, 1.4f, 6.4f, 5.3f, 66.6f, 42.9f, 206f, 12.3f, 1.1f},
	{	0.4f, 14f, 342.9f, 210.4f, 4.5f, 1.4f, 6.4f, 5.2f, 64.9f, 41.8f, 200.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 340.1f, 208.6f, 4.5f, 1.4f, 6.4f, 5.2f, 63.1f, 40.7f, 195.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 337.2f, 206.9f, 4.5f, 1.4f, 6.4f, 5.1f, 61.4f, 39.6f, 190.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 334.4f, 205.1f, 4.5f, 1.4f, 6.4f, 5.1f, 59.7f, 38.5f, 184.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 331.5f, 203.4f, 4.5f, 1.4f, 6.4f, 5f, 58f, 37.4f, 179.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 328.7f, 201.6f, 4.5f, 1.4f, 6.4f, 5f, 56.3f, 36.3f, 174.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 319.6f, 196.1f, 4.5f, 1.4f, 6.4f, 4.9f, 54.5f, 35.1f, 168.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 310.6f, 190.5f, 4.5f, 1.4f, 6.4f, 4.7f, 52.6f, 33.9f, 162.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 301.6f, 185f, 4.5f, 1.4f, 6.4f, 4.6f, 50.8f, 32.7f, 157.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 292.6f, 179.5f, 4.5f, 1.4f, 6.4f, 4.4f, 48.9f, 31.5f, 151.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 283.5f, 173.9f, 4.5f, 1.4f, 6.4f, 4.3f, 47.1f, 30.3f, 145.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 274.5f, 168.4f, 4.5f, 1.4f, 6.4f, 4.2f, 45.2f, 29.2f, 140f, 12.3f, 1.1f},
	{	0.4f, 14f, 265.5f, 162.9f, 4.5f, 1.4f, 6.4f, 4f, 43.4f, 28f, 134.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 256.5f, 157.3f, 4.5f, 1.4f, 6.4f, 3.9f, 41.6f, 26.8f, 128.6f, 12.3f, 1.1f},
	{	0.4f, 14f, 247.4f, 151.8f, 4.5f, 1.4f, 6.4f, 3.8f, 39.7f, 25.6f, 122.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 238.4f, 146.3f, 4.5f, 1.4f, 6.4f, 3.6f, 37.9f, 24.4f, 117.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 229.4f, 140.7f, 4.5f, 1.4f, 6.4f, 3.5f, 36f, 23.2f, 111.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 220.4f, 135.2f, 4.5f, 1.4f, 6.4f, 3.3f, 34.2f, 22f, 105.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 211.3f, 129.6f, 4.5f, 1.4f, 6.4f, 3.2f, 32.3f, 20.8f, 100.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 202.3f, 124.1f, 4.5f, 1.4f, 6.4f, 3.1f, 30.5f, 19.6f, 94.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 193.3f, 118.6f, 4.5f, 1.4f, 6.4f, 2.9f, 28.6f, 18.5f, 88.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 184.3f, 113f, 4.5f, 1.4f, 6.4f, 2.8f, 26.8f, 17.3f, 83f, 12.3f, 1.1f},
	{	0.4f, 14f, 175.2f, 107.5f, 4.5f, 1.4f, 6.4f, 2.7f, 25f, 16.1f, 77.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 166.2f, 102f, 4.5f, 1.4f, 6.4f, 2.5f, 23.1f, 14.9f, 71.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 157.2f, 96.4f, 4.5f, 1.4f, 6.4f, 2.4f, 21.3f, 13.7f, 65.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 148.2f, 90.9f, 4.5f, 1.4f, 6.4f, 2.3f, 19.4f, 12.5f, 60.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 143f, 87.7f, 4.5f, 1.4f, 6.4f, 2.2f, 18.4f, 11.9f, 57f, 12.3f, 1.1f},
	{	0.4f, 14f, 137.9f, 84.6f, 4.5f, 1.4f, 6.4f, 2.1f, 17.4f, 11.2f, 53.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 132.7f, 81.4f, 4.5f, 1.4f, 6.4f, 2f, 16.4f, 10.6f, 50.8f, 12.3f, 1.1f},
	{	0.4f, 14f, 127.6f, 78.3f, 4.5f, 1.4f, 6.4f, 1.9f, 15.4f, 9.9f, 47.7f, 12.3f, 1.1f},
	{	0.4f, 14f, 122.5f, 75.1f, 4.5f, 1.4f, 6.4f, 1.9f, 14.4f, 9.3f, 44.6f, 12.3f, 1.1f},
	{	0.4f, 14f, 117.3f, 72f, 4.5f, 1.4f, 6.4f, 1.8f, 13.4f, 8.6f, 41.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 112.2f, 68.8f, 4.5f, 1.4f, 6.4f, 1.7f, 12.4f, 8f, 38.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 107f, 65.7f, 4.5f, 1.4f, 6.4f, 1.6f, 11.4f, 7.3f, 35.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 101.9f, 62.5f, 4.5f, 1.4f, 6.4f, 1.5f, 10.4f, 6.7f, 32.2f, 12.3f, 1.1f},
	{	0.4f, 14f, 96.8f, 59.4f, 4.5f, 1.4f, 6.4f, 1.5f, 9.4f, 6f, 29.1f, 12.3f, 1.1f},
	{	0.4f, 14f, 95.5f, 58.6f, 4.5f, 1.4f, 6.4f, 1.5f, 9.2f, 5.9f, 28.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 94.2f, 57.8f, 4.5f, 1.4f, 6.4f, 1.4f, 9.1f, 5.8f, 28f, 12.3f, 1.1f},
	{	0.4f, 14f, 93f, 57f, 4.5f, 1.4f, 6.4f, 1.4f, 8.9f, 5.7f, 27.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 91.7f, 56.3f, 4.5f, 1.4f, 6.4f, 1.4f, 8.7f, 5.6f, 27f, 12.3f, 1.1f},
	{	0.4f, 14f, 90.5f, 55.5f, 4.5f, 1.4f, 6.4f, 1.4f, 8.6f, 5.5f, 26.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 89.2f, 54.7f, 4.5f, 1.4f, 6.4f, 1.4f, 8.4f, 5.4f, 26f, 12.3f, 1.1f},
	{	0.4f, 14f, 88f, 54f, 4.5f, 1.4f, 6.4f, 1.3f, 8.2f, 5.3f, 25.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 86.7f, 53.2f, 4.5f, 1.4f, 6.4f, 1.3f, 8.1f, 5.2f, 25f, 12.3f, 1.1f},
	{	0.4f, 14f, 85.4f, 52.4f, 4.5f, 1.4f, 6.4f, 1.3f, 7.9f, 5.1f, 24.5f, 12.3f, 1.1f},
	{	0.4f, 14f, 84.2f, 51.6f, 4.5f, 1.4f, 6.4f, 1.3f, 7.7f, 5f, 23.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 82.9f, 50.9f, 4.5f, 1.4f, 6.4f, 1.3f, 7.6f, 4.9f, 23.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 81.7f, 50.1f, 4.5f, 1.4f, 6.4f, 1.2f, 7.4f, 4.8f, 22.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 80.4f, 49.3f, 4.5f, 1.4f, 6.4f, 1.2f, 7.2f, 4.7f, 22.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 79.2f, 48.6f, 4.5f, 1.4f, 6.4f, 1.2f, 7.1f, 4.6f, 21.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 77.9f, 47.8f, 4.5f, 1.4f, 6.4f, 1.2f, 6.9f, 4.5f, 21.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 76.6f, 47f, 4.5f, 1.4f, 6.4f, 1.2f, 6.7f, 4.3f, 20.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 75.4f, 46.2f, 4.5f, 1.4f, 6.4f, 1.1f, 6.6f, 4.2f, 20.4f, 12.3f, 1.1f},
	{	0.4f, 14f, 74.1f, 45.5f, 4.5f, 1.4f, 6.4f, 1.1f, 6.4f, 4.1f, 19.9f, 12.3f, 1.1f},
	{	0.4f, 14f, 72.9f, 44.7f, 4.5f, 1.4f, 6.4f, 1.1f, 6.3f, 4f, 19.3f, 12.3f, 1.1f},
	{	0.4f, 14f, 71.6f, 43.9f, 4.5f, 1.4f, 6.4f, 1.1f, 6.1f, 3.9f, 18.8f, 12.3f, 1.1f}
    };
    
    public static float[][] Edgar14CH4_1890_1970=new float[][]{	//TgCH4
	{	0.628f, 10.819f, 3.328f, 4.279f, 10.646f, 1.35f, 3.561f, 0.61f, 25.712f, 14.044f, 3.889f, 1.996f, 0.471f},
	{	0.764f, 14.195f, 4.154f, 4.603f, 15.733f, 1.4f, 4.239f, 0.621f, 27.084f, 14.478f, 4.38f, 1.737f, 0.703f},
	{	0.962f, 20.832f, 6.278f, 5.174f, 16.329f, 1.776f, 4.485f, 0.676f, 26.896f, 15.282f, 5.319f, 2.331f, 1.07f},
	{	1.157f, 26.499f, 7.175f, 6.492f, 15.942f, 2.357f, 5.86f, 0.735f, 29.671f, 16.498f, 7.151f, 2.698f, 1.616f},
	{	1.285f, 24.087f, 7.918f, 7.954f, 18.648f, 3.781f, 7.104f, 1.114f, 25.895f, 21.756f, 11.31f, 2.884f, 1.731f},
	{	1.454f, 24.507f, 9.181f, 8.176f, 20.024f, 3.692f, 8.631f, 1.416f, 31.275f, 20.983f, 9.831f, 3.045f, 2.776f},
	{	1.723f, 28.395f, 11.291f, 15.54f, 19.798f, 5.161f, 10.512f, 1.9f, 31.91f, 22.697f, 10.765f, 3.463f, 2.232f},
	{	2.119f, 28.623f, 19.872f, 13.756f, 21.959f, 6.792f, 16.67f, 2.882f, 35.18f, 38.276f, 14.386f, 4.32f, 2.973f},
	{	2.956f, 37.158f, 24.425f, 18.594f, 21.993f, 8.029f, 22.858f, 4.159f, 36.627f, 38.94f, 16.995f, 5.608f, 2.952f}
    };
    public static float[][] Edgar14CH4_1971_2000=new float[][]{	//TgCH4
	{	3.029f, 36.332f, 24.996f, 18.868f, 21.803f, 9.478f, 26.622f, 5.286f, 36.581f, 40.756f, 17.016f, 5.705f, 2.733f},
	{	3.174f, 37.432f, 25.506f, 19.028f, 21.196f, 9.687f, 27.438f, 5.583f, 36.242f, 41.063f, 16.597f, 5.939f, 2.583f},
	{	3.286f, 37.527f, 26.085f, 19.285f, 21.521f, 9.991f, 28.291f, 6.072f, 36.809f, 40.989f, 17.107f, 5.906f, 2.571f},
	{	3.286f, 37.218f, 26.667f, 19.386f, 21.435f, 10.306f, 29.427f, 6.329f, 36.898f, 41.18f, 16.837f, 6.049f, 2.49f},
	{	3.347f, 37.145f, 27.098f, 19.565f, 21.515f, 10.719f, 30.754f, 6.157f, 37.592f, 41.905f, 17.027f, 6.162f, 2.403f},
	{	3.345f, 37.301f, 27.928f, 20.042f, 21.395f, 11.018f, 31.875f, 6.514f, 37.267f, 42.224f, 16.967f, 6.175f, 2.467f},
	{	3.374f, 36.39f, 28.641f, 20.434f, 21.266f, 11.302f, 32.756f, 6.585f, 37.86f, 42.367f, 17.308f, 6.038f, 2.525f},
	{	3.371f, 36.026f, 28.714f, 20.856f, 21.31f, 11.367f, 33.801f, 6.645f, 38.091f, 42.357f, 17.757f, 5.895f, 2.446f},
	{	3.462f, 38.339f, 29.18f, 21.518f, 21.712f, 11.526f, 34.701f, 6.845f, 37.891f, 42.18f, 17.661f, 5.8f, 2.495f},
	{	3.514f, 39.041f, 30.127f, 21.686f, 21.697f, 11.496f, 35.467f, 6.408f, 37.865f, 41.993f, 18.056f, 5.823f, 2.553f},
	{	3.445f, 38.52f, 30.53f, 21.728f, 21.508f, 10.903f, 35.742f, 6.383f, 38.354f, 41.407f, 18.243f, 5.843f, 2.567f},
	{	3.467f, 38.393f, 30.851f, 22.094f, 21.382f, 11.544f, 36.891f, 6.112f, 37.996f, 41.448f, 18.187f, 5.883f, 2.588f},
	{	3.41f, 36.736f, 30.824f, 22.34f, 21.01f, 11.502f, 37.82f, 6.052f, 38.843f, 41.877f, 18.625f, 5.764f, 2.591f},
	{	3.528f, 38.601f, 31.281f, 22.513f, 20.015f, 11.571f, 39.56f, 6.457f, 39.209f, 42.415f, 19.227f, 5.898f, 2.708f},
	{	3.561f, 38.083f, 31.392f, 22.967f, 20.572f, 11.632f, 43.922f, 6.463f, 39.319f, 42.617f, 19.676f, 6.023f, 2.742f},
	{	3.72f, 37.927f, 31.651f, 23.322f, 20.666f, 11.569f, 45.703f, 7.127f, 39.963f, 43.042f, 19.679f, 6.209f, 2.752f},
	{	3.781f, 38.774f, 31.997f, 23.467f, 20.145f, 11.578f, 47.444f, 7.38f, 39.779f, 43.413f, 19.534f, 6.173f, 2.693f},
	{	4.023f, 39.488f, 32.473f, 23.889f, 19.705f, 11.415f, 49.01f, 7.83f, 40.444f, 43.796f, 19.908f, 6.166f, 2.704f},
	{	5.545f, 39.674f, 32.905f, 24.562f, 19.56f, 11.052f, 50.21f, 8.311f, 40.767f, 44.745f, 20.222f, 6.297f, 2.743f},
	{	3.952f, 40.839f, 32.922f, 25.037f, 19.307f, 9.988f, 46.59f, 8.471f, 40.167f, 45.079f, 20.209f, 6.472f, 2.747f},
	{	4.175f, 39.873f, 33.422f, 25.448f, 19.022f, 9.377f, 44.61f, 8.509f, 40.618f, 45.153f, 20.758f, 6.455f, 2.8f},
	{	4.102f, 39.838f, 33.84f, 25.6f, 18.335f, 8.921f, 42.501f, 8.761f, 40.639f, 45.125f, 21.447f, 6.389f, 2.809f},
	{	4.451f, 39.75f, 34.058f, 25.904f, 17.677f, 8.481f, 41.065f, 9.038f, 41.206f, 45.032f, 21.652f, 6.328f, 2.821f},
	{	5.61f, 39.943f, 34.609f, 26.256f, 17.304f, 8.205f, 37.608f, 9.485f, 41.57f, 46.118f, 22.304f, 6.338f, 2.875f},
	{	5.837f, 39.781f, 35.056f, 26.735f, 17.364f, 8.202f, 36.013f, 9.942f, 42.325f, 48.195f, 23.256f, 6.322f, 2.888f},
	{	5.927f, 39.884f, 35.263f, 26.81f, 17.185f, 8.053f, 35.315f, 10.239f, 43.076f, 48.333f, 23.561f, 6.433f, 2.867f},
	{	6.017f, 39.986f, 35.471f, 26.884f, 17.006f, 7.905f, 34.617f, 10.535f, 43.827f, 48.471f, 23.866f, 6.544f, 2.846f},
	{	6.107f, 40.089f, 35.679f, 26.959f, 16.827f, 7.756f, 33.92f, 10.831f, 44.578f, 48.609f, 24.171f, 6.655f, 2.826f},
	{	6.198f, 40.191f, 35.886f, 27.034f, 16.648f, 7.607f, 33.222f, 11.127f, 45.328f, 48.747f, 24.476f, 6.766f, 2.805f},
	{	6.288f, 40.294f, 36.094f, 27.108f, 16.469f, 7.458f, 32.524f, 11.424f, 46.079f, 48.884f, 24.781f, 6.877f, 2.784f}
    };
    
    public static float[][] Edgar14CH4_2001_2100_A2=new float[][]{	//TgCH4
	{	6.463f, 40.616f, 36.729f, 28.273f, 16.597f, 7.408f, 32.806f, 11.817f, 46.726f, 49.332f, 25.487f, 6.697f, 2.814f},
	{	6.638f, 40.938f, 37.365f, 29.437f, 16.725f, 7.358f, 33.087f, 12.211f, 47.372f, 49.779f, 26.193f, 6.518f, 2.844f},
	{	6.814f, 41.26f, 38f, 30.601f, 16.853f, 7.308f, 33.369f, 12.605f, 48.018f, 50.226f, 26.899f, 6.338f, 2.873f},
	{	6.989f, 41.582f, 38.636f, 31.765f, 16.982f, 7.259f, 33.65f, 12.998f, 48.665f, 50.674f, 27.605f, 6.158f, 2.903f},
	{	7.164f, 41.904f, 39.271f, 32.929f, 17.11f, 7.209f, 33.932f, 13.392f, 49.311f, 51.121f, 28.311f, 5.979f, 2.932f},
	{	7.34f, 42.226f, 39.906f, 34.093f, 17.238f, 7.159f, 34.213f, 13.786f, 49.958f, 51.568f, 29.017f, 5.799f, 2.962f},
	{	7.515f, 42.547f, 40.542f, 35.257f, 17.366f, 7.109f, 34.495f, 14.18f, 50.604f, 52.015f, 29.723f, 5.619f, 2.991f},
	{	7.69f, 42.869f, 41.177f, 36.421f, 17.494f, 7.059f, 34.777f, 14.573f, 51.25f, 52.463f, 30.429f, 5.44f, 3.021f},
	{	7.865f, 43.191f, 41.813f, 37.585f, 17.622f, 7.009f, 35.058f, 14.967f, 51.897f, 52.91f, 31.135f, 5.26f, 3.05f},
	{	8.041f, 43.513f, 42.448f, 38.749f, 17.751f, 6.959f, 35.34f, 15.361f, 52.543f, 53.357f, 31.842f, 5.08f, 3.08f},
	{	8.285f, 43.856f, 43.437f, 39.608f, 17.821f, 7.105f, 35.678f, 15.872f, 53.172f, 53.868f, 32.458f, 5.093f, 3.085f},
	{	8.529f, 44.2f, 44.425f, 40.467f, 17.891f, 7.251f, 36.016f, 16.383f, 53.8f, 54.378f, 33.075f, 5.106f, 3.09f},
	{	8.774f, 44.543f, 45.414f, 41.326f, 17.962f, 7.397f, 36.354f, 16.894f, 54.429f, 54.888f, 33.692f, 5.118f, 3.095f},
	{	9.018f, 44.886f, 46.403f, 42.185f, 18.032f, 7.543f, 36.693f, 17.405f, 55.057f, 55.399f, 34.309f, 5.131f, 3.1f},
	{	9.262f, 45.229f, 47.391f, 43.044f, 18.103f, 7.689f, 37.031f, 17.916f, 55.686f, 55.909f, 34.925f, 5.143f, 3.105f},
	{	9.507f, 45.572f, 48.38f, 43.903f, 18.173f, 7.835f, 37.369f, 18.427f, 56.314f, 56.42f, 35.542f, 5.156f, 3.11f},
	{	9.751f, 45.916f, 49.369f, 44.762f, 18.244f, 7.981f, 37.707f, 18.938f, 56.943f, 56.93f, 36.159f, 5.169f, 3.115f},
	{	9.996f, 46.259f, 50.358f, 45.621f, 18.314f, 8.127f, 38.046f, 19.449f, 57.571f, 57.441f, 36.775f, 5.181f, 3.12f},
	{	10.24f, 46.602f, 51.346f, 46.48f, 18.384f, 8.273f, 38.384f, 19.96f, 58.2f, 57.951f, 37.392f, 5.194f, 3.125f},
	{	10.484f, 46.945f, 52.335f, 47.339f, 18.455f, 8.418f, 38.722f, 20.471f, 58.828f, 58.461f, 38.009f, 5.207f, 3.13f},
	{	10.454f, 47.635f, 53.235f, 47.684f, 18.49f, 8.48f, 39.782f, 21.077f, 59.601f, 59.32f, 38.409f, 5.242f, 3.155f},
	{	10.423f, 48.324f, 54.135f, 48.029f, 18.526f, 8.542f, 40.842f, 21.682f, 60.373f, 60.178f, 38.809f, 5.277f, 3.18f},
	{	10.392f, 49.013f, 55.036f, 48.374f, 18.562f, 8.604f, 41.902f, 22.287f, 61.146f, 61.036f, 39.21f, 5.313f, 3.204f},
	{	10.361f, 49.703f, 55.936f, 48.719f, 18.597f, 8.666f, 42.962f, 22.893f, 61.918f, 61.895f, 39.61f, 5.348f, 3.229f},
	{	10.33f, 50.392f, 56.836f, 49.064f, 18.633f, 8.728f, 44.022f, 23.498f, 62.691f, 62.753f, 40.01f, 5.384f, 3.253f},
	{	10.299f, 51.081f, 57.736f, 49.409f, 18.668f, 8.79f, 45.081f, 24.104f, 63.464f, 63.611f, 40.41f, 5.419f, 3.278f},
	{	10.268f, 51.771f, 58.637f, 49.754f, 18.704f, 8.852f, 46.141f, 24.709f, 64.236f, 64.47f, 40.81f, 5.455f, 3.303f},
	{	10.237f, 52.46f, 59.537f, 50.099f, 18.74f, 8.914f, 47.201f, 25.315f, 65.009f, 65.328f, 41.211f, 5.49f, 3.327f},
	{	10.206f, 53.149f, 60.437f, 50.443f, 18.775f, 8.976f, 48.261f, 25.92f, 65.781f, 66.186f, 41.611f, 5.526f, 3.352f},
	{	10.175f, 53.839f, 61.337f, 50.788f, 18.811f, 9.038f, 49.321f, 26.525f, 66.554f, 67.044f, 42.011f, 5.561f, 3.376f},
	{	10.126f, 54.416f, 61.435f, 51.699f, 18.89f, 9.12f, 50.335f, 27.199f, 67.22f, 68.095f, 42.321f, 5.603f, 3.409f},
	{	10.077f, 54.994f, 61.532f, 52.61f, 18.969f, 9.203f, 51.348f, 27.873f, 67.887f, 69.145f, 42.631f, 5.646f, 3.442f},
	{	10.027f, 55.572f, 61.629f, 53.52f, 19.048f, 9.285f, 52.362f, 28.546f, 68.553f, 70.196f, 42.942f, 5.688f, 3.475f},
	{	9.978f, 56.149f, 61.726f, 54.431f, 19.127f, 9.367f, 53.375f, 29.22f, 69.219f, 71.246f, 43.252f, 5.73f, 3.507f},
	{	9.928f, 56.727f, 61.824f, 55.342f, 19.206f, 9.45f, 54.389f, 29.894f, 69.885f, 72.296f, 43.562f, 5.773f, 3.54f},
	{	9.879f, 57.304f, 61.921f, 56.252f, 19.285f, 9.532f, 55.403f, 30.567f, 70.552f, 73.347f, 43.872f, 5.815f, 3.573f},
	{	9.83f, 57.882f, 62.018f, 57.163f, 19.364f, 9.614f, 56.416f, 31.241f, 71.218f, 74.397f, 44.182f, 5.857f, 3.605f},
	{	9.78f, 58.459f, 62.115f, 58.074f, 19.443f, 9.697f, 57.43f, 31.915f, 71.884f, 75.448f, 44.492f, 5.899f, 3.638f},
	{	9.731f, 59.037f, 62.213f, 58.984f, 19.522f, 9.779f, 58.443f, 32.588f, 72.551f, 76.498f, 44.803f, 5.942f, 3.671f},
	{	9.681f, 59.615f, 62.31f, 59.895f, 19.601f, 9.862f, 59.457f, 33.262f, 73.217f, 77.549f, 45.113f, 5.984f, 3.703f},
	{	9.913f, 60.007f, 62.482f, 60.54f, 19.688f, 9.99f, 60.424f, 33.935f, 73.99f, 78.716f, 45.212f, 6.01f, 3.728f},
	{	10.145f, 60.399f, 62.654f, 61.185f, 19.775f, 10.118f, 61.392f, 34.608f, 74.762f, 79.883f, 45.311f, 6.036f, 3.753f},
	{	10.377f, 60.792f, 62.826f, 61.83f, 19.861f, 10.246f, 62.359f, 35.281f, 75.535f, 81.051f, 45.409f, 6.062f, 3.777f},
	{	10.609f, 61.184f, 62.998f, 62.475f, 19.948f, 10.374f, 63.326f, 35.954f, 76.308f, 82.218f, 45.508f, 6.088f, 3.802f},
	{	10.841f, 61.576f, 63.17f, 63.12f, 20.035f, 10.502f, 64.294f, 36.627f, 77.081f, 83.385f, 45.607f, 6.114f, 3.827f},
	{	11.073f, 61.969f, 63.341f, 63.765f, 20.122f, 10.63f, 65.261f, 37.3f, 77.854f, 84.553f, 45.706f, 6.141f, 3.851f},
	{	11.305f, 62.361f, 63.513f, 64.41f, 20.208f, 10.758f, 66.228f, 37.973f, 78.626f, 85.72f, 45.805f, 6.167f, 3.876f},
	{	11.537f, 62.753f, 63.685f, 65.056f, 20.295f, 10.886f, 67.196f, 38.646f, 79.399f, 86.887f, 45.904f, 6.193f, 3.901f},
	{	11.769f, 63.146f, 63.857f, 65.701f, 20.382f, 11.013f, 68.163f, 39.319f, 80.172f, 88.055f, 46.003f, 6.219f, 3.925f},
	{	12.001f, 63.538f, 64.029f, 66.346f, 20.468f, 11.141f, 69.13f, 39.992f, 80.945f, 89.222f, 46.102f, 6.245f, 3.95f},
	{	12.167f, 64.015f, 64.234f, 67.197f, 20.511f, 11.187f, 70.545f, 40.734f, 81.104f, 90.186f, 46.354f, 6.369f, 3.968f},
	{	12.332f, 64.492f, 64.44f, 68.048f, 20.553f, 11.232f, 71.959f, 41.475f, 81.264f, 91.149f, 46.606f, 6.493f, 3.986f},
	{	12.497f, 64.968f, 64.645f, 68.899f, 20.596f, 11.277f, 73.373f, 42.217f, 81.423f, 92.113f, 46.859f, 6.618f, 4.004f},
	{	12.663f, 65.445f, 64.85f, 69.75f, 20.638f, 11.322f, 74.788f, 42.958f, 81.583f, 93.077f, 47.111f, 6.742f, 4.022f},
	{	12.828f, 65.922f, 65.055f, 70.602f, 20.681f, 11.367f, 76.202f, 43.7f, 81.742f, 94.04f, 47.364f, 6.866f, 4.04f},
	{	12.993f, 66.398f, 65.26f, 71.453f, 20.723f, 11.412f, 77.616f, 44.441f, 81.902f, 95.004f, 47.616f, 6.991f, 4.058f},
	{	13.159f, 66.875f, 65.466f, 72.304f, 20.765f, 11.457f, 79.031f, 45.183f, 82.062f, 95.968f, 47.869f, 7.115f, 4.076f},
	{	13.324f, 67.352f, 65.671f, 73.155f, 20.808f, 11.502f, 80.445f, 45.924f, 82.221f, 96.931f, 48.121f, 7.239f, 4.094f},
	{	13.489f, 67.828f, 65.876f, 74.006f, 20.85f, 11.547f, 81.859f, 46.666f, 82.381f, 97.895f, 48.374f, 7.363f, 4.113f},
	{	13.654f, 68.305f, 66.081f, 74.857f, 20.893f, 11.592f, 83.274f, 47.407f, 82.54f, 98.859f, 48.626f, 7.488f, 4.131f},
	{	13.767f, 68.691f, 66.541f, 75.554f, 20.994f, 11.657f, 84.668f, 47.914f, 81.99f, 100.127f, 49.254f, 7.661f, 4.15f},
	{	13.879f, 69.078f, 67.001f, 76.25f, 21.094f, 11.723f, 86.062f, 48.421f, 81.44f, 101.396f, 49.883f, 7.834f, 4.17f},
	{	13.991f, 69.464f, 67.461f, 76.947f, 21.195f, 11.788f, 87.456f, 48.927f, 80.89f, 102.664f, 50.511f, 8.008f, 4.19f},
	{	14.103f, 69.851f, 67.921f, 77.643f, 21.296f, 11.853f, 88.85f, 49.434f, 80.34f, 103.932f, 51.139f, 8.181f, 4.21f},
	{	14.216f, 70.237f, 68.381f, 78.339f, 21.397f, 11.918f, 90.244f, 49.94f, 79.789f, 105.201f, 51.768f, 8.354f, 4.23f},
	{	14.328f, 70.624f, 68.841f, 79.036f, 21.497f, 11.983f, 91.638f, 50.447f, 79.239f, 106.469f, 52.396f, 8.528f, 4.25f},
	{	14.44f, 71.01f, 69.301f, 79.732f, 21.598f, 12.048f, 93.032f, 50.954f, 78.689f, 107.738f, 53.024f, 8.701f, 4.269f},
	{	14.552f, 71.396f, 69.761f, 80.429f, 21.699f, 12.113f, 94.426f, 51.46f, 78.139f, 109.006f, 53.652f, 8.874f, 4.289f},
	{	14.665f, 71.783f, 70.221f, 81.125f, 21.8f, 12.179f, 95.82f, 51.967f, 77.589f, 110.274f, 54.281f, 9.048f, 4.309f},
	{	14.777f, 72.169f, 70.681f, 81.821f, 21.901f, 12.244f, 97.214f, 52.473f, 77.039f, 111.543f, 54.909f, 9.221f, 4.329f},
	{	14.937f, 72.813f, 71.6f, 82.599f, 22.066f, 12.382f, 98.42f, 52.303f, 76.673f, 113.195f, 55.158f, 9.454f, 4.344f},
	{	15.096f, 73.457f, 72.518f, 83.377f, 22.231f, 12.52f, 99.626f, 52.132f, 76.307f, 114.848f, 55.407f, 9.686f, 4.358f},
	{	15.256f, 74.101f, 73.437f, 84.155f, 22.397f, 12.658f, 100.833f, 51.961f, 75.941f, 116.501f, 55.656f, 9.919f, 4.373f},
	{	15.415f, 74.745f, 74.355f, 84.933f, 22.562f, 12.796f, 102.039f, 51.79f, 75.575f, 118.154f, 55.906f, 10.151f, 4.388f},
	{	15.575f, 75.389f, 75.273f, 85.711f, 22.728f, 12.933f, 103.245f, 51.619f, 75.209f, 119.806f, 56.155f, 10.384f, 4.403f},
	{	15.735f, 76.033f, 76.192f, 86.488f, 22.893f, 13.071f, 104.452f, 51.448f, 74.843f, 121.459f, 56.404f, 10.616f, 4.417f},
	{	15.894f, 76.677f, 77.11f, 87.266f, 23.059f, 13.209f, 105.658f, 51.278f, 74.477f, 123.112f, 56.653f, 10.849f, 4.432f},
	{	16.054f, 77.321f, 78.029f, 88.044f, 23.224f, 13.347f, 106.864f, 51.107f, 74.111f, 124.765f, 56.902f, 11.081f, 4.447f},
	{	16.213f, 77.965f, 78.947f, 88.822f, 23.39f, 13.485f, 108.071f, 50.936f, 73.745f, 126.417f, 57.151f, 11.314f, 4.462f},
	{	16.373f, 78.609f, 79.865f, 89.6f, 23.555f, 13.623f, 109.277f, 50.765f, 73.379f, 128.07f, 57.4f, 11.546f, 4.477f},
	{	16.591f, 79.667f, 81.148f, 90.049f, 23.741f, 13.78f, 110.351f, 50.167f, 73.488f, 129.602f, 57.479f, 11.733f, 4.495f},
	{	16.808f, 80.725f, 82.431f, 90.498f, 23.927f, 13.936f, 111.424f, 49.569f, 73.597f, 131.133f, 57.558f, 11.92f, 4.514f},
	{	17.026f, 81.782f, 83.714f, 90.948f, 24.113f, 14.093f, 112.498f, 48.971f, 73.707f, 132.664f, 57.636f, 12.107f, 4.532f},
	{	17.244f, 82.84f, 84.998f, 91.397f, 24.299f, 14.249f, 113.572f, 48.373f, 73.816f, 134.196f, 57.715f, 12.294f, 4.551f},
	{	17.461f, 83.898f, 86.281f, 91.846f, 24.485f, 14.406f, 114.645f, 47.776f, 73.925f, 135.727f, 57.794f, 12.481f, 4.569f},
	{	17.679f, 84.956f, 87.564f, 92.295f, 24.671f, 14.562f, 115.719f, 47.178f, 74.034f, 137.259f, 57.872f, 12.668f, 4.588f},
	{	17.896f, 86.013f, 88.847f, 92.745f, 24.857f, 14.719f, 116.793f, 46.58f, 74.143f, 138.79f, 57.951f, 12.855f, 4.606f},
	{	18.114f, 87.071f, 90.13f, 93.194f, 25.042f, 14.875f, 117.866f, 45.982f, 74.252f, 140.322f, 58.03f, 13.042f, 4.625f},
	{	18.332f, 88.129f, 91.413f, 93.643f, 25.228f, 15.032f, 118.94f, 45.384f, 74.361f, 141.853f, 58.108f, 13.229f, 4.643f},
	{	18.549f, 89.187f, 92.696f, 94.093f, 25.414f, 15.188f, 120.014f, 44.786f, 74.47f, 143.385f, 58.187f, 13.416f, 4.662f},
	{	18.754f, 90.053f, 93.722f, 94.546f, 25.592f, 15.239f, 121.195f, 44.509f, 74.758f, 144.683f, 58.32f, 13.799f, 4.666f},
	{	18.958f, 90.919f, 94.747f, 94.999f, 25.77f, 15.29f, 122.375f, 44.233f, 75.046f, 145.981f, 58.453f, 14.182f, 4.671f},
	{	19.163f, 91.785f, 95.773f, 95.452f, 25.948f, 15.341f, 123.556f, 43.956f, 75.334f, 147.279f, 58.586f, 14.566f, 4.675f},
	{	19.367f, 92.651f, 96.799f, 95.905f, 26.125f, 15.392f, 124.737f, 43.679f, 75.621f, 148.577f, 58.719f, 14.949f, 4.68f},
	{	19.572f, 93.517f, 97.825f, 96.358f, 26.303f, 15.443f, 125.917f, 43.403f, 75.909f, 149.876f, 58.851f, 15.333f, 4.685f},
	{	19.776f, 94.383f, 98.851f, 96.811f, 26.481f, 15.494f, 127.098f, 43.126f, 76.197f, 151.174f, 58.984f, 15.716f, 4.689f},
	{	19.981f, 95.249f, 99.876f, 97.264f, 26.659f, 15.545f, 128.279f, 42.849f, 76.485f, 152.472f, 59.117f, 16.1f, 4.694f},
	{	20.185f, 96.115f, 100.902f, 97.717f, 26.836f, 15.595f, 129.459f, 42.573f, 76.773f, 153.77f, 59.25f, 16.483f, 4.699f},
	{	20.39f, 96.981f, 101.928f, 98.171f, 27.014f, 15.646f, 130.64f, 42.296f, 77.061f, 155.068f, 59.383f, 16.866f, 4.703f},
	{	20.594f, 97.847f, 102.954f, 98.624f, 27.192f, 15.697f, 131.821f, 42.019f, 77.349f, 156.366f, 59.516f, 17.25f, 4.708f}
    };
    
    public static float[][] Edgar14N2O_1890_1970=new float[][]{	//TgN
	{	0.009f, 0.145f, 0.05f, 0.036f, 0.059f, 0.008f, 0.038f, 0.008f, 0.209f, 0.038f, 0.035f, 0.07f, 0.002f},
	{	0.01f, 0.153f, 0.063f, 0.04f, 0.101f, 0.005f, 0.042f, 0.009f, 0.215f, 0.043f, 0.042f, 0.055f, 0.002f},
	{	0.012f, 0.16f, 0.089f, 0.046f, 0.087f, 0.006f, 0.043f, 0.01f, 0.222f, 0.049f, 0.051f, 0.076f, 0.002f},
	{	0.013f, 0.179f, 0.102f, 0.067f, 0.092f, 0.015f, 0.062f, 0.01f, 0.227f, 0.059f, 0.066f, 0.083f, 0.003f},
	{	0.015f, 0.163f, 0.107f, 0.088f, 0.108f, 0.03f, 0.067f, 0.017f, 0.234f, 0.071f, 0.08f, 0.093f, 0.003f},
	{	0.017f, 0.181f, 0.121f, 0.082f, 0.145f, 0.019f, 0.061f, 0.022f, 0.238f, 0.089f, 0.091f, 0.091f, 0.006f},
	{	0.029f, 0.394f, 0.189f, 0.304f, 0.377f, 0.066f, 0.097f, 0.039f, 0.266f, 0.153f, 0.143f, 0.152f, 0.04f},
	{	0.041f, 0.495f, 0.28f, 0.211f, 0.531f, 0.094f, 0.141f, 0.052f, 0.287f, 0.214f, 0.165f, 0.188f, 0.044f},
	{	0.08f, 0.939f, 0.442f, 0.347f, 0.932f, 0.191f, 0.344f, 0.092f, 0.41f, 0.506f, 0.238f, 0.339f, 0.055f}
    };
    public static float[][] Edgar14N2O_1971_2000=new float[][]{	//TgN
	{	0.086f, 0.964f, 0.446f, 0.352f, 0.955f, 0.204f, 0.361f, 0.094f, 0.422f, 0.531f, 0.24f, 0.34f, 0.056f},
	{	0.089f, 0.992f, 0.458f, 0.354f, 0.974f, 0.212f, 0.371f, 0.095f, 0.422f, 0.556f, 0.244f, 0.341f, 0.061f},
	{	0.096f, 1.043f, 0.467f, 0.353f, 1.019f, 0.224f, 0.399f, 0.096f, 0.436f, 0.583f, 0.249f, 0.323f, 0.066f},
	{	0.091f, 1.031f, 0.481f, 0.355f, 1.059f, 0.234f, 0.404f, 0.097f, 0.443f, 0.579f, 0.248f, 0.333f, 0.063f},
	{	0.095f, 1.086f, 0.492f, 0.365f, 1.061f, 0.243f, 0.406f, 0.101f, 0.485f, 0.617f, 0.248f, 0.345f, 0.06f},
	{	0.098f, 1.07f, 0.508f, 0.369f, 1.054f, 0.24f, 0.418f, 0.106f, 0.492f, 0.618f, 0.254f, 0.345f, 0.062f},
	{	0.102f, 1.066f, 0.522f, 0.377f, 1.062f, 0.242f, 0.417f, 0.109f, 0.515f, 0.67f, 0.261f, 0.331f, 0.066f},
	{	0.103f, 1.064f, 0.52f, 0.388f, 1.09f, 0.249f, 0.43f, 0.112f, 0.544f, 0.739f, 0.268f, 0.325f, 0.067f},
	{	0.102f, 1.092f, 0.529f, 0.396f, 1.108f, 0.247f, 0.419f, 0.114f, 0.555f, 0.787f, 0.27f, 0.323f, 0.07f},
	{	0.108f, 1.078f, 0.545f, 0.404f, 1.094f, 0.239f, 0.432f, 0.119f, 0.548f, 0.843f, 0.278f, 0.327f, 0.065f},
	{	0.112f, 1.084f, 0.55f, 0.408f, 1.071f, 0.242f, 0.424f, 0.123f, 0.575f, 0.831f, 0.29f, 0.325f, 0.065f},
	{	0.115f, 1.025f, 0.55f, 0.415f, 1.06f, 0.244f, 0.439f, 0.127f, 0.6f, 0.852f, 0.301f, 0.327f, 0.067f},
	{	0.114f, 1.005f, 0.545f, 0.416f, 1.06f, 0.243f, 0.466f, 0.132f, 0.636f, 0.899f, 0.312f, 0.32f, 0.068f},
	{	0.117f, 1.051f, 0.556f, 0.411f, 1.09f, 0.246f, 0.468f, 0.131f, 0.647f, 0.927f, 0.32f, 0.328f, 0.069f},
	{	0.116f, 1.028f, 0.564f, 0.421f, 1.085f, 0.236f, 0.479f, 0.127f, 0.658f, 0.892f, 0.324f, 0.337f, 0.07f},
	{	0.116f, 1.001f, 0.564f, 0.428f, 1.08f, 0.235f, 0.488f, 0.132f, 0.672f, 0.904f, 0.337f, 0.341f, 0.071f},
	{	0.115f, 0.998f, 0.57f, 0.431f, 1.066f, 0.23f, 0.496f, 0.135f, 0.678f, 1.006f, 0.338f, 0.336f, 0.071f},
	{	0.111f, 0.972f, 0.574f, 0.44f, 1.051f, 0.233f, 0.482f, 0.136f, 0.726f, 1.072f, 0.349f, 0.343f, 0.071f},
	{	0.128f, 1.009f, 0.58f, 0.45f, 1.038f, 0.228f, 0.464f, 0.141f, 0.749f, 1.118f, 0.353f, 0.352f, 0.073f},
	{	0.117f, 1.018f, 0.578f, 0.459f, 1.003f, 0.192f, 0.443f, 0.141f, 0.773f, 1.162f, 0.357f, 0.359f, 0.073f},
	{	0.121f, 1.022f, 0.575f, 0.462f, 0.968f, 0.162f, 0.407f, 0.136f, 0.791f, 1.183f, 0.362f, 0.354f, 0.072f},
	{	0.122f, 1.057f, 0.582f, 0.458f, 0.943f, 0.15f, 0.361f, 0.143f, 0.813f, 1.206f, 0.378f, 0.342f, 0.072f},
	{	0.129f, 1.066f, 0.582f, 0.464f, 0.945f, 0.144f, 0.324f, 0.142f, 0.831f, 1.165f, 0.385f, 0.336f, 0.071f},
	{	0.141f, 1.105f, 0.591f, 0.468f, 0.953f, 0.142f, 0.28f, 0.14f, 0.862f, 1.234f, 0.398f, 0.337f, 0.072f},
	{	0.148f, 1.122f, 0.594f, 0.473f, 0.955f, 0.147f, 0.255f, 0.143f, 0.899f, 1.39f, 0.407f, 0.334f, 0.071f},
	{	0.143f, 1.11f, 0.663f, 0.449f, 0.975f, 0.245f, 0.365f, 0.135f, 0.944f, 1.196f, 0.316f, 0.247f, 0.091f},
	{	0.144f, 1.114f, 0.672f, 0.452f, 0.96f, 0.251f, 0.354f, 0.135f, 0.959f, 1.211f, 0.313f, 0.257f, 0.091f},
	{	0.144f, 1.118f, 0.68f, 0.454f, 0.945f, 0.257f, 0.344f, 0.136f, 0.974f, 1.226f, 0.31f, 0.267f, 0.09f},
	{	0.145f, 1.122f, 0.689f, 0.457f, 0.931f, 0.264f, 0.333f, 0.136f, 0.989f, 1.242f, 0.307f, 0.277f, 0.09f},
	{	0.146f, 1.126f, 0.697f, 0.46f, 0.916f, 0.27f, 0.323f, 0.137f, 1.004f, 1.257f, 0.304f, 0.287f, 0.089f}
    };
    public static float[][] Edgar14N2O_2001_2100_A2=new float[][]{	//TgN
	{	0.147f, 1.14f, 0.701f, 0.48f, 0.918f, 0.272f, 0.326f, 0.14f, 1.029f, 1.271f, 0.325f, 0.278f, 0.091f},
	{	0.149f, 1.155f, 0.704f, 0.5f, 0.92f, 0.274f, 0.328f, 0.143f, 1.054f, 1.286f, 0.347f, 0.269f, 0.093f},
	{	0.15f, 1.169f, 0.708f, 0.52f, 0.923f, 0.276f, 0.331f, 0.146f, 1.08f, 1.301f, 0.368f, 0.26f, 0.095f},
	{	0.151f, 1.183f, 0.711f, 0.54f, 0.925f, 0.278f, 0.334f, 0.149f, 1.105f, 1.315f, 0.39f, 0.251f, 0.096f},
	{	0.153f, 1.197f, 0.715f, 0.56f, 0.927f, 0.28f, 0.336f, 0.152f, 1.131f, 1.33f, 0.411f, 0.242f, 0.098f},
	{	0.154f, 1.212f, 0.718f, 0.581f, 0.929f, 0.283f, 0.339f, 0.155f, 1.156f, 1.344f, 0.433f, 0.233f, 0.1f},
	{	0.155f, 1.226f, 0.722f, 0.601f, 0.932f, 0.285f, 0.342f, 0.158f, 1.181f, 1.359f, 0.454f, 0.224f, 0.102f},
	{	0.157f, 1.24f, 0.725f, 0.621f, 0.934f, 0.287f, 0.344f, 0.161f, 1.207f, 1.373f, 0.476f, 0.215f, 0.104f},
	{	0.158f, 1.254f, 0.729f, 0.641f, 0.936f, 0.289f, 0.347f, 0.165f, 1.232f, 1.388f, 0.497f, 0.206f, 0.106f},
	{	0.16f, 1.269f, 0.733f, 0.661f, 0.939f, 0.291f, 0.35f, 0.168f, 1.257f, 1.402f, 0.519f, 0.198f, 0.107f},
	{	0.161f, 1.292f, 0.745f, 0.679f, 0.944f, 0.292f, 0.354f, 0.172f, 1.291f, 1.426f, 0.541f, 0.2f, 0.108f},
	{	0.163f, 1.315f, 0.758f, 0.696f, 0.949f, 0.293f, 0.358f, 0.176f, 1.324f, 1.45f, 0.563f, 0.203f, 0.109f},
	{	0.164f, 1.337f, 0.771f, 0.714f, 0.954f, 0.293f, 0.362f, 0.18f, 1.357f, 1.474f, 0.585f, 0.206f, 0.109f},
	{	0.166f, 1.36f, 0.783f, 0.731f, 0.959f, 0.294f, 0.366f, 0.184f, 1.39f, 1.498f, 0.606f, 0.208f, 0.11f},
	{	0.167f, 1.383f, 0.796f, 0.749f, 0.965f, 0.295f, 0.37f, 0.188f, 1.423f, 1.522f, 0.628f, 0.211f, 0.111f},
	{	0.169f, 1.406f, 0.809f, 0.767f, 0.97f, 0.296f, 0.374f, 0.192f, 1.456f, 1.545f, 0.65f, 0.214f, 0.111f},
	{	0.17f, 1.429f, 0.821f, 0.784f, 0.975f, 0.297f, 0.378f, 0.197f, 1.489f, 1.569f, 0.672f, 0.217f, 0.112f},
	{	0.172f, 1.452f, 0.834f, 0.802f, 0.98f, 0.297f, 0.383f, 0.201f, 1.522f, 1.593f, 0.694f, 0.219f, 0.113f},
	{	0.173f, 1.475f, 0.847f, 0.82f, 0.986f, 0.298f, 0.387f, 0.205f, 1.555f, 1.617f, 0.716f, 0.222f, 0.113f},
	{	0.175f, 1.498f, 0.859f, 0.837f, 0.991f, 0.299f, 0.391f, 0.209f, 1.588f, 1.641f, 0.738f, 0.225f, 0.114f},
	{	0.175f, 1.509f, 0.881f, 0.842f, 0.991f, 0.299f, 0.396f, 0.215f, 1.614f, 1.654f, 0.759f, 0.227f, 0.114f},
	{	0.176f, 1.52f, 0.902f, 0.847f, 0.991f, 0.298f, 0.401f, 0.221f, 1.64f, 1.666f, 0.78f, 0.229f, 0.114f},
	{	0.176f, 1.532f, 0.923f, 0.851f, 0.99f, 0.298f, 0.407f, 0.227f, 1.665f, 1.679f, 0.801f, 0.23f, 0.113f},
	{	0.177f, 1.543f, 0.944f, 0.856f, 0.99f, 0.298f, 0.412f, 0.233f, 1.691f, 1.692f, 0.822f, 0.232f, 0.113f},
	{	0.177f, 1.555f, 0.966f, 0.861f, 0.99f, 0.298f, 0.417f, 0.239f, 1.717f, 1.705f, 0.843f, 0.234f, 0.113f},
	{	0.178f, 1.566f, 0.987f, 0.866f, 0.99f, 0.297f, 0.423f, 0.245f, 1.742f, 1.717f, 0.864f, 0.236f, 0.112f},
	{	0.178f, 1.577f, 1.008f, 0.87f, 0.99f, 0.297f, 0.428f, 0.251f, 1.768f, 1.73f, 0.885f, 0.238f, 0.112f},
	{	0.179f, 1.589f, 1.03f, 0.875f, 0.99f, 0.297f, 0.433f, 0.258f, 1.794f, 1.743f, 0.906f, 0.24f, 0.112f},
	{	0.18f, 1.6f, 1.051f, 0.88f, 0.99f, 0.297f, 0.438f, 0.264f, 1.819f, 1.756f, 0.927f, 0.242f, 0.111f},
	{	0.18f, 1.612f, 1.072f, 0.885f, 0.989f, 0.296f, 0.444f, 0.27f, 1.845f, 1.768f, 0.948f, 0.244f, 0.111f},
	{	0.18f, 1.611f, 1.082f, 0.899f, 0.985f, 0.295f, 0.449f, 0.273f, 1.858f, 1.777f, 0.964f, 0.245f, 0.11f},
	{	0.18f, 1.61f, 1.093f, 0.913f, 0.981f, 0.293f, 0.455f, 0.276f, 1.872f, 1.785f, 0.981f, 0.246f, 0.11f},
	{	0.181f, 1.609f, 1.103f, 0.928f, 0.976f, 0.291f, 0.461f, 0.279f, 1.886f, 1.793f, 0.998f, 0.246f, 0.109f},
	{	0.181f, 1.608f, 1.113f, 0.942f, 0.972f, 0.29f, 0.466f, 0.282f, 1.899f, 1.801f, 1.015f, 0.247f, 0.109f},
	{	0.181f, 1.608f, 1.124f, 0.957f, 0.967f, 0.288f, 0.472f, 0.285f, 1.913f, 1.81f, 1.032f, 0.248f, 0.108f},
	{	0.181f, 1.607f, 1.134f, 0.971f, 0.963f, 0.287f, 0.477f, 0.288f, 1.926f, 1.818f, 1.049f, 0.249f, 0.107f},
	{	0.181f, 1.606f, 1.144f, 0.985f, 0.958f, 0.285f, 0.483f, 0.292f, 1.94f, 1.826f, 1.065f, 0.25f, 0.107f},
	{	0.181f, 1.605f, 1.155f, 1f, 0.954f, 0.283f, 0.488f, 0.295f, 1.953f, 1.835f, 1.082f, 0.251f, 0.106f},
	{	0.181f, 1.604f, 1.165f, 1.014f, 0.95f, 0.282f, 0.494f, 0.298f, 1.967f, 1.843f, 1.099f, 0.252f, 0.106f},
	{	0.182f, 1.604f, 1.175f, 1.028f, 0.945f, 0.28f, 0.5f, 0.301f, 1.98f, 1.851f, 1.116f, 0.253f, 0.105f},
	{	0.181f, 1.603f, 1.197f, 1.032f, 0.942f, 0.279f, 0.505f, 0.304f, 1.993f, 1.864f, 1.128f, 0.252f, 0.104f},
	{	0.181f, 1.603f, 1.218f, 1.035f, 0.939f, 0.278f, 0.51f, 0.307f, 2.006f, 1.877f, 1.141f, 0.252f, 0.103f},
	{	0.181f, 1.603f, 1.24f, 1.038f, 0.936f, 0.276f, 0.515f, 0.31f, 2.019f, 1.89f, 1.153f, 0.252f, 0.101f},
	{	0.181f, 1.603f, 1.262f, 1.042f, 0.933f, 0.275f, 0.521f, 0.313f, 2.032f, 1.903f, 1.166f, 0.252f, 0.1f},
	{	0.18f, 1.603f, 1.283f, 1.045f, 0.931f, 0.274f, 0.526f, 0.316f, 2.045f, 1.917f, 1.179f, 0.251f, 0.099f},
	{	0.18f, 1.603f, 1.305f, 1.048f, 0.928f, 0.272f, 0.531f, 0.319f, 2.058f, 1.93f, 1.191f, 0.251f, 0.098f},
	{	0.18f, 1.603f, 1.326f, 1.052f, 0.925f, 0.271f, 0.536f, 0.322f, 2.071f, 1.943f, 1.204f, 0.251f, 0.097f},
	{	0.18f, 1.602f, 1.348f, 1.055f, 0.922f, 0.27f, 0.542f, 0.325f, 2.084f, 1.956f, 1.216f, 0.251f, 0.095f},
	{	0.179f, 1.602f, 1.369f, 1.058f, 0.919f, 0.269f, 0.547f, 0.328f, 2.097f, 1.969f, 1.229f, 0.25f, 0.094f},
	{	0.179f, 1.602f, 1.391f, 1.062f, 0.916f, 0.267f, 0.552f, 0.331f, 2.11f, 1.982f, 1.241f, 0.25f, 0.093f},
	{	0.18f, 1.611f, 1.413f, 1.071f, 0.916f, 0.266f, 0.556f, 0.334f, 2.129f, 1.992f, 1.258f, 0.254f, 0.093f},
	{	0.18f, 1.621f, 1.435f, 1.08f, 0.917f, 0.264f, 0.56f, 0.337f, 2.147f, 2.003f, 1.274f, 0.258f, 0.093f},
	{	0.181f, 1.63f, 1.457f, 1.09f, 0.917f, 0.262f, 0.564f, 0.34f, 2.166f, 2.013f, 1.291f, 0.261f, 0.093f},
	{	0.182f, 1.639f, 1.478f, 1.099f, 0.917f, 0.261f, 0.568f, 0.343f, 2.185f, 2.024f, 1.307f, 0.265f, 0.093f},
	{	0.182f, 1.648f, 1.5f, 1.108f, 0.917f, 0.259f, 0.572f, 0.346f, 2.203f, 2.034f, 1.324f, 0.269f, 0.094f},
	{	0.183f, 1.658f, 1.522f, 1.118f, 0.918f, 0.257f, 0.576f, 0.349f, 2.222f, 2.045f, 1.34f, 0.273f, 0.094f},
	{	0.183f, 1.667f, 1.544f, 1.127f, 0.918f, 0.255f, 0.581f, 0.353f, 2.24f, 2.055f, 1.357f, 0.276f, 0.094f},
	{	0.184f, 1.676f, 1.566f, 1.136f, 0.918f, 0.254f, 0.585f, 0.356f, 2.259f, 2.065f, 1.373f, 0.28f, 0.094f},
	{	0.185f, 1.685f, 1.588f, 1.146f, 0.919f, 0.252f, 0.589f, 0.359f, 2.278f, 2.076f, 1.389f, 0.284f, 0.094f},
	{	0.185f, 1.695f, 1.61f, 1.155f, 0.919f, 0.25f, 0.593f, 0.362f, 2.296f, 2.086f, 1.406f, 0.288f, 0.094f},
	{	0.186f, 1.704f, 1.634f, 1.161f, 0.92f, 0.249f, 0.596f, 0.366f, 2.302f, 2.097f, 1.434f, 0.29f, 0.094f},
	{	0.187f, 1.714f, 1.659f, 1.167f, 0.922f, 0.249f, 0.599f, 0.37f, 2.308f, 2.108f, 1.463f, 0.291f, 0.094f},
	{	0.188f, 1.724f, 1.684f, 1.172f, 0.924f, 0.248f, 0.602f, 0.374f, 2.314f, 2.119f, 1.491f, 0.293f, 0.094f},
	{	0.189f, 1.733f, 1.708f, 1.178f, 0.925f, 0.247f, 0.605f, 0.378f, 2.32f, 2.13f, 1.52f, 0.295f, 0.094f},
	{	0.19f, 1.743f, 1.733f, 1.184f, 0.927f, 0.246f, 0.608f, 0.382f, 2.326f, 2.141f, 1.548f, 0.297f, 0.093f},
	{	0.191f, 1.753f, 1.758f, 1.19f, 0.929f, 0.245f, 0.612f, 0.385f, 2.332f, 2.152f, 1.577f, 0.299f, 0.093f},
	{	0.192f, 1.762f, 1.782f, 1.196f, 0.93f, 0.245f, 0.615f, 0.389f, 2.338f, 2.163f, 1.605f, 0.301f, 0.093f},
	{	0.193f, 1.772f, 1.807f, 1.201f, 0.932f, 0.244f, 0.618f, 0.393f, 2.344f, 2.174f, 1.634f, 0.303f, 0.093f},
	{	0.194f, 1.781f, 1.831f, 1.207f, 0.934f, 0.243f, 0.621f, 0.397f, 2.35f, 2.185f, 1.662f, 0.304f, 0.093f},
	{	0.195f, 1.791f, 1.856f, 1.213f, 0.935f, 0.242f, 0.624f, 0.401f, 2.356f, 2.197f, 1.691f, 0.306f, 0.093f},
	{	0.196f, 1.802f, 1.882f, 1.215f, 0.937f, 0.242f, 0.628f, 0.406f, 2.363f, 2.21f, 1.707f, 0.31f, 0.093f},
	{	0.197f, 1.813f, 1.909f, 1.217f, 0.939f, 0.241f, 0.632f, 0.41f, 2.371f, 2.223f, 1.724f, 0.313f, 0.092f},
	{	0.198f, 1.825f, 1.935f, 1.219f, 0.942f, 0.24f, 0.636f, 0.414f, 2.378f, 2.237f, 1.74f, 0.317f, 0.092f},
	{	0.2f, 1.836f, 1.961f, 1.221f, 0.944f, 0.24f, 0.64f, 0.419f, 2.386f, 2.25f, 1.756f, 0.321f, 0.092f},
	{	0.201f, 1.847f, 1.988f, 1.223f, 0.946f, 0.239f, 0.644f, 0.423f, 2.393f, 2.264f, 1.773f, 0.324f, 0.092f},
	{	0.202f, 1.858f, 2.014f, 1.225f, 0.948f, 0.238f, 0.648f, 0.427f, 2.401f, 2.277f, 1.789f, 0.328f, 0.092f},
	{	0.203f, 1.869f, 2.04f, 1.227f, 0.95f, 0.238f, 0.652f, 0.432f, 2.408f, 2.291f, 1.805f, 0.331f, 0.091f},
	{	0.204f, 1.88f, 2.067f, 1.229f, 0.952f, 0.237f, 0.655f, 0.436f, 2.416f, 2.304f, 1.822f, 0.335f, 0.091f},
	{	0.205f, 1.892f, 2.093f, 1.231f, 0.954f, 0.237f, 0.659f, 0.44f, 2.423f, 2.318f, 1.838f, 0.338f, 0.091f},
	{	0.206f, 1.903f, 2.119f, 1.233f, 0.956f, 0.236f, 0.663f, 0.445f, 2.431f, 2.331f, 1.854f, 0.342f, 0.091f},
	{	0.207f, 1.917f, 2.157f, 1.226f, 0.958f, 0.235f, 0.668f, 0.445f, 2.436f, 2.343f, 1.866f, 0.346f, 0.091f},
	{	0.208f, 1.931f, 2.194f, 1.218f, 0.961f, 0.235f, 0.673f, 0.446f, 2.442f, 2.355f, 1.878f, 0.35f, 0.09f},
	{	0.21f, 1.946f, 2.232f, 1.211f, 0.963f, 0.234f, 0.677f, 0.447f, 2.447f, 2.367f, 1.89f, 0.353f, 0.09f},
	{	0.211f, 1.96f, 2.269f, 1.204f, 0.965f, 0.234f, 0.682f, 0.448f, 2.453f, 2.379f, 1.901f, 0.357f, 0.09f},
	{	0.212f, 1.974f, 2.306f, 1.197f, 0.967f, 0.233f, 0.687f, 0.449f, 2.458f, 2.391f, 1.913f, 0.361f, 0.09f},
	{	0.214f, 1.989f, 2.344f, 1.19f, 0.969f, 0.233f, 0.692f, 0.449f, 2.464f, 2.402f, 1.925f, 0.365f, 0.09f},
	{	0.215f, 2.003f, 2.381f, 1.183f, 0.971f, 0.232f, 0.696f, 0.45f, 2.469f, 2.414f, 1.936f, 0.369f, 0.089f},
	{	0.216f, 2.017f, 2.418f, 1.175f, 0.973f, 0.232f, 0.701f, 0.451f, 2.475f, 2.426f, 1.948f, 0.373f, 0.089f},
	{	0.217f, 2.031f, 2.456f, 1.168f, 0.976f, 0.231f, 0.706f, 0.452f, 2.48f, 2.438f, 1.96f, 0.376f, 0.089f},
	{	0.219f, 2.046f, 2.493f, 1.161f, 0.978f, 0.231f, 0.711f, 0.452f, 2.486f, 2.45f, 1.971f, 0.38f, 0.089f},
	{	0.221f, 2.063f, 2.524f, 1.159f, 0.98f, 0.23f, 0.715f, 0.454f, 2.486f, 2.459f, 1.99f, 0.38f, 0.089f},
	{	0.222f, 2.081f, 2.555f, 1.158f, 0.982f, 0.23f, 0.72f, 0.456f, 2.487f, 2.469f, 2.01f, 0.379f, 0.089f},
	{	0.224f, 2.098f, 2.586f, 1.156f, 0.985f, 0.23f, 0.724f, 0.458f, 2.488f, 2.478f, 2.029f, 0.379f, 0.089f},
	{	0.226f, 2.116f, 2.616f, 1.154f, 0.987f, 0.229f, 0.729f, 0.46f, 2.488f, 2.487f, 2.048f, 0.378f, 0.089f},
	{	0.228f, 2.133f, 2.647f, 1.153f, 0.989f, 0.229f, 0.734f, 0.462f, 2.489f, 2.496f, 2.067f, 0.378f, 0.09f},
	{	0.23f, 2.151f, 2.678f, 1.151f, 0.992f, 0.228f, 0.738f, 0.464f, 2.49f, 2.506f, 2.086f, 0.378f, 0.09f},
	{	0.232f, 2.168f, 2.709f, 1.149f, 0.994f, 0.228f, 0.743f, 0.466f, 2.491f, 2.515f, 2.105f, 0.377f, 0.09f},
	{	0.233f, 2.185f, 2.74f, 1.148f, 0.996f, 0.228f, 0.747f, 0.468f, 2.491f, 2.524f, 2.124f, 0.377f, 0.09f},
	{	0.235f, 2.203f, 2.77f, 1.146f, 0.999f, 0.227f, 0.752f, 0.47f, 2.492f, 2.534f, 2.143f, 0.376f, 0.09f},
	{	0.237f, 2.22f, 2.801f, 1.144f, 1.001f, 0.227f, 0.756f, 0.471f, 2.493f, 2.543f, 2.163f, 0.376f, 0.09f}
    };
    
    
} //end class


