/*
 Start JCM class
Opens the main frame, Makes main menus, Initiates modules
 
 P2 Note all labels are loading, before MF shows!
 P2 (CHECK again -seems to be fixed)  top level menus don't show correct complexity, L&F etc. after setup
 
 
 */

package jcm;
import jcm.core.*;
import jcm.core.report;
import jcm.gui.doc.*;
import jcm.gui.gen.*;
import jcm.gui.nav.showpan;
import jcm.gui.nav.jcmTree;
import jcm.mod.luc.LUCdata;
import static jcm.core.filter.filtertype;
import static jcm.core.filter.filtertype.*;
import static jcm.core.complexity.*;
import static jcm.core.report.*;

public class StartJCM {
    
    
    // ********** MAIN **********
    public static void main(String[] args) {
	
	report.start(); //captures errors
	
	//*************** SHOW SPLASH **********************
	splash splash=new splash();
	
	
	//*************** EXPLORE PACKAGE *******************
	splash.report("Explore Package Roots");
	root.makeroot();
	
	//**************** LABELS *************************
	splash.report("Load labels");
	
	//temporarily moved to start, to check menus
	labman.loaddefaultchanges(); //should do before show any doc with setup!
	
	
	//************* RESTORE SETUP ****************************
	boolean succeeded=false;
	if (args.length>0 && args[0] !=null && args[0].length()>0) try {
	    splash.report("Loading Setup: "+args[0]);
	    succeeded=setup.loadpacksetup(args[0]);
	} catch (Exception e) { deb(e, "error in loading package setup "+args[0]); }
	
	if (!succeeded || setup.restart) {
	    splash.report("Restoring Previous Setup");
	    setup.loadcurrentsetup();
	}
	
	// ************** CHECK MF EXISTS, ADD TREE IF NONE **********
	if  (showpan.mf==null) showpan.makeMainframeDefSize();
	
	//showpan.show(startdialog.b, "JCM5 Startup Info"); //used to call "toFront', but now layout has changed this doesn't work
	if (register.getComponentsOfType(jcmTree.class).size()==0) showpan.makepan(jcmTree.class, null);
	//if (register.getComponentsOfType(docview.class).size()==0) showpan.makepan(docview.class, null);
	
	
	//************* LAZY LOADING****************************
	/*
	 The point of below is to stimulate download of the other jars  (especially if using JWS),
	 */
	splash.message("<html><font color=orange>JCM is now ready to use<p> Meanwhile some extra data will continue to load" );
	
	splash.report("Loading documentation");
	deb("-preloaded: "+register.class.getResource("/labdoc/doc_base_en.txt").getPath());
	splash.report("Loading source");
	deb("-preloaded: "+register.class.getResource("/source/jcm/StartJCM.java").getPath());
	splash.report("Loading GCM-data");
	deb("-preloaded: "+register.class.getResource("/data/gcmdata/basehad3.pre.dat").getPath());
	splash.report("Loading CalcLucEmit data");
	LUCdata.getdata(); //so that plots open faster. note, this should not clash with event despatching thread
	
	if (setup.restart) {
	    splash.report("Restoring Previous Setup");
	    setup.loadcurrentsetup();
	}
	
	//************ REMOVE SPLASH ********************
	splash.end();
	
    } //end main
    
    
}//end class








