/*
 All load/save operations should pass through this class, even for simple methods,
 anticipating later addition of  file-chooser dialogs, security-exception alerts etc.
 
 */


package jcm.tls;
import java.awt.Component;
import jcm.core.*;
import java.net.URL;
import java.io.*;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import javax.swing.*;

//import javax.jnlp.*;

public class fileio {
    
    public static URL getURL(String filename) {
	return register.class.getResource("/"+filename);
	/*
	 above works for netbeans, lone jar, and java-webstart
	ClassLoader.getSystemResource(filename); //works for lone jar but maybe not on web?
	register.class.getResource("../../"+filename); //works within netbeans but not lone jar
	 note register is not essential, just need a class object
	 */
    }
    
    //*********************************
//used by world tree and for defaultsetup
    public static Enumeration<JarEntry>  getJarEntries(URL u) {
	try {
	    JarURLConnection j =(JarURLConnection)u.openConnection();
	    return j.getJarFile().entries();
	} catch (Exception e) { System.out.println("Can't find Jar of : " +u); e.printStackTrace();  return null; }
    }
    
    //*********************************
    //STREAMS of binary data
    public static InputStream getStream(final String filename) {
	return register.class.getResourceAsStream("/"+filename);
    }
    public static InputStream getStream(final File file) {
	try { return new FileInputStream(file); } catch (IOException e) { e.printStackTrace(); return null; }
    }
    
    public static BufferedInputStream getBuffStream(final String filename) {
	return new BufferedInputStream(getStream(filename));
    }
    
    //used by mapdata, loaddata
    public static DataInputStream getDIS(String filename) {
	return new DataInputStream(getBuffStream(filename));
    }
    
    public static LineNumberReader getLNR(String filename) {
	return new LineNumberReader(new BufferedReader(new InputStreamReader(getStream(filename))));
    }
    
    
    public  static String[][] loadtab(String filename, String separator) {
	return loadtab(new LineNumberReader(new BufferedReader(new InputStreamReader(getStream(filename)))), separator);
    }
    
    public  static String[][] loadtab(File file, String separator) {
	return loadtab(new LineNumberReader(new BufferedReader(new InputStreamReader(getStream(file)))), separator);
    }
    
    public  static String[][] loadtab(LineNumberReader lnr, String separator) {
	StringTokenizer st;	String s;
	ArrayList<String[]> as=new ArrayList();
	try {
	    while ((s=lnr.readLine())!=null) {
		st = new StringTokenizer(s, separator);
		ArrayList<String> a= new ArrayList();
		while (st.hasMoreTokens()) a.add(st.nextToken().trim());
		as.add(a.toArray(new String[a.size()]));
	    }//while
	} catch (IOException e) { e.printStackTrace(); }
	
	return (String[][]) as.toArray(new String[as.size()][]);
    }
    
    //*********************************
    //LOAD STRING
    //used by labinf, showsource,
    //encoding option used by labman
    
    public static String loadstring(String filename) {	return loadstring(filename, null); }
    public static String loadstring(String filename, String encoding ) {    return loadstring(getBuffStream(filename), filename, encoding); }
    public static String loadstring(File file) {	return loadstring(new BufferedInputStream(getStream(file)), file.getAbsolutePath(), null); }
    public static String loadstring(File file,  String encoding) {	return loadstring(new BufferedInputStream(getStream(file)), file.getAbsolutePath(), encoding); }
    
    public static String loadstring(BufferedInputStream bis, String filename, String encoding ) {
	StringBuffer sb=new StringBuffer(); int db;
	try {	new InputStreamReader(bis, encoding); } catch (Exception e) {	encoding=null; }
	try {
	    if (encoding!=null) {
		InputStreamReader isr= new InputStreamReader(bis, encoding);
		while ( (db=isr.read())!=-1	) sb.append((char)db); //used to use readnext method -why?
		isr.close();
	    } else {
		while ((db=bis.read())!=-1) {	sb.append((char)db); }
		bis.close();
	    }
	} catch (IOException e) {
	    if (getURL(filename)==null) { System.out.println("Couldn't locate file: "+filename); return ""; }
	    System.out.println("IO Error loading "+filename+"\n"+e); e. printStackTrace(); return "";
	}
	return sb.toString();
    }
    
    //this method can cause seize-up because never returns -1 at end of stream
    static  int readnext(InputStreamReader isr ) {
	try {
	    return isr.read();
	} catch (IOException e) {
	    System.out.println(" "+e.getMessage());
	    try { isr.skip(1); } catch (IOException e2)  { System.out.println("noskip "+e2.getMessage()); }
	    return 0; }
    }
    
    //****************************
    //no longer needed (as won't work from JAR)
    public static String loadtextfile(String filename) {
	try {
	    StringBuffer sb=new StringBuffer(); int db;
	    FileReader fr=new FileReader(filename);
	    while ((db=fr.read())!=-1) {	sb.append((char)db); }
	    fr.close(); return sb.toString();
	} catch (IOException e) {  System.out.println("IO Error loading "+filename+"\n"+e); return "";  }
    }
    
    //*********************************
    //LOAD FLOAT array
    //used by scripts
    //note use of FIle will cause security exception in java-webstart
    
    public static  float[] loadfloat(String a, int len) {
	try {
	    DataInputStream dis = new DataInputStream(new FileInputStream(new File(a)));
	    float[] f=new float[len]; for (int i=0; i<len; i++)  f[i]=dis.readFloat();
	    dis.close();
	    return f;
	} catch (IOException e) {	System.out.println("loadfloat: "+a+ " "+e); e.printStackTrace(); return null; }
    }
    
    //*********************************
    //FileSaveDialog - used by datable, imagesaver
    
    public static File getFileFromDialog(String filename, String title, String message) { return getFileFromDialog("user", filename, title, message); }
    public static File getFileFromDialog(String dirpath, String filename, String title, String message) { return getFileFromDialog(jcm.gui.nav.showpan.mf, dirpath, filename, title, message); }
    public static File getFileFromDialog(Component c, String dirpath, String filename, String title, String message) {
	JFileChooser fc=dirpath=="user" ? new JFileChooser() : new JFileChooser(dirpath);
	fc.setDialogTitle(title);
	fc.setSelectedFile(new File(filename));
	if (filename.equals("")) fc.setFileSelectionMode(fc.DIRECTORIES_ONLY); //used for saving labdoc
	int result= message=="save" ? fc.showSaveDialog(c) : message=="load" ? fc.showOpenDialog(c) : fc.showDialog(c, message) ;
	return (result== JFileChooser.APPROVE_OPTION) ? fc.getSelectedFile() : null;
    }
    
    
    
    //*********************************
    //SAVE TEXT FILE
    
    //used by scripts
    public static void savetextfile(String name, String text) {
	try { savetextfile(new FileWriter(new File("").getPath()+name), text); } catch (IOException e) {	System.out.println(e.getMessage()); }
    }
    
    //used by register-setup
    public static void savetextfile(File file, String text) {
	try { savetextfile(new FileWriter(file), text); } catch (IOException e) {	System.out.println(e.getMessage()); }
    }
    
    //used by labinf
    public static void savetextfile(File dir, String name, String text, String encoding) {
	try {  savetextfile(new OutputStreamWriter(new FileOutputStream(dir.getPath()+"/"+name), encoding) , text);  } catch (IOException e) {	System.out.println(e.getMessage()); }
    }
    
    public static void savetextfile(OutputStreamWriter f, String text) {
	try {
	    for (int a=0; a<text.length(); a+=100) {	int b=(text.length()-a); f.write(text, a, b>100 ? 100 : b); f.flush(); }
	    System.out.println("saved file successfully"); f.close();
	} catch (IOException e) {	System.out.println(e.getMessage()); };
    }
    
    
} //end class


/*
P2 ENH  Process dialog for load/save data (put the slow process in a runnable)
Need to put a process-dialog re doc and re maps and re source in case the classloader hasn't finished
maybe - use ClassLoader in a background thread, after main window showing
Try ProgressMonitorInputStream?- no causes unexplained freezes!
 
 P1 STRUC harmonise fileio methods
 docview (mainmenu/popup) uses html links
 labinf/editor uses loadstring...
 sourceview menu uses own system
 mapdata uses getDIS
 
 P2 CHECK possible to get "streamClosed" error- need option to try again ?? (once a problem in mapplot)
 P3 CHECK check use of File would cause security exception in java-webstart
 P2 IDEA fileio use JNLP.jar for enable load /save even with JWS sandbox
Could  use jnlp.jar (jdk5/demo/sample/jnlp/servlet) for file load/save etc.
  jnlp download service could solve loading process  - checkout the develops guide examples
 But is jnlp package available from JWS without loading separately?
 
 P1 TIDY fileio old methods below
 
 */


//	System.err.println("jcm codebase="+root.codebase);
//	String test="data/regions.txt";
//	System.err.println("test* "+testfile(test) +" *done");
//	System.err.println("abspath="+new File(test).getAbsolutePath());
//	System.err.println("loadstring "+jcm.tls.fileio.loadstring(test));

	/*
	 public static void setcodebase(String[] args) {
		String classpath, codebase;
		if (args.length<1) {
			//classpath=System.getProperty("java.class.path"); codebase=classpath.substring(2,classpath.length()-4);
			codebase=System.getProperty("user.dir").substring(1)+System.getProperty("file.separator")+"jcm";
		} else codebase=args[0];
	 
		 try {
		root.codebase=  new URL("file://"+codebase);
			} catch (MalformedURLException e) {	System.err.println(e); }
	 
	}
	 
	 
	 
	static String testfile(String s) {
		StringBuffer sb=new StringBuffer("testfile output ");
	    try {
		int db;
		FileReader fr=new FileReader(s);
		    while ( (db=fr.read())!=-1) sb.append((char)db);
		    fr.close();
		} catch (Exception e) {	System.err.println("testfile error "+e); }
	    return sb.toString();
	}
	 */

