/*
 * plot_contribtemp_1.java
 *
 * Created on 7 fvrier 2006, 11:49
 */

package jcm.script;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jcm.core.qtset;
import jcm.gui.gen.imagesaver;
import jcm.gui.plot.lineplot;
import jcm.gui.nav.showpan;
import jcm.mod.reg.regman;
import jcm.tls.fileio;
import jcm.tls.txt;

public class plot_contribtemp_1 extends calcscript{
    
    Map<String, qtset> regionCurves  = new HashMap();
    String[] regionsChosen= contribtemp_1.regionsChosen;
    Map<String, Float> prob = new HashMap();
    boolean storeprob=true;
    
    public void run() {
        
        lineplot.thin = 1000;
        
        //new String[]{ "United States", "Canada" };
//                contribtemp_1.regionsChosen
        
        for (final String s : regionsChosen){
            checkbut();
            regionCurves.put(s, new qtset(s, 1850, 2005, 5));
            
            File f=new File("results"+fs+s+".tab");
            
            String[][] s1 = fileio.loadtab(f, "\t");
            
            
            
            for (int r=0; r<s1.length; r++) {
                String line = "";
                if (r==0) {
                    for (int c=1; c<s1[0].length; c++) {
                        regionCurves.get(s).reg(s1[0][c]);
                        String[] parts=txt.split(s1[0][c], new String[] {" ", "_"});
                        if(storeprob) prob.put(s1[0][c], Float.parseFloat(parts[parts.length-1])-440);
                        try {
                            Color col=new Color(
                                    parts[0].equals("IVIGmodel-A") ? 0 : parts[0].equals("IVIGmodel-B") ? 127 : 255,
                                    150,
                                    150,
                                    (int)(3000 / (Float.parseFloat(parts[parts.length-1])-440))
                                    );
                            regionCurves.get(s).reg(s1[0][c]).color=col;
                        } catch (Exception e) { String sss=""; for (String ss : parts) sss+=ss+"\t"; System.err.println("color out of range "+sss); }
                    }
                    storeprob = false;
                } else {
                    for (int c=1; c<s1[0].length; c++) regionCurves.get(s).set(s1[0][c], (int)Float.parseFloat(s1[r][0]) , Float.parseFloat(s1[r][c]));
                }
            }//row
            
            //plotandsave(s);
        } //s
        System.err.println("All tables loaded");
        
        pdf();
        
        end();
    } //end run
    
    void pdf() {
        qtset pdf = new qtset("pdf",0 ,300, 1), cumf = new qtset("cumf",0 ,300, 1);
        
        for (final String s : regionsChosen){
            for (int z=0; z<=1000; z++) { pdf.set(s,z,0); cumf.set(s,z,0); }
            pdf.reg(s).color=regman.allreg.find(s).color;  cumf.reg(s).color=regman.allreg.find(s).color;
            for (String n : prob.keySet()){
                int z=(int)(regionCurves.get(s).get(n, 2000)*10); //rel cont 0/00
                pdf.set(s, z, pdf.get(s,z)+ prob.get(n) );
            }//n
            for (int z=1; z<=1000; z++) cumf.set(s, z, cumf.get(s,z-1)+pdf.get(s,z-1));
            
        }//s
        
        JComponent c1 = plot(pdf);
        resize(c1, 0, 0, 800, 600);
        ((lineplot)c1).xscale.min=0;
        ((lineplot)c1).doplot();
        imagesaver.saveimage(c1, "png", new File("results"+fs+pdf+".png"));
        
        JComponent c2 = plot(cumf);
        resize(c2, 0, 0, 800, 600);
        ((lineplot)c2).xscale.min=0;
        ((lineplot)c2).doplot();
        
        imagesaver.saveimage(c2, "png", new File("results"+fs+cumf+".png"));
        
    }
        
    void plotandsave(final String s) {
        SwingUtilities.invokeLater(new Runnable() { public void run() {
            try {
                JComponent c1 = plot(regionCurves.get(s));
                resize(c1, 0, 0, 800, 600);
                imagesaver.saveimage(c1, "png", new File("results"+fs+s+".png"));
                showpan.dispose(c1);
                System.gc();
            } catch (Exception ex) {	System.out.println("Error plotting figure"); };
        }});
    }
        
} //end class


