/*
 Shares module calculates regional emissions quotas (for a policy scenario) according to various sharing-schemes
 Currently only for fossil CO2, needs to be extended to other gases
 
 
OK P4 spike in  socreg.emitfosquota not consistent with carboncycle totemit (due to starting in fsy+1 rather than fsy)
OK P3 CHECK Shares options working, including changing regionsets (except leastcost)
OK P3 CHECK shares with varying regionsets, inc clear old regions
 
P3 CHECK: shares emissions per-capita seem to drop for some countries, rise for others in 2003
 
P2 FIX Put back Kyoto protocol options (but needs better short-term baseline for non-Ax1)
P2 FIX Put back reduce emissions intensity
P2 CHECK "cheapest" option in shares (after fixed costs)
P2 ENH Put back Brazilian proposal variant (see also responsibility)
P2 PLAN Extend shares to other gases
 
 P2 STRUC More efficient structure for policy vs baseline (anticipating extension to many gases/sectors):
A "fork" or pointing qtset could combine the history and either base or policy (while not replicating data)
the individual history or basescen qtsets could then be "expert" or moved to respective classes, and also restricted length
be careful re calculation order: in this case the forking qtset must be used last. Or maybe its not used at all, its just for plotting?
Checkout mitigation module for how this works currently: is objective the only parameter affecting forks?
what about if WRE option changes the year?
 
 P2 STRUC (but also for clarity to user) shares - socreg.emitfosquota should be emitfos, emitfosbase should not include history
But at the moment emitfosbase, emitluc, emitch4 and emitn2o are all SRES-only, better to change this later
 
P1 STRUC Don't really need permanent qtset for abatement - just put the calc into costs and have the diff as calc-on demand from menus (like ratio)
P1 IDEA STRUC  Alternative: baseline and quota both extend a common submodule, make use of parallel worlds for two scenarios?
 
 */

package jcm.mod.soc;
import jcm.core.*;
import java.util.*;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.mod.obj.futbasescen;
import jcm.mod.reg.region;
import jcm.mod.obj.controller;
import jcm.mod.carbon.carboncycle;


public class shares extends module {
    
    
    //INTERACTIONS
    public void setinteractions() {
        follows(get(futbasescen.class));
        follows(get(controller.class), get(controller.class).objective.chosen!="nopolicy");
        //can't follow get(costs.class), get(responsibility.class) - because these follows shares
        setaffectedby(get(responsibility.class), distribution.chosen=="brazil");
        setaffectedby(get(socreg.class).regions);
        setaffectedby(get(costs.class), ((String)distribution.chosen).startsWith("cheapest"));
        distribution.setaffectedby(get(controller.class).objective);
        affectsfutureonly=true;
    }
    
    //*******************************
    //PARAMETERS
    
    String[] distriboptions={	"unspecified", "percapita",  "brazil", "sresdist", "convpergdp",  "grandfather", "cheapest-iterative", "cheapest-algebraic"};
    
    //convergence and popu cutoff years and conv factor
    public param
            distribution=new param("distribmenu", distriboptions, "sresdist"),
            convergey=new param("convyear", "", 2040, 2010, 2100),
            popcoy=new param("popcoy", "", 2030, 1990, 2100),
            cvf=new param("convfac", "", 6, 1, 13),
            exponential=new param("expconvopt", false),
            popcoyoption=new param("popcoyopt", false),
            kyotop=new param("kyotoopt", false, experimental),
            incusa=new param("incusaopt", true, experimental) ;
    
    //***************************************************
    
    socreg socreg; responsibility rs;
    
    List<region> reg;
    int sy; double cf;
    
    Map<region, Float> fp = new HashMap();
    Map<region, Float> feff = new HashMap();
    Map<region, Float> fr = new HashMap();
    Set<region> participate = new HashSet(), notp;
    float npemit=0, pemit=0, tfr=0, fostot=0, tempinctot=0, poptot=0, tempincp=0;
    //***************************************************
    //MAIN CALC LOOP
    
    public void initsetup() { socreg=get(socreg.class); rs = get(responsibility.class);}
    
    public void precalc() {
        
        sy=(kyotop.istrue() ? 2012 : fsy);
        cf=cvf.getval()/(double)(convergey.getval()-sy);
        //moved from get(mitigation.class) - prob if affects other modules before this in loop?
        if (get(controller.class).objective.chosen=="nopolicy") distribution.chosen="sresdist";
        fp.clear(); feff.clear(); fr.clear(); participate.clear();
        reg = ((region) (socreg.regions.chosen)).reg;
        //int nregs = reg.size();
    }
    
    
    public void calcstep() {
        //note emitfos is first filled to be same as baseline
        //if (year<sy || distribution.chosen=="sresdist") //this for efficiency, but causes some problems with convergence (depending on sequence of parameter changes)
        
        if (year>=sy) {
            for (region r : reg)  socreg.emitfosquota.set(r, socreg.emitfosbase.get(r));
            if (distribution.chosen=="unspecified")  for (region r : reg)  socreg.emitfosquota.set(r, 0);
            if (distribution.chosen=="grandfather")  for (region r : reg)  socreg.emitfosquota.set(r, socreg.emitfosquota.get(r, year-1));
            if (distribution.chosen=="percapita") converge("pop");
            if (distribution.chosen=="convpergdp") converge("gdp");
            if (distribution.chosen=="cheapest-algebraic") leastcost(false);
            if (distribution.chosen=="cheapest-iterative") leastcost(true);
            if (year<=2100 && distribution.chosen=="brazil") brazil();
            
            else topdownscale();
        } //if  year
        
    } //end calcstep
    
    //*********************************
    
    public void topdownscale() {
        float fostot=0;  for (region r : ((region) (socreg.regions.chosen)).reg) fostot += socreg.emitfosquota.get(r);
        if (fostot>0)  for (region r : ((region) (socreg.regions.chosen)).reg)  socreg.emitfosquota.set(r, socreg.emitfosquota.get(r)*get(carboncycle.class).fossil.get()/fostot);
    } //scale
    
    //******************
    //BRAZIL
    
    void brazil() { //ns?? = year
        
        npemit=0; pemit=0; tfr=0; fostot=0; tempinctot=0; tempincp=0; poptot=0;
        //participate.clear();
        
        if (!kyotop.istrue() || year>2012){
            
            //work out the participates
            for (region r : reg){
                tempinctot+= rs.surftemp.get(r, year-1); //get out, after the participation criteria=tempincp
                poptot+=socreg.pop.get(r, year);
                fostot += socreg.emitfosquota.get(r, year-1);
            }
            
            for (region r : reg) {
                fr.put(r, rs.surftemp.get(r, year-1) / tempinctot); //fraction get(responsibility.class)
                fp.put(r, socreg.pop.get(r, year) / poptot); //fraction population
                feff.put(r, socreg.emitfosquota.get(r,year-1) / fostot); //fraction emissions
                //feluc[nr(r)]= ;
                //if (fr[nr]>fp[nr]) participate[nr]=true;
                if (feff.get(r) > fp.get(r)) participate.add(r);
            }
            for (region r : participate) {
                tempincp+= rs.surftemp.get(r, year-1);
                pemit += socreg.emitfosquota.get(r,year-1);
            }
            
            notp = new HashSet(reg); notp.removeAll(participate);
            for (region r : notp) {
                npemit += socreg.emitfosbase.get(r,year);//
            }
            float totred = pemit-(get(carboncycle.class).fossil.get()-npemit);
            
            for (region r : participate) {
                socreg.emitfosquota.set(r, socreg.emitfosquota.get(r, year-1) - totred * rs.surftemp.get(r, year-1) / tempincp);
                //if (socreg.emitfosquota.get(r,year)<0) socreg.emitfosquota.set(r, 0);
                // if (socreg.emitfosquota.get(r,year)>socreg.emitfosbase.get(r,year)) socreg.emitfosquota.set(r, socreg.emitfosbase.get(r,year));
            }
            
            
        }
    } //end brazil
    
    
//*************************************
//CONVERGE
    
    void converge(String cw) {
        int cyear= (year<=popcoy.getval() || !popcoyoption.istrue()) ? year : (int)( popcoy.getval());
        
        double f =
                (year>= convergey.getval()) ? 1
                :  (exponential.istrue()) ? (double)Math.exp(cf*(year-convergey.getval()-1))
                :    (double)1.0/(convergey.getval()-year);
        
        float poptot=0, gdptot=0, emittot=0; //note if implement  a standard world total region for all regional data, can use this instead
        for (region r : ((region) (socreg.regions.chosen)).reg)  {poptot+=socreg.pop.get(r, cyear); gdptot+=socreg.gdp.get(r, cyear); emittot+=socreg.emitfosquota.get(r); }
        
        //main convergence formula
        float cr=1, er;
        for (region r : ((region) (socreg.regions.chosen)).reg)  {
            if (cw=="pop") cr =(float)socreg.pop.get(r, cyear)/poptot;
            if (cw=="gdp") cr =(float)socreg.gdp.get(r, cyear)/gdptot;
            er=socreg.emitfosquota.get(r, year-1)/emittot;
            socreg.emitfosquota.set(r, (float)(er - f * (er - cr)));
        } //end nr
        
    } //end convergence
    
//**************************************
//LEASTCOST
    public int nr(region r) {  	return ((region) (socreg.regions.chosen)).reg.indexOf(r);     }
//temporary fix - rather inefficient
    
    
    void leastcost(boolean iterative) {
        
                /*
                Note: should adjust also by popweighting if want maximise welfare
                 
                Principle is to make Marginal cost (=dcost/dabate) same for all regions
                For Nordhaus cost function, differentiating gives:
                marginal cost  = beta  * fac1 * abate ^ (beta-1)
                where beta = abatepow 	and fac1 = gdp*abatelin*b1 / emitbase ^ beta
                =>  (marginal cost / beta) ^ (1/(beta-1)) = fac1 ^ (1 / (beta-1)) * abate = constant fac3
                 
                Problem is that formula can give negative emissions to some regions, especially India
                can fix at zero, but then must scale to get right total, maybe no longer least-cost?
                Checking MACs: they are all very close, at least before some regions reach zero
                 
                For Macgem no algebraic solution because the beta are all different => need to iterate
                (although in practice formula below gives reasonable results)
                Calc macs from previous year, allocate (extra) abatement in inverse proportion to MACs
                Alternative method: Give all abatement to region with lowest mac? (maybe split into smaller chunks)
                or keep adjusting frac of abatement: start at 1, and reduce as mac higher
                Or could assume MACs will change by same amount as previous step?
                 
                 */
        
        float suma=0, sumb=0, sums=0, summ=0;
        int nregs=((region) (socreg.regions.chosen)).reg.size();
        float[] mac=new float[nregs];
        float[] abateshare=new float[nregs];
        
        if (iterative) 	{
            for (region r : ((region) (socreg.regions.chosen)).reg) 	{
                mac[nr(r)]= 1f / (get(costs.class).mac(r, year-1)*get(costs.class).ew(r, year-1));
                if (Float.isInfinite(mac[nr(r)]) || Float.isNaN(mac[nr(r)])) mac[nr(r)]=0;
                summ+=mac[nr(r)];
            }
            for (region r : ((region) (socreg.regions.chosen)).reg) 	{
                if (summ>0) abateshare[nr(r)]*=(0.6f+0.4f*mac[nr(r)]/summ);
                else abateshare[nr(r)]= socreg.emitfosbase.get(r)/get(carboncycle.class).fossil.get() ;
                socreg.emitfosquota.set(r, socreg.emitfosquota.get(r, year-1) + (socreg.emitfosbase.get(r)-socreg.emitfosbase.get(r, year-1)));
            }
        }	else {	//algebraic solution - no weights yet
            for (region r : ((region) (socreg.regions.chosen)).reg) 	{
                abateshare[nr(r)] =  1f / (float) Math.pow(get(costs.class).alpha(r), 1f / (get(costs.class).beta(r) -1f) );
                socreg.emitfosquota.set(r, socreg.emitfosbase.get(r));
            }
        }
        
        for (region r : ((region) (socreg.regions.chosen)).reg)  	{
            sums+=	abateshare[nr(r)];
            sumb+= socreg.emitfosquota.get(r);
        }//nr
        
        suma= sumb - get(carboncycle.class).fossil.get();
        
        for (region r : ((region) (socreg.regions.chosen)).reg)  {
            socreg.emitfosquota.set(r,  socreg.emitfosquota.get(r)-  suma * abateshare[nr(r)] / sums) ;
            if (socreg.emitfosquota.get(r)<0) socreg.emitfosquota.set(r, 0);
            if (socreg.emitfosquota.get(r)>socreg.emitfosbase.get(r)) socreg.emitfosquota.set(r, socreg.emitfosbase.get(r));
        }
        
        
    } //leastcost
    
    
//******************************
} //end  class


//*************************************
        /*
        //REDUCEINTENSITY
        //not currently working
         
        //			if  (stabilisation.objective.chosen=="reduceintensity") reduceintensity(ns, rs);
         
         
        void reduceintensity(int ns) {
        //reduce energy intensity by 2% per year, apply to all regions
        get(carboncycle.class).fossil[ns]=0;
        for (nr=0; nr<12; nr++) {
        emitfos[nr][ns]=(float)(1.0+stabilisation.reduceintensity.getval()/100)*emitfos[nr][ns-1]*get(people.class).gdp[nr][ns]/get(people.class).gdp[nr][ns-1];
        get(carboncycle.class).fossil[ns]+=emitfos[nr][ns];
}
        for (nr=0; nr<nregs; nr++) share[nr][ns]=emitfos[nr][ns]/get(carboncycle.class).fossil[ns];
        emitfos[12][ns]=get(carboncycle.class).fossil[ns];
         
        //below two lines used to apply after end of region-time
        //			get(carboncycle.class).fossil[ns]=(float)(1.0+stabilisation.reduceintensity.getval()/100)*get(carboncycle.class).fossil[ns-1]*get(people.class).gdp[12][regs]/get(people.class).gdp[12][regs-1];
        //			get(carboncycle.class).totemit[ns]=get(carboncycle.class).fossil[ns]+get(carboncycle.class).lucf[ns]+socreg.bunker[ns];
} //end intensity
         
         //************************************************
        //BRAZIL
        //not currently used
         
        //from precalc		if (distribution.chosen=="brazil") for (int nr=0; nr<nregs; nr++) participate[nr]=false; //initialise brazil
        //from calcstep				if (distribution.chosen=="brazil") brazil(ns);
         
        boolean[] participate=new boolean[nregs]; //for brazil proposal threshold
         
        void brazil(int ns) {
        if (!kyotop.istrue() || ns>2012-gsy){
        float npemit=0, pemit=0, tfr=0; float[] fr=new float[12], fp=new float[12], fe=new float[12]; //totals for non-participants and participants
         
        for (int nr=0; nr<12; nr++) {
        fr[nr]=get(responsibility.class).atco2[nr][ns-1]/get(responsibility.class).atco2[12][ns-1]; //fraction get(responsibility.class)
        fp[nr]=get(people.class).pop[nr][ns]/get(people.class).pop[12][ns]; //fraction population
        fe[nr]=emitfos[nr][ns-1]/get(carboncycle.class).fossil[ns-1]; //fraction emissions
        //if (fr[nr]>fp[nr]) participate[nr]=true;
        if (fe[nr]>fp[nr]) participate[nr]=true;
         
         if (participate[nr]) {
         pemit += emitfos[nr][ns-1];
         tfr += fr[nr]; }
         else {
         emitfos[nr][ns]=get(costs.class).baseemit[nr][ns];
         npemit += emitfos[nr][ns]; }
        }
        float rpr = ((npemit+pemit)-get(carboncycle.class).fossil[ns])/tfr; //reduction needed per share get(responsibility.class)
        for (int nr=0; nr<12; nr++) if (participate[nr]) emitfos[nr][ns]=emitfos[nr][ns-1]-rpr*fr[nr];
        emitfos[12][ns]=0;
        for (int nr=0; nr<12; nr++) emitfos[12][ns]+=emitfos[nr][ns];
}
} //end brazil
         
        //************************************************
        //KYOTO
        //not currently working
        //kyoto targets US, CANZ, Jap, EU+, EEuro, RUB :
        //note regional targets were calculated in an excel file using CDIAC emissions data
         
        double[] targetfrac={	0.93, 0.995285031, 0.94, 0.921698359, 0.95, 0.997184973};
        double targetemit[]=new double[6];
         
        //note EU+ includes norway & iceland with higher targets then EU,
        //EEuro includes Ex-Yugo and Albania without target,
        //original figure for EEu with linear projections was 0.987934518
        //but these unrealistically high, so 0.95 is a guess
        //also original targets were for all six basket gases and here were applied to CO2 only
        //so total (CO2) reduction for six regions is less than 5%
        //should improve this module to apply to six gases!
         
        //from precalc
        // 		if (kyotop.istrue()) precalckyoto();
        //		else if (kyotop.changed) emitshare();
         
        temporarily disabled
        at start of converge
        if (!kyotop.istrue()) {
        for (nr=0; nr<14; nr+=1) {	share[nr][ss]=share2000(nr); }
        share[12][ss]=1f; //share[13][ss]=(float)ef[13];
}
         
         
        void precalckyoto() {
         
        //if sres sc>5 no shares data so use b1 for non annexb
        int oldsc=sres.scenario.getchosenindex(); if (oldsc>5) sres.scenario.choose(4);
        //shares for all years a bit inefficient but no one-year sres method due to normalising
        //temp disabled		emitshare();
         
        for (nr=(incusa.istrue()? 0 : 1) ; nr<6 ; nr++) targetemit[nr]=emitfos[nr][1990-gsy]*targetfrac[nr];
         
        for (year=2001; year<2013; year++) {
        int ns=year-gsy;
         
        for (nr=(incusa.istrue()? 0 : 1) ; nr<6 ; nr++) {
        if (year<2008) emitfos[nr][ns]=(float)(((2008-year)*emitfos[nr][2000-gsy]+(year-2000)*targetemit[nr])/8.0);
        else emitfos[nr][ns]=(float)targetemit[nr];
}
        //denmark
        if (year<2008) emitfos[13][ns]=(float)(((2008-year)*emitfos[13][2000-gsy]+(year-2000)*emitfos[13][1990-gsy]*0.92)/8.0);
        else emitfos[13][ns]=(float)(emitfos[13][1990-gsy]*0.92);
         
        //set emissions for regions not included using sres data (set above)
        get(carboncycle.class).fossil[ns]=1000f*sres.interp(sres.fosemit, year);
        for (nr=6 ; nr<12 ; nr++) {
        emitfos[nr][ns]=get(carboncycle.class).fossil[ns]*share[nr][ns];
}
        if (!incusa.istrue()) emitfos[0][ns]=get(carboncycle.class).fossil[ns]*share[0][ns];
         
         
        //now got all the emits ok, work out the new total and shares
        get(carboncycle.class).fossil[ns]=0;
        for (nr=0 ; nr<12 ; nr++) get(carboncycle.class).fossil[ns]+=emitfos[nr][ns];
        emitfos[12][ns]=get(carboncycle.class).fossil[ns];
        for (nr=0 ; nr<14 ; nr++) share[nr][ns]=emitfos[nr][ns]/get(carboncycle.class).fossil[ns];
         
} //end year
         
        sres.scenario.choose(oldsc);
         
} //end precalckyoto
         
         
         ***************************
        another leastcost iteration
         
                float  minmac=Float.MAX_VALUE; int mr=0;
         
                int ni=48;
                for (int i=0; i<ni; i++) {
                for (int nr=0; nr<nregs; nr++) if (gamma[nr]<minmac) {	minmac=gamma[nr]; mr=nr; }
                emitfos[mr][ns]	-= suma/ni;
                if (emitfos[mr][ns]<0) emitfos[mr][ns]= 0;
                get(costs.class).abateemit[mr][ns]=emitfos[mr][ns]-emitfos[mr][ns];
                gamma[mr]=get(costs.class).mac(mr, ns); minmac=gamma[mr];
} //i
         
         */
