/*
 Responsibility of each region for climate change
developed for UNFCCC Brazilian proposal exercise
Louvain-la-neuve July 02
 
Note, this module comes at the end of the calculation step loop (see modlist),
so it can draw on results from other modules, but it should not affect them.
It won't be called unless an attribution plot is visible.
 
 *********** Responsibilty Todo *********
OK P4 FIX respond Cathy/Jesper
OK P3 FIX responsibility with varying regionsets (inc clear old regions in qtsets)
OK P3 set responsibility qtset units - check old attributeplot
 
P3 PLAN Consider what needed for MATCH paper3 - inc calculation of marginal cause-effect tables
P3 PLAN for probabilistic assessment of responsibility, esp re carbon cycle / LUC
P3 PLAN for make Brazilian emit-reduc proposal work again in shares
P3 FIX Responsibility should use emitlucquota
P2 FIX Responsibility should use data from shares not socreg - when available for all gases!
P1 IDEA Integrated -per capitae
 
P2 CHECK should recheck attribution results vs old data (since move to Qts May05)

P2 CHECK Regional future landuse/CH4/N2O emissions not working with JCM12
P2 CH4 & N2O emissions stop in 1990 =>affects responsibility
P2 FIX timeslice method no longer working! use thread instead of loop.gowithin();?
 
 
 *
 */

package jcm.mod.soc;
import jcm.core.*;
import static jcm.gui.gen.colfont.*;

import jcm.mod.reg.region;
import jcm.mod.obj.controller;
import jcm.mod.carbon.*;
import jcm.mod.ogas.*;
import jcm.mod.cli.*;

public class responsibility extends module {
    
    //*****************************
    //standard module bits
    
    public void setinteractions() {
	//setaffectedby(people.regions); //should work through get(socreg.class)
	//setaffectedby(get(othgasemit.class)); //should be, but not yet
	follows(get(socreg.class));
	follows(get(shares.class)); //doesn't yet use get(shares.class), but should do
	follows(get(radfor.class)); //will catch any gas-changed
	follows(get(glotemp.class));
	//note also precalc method
    }
    
    public param method=new param("attmeth", new String[]{	"timeslice","normarg","tracer"}, "tracer");
    
    public param
	    differential=new param("differential", false), //use Enting differential formula for RF
	    simplecarbon=new param("simplecarbon", false), //ignore back fluxes
	    startyear=new param("startyear", "", 1850, 1850, 2000),
	    endyear=new param("endyear", "", 2002, 1990, 2100);
    
    
    public qtset
	    atco2=new qtset("atco2", "ppm"),
	    atch4=new qtset("atch4", "ppb"),
	    atn2o=new qtset("atn2o", "ppb"),
	    
	    rfco2=new qtset("rfco2", "w&per&m2"),
	    rfch4=new qtset("rfch4", "w&per&m2"),
	    rfn2o=new qtset("rfn2o", "w&per&m2"),
	    rftot=new qtset("rftot", "w&per&m2"),
	    
	    surftemp=new qtset("surftemp", "degcbase"),
	    sealevte=new qtset("sealevte", "metres");
    
    //####################################
    
    //PRECALC
    public void precalc() {
	for (qtset qq : qtsets) get(socreg.class).clearoldregions(qq);
	makearrays();
	
	if (!intimesliceloop) {
	    if (changed && needed) {	loop.calcfutureonly=false; get(carboncycle.class).changed=true; get(glotemp.class).changed=true; }
	    //this forces get(carboncycle.class) and get(glotemp.class) to recalc, so that this module can access their temporary state of boxes/fluxes within the timestep loop
	    //but these modules are not affected by responsibility (would be very inefficient)
	    if (startyear.getval()<1850) startyear.setval(1850);
	    if (endyear.getval()>2100) endyear.setval(2100);
	    debug="";
	}
    }
    
    //CALCSTEP
    public void calcstep() {
	if (!intimesliceloop && method.chosen.equals("tracer")) {	//?need to check both
	    if (year>2100) return; //makes it faster and plots lower
	    carbonstep();
	    atchemstep();
	    rfstep();
	    glotempstep();
	}
    } //end calcstep
    
    //POSTCALC
    public void postcalc() {
	if (!intimesliceloop && (method.chosen.equals("timeslice") || method.chosen.equals("normarg")))   {
	    intimesliceloop=true;
	    starttimeslice();
	    System.out.println("timeslicing ");
	    for (int tsy=(int) startyear.getval(); tsy<= endyear.getval(); tsy++) 	timeslicescenario(tsy);
	    endtimeslice();
	    System.out.println("attributing ");
	    attribute();
	    intimesliceloop=false;
	}
	if (method.chosen.equals("tracer")) System.out.println(debug);
    }
    
    
    //####################################
    //attribution emissions start and end year, impact calculation year, number of years (for array)
    
    boolean attrib=false; //flag whether to attribute this year
    
    public int nregs, oldnregs=0, nemit, nrf, oth;
    final static int ncb=berncarbon.ncb,  nhb=udebclimod.nhb;
    
    float[] ls,hs,so,hu;
    float[][]ciq; float[][][] hiq;
    float[][] acccbox;
    
    public boolean intimesliceloop=false;
    String debug="";
    
    region unattreg=new region("Before start/After End", dkgrey );
    region othgasreg=new region("F-gases+Ozone+others", greygreen );
    region aerosolreg=new region("Aerosols", cyan );
    region solvolreg=new region("Solar and Volcano", yellow );
    
    region reg(int nr) {
	if (nr<nregs) return ((region) (get(socreg.class).regions.chosen)).reg.get(nr);
	if (nr==nregs) return unattreg;
	if (nr==nregs+1) return othgasreg;
	if (nr==nregs+2) return aerosolreg;
	if (nr==nregs+3) return solvolreg;
	return null;
    }
    
    public void makearrays() {
	nregs=((region) (get(socreg.class).regions.chosen)).reg.size();
	if (nregs!=oldnregs) {
	        
	    oldnregs=nregs;
	    nemit=nregs+1; nrf=nregs+4; oth=nregs;
	    //note +1 for other/unattributed before start, after end, +4 adds also other gas, get(aerosol.class), solvol
	    
	    //for carbon cycle
	    ciq=new float[nrf][ncb];
	    ls=new float[nrf]; hs=new float [nrf]; so=new float[nrf]; hu=new float[nrf];
	    acccbox= new float[nrf][4];
	    //for heat fluxes
	    hiq=new float[nrf][2][nhb];
	}
    } //makearrays
    
    
    //#######################
    //EMISSIONS
    
    boolean attrib(int y) { return (y>=startyear.getval() && y <=endyear.getval()); }
    
    float totco2emit(region r, int y) {
	if (y<gsy) return 0; //oldtotemit at start
	if (r==unattreg) return attrib(y) ? 0 : get(carboncycle.class).fossil.get(y) + get(carboncycle.class).lucf.get(y) ;
	if (r==othgasreg || r==aerosolreg || r==solvolreg) return 0;//- no emissions, but effect from temperature feedbacks
	else return attrib(y) ? get(socreg.class).emitfosbase.get(r, y) + get(socreg.class).emitlucbase.get(r, y) : 0;
    }
    float ch4emit(region r, int y) {
	if (r==unattreg) return attrib(y) ? 0 : get(othgasemit.class).ch4emit.get(y);
	else return attrib(y) ?  get(socreg.class).emitch4.get(r, y) : 0;
    }
    float n2oemit(region r, int y) {
	if (r==unattreg) return attrib(y) ? 0 : get(othgasemit.class).n2oemit.get(y);
	else return attrib(y) ?  get(socreg.class).emitn2o.get(r, y) : 0;
    }
    
    
    //#######################
    //CARBON CYCLE
    
    float sink, atinc, lsinc, hsinc, fracat, fracls, frachs,  totls, toths, totat, npinc, dls, dhs, dnp, dat;
    float soinc, huinc, fracso, frachu, totso, tothu, dso, dhu;
    
    void carbonstep() {
	
	//simple ACCC model
	if (get(carboncycle.class).accccarbon.istrue()) {
	    if (ns==0) for (int i=0; i<4; i++) {	acccbox[oth][i]=get(carboncycle.class).acccbox[i]; for (int nr=0; nr<nregs; nr++) acccbox[nr][i]=0; }
	    for (int nr=0; nr<nrf; nr++) atco2.set(reg(nr), get(carboncycle.class).acccmod(acccbox[nr],  totco2emit(reg(nr), year)) );
	    return;
	}
	
		/*
		Since this module follows get(carboncycle.class).java in same step loop,
		we can scale the global nonlinear fluxes in proportion to the attributed fraction from the source box,
		i.e. fraction of the atmosphere for npinc (fertilisation air=>bio),
		and of ls and hs boxes for lsinc and hsinc which are sea=>air fluxes (the extra due to carbonate chemistry).
		This proportionality based on previous timestep to avoid iteration.
		(the iteration and chemistry are the slow parts of carbon calcstep)
		Note that this only works if carbon module always calculated!
		 */
	
	
	for (int nr=0; nr<nrf; nr++) {
	    region r=reg(nr);
	    
	    //set starting state
	    if (ns==0) for (int n=0; n<ncb; n++) ciq[nr][n]=(nr==oth ? (float)get(berncarbon.class).ciq[n] : 0);
	    
			/*
			Apportioning non-linear fluxes:
			Non-linear flux from atmosphere is obviously apportioned to atmospheric CO2
			 
			But feedback on ocean chemistry is response to both CO2 and temperature - complex equilibria!
			In A2 scenario by 2100,  ocean sink is 13.3 with linear model, 7.26 with chemistry but no temp-feedback, 6.44 with temp-feedback too.
			So non-lin flux (when CF on) could be apportioned as 88% to carbon in that box, and 12% to surface temperature
			But this only applies when high CO2 (pCO2rise=appx550, temprise = appx5.0), not in early years when temp matters more.
			try 0.0016 * co2rise
			 
			check lsinc- gets more negative with feedback=>  implies greater flux out of ocean
			check npinc - gets more and more negative  - because it's the difference once you subtract the linear part (prop to at?)
			check soinc - gets negative when there is a feedback - its a flux out of soil
			 
			Attribution of temp feedback on soil carbon is apportioned by get(shares.class) of temperature
			(noting that mostly non-anthropogenic carbon is released)
			Fraction of heat from other gases/get(aerosol.class)s/solv should also be included!
			 
			Note that to get ocean chemistry feedbacks to work, it's important that non-linear fluxes start at zero,
			not starting with offset to put more flux into linear part averaged over run (an efficiency trick used in get(berncarbon.class) - now removed)
			 
			 */
	    
	    float ft = (ns>0 && (get(glotemp.class).avchange.get(year-1)>0.1 || get(glotemp.class).avchange.a[ns-1]<-0.1)) ? surftemp.get(r, year-1)/get(glotemp.class).avchange.get(year-1) : 0;
	    float fc= (ns>0 && get(carbonatechemistry.class).chemfeedback.istrue())  ?   0.0016f * (get(carboncycle.class).co2atppm.get(year-1)-(float)get(carboncycle.class).atppmprein)  : 1;
	    
	    
	    fracat= (ns>0) ? (atco2.get(r, year-1)/(get(carboncycle.class).co2atppm.get(year-1)-(float)get(carboncycle.class).atppmprein)) : 0;
	    fracls=  (ns>0) ? fc* ls[nr]/totls + (1f - fc)* ft : 0;
	    frachs=  (ns>0) ? fc*hs[nr]/toths + (1f - fc)* ft : 0;
	    //note totls and toths typically a few thousand
	    fracso= ft;
	    frachu= ft;
	    
			/*
			if (!attribtempfb.istrue()) {
			//below attribute soil feedback to carbon only (not correct -for experiment)
			//also problems when anthropogenic soil carbon goes negative
			fracso= (ns>0) ? so[nr]/totso : 0;
			frachu= (ns>0) ? hu[nr]/tothu : 0;
			}
			 */
	    
	    atco2.set(r, 0); ls[nr]=0; hs[nr]=0; so[nr]=0; hu[nr]=0;
	    
	    //use the *old* values for the step function
	    lsinc=(float)get(berncarbon.class).oldlsinc*fracls;
	    hsinc=(float)get(berncarbon.class).oldhsinc*frachs;
	    npinc=(float)get(berncarbon.class).oldnpinc*fracat;
	    soinc=(float)get(berncarbon.class).oldsoinc*fracso;
	    huinc=(float)get(berncarbon.class).oldhuinc*frachu;
	    atinc= totco2emit(r, year-1)- (lsinc+hsinc+npinc+soinc+huinc);
	    //and changes for the ramp function
	    dls=(float)get(berncarbon.class).dls*fracls;
	    dhs=(float)get(berncarbon.class).dhs*frachs;
	    dnp=(float)get(berncarbon.class).dnp*fracat;
	    dso=(float)get(berncarbon.class).dso*fracso;
	    dhu=(float)get(berncarbon.class).dhu*frachu;
	    
	    dat= (totco2emit(r, year)-totco2emit(r, year-1)) -(dls+dhs+dnp+dso+dhu);
	    
	    for (int n=0; n<ncb; n++) {
		
		//apply the prop & step & ramp functions
		ciq[nr][n]=(float)(
			ciq[nr][n]*get(berncarbon.class).cpropf[n]
			+get(berncarbon.class).scicAT[n]*atinc
			+get(berncarbon.class).scicLS[n]*lsinc
			+get(berncarbon.class).scicHS[n]*hsinc
			+get(berncarbon.class).scicNP[n]*npinc
			+get(berncarbon.class).rcicAT[n]*dat
			+get(berncarbon.class).rcicLS[n]*dls
			+get(berncarbon.class).rcicHS[n]*dhs
			+get(berncarbon.class).rcicNP[n]*dnp
			+get(berncarbon.class).scicSO[n]*soinc
			+get(berncarbon.class).rcicSO[n]*dso
			+get(berncarbon.class).scicHU[n]*huinc
			+get(berncarbon.class).rcicHU[n]*dhu
			);
		//and calculate new concentration
		atco2.set(r, atco2.get(r)+(float)get(berncarbon.class).crAT[n]*ciq[nr][n]);
		ls[nr]+=(float)get(berncarbon.class).crLS[n]*ciq[nr][n];
		hs[nr]+=(float)get(berncarbon.class).crHS[n]*ciq[nr][n];
		so[nr]+=(float)get(berncarbon.class).crSO[n]*ciq[nr][n];
		hu[nr]+=(float)get(berncarbon.class).crHU[n]*ciq[nr][n];
	    } //n
	    atco2.set(r, atco2.get(r)*(float)get(carboncycle.class).ppmpmtc);
	    
	} //nr
	
	//new totals
	totls=0; toths=0; totat=0; totso=0; tothu=0;
	for (int nr=0; nr<nrf; nr++) {	totls+=ls[nr]; toths+=hs[nr]; totat+=atco2.get(reg(nr)); totso+=so[nr]; tothu+=hu[nr]; }
	
    } //carbonstep
    
    
    
    //####################################
    //get(atchem.class)
    float  extrach4, extran2o, fracn2o;
    
    void atchemstep() {
	if (ns==0) {
	    for (int nr=0; nr<nregs ; nr++) {	atch4.set(reg(nr), 0) ; atn2o.set(reg(nr), 0) ; }
	    atch4.set(unattreg, get(atchem.class).ch4conc.get()-get(atchem.class).ch4prein);
	    atch4.set(othgasreg, 0);
	    atn2o.set(unattreg, get(atchem.class).n2oconc.get()-get(atchem.class).n2oprein);
	    
	} else {
	    
	    for (int nr=0; nr<nemit ; nr++) {
		region r=reg(nr);
		atch4.set(r, atch4.get(r, year-1) *(1f-1f/get(atchem.class).ch4life(ns)) +(float)(get(atchem.class).ppbpmtch4 * ch4emit(r, year) ) );
		atn2o.set(r, atn2o.get(r, year-1) *(1f-1f/get(atchem.class).n2olife(ns)) +(float)(get(atchem.class).ppbpmtn * n2oemit(r, year) ) );
	    } //nr
	    
	    
			/*account for any effect of changing lifetime on natural emissions,
			or (if we use fixed 2000 lifetimes) discrepancy between preindustrial concn and natural emissions
			 
			This should ensure consistency with concentrations in main JCM calculations.
			But how to attribute this extra change in concentration?
			for ch4, this is due to changing OH which is affected by several gases
			- so until we can attribute OH, assign this to "other gas" category (nemit)
			 */
	    
	    extrach4=(get(atchem.class).ppbpmtch4 * get(atchem.class).ch4emitnat() - get(atchem.class).ch4prein /get(atchem.class).ch4life(ns) );
	    atch4.set(othgasreg, atch4.get(othgasreg, year-1) *(1f-1f/get(atchem.class).ch4life(ns)) + extrach4 ) ; //other gas category
	    
	    //apply same rule to n2o
	    extran2o=(get(atchem.class).ppbpmtn * get(atchem.class).n2oemitnat() - get(atchem.class).n2oprein /get(atchem.class).n2olife(ns) );
	    atn2o.set(othgasreg, atn2o.get(othgasreg, year-1) *(1f-1f/get(atchem.class).n2olife(ns)) + extran2o ); //other gas category
	    
			/* old method
			for co2 extra (nonlinear) sea-air flux attributed according to fraction of extra carbon in mixed layer
			for n2o which affects its own lifetime, apply similar principle as CO2, according to concentration
			 
			fracn2o=(get(atchem.class).n2oconc[ns]-get(atchem.class).n2oprein); //avoid dividing by tiny quantities
			if (fracn2o>0.1) for (int nr=0; nr<(nemit); nr++) atn2o[nr][ns]+= extran2o*atn2o[nr][ns]/fracn2o;
			 */
	} //ns>0
    } //get(atchem.class)step
    
    
    //####################################
    //RADIATIVE FORCING
    
	/* differential RF formula taken from Enting papers,
	not bad for CO2,
	however causes a long "memory" with CH4
	beware total emissions must be consistent with oghga if use oghga concs!
	 */
    float dc;
    
    void rfstep() {
	
	for (int nr=0; nr<nrf ; nr++) {
	    region r=reg(nr);
	    
	    if (differential.istrue() && year>(startyear.getval()+1)) {
		//year because first step is too big to apply differential rate
		int yy= (year>gsy ? year-1 : gsy);
		dc=(get(carboncycle.class).co2atppm.get()-get(carboncycle.class).co2atppm.get(yy));
		rfco2.set(r, yy/* check! */ , rfco2.get(r, yy)+ ((Math.abs(dc)>0.0001) ? (get(carboncycle.class).co2rf.get()-get(carboncycle.class).co2rf.get(yy) )*(atco2.get(r) -atco2.get(r, yy) )/dc : 0) );
		
		if (nr<nemit+1){	//n2o and ch4 no effect from get(aerosol.class)/solvar
		    dc=(get(atchem.class).n2oconc.get()-get(atchem.class).n2oconc.get(yy));
		    rfn2o.set(r, rfn2o.get(r, yy)+ ((Math.abs(dc)>0.0001) ? (get(atchem.class).n2orf.get()-get(atchem.class).n2orf.get(yy))*(atn2o.get(r) -atn2o.get(r, yy) )/dc: 0) );
		    dc=(get(atchem.class).ch4conc.get()-get(atchem.class).ch4conc.get(yy));
		    rfch4.set(r, rfch4.get(r, yy)+ ((Math.abs(dc)>0.0001) ? (get(atchem.class).ch4rf.get()-get(atchem.class).ch4rf.get(yy))*(atch4.get(r) -atch4.get(r, yy) )/dc : 0) );
		}
	    } 	else {	//not differential
		dc=(get(carboncycle.class).co2atppm.get()-(float)get(carboncycle.class).atppmprein);
		rfco2.set(r, atco2.get(r) * ((Math.abs(dc)>0.0001) ? get(carboncycle.class).co2rf.get()/dc : 0) );
		if (nr<nemit+1){
		    dc=(get(atchem.class).n2oconc.get()-get(atchem.class).n2oprein);
		    rfn2o.set(r, atn2o.get(r) * ((Math.abs(dc)>0.0001) ? get(atchem.class).n2orf.get()/dc : 0) );
		    dc=(get(atchem.class).ch4conc.get()-get(atchem.class).ch4prein);
		    rfch4.set(r, atch4.get(r) * ((Math.abs(dc)>0.0001) ? get(atchem.class).ch4rf.get()/dc : 0) );
		}
	    }
	} //nr
	
	//total
	for (int nr=0; nr<nemit ; nr++)  rftot.set(reg(nr), rfco2.get(reg(nr))+rfch4.get(reg(nr))+rfn2o.get(reg(nr)) );
	//other gases
	rftot.set( othgasreg,
		rfco2.get(othgasreg)+rfch4.get(othgasreg)+rfn2o.get(othgasreg)
		+get(fgas.class).cfcrf.get()+get(fgas.class).hfcrf.get()+get(atchem.class).strath2orf.get()+get(atchem.class).tropo3rf.get()+get(fgas.class).strato3rf.get()
		);
	
	//get(aerosol.class) and solar - include feedback effect on carbon
	rftot.set( aerosolreg, rfco2.get( aerosolreg) +get(aerosol.class).aerorf.get() );
	rftot.set( solvolreg, rfco2.get( solvolreg) +get(aerosol.class).natvrf.get() );
	
    } //rfstep
    
	/*
	Note: RF from other gases includes any due to accumulated conc before start
	also includes effect of changing CH4 lifetime (see note above)!
	not problem if start-date before 1970 (as no get(fgas.class)es and ozone has short life)
	but if start much later should calc separately to shift to "other" category
	 */
    
    //####################################
	/*
	HEAT FLUXES: surface temp and sealevel
	adapted from udebclimod.java but a bit simpler:
	no upwelling feedback (yet)
	only well mixed rf same for all surface boxes
	no north-south flux (as setting the rate to zero makes hardly any difference to global temp)
	(note the two oceans are still different as northern has more land => cools/warms faster).
	 */
    
    float qin, qinold, dqin;
    float[] rff=new float[2], sf=new float[2], mlt=new float[2], boxtemp=new float[4];
    
    void udebclimodsetup() {
	for (int o=0; o<2; o++) {
	    //factor to combine direct input from rf + input via land
	    rff[o]=(float)(1f+ (get(udebclimod.class).frac[o*3]/get(udebclimod.class).frac[o+1])*get(udebclimod.class).klo/(get(udebclimod.class).kls*get(udebclimod.class).frac[o*3]+get(udebclimod.class).klo));
	    sf[o]=(float)(get(udebclimod.class).spaceflux[o]*get(udebclimod.class).qpt*get(udebclimod.class).tstart);
	    for (int n=0; n<nhb; n++) {
		//fill boxes: oth gets all the heat already accumulated, others start with steady-state
		for (int nr=0; nr<(nrf) ; nr++)
		    hiq[nr][o][n]=(float) ( (nr==oth) ?  get(udebclimod.class).hiq[o][n] : get(udebclimod.class).hiqstart[o][n]) ;
	    }
	} //o
    } //hf setup
    
    void glotempstep() {
	
	if (ns==0) udebclimodsetup();
	
	//below lets it start in 1750 accumulating get(aerosol.class)s etc.
	
	for (int nr=0; nr<nrf ; nr++) {
	    region r=reg(nr);
	    surftemp.set(r, 0);
	    sealevte.set(r, 0);
	    
	    for (int o=0; o<2; o++) {	//for each ocean
		
		mlt[o]=0;
		
		//calc heat input to each ocean mixed layer (watt-year per m2)
		qinold = sf[o] + (ns>0 ? rftot.get(r, year-1)  : 0) *rff[o];
		qin=  sf[o] + rftot.get(r) *rff[o];
		dqin= qin-qinold;
		
		for (int n=0; n<nhb; n++) {	//for each layer
		    
		    //apply prop, step, ramp functions
		    hiq[nr][o][n]= (float)(
			    get(udebclimod.class).hpropf[o][n]*hiq[nr][o][n]
			    + get(udebclimod.class).shicML[o][n]*qinold
			    + get(udebclimod.class).rhicML[o][n]*dqin
			    );
		    
		    //calc new surface temperatures
		    mlt[o]+=(float)get(udebclimod.class).hrML[o][n]*hiq[nr][o][n];
		    //sea-level rise due to thermal expansion (averages both oceans)
		    sealevte.set( r, sealevte.get(r) + (float)get(udebclimod.class).hrsl[o][n]*hiq[nr][o][n] );
		    
		} //nhb
		
		mlt[o]= (float)(mlt[o]/get(udebclimod.class).qpt - get(udebclimod.class).tstart); //convert to temp rise
	    } //o
	    
	    //P2 CHECK sealevteinit seems to be not working!
	    sealevte.set( r, sealevte.get(r) - (float)get(udebclimod.class).sealevteinit ); //convert to change
	    
	    boxtemp[0]=(float)((mlt[0]*get(udebclimod.class).cice*get(udebclimod.class).klo + get(udebclimod.class).frac[0]*rftot.get(r))/(get(udebclimod.class).kls*get(udebclimod.class).frac[0]+get(udebclimod.class).klo));
	    boxtemp[3]=(float)((mlt[1]*get(udebclimod.class).cice*get(udebclimod.class).klo + get(udebclimod.class).frac[3]*rftot.get(r))/(get(udebclimod.class).kls*get(udebclimod.class).frac[3]+get(udebclimod.class).klo));
	    boxtemp[1]=(float)(mlt[0]*get(udebclimod.class).cice);
	    boxtemp[2]=(float)(mlt[1]*get(udebclimod.class).cice);
	    for (int i=0; i<4; i++) surftemp.set(r,  surftemp.get(r) + (float)(boxtemp[i]*get(udebclimod.class).frac[i]) );
	} //nr
	
    } //end get(glotemp.class)step
    
    //####################################
    //TIMESLICE
    
    
    float[] fossilorig, lucforig, methorig, n2oorig, indicorig;
    float[][] indic;
    Object mitigorig;
    
    
    void starttimeslice() {
	fossilorig=(float[]) get(carboncycle.class).fossil.a.clone();
	lucforig=(float[]) get(carboncycle.class).lucf.a.clone();
	methorig=(float[]) get(othgasemit.class).ch4emit.a.clone();
	n2oorig=(float[]) get(othgasemit.class).n2oemit.a.clone();
	indicorig=(float[]) get(glotemp.class).avchange.a.clone();
	indic=new float[1+(int)(endyear.getval()-startyear.getval())][]; //effect of year A on year B
	if (method.chosen.equals("timeslice")) {
	    for (int ns=(int)startyear.getval()-gsy; ns<=glos; ns++) {
		get(carboncycle.class).lucf.a[ns]=0; get(carboncycle.class).fossil.a[ns]=0;
	    }
	}
	mitigorig=get(controller.class).objective.chosen;
	get(controller.class).objective.chosen="donothing";
	loop.itc=new interacob[] {	get(carboncycle.class) }; loop.itn=new interacob[] {	this}; //loop.scin=true;
    }
    
    void timeslicescenario(int tsy) {
	int ts=tsy-gsy;
	if (method.chosen.equals("timeslice")) {
	    get(carboncycle.class).fossil.a[ts]= fossilorig[ts];
	    get(carboncycle.class).lucf.a[ts]= lucforig[ts];
	}
	/*if (method.chosen.equals("normarg"))*/ 	else  {
	    get(carboncycle.class).fossil.a[ts]= 0; get(carboncycle.class).fossil.a[ts-1]=fossilorig[ts-1];
	    get(carboncycle.class).lucf.a[ts] =0; get(carboncycle.class).lucf.a[ts-1]= lucforig[ts-1];
	}
	get(carboncycle.class).changed=true;
	indic[tsy-(int)startyear.getval()]=(float[]) get(glotemp.class).avchange.a.clone();
    }
    
    void endtimeslice() {
	for (int ns=(int)startyear.getval()-gsy; ns<=glos; ns++) {
	    //don't just move pointer, because plot keeps old reference!
	    get(carboncycle.class).fossil.a[ns]=fossilorig[ns];
	    get(carboncycle.class).lucf.a[ns]=lucforig[ns];
	}
	get(controller.class).objective.chosen=mitigorig;
	get(carboncycle.class).changed=true;
	loop.scin=false;
    }
    
    void attribute() {
	System.out.println("attributing ");
	float change, frac;
	for (int ns=0; ns<=glos; ns++) {
	    String d=""+(ns+1750)+" ";
	    for (int nr=0; nr<nregs ; nr++) 	surftemp.set(reg(nr), 0);
	    for (int tsy=(int)startyear.getval(); tsy<(int)endyear.getval() && tsy<(ns+gsy); tsy++) {
		if (method.chosen.equals("timeslice")) 	change=indic[1+tsy-(int)startyear.getval()][ns]-indic[tsy-(int)startyear.getval()][ns];
		else /*if (method.chosen.equals("normarg"))*/ change=indicorig[ns]-indic[tsy-(int)startyear.getval()][ns];
		for (int nr=0; nr<nregs ; nr++) {
		    region r=((region) (get(socreg.class).regions.chosen)).reg.get(nr);
		    frac=(get(socreg.class).emitfosbase.get(r, tsy)+get(socreg.class).emitlucbase.get(r, tsy))/(get(carboncycle.class).fossil.get(tsy)+get(carboncycle.class).lucf.get(tsy));
		    surftemp.set(reg(nr), surftemp.get(reg(nr)) + change*frac );
		}
		d+="\t\t"+change;
	    } //ts
	    System.out.println(d);
	} //ns
	
    } //attribute
    
    
    
} //end responsibility




