

package jcm.mod.soc;
import java.awt.Color;
import jcm.core.*;
import jcm.mod.data.*;
import jcm.mod.reg.*;
import jcm.mod.carbon.*;
import static jcm.gui.gen.colfont.*;

public class history extends module {
    
    public void initsetup() {
        follows(get(CalcLucEmit.class));
        setaffectedby(get(socreg.class));//.regions);
        makegdpen();
        aviaship();
    }
    
    public void setinteractions() {
        //this feedback (for inverse carbon) could be very inefficient!
        setaffectedby(get(carboncycle.class), get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") ||  get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") 	);
    }
    
    //*****************************
    qtset emitfos, emitluc, emitch4, emitn2o, pop, gdp, energy;
    region regset;
    
    public static qtset fosCO2=new qtset("fosCO2", "mega&ton&carbon", 1750, 2002, complexity.expert);
    public static qtset hydepop=new qtset("pop", "kilo&person", 1700, 2002, complexity.expert);
    
    static  {
        //note complicated mix for fosCO2 could be replaced by CDIAC which now extends to 2002 (but note UNFCCC extends to 2003)
        histdata.loaddata(fosCO2, "cdiacrows.csv", ",", false, 1f, 1750, 2000, 1750); histdata.oldsplit(fosCO2);
        histdata.loaddata(fosCO2, "eia_co2_emission.csv", "\t", false,  1f, 1980, 2002, 2001); //use only 2001-2
        histdata.loaddata(fosCO2, "UNFCCC_CO2emit.csv", ",", false,  12f/44f, 1990, 2002, 1990); //use 1990-2002 for countries with data
        histdata.loaddata(hydepop, "HYDE_pop_kkg.csv", "\t", true,  1f, 1700, 1995, 1700);
        histdata.loaddata(hydepop, "pop2002.csv", "\t", false, 1f, 2002, 2002, 2002); interpolator.linearinterp(hydepop, 1995, 2002);
    }
    
    //****************************
    
    public void precalc() {
        
        socreg socreg=get(socreg.class);
        emitfos=socreg.emitfosbase;  emitluc=socreg.emitlucbase; emitch4=socreg.emitch4; emitn2o=socreg.emitn2o;
        pop=socreg.pop; gdp=socreg.gdp; energy=socreg.energy;
        
        regset=(region)socreg.regions.chosen;
        
//	pop.map.clear(); gdp.map.clear(); energy.map.clear();
//	emitfos.map.clear(); emitluc.map.clear(); emitch4.map.clear(); emitn2o.map.clear();
        
        interpolator.fillregdata(hydepop, pop, regset , 0.001f);
        
        new interpolator(jcm12gdp, "JCM12", 1900, 1, false).fill(gdp, regset, 1900, 2000, hydepop);
        new interpolator(jcm12en, "JCM12", 1900, 1, false).fill(energy, regset, 1900, 2000, hydepop);
        
        if (get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR")) interpolator.fillregdata(get(CalcLucEmit.class).edgarff, emitfos, regset, 0.001f);
        else interpolator.fillregdata(fosCO2, emitfos, regset, 0.001f);
//	interpolator.fillregdata(histdata.lucCO2, emitluc, regset, 0.001f);
        
        if (get(CalcLucEmit.class).lucsource.chosen.equals("Houghton")) {
            float scalefactor=(float)get(CalcLucEmit.class).landuseemit.getval()/2158.09f;
            new interpolator(get(CalcLucEmit.class).lucCO2Houghton, 1950, 1f, scalefactor*0.001f).fill(emitluc, regset, 1850, 2000, get(CalcLucEmit.class).lucCO2CAIT);
        }
        
        if (get(CalcLucEmit.class).lucsource.chosen.equals("EDGAR"))
            interpolator.fillregdata(get(CalcLucEmit.class).edgarluc, emitluc, regset, 0.001f);
        
//        if (lucsource.chosen.equals("MATCH"))
//            new interpolator(matchdata.matchco2luc, 1890, 1).fill(emitluc, regset, 1890, 2000, histdata.lucCO2IVIG);
        
        //for (int y=1750; y<1850; y++) lucf.set(y, lucf.get(1850)*(y-1750)/100f);
        if (get(CalcLucEmit.class).lucsource.chosen.equals("IVIGmodel")) interpolator.fillregdata(get(CalcLucEmit.class).lucemit, emitluc, regset, 0.001f);
//	if (get(CalcLucEmit.class).lucsource.chosen.equals("IVIGdata")) interpolator.fillregdata(get(CalcLucEmit.class).lucCO2IVIG, emitluc, regset, 0.001f);
        //            } else if (year<=2002) { lucf.set(0); for (qt q : histdata.lucCO2.map.values()) lucf.set(lucf.get()+q.get()/1000f); }
        
        
//	emitch4.map.clear();
        new interpolator(matchdata.Edgar14CH4_1890_1970, "EDGAR", 1890, 10, true).fill(emitch4, regset, 1890, 1970, hydepop);
        new interpolator(matchdata.Edgar14CH4_1971_2000, "EDGAR", 1971, 1, true).fill(emitch4, regset, 1971, 2000, hydepop);
        
//	emitn2o.map.clear();
        new interpolator(matchdata.Edgar14N2O_1890_1970, "EDGAR", 1890, 10, true).fill(emitn2o, regset, 1890, 1970, hydepop);
        new interpolator(matchdata.Edgar14N2O_1971_2000, "EDGAR", 1971, 1, true).fill(emitn2o, regset, 1971, 2000, hydepop);
        //Note EH CH4 in Tg CH4, N2O in TgN
        
        
    }
    
    public void calcstep(){
        qt fossil=get(carboncycle.class).fossil, lucf=get(carboncycle.class).lucf, totemit=get(carboncycle.class).totemit;
        socreg socreg=get(socreg.class);
        if (year<2003) {
            emitfos.set("bunker", aviaship.get("tot_in")); socreg.emitfosquota.set("bunker", emitfos.get("bunker"));
            for (region r : regset.reg) { socreg.emitfosquota.set(r, socreg.emitfosbase.get(r)); socreg.emitlucquota.set(r, socreg.emitlucbase.get(r)); }
            
            fossil.set(get(socreg.class).emitfosbase.calctot());
            pop.calctot();
            gdp.calctot();
        }
        if ( ns>5 && ((get(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year<2005 ) || (get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") && year<1850) )) get(carboncycle.class).inverseluc();
        else if (year < 2003) lucf.set(get(socreg.class).emitlucbase.calctot());
        if (year<2003) totemit.set(fossil.get()+lucf.get());
    }
    
    //****************************
    //Historical data - array starts in 1900 but data starts in 1970 (why?)
    //note region 12 is world, 13 is denmark
    //gdp, energy data was saved per-capita, so don't apply any weights in splitting
    
    static public float[][]
            jcm12pop=new float[14][101], // now only used for restoring gdp&en below
            jcm12gdp=new float[14][101],
            jcm12en=new float[14][101];
    ;
    
    void makegdpen() {
        //multiply gdp and en by population (original from image was per-capita)
        //have to do this before interpolation, otherwise doesn't work for other region-sets
        for (int i=0; i<13; i++) {
            for (int j=70; j<101; j++) jcm12gdp[i][j]*=0.001f*jcm12pop[i][j];
            for (int j=71; j<101; j++) jcm12en[i][j]*=jcm12pop[i][j];
            for (int j=0; j<11; j++) for (int sc=0; sc<6; sc++)  {
                int scp=(sc==3 ? 1 : sc==5 ? 2 : 0); //pop is same for all A1+B1
                int scg=(sc>2 ? sc-2 : 0); //gdp is same for all A1T,F,B,
                if (sc==0 || sc>2) sres.jcm12gdppc[i][scg][j] *=0.001f*sres.jcm12pop[i][scp][j];
                sres.jcm12enpc[i][sc][j] *=sres.jcm12pop[i][scp][j];
            }
        }
    }
    
    /*
     work backwards from 2002 data
     see text file in climate/data/gases/bunker for more info
     note av=aviation, ma=marine, A1=Annex1, DC=others, in=international, do=domestic
     emit is in mtc
     */
    public qtset aviaship=new qtset("aviaship", "mega&ton&carbon", 1750, 2002, complexity.expert);
    void aviaship() {
        float r=12f/44f; //convert CO2 to C
        String[] names= {"av_A1_in", "av_DC_in", "ma_A1_in", "ma_DC_in", "av_A1_do", "av_DC_do", "ma_A1_do", "ma_DC_do", "tot_in", "tot_do", "tot_av", "tot_ship"};
        Color[] cols= {dkred, dkorange, dkblue, dkcyan, pink, orange, ltblue, cyan, black, grey, red, blue};
        float[] e={205f*r, 205f*0.6f*r, 204f*r, 204f*1.2f*r, 240f*r, 240f*0.6f*r, 100f*r, 100f*1.2f*r,  0,  0, 0, 0 }; //emit mtc
        float[] c, c1= {0, 2, 0, 2,  0, 2, 0, 2 }, c2= {4, 6, 0, 2, 4, 6, 0, 2};  //% increase per year (as fraction of global total emissions), c1 is used only 2000-2002
        
        for (int i=0; i<12; i++) { aviaship.reg(names[i]).color=cols[i]; if (i>7) aviaship.reg(names[i]).type=qt.Type.total; }
        
//correction such that total international bunker starts at 3.3% of fossil, as per IEA data
        float cf=0; for (int i=0; i<4; i++) cf+=e[i]; cf=fosCO2.calctot(2002)*0.001f*0.033f/cf;
        for (int i=0; i<8; i++) e[i]*=cf;
        
        for (int y=2002; y>=1750; y--) {
            c= (y >= 2000) ?  c1  : c2;
            float rtot= fosCO2.calctot(y) / fosCO2.calctot(y+1);
            if (y<2002) for (int i=0; i<8; i++) e[i]*=(100f / (100f+c[i])) * rtot;
            e[8]=e[0]+e[1]+e[2]+e[3];  e[9]=e[4]+e[5]+e[6]+e[7]; e[10]=e[0]+e[1]+e[4]+e[5]; e[11]=e[2]+e[3]+e[6]+e[7];
            for (int i=0; i<12; i++)    aviaship.set(names[i], y, e[i]);
        }
    }
    
} //end class


