 /*REGION MANAGER
all-static code for loading region definition data
 */

package jcm.mod.reg;
import jcm.core.*;
import jcm.tls.*;
import static jcm.gui.gen.colfont.*;
import java.awt.*;
import jcm.gui.plot.mapplot;
import jcm.gui.nav.showpan;

public class regman  {
    
    public static region allreg=new region("ALL");
    public static region world=new region("world");
    public static region nations;
    public static Color[]
	    jcm12cols=new Color[]{ red, purple, lilac, yellow, dkorange, brown , cyan, blue, dkgreen, ltblue, green, dkcyan, black, dkblue, grey},
	    sres4cols=new Color[]{ black, yellow, brown, blue, green };
    
    
    static {
	loaddata();
	System.out.println("loaded region data ok");
	nations=allreg.find("NATIONS");
//		allreg.find("JCM12").setcols(jcm12cols);
//		allreg.find("SRES4").setcols(sres4cols);
	world.color=black;
	System.out.println("made main reg list ok");
    }
    
    
    public static param<region> makeregionparam() {
	region[] rr=(region[]) allreg.find("MAINLIST").reg.toArray(new region[0]);
	param p=new param("regions", rr, allreg.find("JCM12") );
	p.addAction(showpan.pan("Map", mapplot.class, p));
	return p;
    }
    
    
    //*****************************************************
    
    public static void loaddata() {
	
	String[][] tab=fileio.loadtab("data/countrynames.csv", "\t");
	for (String[] row : tab) if (row.length>1) {
	    region r=allreg.find(row[1]);
	    for (String s : row) if (!s.equals(row[1]) && s.trim().length()>0) {
		if (s.startsWith("#")) r.color=new Color(Integer.decode(s));
		else { r.altnames.add(s); r.simpaltnames.add(r.simplify(s)); }
	    }
	    //if (allreg.checkfind(row[1])) System.err.println("duplicate: "+row[0]);
	}
	
	String poly=fileio.loadstring("data/regions.txt").trim();
	String[] line=txt.split(poly, "\n", true), item;
	for (int i=0; i<line.length-1; i++) {
	    item=txt.split(line[i], " ", true);
	    try {
		if (region.nsew(item[0])==0) {	//not nsew
		    region r=allreg.find(item[0]);
		    if (item[1].equals("+")) r.addsub(item); //consists of following subregions
		    else if (item[1].equals("-")) r.subtract(item); //remove following subregions
		    else if (item[1].equals("&")) r.addset(item); //add set (expanding not recursive). can repeat an entry
		    else if (item[1].equals("L")) { r.defbox(item); r.land=true; } //tgcia box ocean
		    else if (item[1].equals("O")) { r.defbox(item); r.land=false; } //tgcia box ocean
		    else r.addedge(item); //add adge (with, from, to, corners)
		}
	    } catch (Exception e) {	System.out.println(line[i]+" regload "+e); e.printStackTrace(); }
	}
	
    } //end loaddata
    
} //end regman





