/*region class:
 both an individual country/polygon, and a set that is made of other regions
P1 STRUC could split region into types: region defined by edges, region defined by corners, sum of regions, regionset, other...
 */

package jcm.mod.reg;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.*;

import jcm.core.*;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;

public class region extends infob {
    
    public boolean dud=false, wrapping=false, included=false, fixedpoly=false, land=true;
    public region superset=regman.allreg;
    public ArrayList<String> altnames=new ArrayList(0);
    public ArrayList<String> simpaltnames=new ArrayList(0);
      public List<region> reg=new ArrayList();
  
    //***************************************************
    //constructors
    public region(String s) { name=s; }
    public region(String s, Color c) { name=s; color=c;}
    public region() {	name="unnamed region"; }
    
    //***************************************************
    //NAME / COLOR / DOC
    
    public void setcols(Color[] cols)  {	for (int i=0; i<reg.size(); i++ ) reg.get(i).color=cols[i]; }
    public Color[] getcols() { Color[] cols=new Color[reg.size()+1]; for (int i=0; i<reg.size(); i++) cols[i]=reg.get(i).getColor(); cols[reg.size()]=Color.black; return cols; }
    
    public String getName() {	return (altnames.size()>0) ?  altnames.get(0) : name; }
    public String[] getnames() {	String[] names=new String[reg.size()+1]; for (int i=0; i<reg.size(); i++) names[i]=reg.get(i).name; names[reg.size()]="world"; return names; }
    
    public String getExtraDoc() { return   docSubReg()+"aboutregions"+"<hr>";     }
    
    public String docSubReg() {
	String s="", s2="";
	//Set<region> subr= subreg(regman.nations);
	if  (reg.size()>1) { for (region r : reg) s+="<li>"+ r.hashcolor()+autodoc.link(r.name, r.getName())+"</font>"; s= "==`subreg== <ul>"+s+"</ul>"; }
	Set<region> supr=new HashSet(); for (region r : regman.allreg.reg) if (r.reg.contains(this)) supr.add(r);
	if  (supr.size()>1) { for (region r : supr) s2+="<li>"+ r.hashcolor()+autodoc.link(r.name, r.getName())+"</font>"; s2= "==`supreg== <ul>"+s2+"</ul>"; }
	return s+s2;
    }
    
    //***************************************************
    //SUBREGIONS
    
    public boolean isset() { return reg.size()>0; }
    
    public boolean checkfind(String s) {
	return findo(s)!=null;
    }
    
    public region find(String s) { //find or make
	region r=findo(s);
	if (r==null) { r=new region(s); reg.add(r); }
	return r;
    }
   /*
    Map<String, String> check=new HashMap();
    if (!s.equals(r.name)){
	    if (check.containsKey(r.name) && !check.get(r.name).equals(s)) System.err.println(s+" => "+r.name+ " "+ check.get(r.name));
	    check.put(r.name, s);
	}
    */
    static String[] ignore=new String[]{ ",", " &", " and", "the", " of", " is.", " isl.",  " isls", " islands", " island",  " rep.", " republic", "fr. ", "french ", "saint ", "st. ", "."  };
    static String[] spacer=new String[]{"-", "/", "  "};
    
    static String simplify(String s) {
	String s2=s.toLowerCase();
	for (String i : ignore) s2=s2.replace(i, "");
	for (String i : spacer) s2=s2.replace(i, " ");
	s2=s2.trim();
	return s2;
    }
    
    public region findo(String s) {
	for (region r : reg) if (r.name.equals(s)) return r;
	for (region r : reg) for (String an : r.altnames) if (an.equals(s)) return r;
	String s2=simplify(s);
	for (region r : reg) for (String an : r.simpaltnames) if (an.equals(s2)) return r;
	return null;
    }
    
    public boolean contains(region cr) {	//recursive
	if (cr==this) return true;
	if (isset()) for (region r: reg ) if (r.contains(cr)) return true;
	return false;
    }
    
    public boolean contains(Point p) {	for (Polygon poly : polyset) if (poly.contains(p.x,p.y)) return true; return false; }
    
    //comparing order
    boolean lt(region r) {	return name.compareTo(r.name)<0; }
    boolean gt(region r) {	return name.compareTo(r.name)>0; }
    
    //find sub-regions of this one within a destination set -used by histdata split,  people, interpolatereg
    public Set<region> subreg(region r) { return subreg(new HashSet(r.reg)); }
    public Set<region> subreg(qtset qq) { return subreg(qq.map.keySet()); }
    
    public Set<region> subreg(Set<Object> destset) {
	Set<region> set=new HashSet();
	for (region sr : reg) sr.addsubreg(set, destset);
	if(set.size()==0)  addsubreg(set, destset);
	if (destset.contains(this) && !set.contains(this)) set.add(this);
	// ((source.map.containsKey(r) && !subregs.contains(r)  )? source.get(r, y)*fac : 0));
	return set;
    }
    
    void addsubreg(Set<region> set, Set<Object> destset) {
	if (destset.contains(this)) set.add(this);
	else for (region sr : reg)  sr.addsubreg(set, destset); //recursive
    }
    
    
    //***************************************************
    //POLYGONS
    public Vector<regpoly> polyset=new Vector();
    
    
    //make polygon corresponding to a particular region
    public void makepolys() {
	if (!fixedpoly) { polyset.clear();  addpoly(this); }
    }
    
    //semi- recursive : poly and contains info always belongs to initial region
    public void addpoly(region ir) {
	String debug=" region "+ir.name;
	try {
	    if (ir.isset()) {
		for (region r : ir.reg) r.included=false;
		for (region r : ir.reg)  { debug+=" "+r.name; if (!r.included) { addpoly(r); debug+=":start "; } else  debug+=":inc "; }
	    } else {
		if (ir.fixedpoly) {
		    polyset.add(ir.polyset.firstElement());
		    ir.included=true;
		}
		if (ir.startedge!=null) {
		    //(follow around the edges anticlockwise)
		    edge e=ir.startedge, eo=e;
		    region et, er, el; regpoly p;
		    boolean startok=false;
		    p=new regpoly(); polyset.add(p);
		    p.wrapping=false;  ir.included=true;
		    do {
			debug +=" \tEdge "+(e!=null ? e.info() : " null");
			//if not internal edge, add edge
			if (!(contains(e.left) && contains(e.right)))  {
			    if (!startok) {	eo=e; startok=true; }
			    p.addedge(e, e.left==ir);
			}
			//move on to next edge (/region)
			if (e.left==ir) {	et= e.to; er=e.right; el=e.left; } else {	et= e.from; er= e.left; el=e.right ; }
			if (contains(et)) {	ir=et; ir.included=true;  e= ir.lt(er)  ? ir.fef(er, el)   : er.fet(ir, el) ; } else {	e=   ir.lt(et)  ? ir.fef(et, er) : et.fet(ir, er) ; }
		    } while (e!=eo && !p.wrapping);
		    //if (!mapproj.notwrap(fp.x,op.x)) {	p.wrapping=true; wrapping=true; }
		}
	    }
	} catch (RuntimeException ex) {	System.out.println(ex+debug); }
    }
    
    
    //***************************************************
    //INTERPOLATE AVERAGE
    //interpolate average for each polygon, from an instance of mapdata (GCM data, baseline climatology etc)
	/*
	 may need to put back regman.allreg.resetdud(); which was called by regcli.precalc(iob) when new dataset
	public static void resetdud () {	for (Enumeration e = reg.elements() ; e.hasMoreElements() ; ((region) e.nextElement()).dud=false ); }
	 
	P1 ENH  Polygon.contains(x,y) is very inefficient for large polygons - it traces every edge segment
	So when bounding box is large, it's checking edges a long way away
	Hence map draws more efficiently with many small polygons despite increased total number of edges
	Could split into subboxes and use contains(x1,y1,x2,y2) method? but that doesn't work in MS-JVM
	name below works with both, but slow in MSJVM
	 */
    
    
    public float avg(mapdata d) {
	if ( (name.startsWith("PAC_") &&name.length()==6)) dud=true; else dud=false;
	if (dud || wrapping) return -999;
	int xo,yo, xi, yi, xd, yd, cell;
	double area=0, sum=0, sumarea=0, dudarea=0;
	boolean inbox;
	//		makepolys(); // -only when changed - which mapplot should ensure!
	for (regpoly p : polyset) {
	    Rectangle box=p.getBoundingBox();
	    
	    int step=5; // degree steps
	    for (xo=box.x; xo<(box.x+box.width); xo+=step)	{
		xd=Math.min((box.x+box.width)-xo, step);
		for (yo=box.y; yo<(box.y+box.height); yo+=step) {
		    yd=Math.min((box.y+box.height)-yo, step);
		    if (p.intersects(xo,yo,xd,yd)) {
			inbox=p.contains(xo,yo,xd,yd);
			for (yi=yo; yi<(yo+yd); yi++) {
			    area=Math.cos((Math.PI*yi)/180.0);
			    for (xi=xo; xi<(xo+xd); xi++)	{
				if (inbox || p.contains(xi,yi)) {
				    cell=findcell(xi,yi,d);
				    try {
					if (d.r[cell]!=-999) {	sum+=d.r[cell]*area; sumarea+=area; } else dudarea+=area;
				    } catch (NullPointerException e) { dudarea+=area; }
				}
			    }
			}
		    }
		}
	    }
	} //polys
	if (sumarea>dudarea) {	dud=false; return (float)(sum/sumarea); } else {	dud=true; return -999; }
    } //regav
    
    int findcell(int x, int y, mapdata d) {
	int xx=(int)(0.5+d.nlon*((x+360)%360)/360.0);
	int yy=(int)(0.5+d.nlat*(90-y)/180.0);
	return yy*d.nlon+xx;
    }
    
    //***************************************************
    //EDGES
    
    edge[] ed=new edge[100]; int ne=0;
    edge startedge;
    
    edge fef(region r, region f) {	for (int n=0; n<ne; n++) if (r==ed[n].right && f==ed[n].from) return ed[n]; return null; }
    edge fet(region r, region t) {	for (int n=0; n<ne; n++) if (r==ed[n].right && t==ed[n].to) return ed[n]; return null; }
    
    edge addedge(String r, String f, String t)	{
	ed[ne]= new edge(this, superset.find(r), superset.find(f), superset.find(t));
	startedge=ed[ne];
	superset.find(r).startedge=ed[ne];
	ne++; return ed[ne-1];
    }
    
    //*****************************************************
    //methods called by loaddata
    public void addedge(String[] item) {
	edge e= addedge(item[1], item[2], item[3]);
	e.p=new Point[item.length-4];
	for (int j=4; j<item.length; j++) e.p[j-4]=parsepoint(item[j]);
    }
    
    //E, W, N, S edges, format of TGCIA regions - note this will trim the half degrees because Polygon only accepts ints
    public void defbox(String[] s) {
	regpoly p=new regpoly();
	p.addPoint(pi(s[5]), pi(s[2]));
	p.addPoint(pi(s[5]), pi(s[3]));
	p.addPoint(pi(s[4]), pi(s[3]));
	p.addPoint(pi(s[4]), pi(s[2]));
	polyset.addElement(p); fixedpoly=true;
	superset.find("TGCIA").reg.add(this);
    }
    
    public void addsub(String[] item) {	for (int j=2; j<item.length; j++) 	reg.add(superset.find(item[j])); }
    public void subtract(String[] item) {	for (int j=2; j<item.length; j++) 	reg.remove(superset.find(item[j])); }
    public void addset(String[] item) {	for (int j=2; j<item.length; j++) {	region rr= superset.find(item[j]); for (region r : rr.reg ) reg.add(r); }	}
    
    public static int pi(String s) {	return Integer.parseInt(s.substring(0, s.length()-2)); }
    public static Point parsepoint(String item) {
	int k=nsew(item.substring(0,1));
	return new Point(xs*Integer.parseInt(item.substring(k+2,item.length())), ys*Integer.parseInt(item.substring(k,k+2)) );
    }
    
    //interpret NSEW info in datafile
    static int xs=1, ys=1; //assume start N, E
    public static int nsew(String c) {
	int k=1;
	if (c.equals("N"))  ys=1;
	else if (c.equals("S")) ys=-1;
	else if (c.equals("E")) xs=1;
	else if (c.equals("W")) xs=-1;
	else if (c.equals("!")); //to skip comments
	else k=0;
	return k;
    }
    //*****************************************************
    
    
} //end class




